/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.launch.server;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Properties;
import net.fabricmc.loader.launch.server.InjectingURLClassLoader;
import net.fabricmc.loader.util.UrlUtil;

public class FabricServerLauncher {
    private static final ClassLoader parentLoader = FabricServerLauncher.class.getClassLoader();
    private static String mainClass = "net.fabricmc.loader.launch.knot.KnotServer";

    public static void main(String[] args) {
        boolean dev;
        URL propUrl = parentLoader.getResource("fabric-server-launch.properties");
        if (propUrl != null) {
            Properties properties = new Properties();
            try (InputStream is = propUrl.openStream();){
                properties.load(is);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (properties.containsKey("launch.mainClass")) {
                mainClass = properties.getProperty("launch.mainClass");
            }
        }
        if (!(dev = Boolean.parseBoolean(System.getProperty("fabric.development", "false")))) {
            try {
                FabricServerLauncher.setup(args);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to setup Fabric server environment!", e);
            }
        } else {
            FabricServerLauncher.launch(mainClass, FabricServerLauncher.class.getClassLoader(), args);
        }
    }

    private static void launch(String mainClass, ClassLoader loader, String[] args) {
        try {
            Class<?> c = loader.loadClass(mainClass);
            c.getMethod("main", String[].class).invoke(null, new Object[]{args});
        }
        catch (Exception e) {
            throw new RuntimeException("An exception occurred when launching the server!", e);
        }
    }

    private static void setup(String ... runArguments) throws IOException {
        File serverJar;
        Throwable throwable;
        Closeable stream;
        File propertiesFile = new File("fabric-server-launcher.properties");
        Properties properties = new Properties();
        if (propertiesFile.exists()) {
            stream = new FileInputStream(propertiesFile);
            throwable = null;
            try {
                properties.load((InputStream)stream);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (stream != null) {
                    if (throwable != null) {
                        try {
                            ((FileInputStream)stream).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ((FileInputStream)stream).close();
                    }
                }
            }
        }
        if (!properties.containsKey("serverJar")) {
            properties.put("serverJar", "server.jar");
            stream = new FileOutputStream(propertiesFile);
            throwable = null;
            try {
                properties.store((OutputStream)stream, null);
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (stream != null) {
                    if (throwable != null) {
                        try {
                            ((FileOutputStream)stream).close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        ((FileOutputStream)stream).close();
                    }
                }
            }
        }
        if (!(serverJar = new File((String)properties.get("serverJar"))).exists()) {
            System.err.println("Could not find Minecraft server .JAR (" + properties.get("serverJar") + ")!");
            System.err.println();
            System.err.println("Fabric's server-side launcher expects the server .JAR to be provided.");
            System.err.println("You can edit its location in fabric-server-launcher.properties.");
            System.err.println();
            System.err.println("Without the official Minecraft server .JAR, Fabric Loader cannot launch.");
            throw new RuntimeException("Searched for '" + serverJar.getName() + "' but could not find it.");
        }
        System.setProperty("fabric.gameJarPath", serverJar.getAbsolutePath());
        try {
            InjectingURLClassLoader newClassLoader = new InjectingURLClassLoader(new URL[]{FabricServerLauncher.class.getProtectionDomain().getCodeSource().getLocation(), UrlUtil.asUrl(serverJar)}, parentLoader, "com.google.common.jimfs.");
            Thread.currentThread().setContextClassLoader(newClassLoader);
            FabricServerLauncher.launch(mainClass, newClassLoader, runArguments);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

