/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.metadata;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.Version;
import net.fabricmc.loader.api.metadata.ContactInformation;
import net.fabricmc.loader.api.metadata.CustomValue;
import net.fabricmc.loader.api.metadata.ModDependency;
import net.fabricmc.loader.metadata.AbstractModMetadata;
import net.fabricmc.loader.metadata.EntrypointMetadata;
import net.fabricmc.loader.metadata.LoaderModMetadata;
import net.fabricmc.loader.metadata.MapBackedContactInformation;
import net.fabricmc.loader.metadata.NestedJarEntry;
import org.apache.logging.log4j.Logger;

public class ModMetadataV0
extends AbstractModMetadata
implements LoaderModMetadata {
    private String id;
    private Version version;
    private DependencyMap requires = new DependencyMap();
    private DependencyMap conflicts = new DependencyMap();
    private String languageAdapter = "net.fabricmc.loader.language.JavaLanguageAdapter";
    private Mixins mixins = Mixins.EMPTY;
    private Side side = Side.UNIVERSAL;
    private boolean lazilyLoaded = false;
    private String initializer;
    private String[] initializers;
    private String name;
    private String description = "";
    private Links links = Links.EMPTY;
    private DependencyMap recommends = new DependencyMap();
    private Person[] authors = new Person[0];
    private Person[] contributors = new Person[0];
    private String license = "";

    @Override
    public int getSchemaVersion() {
        return 0;
    }

    @Override
    public String getOldStyleLanguageAdapter() {
        return this.languageAdapter;
    }

    @Override
    public Map<String, String> getLanguageAdapterDefinitions() {
        return Collections.emptyMap();
    }

    @Override
    public Collection<NestedJarEntry> getJars() {
        return Collections.emptyList();
    }

    @Override
    public Collection<String> getOldInitializers() {
        if (this.initializer != null) {
            if (this.initializers != null) {
                throw new RuntimeException("initializer and initializers should not be set at the same time! (mod ID '" + this.id + "')");
            }
            return Collections.singletonList(this.initializer);
        }
        if (this.initializers != null) {
            return Arrays.asList(this.initializers);
        }
        return Collections.emptyList();
    }

    @Override
    public List<EntrypointMetadata> getEntrypoints(String type) {
        return Collections.emptyList();
    }

    @Override
    public Collection<String> getEntrypointKeys() {
        return Collections.emptyList();
    }

    @Override
    public void emitFormatWarnings(Logger logger) {
    }

    @Override
    public Collection<String> getMixinConfigs(EnvType type) {
        ArrayList<String> mixinConfigs = new ArrayList<String>(Arrays.asList(this.mixins.common));
        if (type == EnvType.CLIENT) {
            mixinConfigs.addAll(Arrays.asList(this.mixins.client));
        } else if (type == EnvType.SERVER) {
            mixinConfigs.addAll(Arrays.asList(this.mixins.server));
        }
        return mixinConfigs;
    }

    @Override
    public boolean loadsInEnvironment(EnvType type) {
        switch (this.side) {
            case UNIVERSAL: {
                return true;
            }
            case CLIENT: {
                return type == EnvType.CLIENT;
            }
            case SERVER: {
                return type == EnvType.SERVER;
            }
        }
        return false;
    }

    @Override
    public String getType() {
        return "fabric";
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        if (this.name == null || this.name.isEmpty()) {
            return this.id;
        }
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Collection<net.fabricmc.loader.api.metadata.Person> getAuthors() {
        return Arrays.asList(this.authors);
    }

    @Override
    public Collection<net.fabricmc.loader.api.metadata.Person> getContributors() {
        return Arrays.asList(this.contributors);
    }

    @Override
    public ContactInformation getContact() {
        return this.links;
    }

    @Override
    public Collection<String> getLicense() {
        return Collections.singletonList(this.license);
    }

    @Override
    public Optional<String> getIconPath(int size) {
        return Optional.of("assets/" + this.getId() + "/icon.png");
    }

    @Override
    public boolean containsCustomValue(String key) {
        return false;
    }

    @Override
    public CustomValue getCustomValue(String key) {
        return null;
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    @Override
    public Collection<ModDependency> getDepends() {
        return this.requires.toModDependencies();
    }

    @Override
    public Collection<ModDependency> getRecommends() {
        return Collections.emptyList();
    }

    @Override
    public Collection<ModDependency> getSuggests() {
        return this.recommends.toModDependencies();
    }

    @Override
    public Collection<ModDependency> getConflicts() {
        return Collections.emptyList();
    }

    @Override
    public Collection<ModDependency> getBreaks() {
        return this.conflicts.toModDependencies();
    }

    public static enum Side {
        CLIENT,
        SERVER,
        UNIVERSAL;


        public boolean hasClient() {
            return this != SERVER;
        }

        public boolean hasServer() {
            return this != CLIENT;
        }

        public boolean isClient() {
            return this == CLIENT;
        }

        public boolean isServer() {
            return this == SERVER;
        }

        public static class Deserializer
        implements JsonDeserializer<Side> {
            public Side deserialize(JsonElement element, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
                return Side.valueOf(element.getAsString().toUpperCase(Locale.ROOT));
            }
        }
    }

    public static class Person
    implements net.fabricmc.loader.api.metadata.Person {
        private final String name;
        private final MapBackedContactInformation contact;

        public Person(String name, String email, String website) {
            this.name = name;
            HashMap<String, String> contactMap = new HashMap<String, String>();
            if (email != null) {
                contactMap.put("email", email);
            }
            if (website != null) {
                contactMap.put("website", website);
            }
            this.contact = new MapBackedContactInformation(contactMap);
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public ContactInformation getContact() {
            return this.contact;
        }

        public static class Deserializer
        implements JsonDeserializer<Person> {
            private static final Pattern WEBSITE_PATTERN = Pattern.compile("\\((.+)\\)");
            private static final Pattern EMAIL_PATTERN = Pattern.compile("<(.+)>");

            public Person deserialize(JsonElement element, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
                if (element.isJsonPrimitive()) {
                    Matcher emailMatcher;
                    String person = element.getAsString();
                    ArrayList parts = Lists.newArrayList((Object[])person.split(" "));
                    String email = "";
                    String website = "";
                    Matcher websiteMatcher = WEBSITE_PATTERN.matcher((CharSequence)parts.get(parts.size() - 1));
                    if (websiteMatcher.matches()) {
                        website = websiteMatcher.group(1);
                        parts.remove(parts.size() - 1);
                    }
                    if ((emailMatcher = EMAIL_PATTERN.matcher((CharSequence)parts.get(parts.size() - 1))).matches()) {
                        email = emailMatcher.group(1);
                        parts.remove(parts.size() - 1);
                    }
                    String name = String.join((CharSequence)" ", parts);
                    return new Person(name, email, website);
                }
                if (element.isJsonObject()) {
                    JsonObject object = element.getAsJsonObject();
                    String name = object.has("name") ? object.get("name").getAsString() : "";
                    String email = object.has("email") ? object.get("email").getAsString() : "";
                    String website = object.has("website") ? object.get("website").getAsString() : "";
                    return new Person(name, email, website);
                }
                throw new RuntimeException("Expected person to be a string");
            }
        }
    }

    public static class Dependency {
        private String[] versionMatchers;
        private Side side;

        public Dependency(String[] versionMatchers, Side side) {
            this.versionMatchers = versionMatchers;
            this.side = side;
        }

        public String[] getVersionMatchers() {
            return this.versionMatchers;
        }

        public Side getSide() {
            return this.side;
        }

        public boolean satisfiedBy(Version version) {
            return true;
        }

        public String toString() {
            return "[" + Joiner.on((String)", ").join((Object[])this.versionMatchers) + "]";
        }

        public static class Deserializer
        implements JsonDeserializer<Dependency> {
            private String[] deserializeVersionMatchers(JsonElement versionEl) {
                String[] versionMatchers;
                if (versionEl.isJsonPrimitive()) {
                    versionMatchers = new String[]{versionEl.getAsString()};
                } else if (versionEl.isJsonArray()) {
                    JsonArray array = versionEl.getAsJsonArray();
                    versionMatchers = new String[array.size()];
                    for (int i = 0; i < array.size(); ++i) {
                        versionMatchers[i] = array.get(i).getAsString();
                    }
                } else {
                    throw new JsonParseException("Expected version to be a string or array");
                }
                return versionMatchers;
            }

            public Dependency deserialize(JsonElement element, Type resultType, JsonDeserializationContext context) throws JsonParseException {
                if (element.isJsonObject()) {
                    JsonObject object = element.getAsJsonObject();
                    Side side = Side.UNIVERSAL;
                    if (object.has("side")) {
                        JsonElement sideEl = object.get("side");
                        side = (Side)((Object)context.deserialize(sideEl, Side.class));
                    }
                    if (!object.has("version")) {
                        throw new JsonParseException("Missing version element");
                    }
                    JsonElement versionEl = object.get("version");
                    String[] versionMatchers = this.deserializeVersionMatchers(versionEl);
                    return new Dependency(versionMatchers, side);
                }
                if (element.isJsonPrimitive() || element.isJsonArray()) {
                    String[] versionMatchers = this.deserializeVersionMatchers(element);
                    return new Dependency(versionMatchers, Side.UNIVERSAL);
                }
                throw new JsonParseException("Expected dependency to be an object");
            }
        }
    }

    public static class DependencyMap
    extends HashMap<String, Dependency> {
        private List<ModDependency> modDepList;

        Collection<ModDependency> toModDependencies() {
            if (this.modDepList == null) {
                ArrayList<1> list = new ArrayList<1>(this.size());
                for (final String s : this.keySet()) {
                    list.add(new ModDependency(){

                        @Override
                        public String getModId() {
                            return s;
                        }

                        @Override
                        public boolean matches(Version version) {
                            return ((Dependency)this.get(s)).satisfiedBy(version);
                        }

                        public String toString() {
                            String[] matchers = ((Dependency)this.get(s)).versionMatchers;
                            if (matchers.length == 0) {
                                return this.getModId();
                            }
                            if (matchers.length == 1) {
                                return this.getModId() + " @ " + matchers[0];
                            }
                            return this.getModId() + " @ [" + Joiner.on((String)", ").join(Arrays.asList(matchers)) + "]";
                        }
                    });
                }
                this.modDepList = Collections.unmodifiableList(list);
            }
            return this.modDepList;
        }
    }

    public static class Links
    extends MapBackedContactInformation {
        public static final Links EMPTY = new Links(Collections.emptyMap());

        public Links(Map<String, String> map) {
            super(map);
        }

        public static class Deserializer
        implements JsonDeserializer<Links> {
            public Links deserialize(JsonElement element, Type resultType, JsonDeserializationContext context) throws JsonParseException {
                HashMap<String, String> map = new HashMap<String, String>();
                if (element.isJsonObject()) {
                    JsonObject object = element.getAsJsonObject();
                    if (object.has("homepage")) {
                        map.put("homepage", object.get("homepage").getAsString());
                    }
                    if (object.has("issues")) {
                        map.put("issues", object.get("issues").getAsString());
                    }
                    if (object.has("sources")) {
                        map.put("sources", object.get("sources").getAsString());
                    }
                } else if (element.isJsonPrimitive()) {
                    map.put("homepage", element.getAsString());
                } else {
                    throw new JsonParseException("Expected links to be an object or string");
                }
                return new Links(map);
            }
        }
    }

    public static class Mixins {
        public static final Mixins EMPTY = new Mixins();
        private String[] client = new String[0];
        private String[] common = new String[0];
        private String[] server = new String[0];

        public String[] getClient() {
            return this.client;
        }

        public String[] getCommon() {
            return this.common;
        }

        public String[] getServer() {
            return this.server;
        }

        static /* synthetic */ String[] access$102(Mixins x0, String[] x1) {
            x0.client = x1;
            return x1;
        }

        static /* synthetic */ String[] access$002(Mixins x0, String[] x1) {
            x0.common = x1;
            return x1;
        }

        static /* synthetic */ String[] access$202(Mixins x0, String[] x1) {
            x0.server = x1;
            return x1;
        }

        public static class Deserializer
        implements JsonDeserializer<Mixins> {
            public Mixins deserialize(JsonElement element, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                Mixins mixins = new Mixins();
                if (!element.isJsonObject()) {
                    throw new JsonParseException("Expected mixins to be an object.");
                }
                JsonObject object = element.getAsJsonObject();
                Mixins.access$102(mixins, this.getStringArray(object, "client"));
                Mixins.access$002(mixins, this.getStringArray(object, "common"));
                Mixins.access$202(mixins, this.getStringArray(object, "server"));
                return mixins;
            }

            private String[] getStringArray(JsonObject object, String name) throws JsonParseException {
                JsonElement element = object.get(name);
                if (element == null || element.isJsonNull()) {
                    return new String[0];
                }
                if (element.isJsonPrimitive()) {
                    return new String[]{element.getAsString()};
                }
                if (element.isJsonArray()) {
                    JsonArray array = element.getAsJsonArray();
                    String[] strings = new String[array.size()];
                    for (int i = 0; i < array.size(); ++i) {
                        strings[i] = array.get(i).getAsString();
                    }
                    return strings;
                }
                throw new JsonParseException("Expected " + name + " to be a string or an array of strings");
            }
        }
    }
}

