/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.util.asm;

import org.objectweb.asm.tree.ClassNode;

public final class ASM {
    private static final int[] EXPERIMENTAL_VERSIONS = new int[0];
    private static final int[] SUPPORTED_VERSIONS = new int[]{393216, 327680, 458752};
    public static final int API_VERSION = ASM.detectVersion();
    private static boolean experimental;

    private ASM() {
    }

    public static String getApiVersionString() {
        String suffix = "";
        if (experimental) {
            int version = ASM.detectVersion(SUPPORTED_VERSIONS);
            suffix = String.format("-EXPERIMENTAL (%d.%d)", (0xFF0000 & version) >> 16, (0xFF00 & version) >> 8);
        }
        return String.format("ASM %d.%d%s", (0xFF0000 & API_VERSION) >> 16, (0xFF00 & API_VERSION) >> 8, suffix);
    }

    private static int detectVersion() {
        int expVersion = ASM.detectVersion(EXPERIMENTAL_VERSIONS);
        if (expVersion > 0) {
            experimental = true;
            return expVersion;
        }
        experimental = false;
        int version = ASM.detectVersion(SUPPORTED_VERSIONS);
        if (version > 0) {
            return version;
        }
        return 327680;
    }

    private static int detectVersion(int[] versions) {
        for (int version : versions) {
            try {
                new ClassNode(version).hashCode();
                return version;
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
        }
        return 0;
    }
}

