/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.util.sat4j.core;

import java.util.Iterator;
import net.fabricmc.loader.util.sat4j.core.Vec;
import net.fabricmc.loader.util.sat4j.specs.IConstr;
import net.fabricmc.loader.util.sat4j.specs.ISolver;
import net.fabricmc.loader.util.sat4j.specs.IVec;

public class ConstrGroup
implements IConstr {
    private final IVec<IConstr> constrs = new Vec<IConstr>();
    private final boolean disallowNullConstraints;

    public ConstrGroup() {
        this(true);
    }

    public ConstrGroup(boolean disallowNullConstraints) {
        this.disallowNullConstraints = disallowNullConstraints;
    }

    public void add(IConstr constr) {
        if (constr == null && this.disallowNullConstraints) {
            throw new IllegalArgumentException("The constraint you entered cannot be removed from the solver.");
        }
        this.constrs.push(constr);
    }

    public void clear() {
        this.constrs.clear();
    }

    public void removeFrom(ISolver solver) {
        Iterator<IConstr> it = this.constrs.iterator();
        while (it.hasNext()) {
            solver.removeConstr(it.next());
        }
    }

    public IConstr getConstr(int i) {
        return this.constrs.get(i);
    }

    public int size() {
        return this.constrs.size();
    }

    public boolean learnt() {
        if (this.constrs.size() == 0) {
            return false;
        }
        return this.constrs.get(0).learnt();
    }

    public double getActivity() {
        return 0.0;
    }

    public int get(int i) {
        throw new UnsupportedOperationException();
    }

    public boolean canBePropagatedMultipleTimes() {
        return false;
    }

    public String toString() {
        return this.constrs.toString();
    }
}

