/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.util.sat4j.tools;

import net.fabricmc.loader.util.sat4j.core.VecInt;
import net.fabricmc.loader.util.sat4j.specs.ContradictionException;
import net.fabricmc.loader.util.sat4j.specs.IConstr;
import net.fabricmc.loader.util.sat4j.specs.ISolver;
import net.fabricmc.loader.util.sat4j.specs.IVecInt;
import net.fabricmc.loader.util.sat4j.specs.TimeoutException;
import net.fabricmc.loader.util.sat4j.tools.AbstractMinimalModel;
import net.fabricmc.loader.util.sat4j.tools.SolutionFoundListener;

public class Minimal4InclusionModel
extends AbstractMinimalModel {
    private static final long serialVersionUID = 1L;
    private int[] prevfullmodel;

    public Minimal4InclusionModel(ISolver solver, IVecInt p, SolutionFoundListener modelListener) {
        super(solver, p, modelListener);
    }

    public Minimal4InclusionModel(ISolver solver, IVecInt p) {
        this(solver, p, SolutionFoundListener.VOID);
    }

    public Minimal4InclusionModel(ISolver solver) {
        this(solver, Minimal4InclusionModel.negativeLiterals(solver), SolutionFoundListener.VOID);
    }

    public int[] model() {
        int[] prevmodel = null;
        VecInt vec = new VecInt();
        VecInt cube = new VecInt();
        IConstr prevConstr = null;
        try {
            do {
                this.prevfullmodel = super.modelWithInternalVariables();
                prevmodel = super.model();
                this.modelListener.onSolutionFound(prevmodel);
                vec.clear();
                cube.clear();
                for (int q : this.prevfullmodel) {
                    if (this.pLiterals.contains(q)) {
                        vec.push(-q);
                        continue;
                    }
                    if (!this.pLiterals.contains(-q)) continue;
                    cube.push(q);
                }
                if (prevConstr != null) {
                    this.removeSubsumedConstr(prevConstr);
                }
                prevConstr = this.addBlockingClause(vec);
            } while (this.isSatisfiable(cube));
        }
        catch (TimeoutException e) {
            throw new IllegalStateException("Solver timed out");
        }
        catch (ContradictionException contradictionException) {
            // empty catch block
        }
        return prevmodel;
    }

    public int[] modelWithInternalVariables() {
        this.model();
        return this.prevfullmodel;
    }
}

