/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.tinyremapper;

import java.util.HashMap;
import java.util.Map;
import net.fabricmc.tinyremapper.AsmRemapper;
import net.fabricmc.tinyremapper.MemberInstance;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.TypePath;
import org.objectweb.asm.commons.AnnotationRemapper;
import org.objectweb.asm.commons.ClassRemapper;
import org.objectweb.asm.commons.FieldRemapper;
import org.objectweb.asm.commons.MethodRemapper;
import org.objectweb.asm.commons.Remapper;
import org.objectweb.asm.tree.MethodNode;

class AsmClassRemapper
extends ClassRemapper {
    private final boolean checkPackageAccess;
    private final boolean renameInvalidLocals;
    private MethodNode methodNode;

    public AsmClassRemapper(ClassVisitor cv, AsmRemapper remapper, boolean checkPackageAccess, boolean renameInvalidLocals) {
        super(cv, (Remapper)remapper);
        this.checkPackageAccess = checkPackageAccess;
        this.renameInvalidLocals = renameInvalidLocals;
    }

    public void visitSource(String source, String debug) {
        String mappedClsName = this.remapper.map(this.className);
        int start = mappedClsName.lastIndexOf(47) + 1;
        int end = mappedClsName.indexOf(36);
        if (end <= 0) {
            end = mappedClsName.length();
        }
        super.visitSource(mappedClsName.substring(start, end).concat(".java"), debug);
    }

    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        this.methodNode = new MethodNode(this.api, access, name, descriptor, signature, exceptions);
        return super.visitMethod(access, name, descriptor, signature, exceptions);
    }

    protected FieldVisitor createFieldRemapper(FieldVisitor fieldVisitor) {
        return new AsmFieldRemapper(fieldVisitor, this.remapper);
    }

    protected MethodVisitor createMethodRemapper(MethodVisitor mv) {
        return new AsmMethodRemapper(mv, this.remapper, this.className, this.methodNode, this.checkPackageAccess, this.renameInvalidLocals);
    }

    public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
        return AsmClassRemapper.createAsmAnnotationRemapper(descriptor, super.visitAnnotation(descriptor, visible), this.remapper);
    }

    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
        return AsmClassRemapper.createAsmAnnotationRemapper(descriptor, super.visitTypeAnnotation(typeRef, typePath, descriptor, visible), this.remapper);
    }

    public static AnnotationRemapper createAsmAnnotationRemapper(String desc, AnnotationVisitor annotationVisitor, Remapper remapper) {
        return annotationVisitor == null ? null : new AsmAnnotationRemapper(annotationVisitor, remapper, desc);
    }

    private static class AsmAnnotationRemapper
    extends AnnotationRemapper {
        private final String annotationClass;

        public AsmAnnotationRemapper(AnnotationVisitor annotationVisitor, Remapper remapper, String annotationDesc) {
            super(annotationVisitor, remapper);
            this.annotationClass = Type.getType((String)annotationDesc).getInternalName();
        }

        public void visit(String name, Object value) {
            super.visit(this.mapAnnotationName(name, AsmAnnotationRemapper.getDesc(value)), value);
        }

        private static String getDesc(Object value) {
            if (value instanceof Type) {
                return ((Type)value).getDescriptor();
            }
            Class<?> cls = value.getClass();
            if (Byte.class.isAssignableFrom(cls)) {
                return "B";
            }
            if (Boolean.class.isAssignableFrom(cls)) {
                return "Z";
            }
            if (Character.class.isAssignableFrom(cls)) {
                return "C";
            }
            if (Short.class.isAssignableFrom(cls)) {
                return "S";
            }
            if (Integer.class.isAssignableFrom(cls)) {
                return "I";
            }
            if (Long.class.isAssignableFrom(cls)) {
                return "J";
            }
            if (Float.class.isAssignableFrom(cls)) {
                return "F";
            }
            if (Double.class.isAssignableFrom(cls)) {
                return "D";
            }
            return Type.getDescriptor(cls);
        }

        public void visitEnum(String name, String descriptor, String value) {
            super.visitEnum(this.mapAnnotationName(name, descriptor), descriptor, this.remapper.mapFieldName(Type.getType((String)descriptor).getInternalName(), value, descriptor));
        }

        public AnnotationVisitor visitAnnotation(String name, String descriptor) {
            return this.createNested(descriptor, this.av.visitAnnotation(this.mapAnnotationName(name, descriptor), descriptor));
        }

        public AnnotationVisitor visitArray(final String name) {
            return new AnnotationVisitor(458752){

                public void visit(String name2, Object value) {
                    if (this.av == null) {
                        this.start(AsmAnnotationRemapper.getDesc(value));
                    }
                    super.visit(name2, value);
                }

                public void visitEnum(String name2, String descriptor, String value) {
                    if (this.av == null) {
                        this.start(descriptor);
                    }
                    super.visitEnum(name2, descriptor, value);
                }

                public AnnotationVisitor visitAnnotation(String name2, String descriptor) {
                    if (this.av == null) {
                        this.start(descriptor);
                    }
                    return super.visitAnnotation(name2, descriptor);
                }

                public AnnotationVisitor visitArray(String name2) {
                    throw new IllegalStateException("nested arrays are disallowed by the jvm spec");
                }

                public void visitEnd() {
                    if (this.av == null) {
                        String newName = name == null ? null : ((AsmRemapper)remapper).mapMethodNamePrefixDesc(annotationClass, name, "()[");
                        this.av = av.visitArray(newName);
                    }
                    super.visitEnd();
                }

                private void start(String desc) {
                    assert (this.av == null);
                    desc = "[" + desc;
                    this.av = this.createNested(desc, av.visitArray(this.mapAnnotationName(name, desc)));
                }
            };
        }

        private String mapAnnotationName(String name, String descriptor) {
            if (name == null) {
                return null;
            }
            return this.remapper.mapMethodName(this.annotationClass, name, "()" + descriptor);
        }

        private AnnotationVisitor createNested(String descriptor, AnnotationVisitor parent) {
            return AsmClassRemapper.createAsmAnnotationRemapper(descriptor, parent, this.remapper);
        }
    }

    private static class AsmMethodRemapper
    extends MethodRemapper {
        private final String owner;
        private final MethodNode methodNode;
        private final MethodVisitor methodVisitor;
        private final boolean isStatic;
        private final int argLvSize;
        private final Map<String, Integer> nameCounts = new HashMap<String, Integer>();
        private final boolean checkPackageAccess;
        private final boolean renameInvalidLocals;
        private final String[] parameterNames;
        private final int[] parameterAccess;
        private int argsVisited;

        public AsmMethodRemapper(MethodVisitor methodVisitor, Remapper remapper, String owner, MethodNode methodNode, boolean checkPackageAccess, boolean renameInvalidLocals) {
            super((MethodVisitor)methodNode, remapper);
            this.owner = owner;
            this.methodNode = methodNode;
            this.methodVisitor = methodVisitor;
            this.isStatic = (methodNode.access & 8) != 0;
            this.argLvSize = AsmMethodRemapper.getLvIndex(methodNode.desc, this.isStatic, Integer.MAX_VALUE);
            this.checkPackageAccess = checkPackageAccess;
            this.renameInvalidLocals = renameInvalidLocals;
            this.parameterNames = new String[this.argLvSize];
            this.parameterAccess = new int[this.argLvSize];
        }

        private static int getLvIndex(String desc, boolean isStatic, int asmIndex) {
            int ret = 0;
            if (!isStatic) {
                ++ret;
            }
            if (!desc.startsWith("()") && asmIndex > 0) {
                Type[] args = Type.getArgumentTypes((String)desc);
                int max = Math.min(args.length, asmIndex);
                for (int i = 0; i < max; ++i) {
                    ret += args[i].getSize();
                }
            }
            return ret;
        }

        public void visitParameter(String name, int access) {
            int lvIndex = AsmMethodRemapper.getLvIndex(this.methodNode.desc, this.isStatic, this.argsVisited++);
            this.parameterNames[lvIndex] = name;
            this.parameterAccess[lvIndex] = access;
        }

        public AnnotationVisitor visitAnnotationDefault() {
            return AsmClassRemapper.createAsmAnnotationRemapper(Type.getObjectType((String)this.owner).getDescriptor(), super.visitAnnotationDefault(), this.remapper);
        }

        public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
            return AsmClassRemapper.createAsmAnnotationRemapper(descriptor, super.visitAnnotation(descriptor, visible), this.remapper);
        }

        public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
            return AsmClassRemapper.createAsmAnnotationRemapper(descriptor, super.visitTypeAnnotation(typeRef, typePath, descriptor, visible), this.remapper);
        }

        public AnnotationVisitor visitParameterAnnotation(int parameter, String descriptor, boolean visible) {
            return AsmClassRemapper.createAsmAnnotationRemapper(descriptor, super.visitParameterAnnotation(parameter, descriptor, visible), this.remapper);
        }

        public void visitLocalVariable(String name, String descriptor, String signature, Label start, Label end, int index) {
            if (this.methodNode == null) {
                return;
            }
            descriptor = this.remapper.mapDesc(descriptor);
            if (index < this.argLvSize) {
                if (AsmMethodRemapper.isValidJavaIdentifier(this.parameterNames[index])) {
                    name = this.parameterNames[index];
                }
                name = ((AsmRemapper)this.remapper).mapMethodArg(this.owner, this.methodNode.name, this.methodNode.desc, index, name);
            }
            if (this.renameInvalidLocals && !AsmMethodRemapper.isValidJavaIdentifier(name)) {
                Type type = Type.getType((String)descriptor);
                name = this.getNameFromType(type);
            }
            if (index < this.argLvSize) {
                this.parameterNames[index] = name;
            }
            this.methodNode.visitLocalVariable(name, descriptor, this.remapper.mapSignature(signature, true), start, end, index);
        }

        private String getNameFromType(Type type) {
            String varName;
            int dotIdx;
            boolean plural = false;
            if (type.getSort() == 9) {
                plural = true;
                type = type.getElementType();
            }
            if ((dotIdx = (varName = type.getClassName()).lastIndexOf(46)) != -1) {
                varName = varName.substring(dotIdx + 1);
            }
            varName = Character.toLowerCase(varName.charAt(0)) + varName.substring(1);
            if (plural) {
                varName = varName + "s";
            }
            return varName + "_" + this.nameCounts.compute(varName, (k, v) -> v == null ? 1 : v + 1);
        }

        private static boolean isValidJavaIdentifier(String s) {
            if (s == null || s.isEmpty()) {
                return false;
            }
            int cp = s.codePointAt(0);
            if (!Character.isJavaIdentifierStart(cp)) {
                return false;
            }
            int max = s.length();
            for (int i = Character.charCount(cp); i < max; i += Character.charCount(cp)) {
                cp = s.codePointAt(i);
                if (Character.isJavaIdentifierPart(cp)) continue;
                return false;
            }
            return true;
        }

        public void visitFieldInsn(int opcode, String owner, String name, String descriptor) {
            if (this.checkPackageAccess) {
                ((AsmRemapper)this.remapper).checkPackageAccess(this.owner, owner, name, descriptor, MemberInstance.MemberType.FIELD);
            }
            super.visitFieldInsn(opcode, owner, name, descriptor);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
            if (this.checkPackageAccess) {
                ((AsmRemapper)this.remapper).checkPackageAccess(this.owner, owner, name, descriptor, MemberInstance.MemberType.METHOD);
            }
            super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
        }

        public void visitInvokeDynamicInsn(String name, String descriptor, Handle bootstrapMethodHandle, Object ... bootstrapMethodArguments) {
            if (this.methodNode == null) {
                return;
            }
            Handle implemented = AsmMethodRemapper.getLambdaImplementedMethod(name, descriptor, bootstrapMethodHandle, bootstrapMethodArguments);
            name = implemented != null ? this.remapper.mapMethodName(implemented.getOwner(), implemented.getName(), implemented.getDesc()) : this.remapper.mapInvokeDynamicMethodName(name, descriptor);
            for (int i = 0; i < bootstrapMethodArguments.length; ++i) {
                bootstrapMethodArguments[i] = this.remapper.mapValue(bootstrapMethodArguments[i]);
            }
            this.methodNode.visitInvokeDynamicInsn(name, this.remapper.mapMethodDesc(descriptor), (Handle)this.remapper.mapValue((Object)bootstrapMethodHandle), bootstrapMethodArguments);
        }

        private static Handle getLambdaImplementedMethod(String name, String desc, Handle bsm, Object ... bsmArgs) {
            if (AsmMethodRemapper.isJavaLambdaMetafactory(bsm)) {
                assert (desc.endsWith(";"));
                return new Handle(9, desc.substring(desc.lastIndexOf(41) + 2, desc.length() - 1), name, ((Type)bsmArgs[0]).getDescriptor(), true);
            }
            System.out.printf("unknown invokedynamic bsm: %s/%s%s (tag=%d iif=%b)%n", bsm.getOwner(), bsm.getName(), bsm.getDesc(), bsm.getTag(), bsm.isInterface());
            return null;
        }

        private static boolean isJavaLambdaMetafactory(Handle bsm) {
            return bsm.getTag() == 6 && bsm.getOwner().equals("java/lang/invoke/LambdaMetafactory") && (bsm.getName().equals("metafactory") && bsm.getDesc().equals("(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodHandle;Ljava/lang/invoke/MethodType;)Ljava/lang/invoke/CallSite;") || bsm.getName().equals("altMetafactory") && bsm.getDesc().equals("(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;[Ljava/lang/Object;)Ljava/lang/invoke/CallSite;")) && !bsm.isInterface();
        }

        public void visitEnd() {
            String[] remappedParamNames = this.remapParameterNames();
            if (this.anyNameExists(remappedParamNames)) {
                for (int i = 0; i < remappedParamNames.length; ++i) {
                    this.methodNode.visitParameter(remappedParamNames[i], this.parameterAccess[i]);
                }
            }
            this.methodNode.visitEnd();
            this.methodNode.accept(this.methodVisitor);
            super.visitEnd();
        }

        private String[] remapParameterNames() {
            Type[] paramTypes = Type.getArgumentTypes((String)this.methodNode.desc);
            String[] params = new String[paramTypes.length];
            for (int i = 0; i < paramTypes.length; ++i) {
                int lvIndex = AsmMethodRemapper.getLvIndex(this.methodNode.desc, this.isStatic, i);
                String name = ((AsmRemapper)this.remapper).mapMethodArg(this.owner, this.methodNode.name, this.methodNode.desc, lvIndex, this.parameterNames[lvIndex]);
                if (this.renameInvalidLocals && !AsmMethodRemapper.isValidJavaIdentifier(name)) {
                    name = this.getNameFromType(paramTypes[i]);
                }
                params[i] = name;
            }
            return params;
        }

        private boolean anyNameExists(String[] parameterNames) {
            for (String name : parameterNames) {
                if (name == null) continue;
                return true;
            }
            return false;
        }
    }

    private static class AsmFieldRemapper
    extends FieldRemapper {
        public AsmFieldRemapper(FieldVisitor fieldVisitor, Remapper remapper) {
            super(fieldVisitor, remapper);
        }

        public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
            return AsmClassRemapper.createAsmAnnotationRemapper(descriptor, super.visitAnnotation(descriptor, visible), this.remapper);
        }

        public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
            return AsmClassRemapper.createAsmAnnotationRemapper(descriptor, super.visitTypeAnnotation(typeRef, typePath, descriptor, visible), this.remapper);
        }
    }
}

