/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.tinyremapper;

import net.fabricmc.tinyremapper.ClassInstance;
import net.fabricmc.tinyremapper.MemberInstance;
import net.fabricmc.tinyremapper.TinyRemapper;
import org.objectweb.asm.commons.Remapper;

class AsmRemapper
extends Remapper {
    private final TinyRemapper remapper;

    public AsmRemapper(TinyRemapper remapper) {
        this.remapper = remapper;
    }

    public String map(String typeName) {
        String ret = this.remapper.classMap.get(typeName);
        if (ret != null) {
            return ret;
        }
        return this.remapper.extraRemapper != null ? this.remapper.extraRemapper.map(typeName) : typeName;
    }

    public String mapFieldName(String owner, String name, String desc) {
        String newName;
        ClassInstance cls = this.getClass(owner);
        if (cls == null) {
            return name;
        }
        MemberInstance member = cls.resolve(MemberInstance.MemberType.FIELD, MemberInstance.getFieldId(name, desc, this.remapper.ignoreFieldDesc));
        if (member != null && (newName = member.getNewName()) != null) {
            return newName;
        }
        assert ((newName = this.remapper.fieldMap.get(owner + "/" + MemberInstance.getFieldId(name, desc, this.remapper.ignoreFieldDesc))) == null || newName.equals(name));
        return this.remapper.extraRemapper != null ? this.remapper.extraRemapper.mapFieldName(owner, name, desc) : name;
    }

    public String mapMethodName(String owner, String name, String desc) {
        String newName;
        ClassInstance cls = this.getClass(owner);
        if (cls == null) {
            return name;
        }
        MemberInstance member = cls.resolve(MemberInstance.MemberType.METHOD, MemberInstance.getMethodId(name, desc));
        if (member != null && (newName = member.getNewName()) != null) {
            return newName;
        }
        assert ((newName = this.remapper.methodMap.get(owner + "/" + MemberInstance.getMethodId(name, desc))) == null || newName.equals(name));
        return this.remapper.extraRemapper != null ? this.remapper.extraRemapper.mapMethodName(owner, name, desc) : name;
    }

    public String mapMethodNamePrefixDesc(String owner, String name, String descPrefix) {
        String newName;
        ClassInstance cls = this.getClass(owner);
        if (cls == null) {
            return name;
        }
        MemberInstance member = cls.resolvePartial(MemberInstance.MemberType.METHOD, name, descPrefix);
        if (member != null && (newName = member.getNewName()) != null) {
            return newName;
        }
        return name;
    }

    public String mapLambdaInvokeDynamicMethodName(String owner, String name, String desc) {
        return this.mapMethodName(owner, name, desc);
    }

    public String mapArbitraryInvokeDynamicMethodName(String owner, String name) {
        return this.mapMethodNamePrefixDesc(owner, name, null);
    }

    public String mapMethodArg(String methodOwner, String methodName, String methodDesc, int lvIndex, String name) {
        String newName = this.remapper.methodArgMap.get(methodOwner + "/" + MemberInstance.getMethodId(methodName, methodDesc) + lvIndex);
        if (newName != null) {
            return newName;
        }
        ClassInstance cls = this.getClass(methodOwner);
        if (cls == null) {
            return name;
        }
        MemberInstance originatingMethod = cls.resolve(MemberInstance.MemberType.METHOD, MemberInstance.getMethodId(methodName, methodDesc));
        if (originatingMethod == null) {
            return name;
        }
        String originatingNewName = this.remapper.methodArgMap.get(originatingMethod.newNameOriginatingCls + "/" + MemberInstance.getMethodId(originatingMethod.name, originatingMethod.desc) + lvIndex);
        return originatingNewName != null ? originatingNewName : name;
    }

    public void checkPackageAccess(String accessingOwner, String owner, String name, String desc, MemberInstance.MemberType type) {
        String mappedDesc;
        String mappedName;
        ClassInstance cls = this.getClass(owner);
        if (cls == null) {
            return;
        }
        String id = MemberInstance.getId(type, name, desc, this.remapper.ignoreFieldDesc);
        MemberInstance member = cls.resolve(type, id);
        if (member != null) {
            cls = member.cls;
            owner = cls.getName();
        }
        if (cls.isPublicOrPrivate() && (member == null || member.isPublicOrPrivate()) || accessingOwner.equals(owner)) {
            return;
        }
        String mappedAccessor = this.map(accessingOwner);
        String mappedTarget = this.map(owner);
        int pos = mappedAccessor.lastIndexOf(47);
        if (pos < 0 && mappedTarget.indexOf(47) < 0) {
            return;
        }
        if (pos >= 0 && pos < mappedTarget.length() && mappedTarget.charAt(pos) == '/' && mappedTarget.indexOf(47, pos + 1) < 0 && mappedAccessor.regionMatches(0, mappedTarget, 0, pos - 1)) {
            return;
        }
        if (cls.isPublicOrPrivate() && member != null && member.isProtected()) {
            ClassInstance accessingCls = this.getClass(accessingOwner);
            while (accessingCls != null && accessingCls.getSuperName() != null) {
                if (accessingCls.getSuperName().equals(owner)) {
                    return;
                }
                accessingCls = this.getClass(accessingCls.getSuperName());
            }
        }
        if (type == MemberInstance.MemberType.FIELD) {
            mappedName = this.mapFieldName(owner, name, desc);
            mappedDesc = this.mapDesc(desc);
        } else {
            mappedName = this.mapMethodName(owner, name, desc);
            mappedDesc = this.mapMethodDesc(desc);
        }
        System.out.printf("Invalid access from %s to %s/%s after remapping.%n", mappedAccessor, mappedTarget, MemberInstance.getId(type, mappedName, mappedDesc, this.remapper.ignoreFieldDesc));
        if (!cls.isPublicOrPrivate()) {
            this.remapper.classesToMakePublic.add(cls);
        }
        if (member != null && !member.isPublicOrPrivate()) {
            this.remapper.membersToMakePublic.add(member);
        }
    }

    private ClassInstance getClass(String owner) {
        return this.remapper.classes.get(owner);
    }
}

