/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.util.sat4j.tools;

import net.fabricmc.loader.util.sat4j.specs.IConstr;
import net.fabricmc.loader.util.sat4j.specs.ISolverService;
import net.fabricmc.loader.util.sat4j.specs.IVec;
import net.fabricmc.loader.util.sat4j.specs.RandomAccessModel;
import net.fabricmc.loader.util.sat4j.tools.IVisualizationTool;
import net.fabricmc.loader.util.sat4j.tools.SearchListenerAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LearnedTracing
extends SearchListenerAdapter<ISolverService> {
    private static final long serialVersionUID = 1L;
    private ISolverService solverService;
    private final IVisualizationTool visuTool;

    public LearnedTracing(IVisualizationTool visuTool) {
        this.visuTool = visuTool;
    }

    @Override
    public void solutionFound(int[] model, RandomAccessModel lazyModel) {
        this.trace();
    }

    @Override
    public void restarting() {
        this.trace();
    }

    private void trace() {
        this.visuTool.init();
        IVec<? extends IConstr> constrs = this.solverService.getLearnedConstraints();
        int n = constrs.size();
        for (int i = 0; i < n; ++i) {
            this.visuTool.addPoint(i, constrs.get(i).getActivity());
        }
        this.visuTool.end();
    }

    @Override
    public void init(ISolverService solverService) {
        this.solverService = solverService;
    }

    @Override
    public void cleaning() {
        this.trace();
    }
}

