/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.tinyremapper;

import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import net.fabricmc.tinyremapper.ClassInstance;

public final class MemberInstance {
    private static final AtomicReferenceFieldUpdater<MemberInstance, String> newNameUpdater = AtomicReferenceFieldUpdater.newUpdater(MemberInstance.class, String.class, "newName");
    final MemberType type;
    final ClassInstance cls;
    final String name;
    final String desc;
    final int access;
    private volatile String newName;
    String newNameOriginatingCls;

    MemberInstance(MemberType type, ClassInstance cls, String name, String desc, int access) {
        this.type = type;
        this.cls = cls;
        this.name = name;
        this.desc = desc;
        this.access = access;
    }

    public String getId() {
        return MemberInstance.getId(this.type, this.name, this.desc, this.cls.context.ignoreFieldDesc);
    }

    public boolean isVirtual() {
        return this.type == MemberType.METHOD && (this.access & 0xA) == 0;
    }

    public boolean isPublicOrPrivate() {
        return (this.access & 3) != 0;
    }

    public boolean isProtected() {
        return (this.access & 4) != 0;
    }

    public String getNewName() {
        return this.newName;
    }

    public boolean setNewName(String name) {
        if (name == null) {
            throw new NullPointerException("null name");
        }
        boolean ret = newNameUpdater.compareAndSet(this, null, name);
        return ret || name.equals(this.newName);
    }

    public void forceSetNewName(String name) {
        this.newName = name;
    }

    public static String getId(MemberType type, String name, String desc, boolean ignoreFieldDesc) {
        return type == MemberType.METHOD ? MemberInstance.getMethodId(name, desc) : MemberInstance.getFieldId(name, desc, ignoreFieldDesc);
    }

    public static String getMethodId(String name, String desc) {
        return name.concat(desc);
    }

    public static String getFieldId(String name, String desc, boolean ignoreDesc) {
        return ignoreDesc ? name : name + ";;" + desc;
    }

    public static String getNameFromId(MemberType type, String id, boolean ignoreFieldDesc) {
        if (ignoreFieldDesc && type == MemberType.FIELD) {
            return id;
        }
        String separator = type == MemberType.METHOD ? "(" : ";;";
        return id.substring(0, id.lastIndexOf(separator));
    }

    static enum MemberType {
        METHOD,
        FIELD;

    }
}

