/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap;

import com.mamiyaotaru.voxelmap.fabricmod.Share;
import com.mamiyaotaru.voxelmap.interfaces.AbstractMapData;
import com.mamiyaotaru.voxelmap.interfaces.IColorManager;
import com.mamiyaotaru.voxelmap.interfaces.IVoxelMap;
import com.mamiyaotaru.voxelmap.util.BlockModel;
import com.mamiyaotaru.voxelmap.util.BlockRepository;
import com.mamiyaotaru.voxelmap.util.GLShim;
import com.mamiyaotaru.voxelmap.util.GLUtils;
import com.mamiyaotaru.voxelmap.util.ImageUtils;
import com.mamiyaotaru.voxelmap.util.MessageUtils;
import com.mamiyaotaru.voxelmap.util.MutableBlockPos;
import com.mamiyaotaru.voxelmap.util.ReflectionUtils;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RasterFormatException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import net.minecraft.class_1047;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1060;
import net.minecraft.class_1087;
import net.minecraft.class_1160;
import net.minecraft.class_1309;
import net.minecraft.class_151;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1926;
import net.minecraft.class_1933;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2404;
import net.minecraft.class_2457;
import net.minecraft.class_2464;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2791;
import net.minecraft.class_2818;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_3300;
import net.minecraft.class_3532;
import net.minecraft.class_3614;
import net.minecraft.class_4548;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_638;
import net.minecraft.class_773;
import net.minecraft.class_776;
import net.minecraft.class_777;
import net.minecraft.class_804;
import net.minecraft.class_809;

public class ColorManager
implements IColorManager {
    private IVoxelMap master;
    class_310 game = null;
    private boolean resourcePacksChanged = false;
    private BufferedImage terrainBuff = null;
    private BufferedImage colorPicker;
    private int sizeOfBiomeArray = 0;
    private int[] blockColors = new int[65536];
    private int[] blockColorsWithDefaultTint = new int[65536];
    private final int COLOR_NOT_LOADED = -16842497;
    private final int COLOR_FAILED_LOAD = 0x1B000000;
    private HashSet<Integer> biomeTintsAvailable = new HashSet();
    private boolean optifineInstalled = false;
    private HashMap<Integer, Integer[]> blockTintTables = new HashMap();
    private HashSet<Integer> biomeTextureAvailable = new HashSet();
    private HashMap<String, Integer> blockBiomeSpecificColors = new HashMap();
    private float failedToLoadX = 0.0f;
    private float failedToLoadY = 0.0f;
    private String renderPassThreeBlendMode;
    private Random random = new Random();
    private final Object tpLoadLock = new Object();
    private boolean loaded = false;
    private final MutableBlockPos dummyBlockPos = new MutableBlockPos(class_2338.field_10980.method_10263(), class_2338.field_10980.method_10264(), class_2338.field_10980.method_10260());
    private final ColorResolver spruceColorResolver = new ColorResolver(){

        @Override
        public int getColorAtPos(class_2680 blockState, class_1959 biome, class_2338 blockPos) {
            return class_1926.method_8342();
        }
    };
    private final ColorResolver birchColorResolver = new ColorResolver(){

        @Override
        public int getColorAtPos(class_2680 blockState, class_1959 biome, class_2338 blockPos) {
            return class_1926.method_8343();
        }
    };
    private final ColorResolver grassColorResolver = new ColorResolver(){

        @Override
        public int getColorAtPos(class_2680 blockState, class_1959 biome, class_2338 blockPos) {
            return biome.method_8711((double)blockPos.method_10263(), (double)blockPos.method_10260());
        }
    };
    private final ColorResolver foliageColorResolver = new ColorResolver(){

        @Override
        public int getColorAtPos(class_2680 blockState, class_1959 biome, class_2338 blockPos) {
            return biome.method_8698();
        }
    };
    private final ColorResolver waterColorResolver = new ColorResolver(){

        @Override
        public int getColorAtPos(class_2680 blockState, class_1959 biome, class_2338 blockPos) {
            return biome.method_8687();
        }
    };
    private final ColorResolver redstoneColorResolver = new ColorResolver(){

        @Override
        public int getColorAtPos(class_2680 blockState, class_1959 biome, class_2338 blockPos) {
            return class_2457.method_10487((int)((Integer)blockState.method_11654((class_2769)class_2457.field_11432)));
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ColorManager(IVoxelMap master) {
        this.master = master;
        this.game = class_310.method_1551();
        this.optifineInstalled = false;
        Field ofProfiler = null;
        try {
            ofProfiler = class_315.class.getDeclaredField("ofProfiler");
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        finally {
            if (ofProfiler != null) {
                this.optifineInstalled = true;
            }
        }
        for (class_1959 biome : class_2378.field_11153) {
            int biomeID = class_2378.field_11153.method_10249((Object)biome);
            if (biomeID <= this.sizeOfBiomeArray) continue;
            this.sizeOfBiomeArray = biomeID;
        }
        ++this.sizeOfBiomeArray;
    }

    @Override
    public int getAirColor() {
        return this.blockColors[BlockRepository.airID];
    }

    @Override
    public BufferedImage getColorPicker() {
        return this.colorPicker;
    }

    @Override
    public void onResourceManagerReload(class_3300 resourceManager) {
        this.resourcePacksChanged = true;
    }

    @Override
    public boolean checkForChanges() {
        boolean changed = this.resourcePacksChanged;
        this.resourcePacksChanged = false;
        if (changed) {
            this.loadColors();
        }
        return changed;
    }

    public void loadColors() {
        this.game.field_1724.method_3117();
        BlockRepository.getBlocks();
        this.loadColorPicker();
        this.loadTexturePackTerrainImage();
        class_1058 missing = (class_1058)this.game.method_1549(class_1059.field_5275).apply(new class_2960("missingno"));
        this.failedToLoadX = missing.method_4594();
        this.failedToLoadY = missing.method_4593();
        this.loaded = false;
        try {
            Arrays.fill(this.blockColors, -16842497);
            Arrays.fill(this.blockColorsWithDefaultTint, -16842497);
            this.loadSpecialColors();
            this.biomeTintsAvailable.clear();
            this.biomeTextureAvailable.clear();
            this.blockBiomeSpecificColors.clear();
            this.blockTintTables.clear();
            if (this.optifineInstalled) {
                try {
                    this.processCTM();
                }
                catch (Exception e) {
                    System.err.println("error loading CTM " + e.getLocalizedMessage());
                    e.printStackTrace();
                }
            }
            try {
                this.loadWaterColor();
            }
            catch (Exception e) {
                System.err.println("error getting water color " + e.getLocalizedMessage());
            }
            if (this.optifineInstalled) {
                try {
                    this.processColorProperties();
                    this.processColorProperty(new class_2960("optifine/colormap/water.png"), "water");
                    this.processColorProperty(new class_2960("optifine/colormap/watercolor.png"), "water");
                    this.processColorProperty(new class_2960("optifine/colormap/watercolorx.png"), "water");
                    this.processColorProperty(new class_2960("optifine/colormap/swampgrass.png"), "grass_block grass fern tall_grass large_fern");
                    this.processColorProperty(new class_2960("optifine/colormap/swampgrasscolor.png"), "grass_block grass fern tall_grass large_fern");
                    this.processColorProperty(new class_2960("optifine/colormap/swampfoliage.png"), "oak_leaves vine");
                    this.processColorProperty(new class_2960("optifine/colormap/swampfoliagecolor.png"), "oak_leaves vine");
                    this.processColorProperty(new class_2960("optifine/colormap/pine.png"), "spruce_leaves");
                    this.processColorProperty(new class_2960("optifine/colormap/pinecolor.png"), "spruce_leaves");
                    this.processColorProperty(new class_2960("optifine/colormap/birch.png"), "birch_leaves");
                    this.processColorProperty(new class_2960("optifine/colormap/birchcolor.png"), "birch_leaves");
                }
                catch (Exception e) {
                    System.err.println("error loading custom color properties " + e.getLocalizedMessage());
                    e.printStackTrace();
                }
            }
            this.master.getMap().forceFullRender(true);
        }
        catch (Exception e) {
            System.err.println("error loading pack");
            e.printStackTrace();
        }
        this.loaded = true;
    }

    @Override
    public final BufferedImage getBlockImage(class_2680 blockState, class_1799 stack, class_1937 world) {
        try {
            class_1087 model = this.game.method_1480().method_4019(stack, world, (class_1309)null);
            this.drawModel(1.0f, 2, class_2350.field_11034, blockState, model, stack);
            BufferedImage blockImage = ImageUtils.createBufferedImageFromGLID(GLUtils.fboTextureID);
            blockImage = ImageUtils.trimCentered(blockImage);
            return blockImage;
        }
        catch (Exception e) {
            System.out.println("error getting block armor image for " + blockState.toString() + ": " + e.getLocalizedMessage());
            e.printStackTrace();
            return null;
        }
    }

    private void drawModel(float scale, int captureDepth, class_2350 facing, class_2680 blockState, class_1087 model, class_1799 stack) {
        float size = 16.0f * scale;
        class_809 transforms = model.method_4709();
        class_804 headTransforms = transforms.field_4311;
        class_1160 translations = headTransforms.field_4286;
        float transX = translations.method_4943() * size + 0.5f * size;
        float transY = translations.method_4945() * size + 0.5f * size;
        float transZ = translations.method_4947() * size + 0.5f * size;
        class_1160 rotations = headTransforms.field_4287;
        float rotX = rotations.method_4943();
        float rotY = rotations.method_4945();
        float rotZ = rotations.method_4947();
        GLShim.glBindTexture(3553, GLUtils.fboTextureID);
        int width = GLShim.glGetTexLevelParameteri(3553, 0, 4096);
        int height = GLShim.glGetTexLevelParameteri(3553, 0, 4097);
        GLShim.glBindTexture(3553, 0);
        GLShim.glPushAttrib(4096);
        GLShim.glViewport(0, 0, width, height);
        GLShim.glMatrixMode(5889);
        GLShim.glPushMatrix();
        GLShim.glLoadIdentity();
        GLShim.glOrtho(0.0, width, height, 0.0, 1000.0, 3000.0);
        GLShim.glMatrixMode(5888);
        GLShim.glPushMatrix();
        GLShim.glLoadIdentity();
        GLShim.glTranslatef(0.0f, 0.0f, -3000.0f - size / 4.0f);
        GLUtils.bindFrameBuffer();
        GLShim.glDepthMask(true);
        GLShim.glEnable(2929);
        GLShim.glEnable(3553);
        GLShim.glEnable(3042);
        GLShim.glEnable(3008);
        GLShim.glEnable(2977);
        GLShim.glDisable(2884);
        GLShim.glTexEnvi(8960, 8704, 7681);
        GLShim.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        GLShim.glClear(16640);
        GLShim.glBlendFunc(770, 771);
        GLShim.glPushMatrix();
        GLShim.glTranslatef((float)(width / 2) - size / 2.0f + transX, (float)(height / 2) - size / 2.0f + transY, 0.0f + transZ);
        GLShim.glScalef(size, size, size);
        GLUtils.img(class_1059.field_5275);
        GLShim.glRotatef(180.0f, 0.0f, 1.0f, 0.0f);
        GLShim.glRotatef(rotY, 0.0f, 1.0f, 0.0f);
        GLShim.glRotatef(rotX, 1.0f, 0.0f, 0.0f);
        GLShim.glRotatef(rotZ, 0.0f, 0.0f, 1.0f);
        if (facing == class_2350.field_11036) {
            GLShim.glRotatef(90.0f, 1.0f, 0.0f, 0.0f);
        }
        class_4587 matrixStack = new class_4587();
        matrixStack.method_22905(-1.0f, 1.0f, 1.0f);
        class_4597.class_4598 immediate = class_310.method_1551().method_22940().method_23000();
        class_310.method_1551().method_1480().method_23179(stack, class_809.class_811.field_4315, false, matrixStack, (class_4597)immediate, 0xF000F0, class_4608.field_21444, model);
        immediate.method_22993();
        GLShim.glPopMatrix();
        GLShim.glTexEnvi(8960, 8704, 8448);
        GLShim.glEnable(2884);
        GLShim.glDisable(2929);
        GLShim.glDepthMask(false);
        GLUtils.unbindFrameBuffer();
        GLShim.glMatrixMode(5889);
        GLShim.glPopMatrix();
        GLShim.glMatrixMode(5888);
        GLShim.glPopMatrix();
        GLShim.glPopAttrib();
        GLShim.glViewport(0, 0, this.game.method_22683().method_4489(), this.game.method_22683().method_4506());
    }

    private void loadColorPicker() {
        try {
            InputStream is = this.game.method_1478().method_14486(new class_2960("voxelmap", "images/colorpicker.png")).method_14482();
            BufferedImage picker = ImageIO.read(is);
            is.close();
            this.colorPicker = new BufferedImage(((Image)picker).getWidth(null), ((Image)picker).getHeight(null), 2);
            Graphics2D gfx = this.colorPicker.createGraphics();
            gfx.drawImage((Image)picker, 0, 0, null);
            gfx.dispose();
        }
        catch (Exception e) {
            System.err.println("Error loading color picker: " + e.getLocalizedMessage());
        }
    }

    @Override
    public void setSkyColor(int skyColor) {
        this.blockColors[BlockRepository.airID] = skyColor;
        this.blockColors[BlockRepository.voidAirID] = skyColor;
        this.blockColors[BlockRepository.caveAirID] = skyColor;
    }

    private void loadTexturePackTerrainImage() {
        try {
            class_1060 textureManager = this.game.method_1531();
            textureManager.method_22813(class_1059.field_5275);
            BufferedImage terrainStitched = ImageUtils.createBufferedImageFromCurrentGLImage();
            this.terrainBuff = new BufferedImage(terrainStitched.getWidth(null), terrainStitched.getHeight(null), 6);
            Graphics2D gfx = this.terrainBuff.createGraphics();
            gfx.drawImage((Image)terrainStitched, 0, 0, null);
            gfx.dispose();
        }
        catch (Exception e) {
            System.err.println("Error processing new resource pack: " + e.getLocalizedMessage());
            e.printStackTrace();
        }
    }

    private void loadSpecialColors() {
        int blockStateID;
        for (class_2680 blockState : BlockRepository.pistonTechBlock.method_9595().method_11662()) {
            blockStateID = BlockRepository.getStateId(blockState);
            this.blockColors[blockStateID] = 0;
        }
        for (class_2680 blockState : BlockRepository.barrier.method_9595().method_11662()) {
            blockStateID = BlockRepository.getStateId(blockState);
            this.blockColors[blockStateID] = 0;
        }
    }

    private void loadWaterColor() {
        int waterRGB = -1;
        class_2680 blockState = BlockRepository.water.method_9564();
        int blockStateID = BlockRepository.getStateId(blockState);
        waterRGB = this.getBlockColor(blockStateID);
        int waterMult = -1;
        if (this.optifineInstalled) {
            InputStream is = null;
            try {
                is = this.game.method_1478().method_14486(new class_2960("optifine/colormap/water.png")).method_14482();
            }
            catch (IOException e) {
                is = null;
            }
            if (is != null) {
                try {
                    BufferedImage waterColor = ImageIO.read(is);
                    is.close();
                    BufferedImage waterColorBuff = new BufferedImage(((Image)waterColor).getWidth(null), ((Image)waterColor).getHeight(null), 1);
                    Graphics2D gfx = waterColorBuff.createGraphics();
                    gfx.drawImage((Image)waterColor, 0, 0, null);
                    gfx.dispose();
                    class_1959 biome = class_1972.field_9409;
                    double var1 = class_3532.method_15363((float)biome.method_21740(new class_2338(0, 64, 0)), (float)0.0f, (float)1.0f);
                    double var2 = class_3532.method_15363((float)biome.method_8715(), (float)0.0f, (float)1.0f);
                    var2 *= var1;
                    var1 = 1.0 - var1;
                    var2 = 1.0 - var2;
                    waterMult = waterColorBuff.getRGB((int)((double)(waterColorBuff.getWidth() - 1) * var1), (int)((double)(waterColorBuff.getHeight() - 1) * var2)) & 0xFFFFFF;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        waterRGB = waterMult != -1 && waterMult != 0 ? this.colorMultiplier(waterRGB, waterMult | 0xFF000000) : this.colorMultiplier(waterRGB, class_1972.field_9409.method_8687() | 0xFF000000);
        for (int t = 0; t < 16; ++t) {
            blockState = (class_2680)BlockRepository.water.method_9564().method_11657((class_2769)class_2404.field_11278, (Comparable)Integer.valueOf(t));
            blockStateID = BlockRepository.getStateId(blockState);
            this.blockColorsWithDefaultTint[blockStateID] = waterRGB;
        }
    }

    @Override
    public final int getBlockColorWithDefaultTint(MutableBlockPos blockPos, int blockStateID) {
        if (this.loaded) {
            int col = this.blockColorsWithDefaultTint[blockStateID];
            if (col != -16842497 && col != 0x1B000000) {
                return col;
            }
            return this.getBlockColor(blockPos, blockStateID);
        }
        return 0;
    }

    @Override
    public final int getBlockColor(MutableBlockPos blockPos, int blockStateID, int biomeID) {
        if (this.loaded) {
            Integer col;
            if (this.optifineInstalled && this.biomeTextureAvailable.contains(blockStateID) && (col = this.blockBiomeSpecificColors.get("" + blockStateID + " " + biomeID)) != null) {
                return col;
            }
            return this.getBlockColor(blockPos, blockStateID);
        }
        return 0;
    }

    private int getBlockColor(int blockStateID) {
        return this.getBlockColor(this.dummyBlockPos, blockStateID);
    }

    private final int getBlockColor(MutableBlockPos blockPos, int blockStateID) {
        int col = 0x1B000000;
        try {
            if (this.blockColors[blockStateID] == -16842497) {
                class_2680 blockState = BlockRepository.getStateById(blockStateID);
                this.blockColors[blockStateID] = this.getColor(blockPos, blockState);
            }
            col = this.blockColors[blockStateID];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return col;
    }

    private int getColor(MutableBlockPos blockPos, class_2680 blockState) {
        try {
            class_2248 block;
            int color = this.getColorForBlockPosBlockStateAndFacing(blockPos, blockState, class_2350.field_11036);
            if (color == this.COLOR_FAILED_LOAD) {
                class_776 blockRendererDispatcher = this.game.method_1541();
                color = this.getColorForTerrainSprite(blockState, blockRendererDispatcher);
            }
            if ((block = blockState.method_11614()) == BlockRepository.cobweb) {
                color |= 0xFF000000;
            }
            if (block == BlockRepository.redstone) {
                color = this.colorMultiplier(color, this.game.method_1505().method_1697(blockState, (class_1920)null, (class_2338)null, 0) | 0xFF000000);
            }
            if (BlockRepository.biomeBlocks.contains(block)) {
                this.applyDefaultBuiltInShading(blockState, color);
            } else {
                this.checkForBiomeTinting(blockPos, blockState, color);
            }
            if (BlockRepository.shapedBlocks.contains(block)) {
                color = this.applyShape(block, color);
            }
            if ((color >> 24 & 0xFF) < 27) {
                color |= 0x1B000000;
            }
            return color;
        }
        catch (Exception e) {
            System.err.println("failed getting color: " + blockState.method_11614().method_9518().method_10863());
            e.printStackTrace();
            return 0x1B000000;
        }
    }

    private int getColorForBlockPosBlockStateAndFacing(class_2338 blockPos, class_2680 blockState, class_2350 facing) {
        int color = this.COLOR_FAILED_LOAD;
        try {
            class_2464 blockRenderType = blockState.method_11610();
            class_776 blockRendererDispatcher = this.game.method_1541();
            if (blockRenderType == class_2464.field_11458) {
                class_1087 iBakedModel = blockRendererDispatcher.method_3349(blockState);
                ArrayList<class_777> quads = new ArrayList<class_777>();
                quads.addAll(iBakedModel.method_4707(blockState, facing, this.random));
                quads.addAll(iBakedModel.method_4707(blockState, null, this.random));
                for (class_777 quad : quads) {
                    if (quad.method_3360()) continue;
                    BlockRepository.biomeBlocks.remove(blockState.method_11614());
                }
                BlockModel model = new BlockModel(quads);
                model.setFailedToLoadCoords(this.failedToLoadX, this.failedToLoadY);
                if (model.numberOfFaces() > 0) {
                    BufferedImage modelImage = model.getImage(this.terrainBuff);
                    if (modelImage != null) {
                        color = this.getColorForCoordinatesAndImage(new float[]{0.0f, 1.0f, 0.0f, 1.0f}, modelImage);
                    } else {
                        System.out.println("image was null");
                    }
                }
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
            color = this.COLOR_FAILED_LOAD;
        }
        return color;
    }

    private int getColorForTerrainSprite(class_2680 blockState, class_776 blockRendererDispatcher) {
        int color = this.COLOR_FAILED_LOAD;
        class_773 blockModelShapes = blockRendererDispatcher.method_3351();
        class_1058 icon = blockModelShapes.method_3339(blockState);
        if (icon == blockModelShapes.method_3333().method_4744().method_4711()) {
            class_2248 block = blockState.method_11614();
            class_3614 material = blockState.method_11620();
            if (block instanceof class_2404) {
                if (material == class_3614.field_15920) {
                    icon = (class_1058)class_310.method_1551().method_1549(class_1059.field_5275).apply(new class_2960("minecraft:blocks/water_flow"));
                } else if (material == class_3614.field_15922) {
                    icon = (class_1058)class_310.method_1551().method_1549(class_1059.field_5275).apply(new class_2960("minecraft:blocks/lava_flow"));
                }
            } else if (material == class_3614.field_15920) {
                icon = (class_1058)class_310.method_1551().method_1549(class_1059.field_5275).apply(new class_2960("minecraft:blocks/water_still"));
            } else if (material == class_3614.field_15922) {
                icon = (class_1058)class_310.method_1551().method_1549(class_1059.field_5275).apply(new class_2960("minecraft:blocks/lava_still"));
            }
        }
        color = this.getColorForIcon(icon);
        return color;
    }

    private int getColorForIcon(class_1058 icon) {
        int color = this.COLOR_FAILED_LOAD;
        if (icon != null) {
            float left = icon.method_4594();
            float right = icon.method_4577();
            float top = icon.method_4593();
            float bottom = icon.method_4575();
            color = this.getColorForCoordinatesAndImage(new float[]{left, right, top, bottom}, this.terrainBuff);
        }
        return color;
    }

    private int getColorForCoordinatesAndImage(float[] uv, BufferedImage imageBuff) {
        int color = 0x1B000000;
        if (uv[0] != this.failedToLoadX || uv[2] != this.failedToLoadY) {
            int left = (int)(uv[0] * (float)imageBuff.getWidth());
            int right = (int)Math.ceil(uv[1] * (float)imageBuff.getWidth());
            int top = (int)(uv[2] * (float)imageBuff.getHeight());
            int bottom = (int)Math.ceil(uv[3] * (float)imageBuff.getHeight());
            try {
                BufferedImage blockTexture = imageBuff.getSubimage(left, top, right - left, bottom - top);
                Image singlePixel = blockTexture.getScaledInstance(1, 1, 4);
                BufferedImage singlePixelBuff = new BufferedImage(1, 1, imageBuff.getType());
                Graphics2D gfx = singlePixelBuff.createGraphics();
                gfx.drawImage(singlePixel, 0, 0, null);
                gfx.dispose();
                color = singlePixelBuff.getRGB(0, 0);
            }
            catch (RasterFormatException e) {
                System.out.println("error getting color");
                System.out.println(left + " " + right + " " + top + " " + bottom);
                color = 0x1B000000;
            }
        }
        return color;
    }

    private void applyDefaultBuiltInShading(class_2680 blockState, int color) {
        class_2248 block = blockState.method_11614();
        int blockStateID = BlockRepository.getStateId(blockState);
        this.blockColorsWithDefaultTint[blockStateID] = block == BlockRepository.largeFern || block == BlockRepository.tallGrass || block == BlockRepository.reeds ? this.colorMultiplier(color, class_1933.method_8377((double)0.7, (double)0.8) | 0xFF000000) : this.colorMultiplier(color, this.game.method_1505().method_1697(blockState, (class_1920)null, (class_2338)null, 0) | 0xFF000000);
    }

    private void checkForBiomeTinting(MutableBlockPos blockPos, class_2680 blockState, int color) {
        class_2248 block = blockState.method_11614();
        String blockName = "" + class_2378.field_11146.method_10221((Object)block);
        if (!BlockRepository.biomeBlocks.contains(block) && !blockName.startsWith("minecraft:")) {
            class_2791 chunk;
            int tint = -1;
            MutableBlockPos tempBlockPos = new MutableBlockPos(0, 0, 0);
            tint = blockPos == this.dummyBlockPos ? this.tintFromFakePlacedBlock(blockState, tempBlockPos, (byte)4) : ((chunk = this.game.field_1687.method_22350((class_2338)blockPos)) != null && !((class_2818)chunk).method_12223() && this.game.field_1687.method_8393(blockPos.method_10263() >> 4, blockPos.method_10260() >> 4) ? this.game.method_1505().method_1697(blockState, (class_1920)this.game.field_1687, (class_2338)blockPos, 1) | 0xFF000000 : this.tintFromFakePlacedBlock(blockState, tempBlockPos, (byte)4));
            if (tint != 0xFFFFFF && tint != -1) {
                int blockStateID = BlockRepository.getStateId(blockState);
                this.biomeTintsAvailable.add(blockStateID);
                this.blockColorsWithDefaultTint[blockStateID] = this.colorMultiplier(color, tint);
                this.createTintTable(blockState, tempBlockPos);
            } else {
                this.blockColorsWithDefaultTint[BlockRepository.getStateId((class_2680)blockState)] = 0x1B000000;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int tintFromFakePlacedBlock(class_2680 blockState, MutableBlockPos loopBlockPos, byte biomeID) {
        class_638 world = this.game.field_1687;
        if (world == null) {
            return -1;
        }
        if (blockState.method_11614() == null) {
            return -1;
        }
        Share.updateCloudsLock.lock();
        int tint = -1;
        try {
            int fakeX = (int)this.game.field_1724.method_23317() - 32;
            int fakeZ = (int)this.game.field_1724.method_23321() - 32;
            class_2791 chunk = world.method_22350((class_2338)loopBlockPos.withXYZ(fakeX, 0, fakeZ));
            class_2680 actualBlockState = world.method_8320((class_2338)loopBlockPos);
            chunk.method_12010((class_2338)loopBlockPos, blockState, false);
            class_4548 biomeArray = chunk.method_12036();
            Object[] actualBiomes = (class_1959[])ReflectionUtils.getPrivateFieldValueByType(biomeArray, class_4548.class, class_1959[].class);
            class_1959[] fakeBiome = new class_1959[actualBiomes.length];
            System.arraycopy(actualBiomes, 0, fakeBiome, 0, actualBiomes.length);
            Arrays.fill(actualBiomes, class_2378.field_11153.method_10200((int)biomeID));
            tint = this.game.method_1505().method_1697(blockState, (class_1920)world, (class_2338)loopBlockPos, 1) | 0xFF000000;
            System.arraycopy(fakeBiome, 0, actualBiomes, 0, actualBiomes.length);
            chunk.method_12010((class_2338)loopBlockPos, actualBlockState, false);
        }
        catch (Exception exception) {
        }
        finally {
            Share.updateCloudsLock.unlock();
        }
        return tint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTintTable(class_2680 blockState, MutableBlockPos loopBlockPos) {
        class_638 world = this.game.field_1687;
        if (world == null) {
            return;
        }
        class_2248 block = blockState.method_11614();
        if (block == null) {
            return;
        }
        Share.updateCloudsLock.lock();
        try {
            Object[] tints = new Integer[this.sizeOfBiomeArray];
            Arrays.fill(tints, (Object)-1);
            int fakeX = (int)this.game.field_1724.method_23317() - 32;
            int fakeZ = (int)this.game.field_1724.method_23321() - 32;
            class_2791 chunk = world.method_22350((class_2338)loopBlockPos.withXYZ(fakeX, 0, fakeZ));
            class_2680 actualBlockState = world.method_8320((class_2338)loopBlockPos);
            chunk.method_12010((class_2338)loopBlockPos, blockState, false);
            class_4548 biomeArray = chunk.method_12036();
            Object[] actualBiomes = (class_1959[])ReflectionUtils.getPrivateFieldValueByType(biomeArray, class_4548.class, class_1959[].class);
            Object[] fakeBiome = new class_1959[actualBiomes.length];
            System.arraycopy(actualBiomes, 0, fakeBiome, 0, actualBiomes.length);
            for (int biomeID = 0; biomeID < this.sizeOfBiomeArray; ++biomeID) {
                class_1959 biome = (class_1959)class_2378.field_11153.method_10200(biomeID);
                if (biome == null) continue;
                Arrays.fill(fakeBiome, biome);
                Arrays.fill(actualBiomes, class_2378.field_11153.method_10200(biomeID));
                tints[biomeID] = this.game.method_1505().method_1697(blockState, (class_1920)world, (class_2338)loopBlockPos, 1) | 0xFF000000;
            }
            System.arraycopy(fakeBiome, 0, actualBiomes, 0, actualBiomes.length);
            chunk.method_12010((class_2338)loopBlockPos, actualBlockState, false);
            int blockStateID = BlockRepository.getStateId(blockState);
            this.blockTintTables.put(blockStateID, (Integer[])tints);
        }
        catch (Exception exception) {
        }
        finally {
            Share.updateCloudsLock.unlock();
        }
    }

    @Override
    public int getBiomeTint(AbstractMapData mapData, class_1937 world, class_2680 blockState, int blockStateID, MutableBlockPos blockPos, MutableBlockPos loopBlockPos, int startX, int startZ) {
        class_2791 chunk = world.method_22350((class_2338)blockPos);
        boolean live = chunk != null && !((class_2818)chunk).method_12223() && this.game.field_1687.method_8393(blockPos.method_10263() >> 4, blockPos.method_10260() >> 4);
        live = live && this.game.field_1687.method_22340((class_2338)blockPos);
        int tint = -2;
        if (this.optifineInstalled || !live && this.biomeTintsAvailable.contains(blockStateID)) {
            try {
                Integer[] tints = this.blockTintTables.get(blockStateID);
                if (tints != null) {
                    int r = 0;
                    int g = 0;
                    int b = 0;
                    for (int t = blockPos.method_10263() - 1; t <= blockPos.method_10263() + 1; ++t) {
                        for (int s = blockPos.method_10260() - 1; s <= blockPos.method_10260() + 1; ++s) {
                            int biomeID = 0;
                            if (live) {
                                biomeID = class_2378.field_11153.method_10249((Object)world.method_23753((class_2338)loopBlockPos.withXYZ(t, blockPos.method_10264(), s)));
                            } else {
                                int dataX = t - startX;
                                int dataZ = s - startZ;
                                dataX = Math.max(dataX, 0);
                                dataX = Math.min(dataX, mapData.getWidth() - 1);
                                dataZ = Math.max(dataZ, 0);
                                biomeID = mapData.getBiomeID(dataX, dataZ = Math.min(dataZ, mapData.getHeight() - 1));
                                if (biomeID == -1) {
                                    biomeID = 1;
                                }
                            }
                            int biomeTint = tints[biomeID];
                            r += (biomeTint & 0xFF0000) >> 16;
                            g += (biomeTint & 0xFF00) >> 8;
                            b += biomeTint & 0xFF;
                        }
                    }
                    tint = 0xFF000000 | (r / 9 & 0xFF) << 16 | (g / 9 & 0xFF) << 8 | b / 9 & 0xFF;
                }
            }
            catch (Exception e) {
                tint = -2;
            }
        }
        if (tint == -2) {
            tint = this.getBuiltInBiomeTint(mapData, world, blockState, blockStateID, blockPos, loopBlockPos, startX, startZ, live);
        }
        return tint;
    }

    private int getBuiltInBiomeTint(AbstractMapData mapData, class_1937 world, class_2680 blockState, int blockStateID, MutableBlockPos blockPos, MutableBlockPos loopBlockPos, int startX, int startZ, boolean live) {
        int tint = -1;
        class_2248 block = blockState.method_11614();
        if (BlockRepository.biomeBlocks.contains(block) || this.biomeTintsAvailable.contains(blockStateID)) {
            tint = !live ? this.getBuiltInBiomeTintFromUnloadedChunk(mapData, world, blockState, blockStateID, blockPos, loopBlockPos, startX, startZ) | 0xFF000000 : this.game.method_1505().method_1697(blockState, (class_1920)world, (class_2338)blockPos, 1) | 0xFF000000;
        }
        return tint;
    }

    private int getBuiltInBiomeTintFromUnloadedChunk(AbstractMapData mapData, class_1937 world, class_2680 blockState, int blockStateID, MutableBlockPos blockPos, MutableBlockPos loopBlockPos, int startX, int startZ) {
        int tint = -1;
        class_2248 block = blockState.method_11614();
        ColorResolver colorResolver = null;
        if (block == BlockRepository.water) {
            colorResolver = this.waterColorResolver;
        } else if (block == BlockRepository.spruceLeaves) {
            colorResolver = this.spruceColorResolver;
        } else if (block == BlockRepository.birchLeaves) {
            colorResolver = this.birchColorResolver;
        } else if (block == BlockRepository.oakLeaves || block == BlockRepository.jungleLeaves || block == BlockRepository.acaciaLeaves || block == BlockRepository.darkOakLeaves || block == BlockRepository.vine) {
            colorResolver = this.foliageColorResolver;
        } else if (block == BlockRepository.redstone) {
            colorResolver = this.redstoneColorResolver;
        } else if (BlockRepository.biomeBlocks.contains(block)) {
            colorResolver = this.grassColorResolver;
        }
        if (colorResolver != null) {
            int r = 0;
            int g = 0;
            int b = 0;
            for (int t = blockPos.method_10263() - 1; t <= blockPos.method_10263() + 1; ++t) {
                for (int s = blockPos.method_10260() - 1; s <= blockPos.method_10260() + 1; ++s) {
                    int dataX = t - startX;
                    int dataZ = s - startZ;
                    dataX = Math.max(dataX, 0);
                    dataX = Math.min(dataX, 255);
                    dataZ = Math.max(dataZ, 0);
                    int biomeID = mapData.getBiomeID(dataX, dataZ = Math.min(dataZ, 255));
                    class_1959 biome = (class_1959)class_2378.field_11153.method_10200(biomeID);
                    if (biome == null) {
                        MessageUtils.printDebug("Null biome ID! " + biomeID + " at " + t + "," + s);
                        MessageUtils.printDebug("block: " + mapData.getBlockstate(dataX, dataZ) + ", height: " + mapData.getHeight(dataX, dataZ));
                        MessageUtils.printDebug("Mapdata: " + mapData.toString());
                        biome = class_1972.field_9409;
                    }
                    int biomeTint = colorResolver.getColorAtPos(blockState, biome, loopBlockPos.withXYZ(t, blockPos.method_10264(), s));
                    r += (biomeTint & 0xFF0000) >> 16;
                    g += (biomeTint & 0xFF00) >> 8;
                    b += biomeTint & 0xFF;
                }
            }
            tint = (r / 9 & 0xFF) << 16 | (g / 9 & 0xFF) << 8 | b / 9 & 0xFF;
        } else if (this.biomeTintsAvailable.contains(blockStateID)) {
            tint = this.getCustomBlockBiomeTintFromUnloadedChunk(mapData, world, blockState, blockPos, loopBlockPos, startX, startZ);
        }
        return tint;
    }

    private int getCustomBlockBiomeTintFromUnloadedChunk(AbstractMapData mapData, class_1937 world, class_2680 blockState, MutableBlockPos blockPos, MutableBlockPos loopBlockPos, int startX, int startZ) {
        int tint = -1;
        try {
            int dataX = blockPos.method_10263() - startX;
            int dataZ = blockPos.method_10260() - startZ;
            dataX = Math.max(dataX, 0);
            dataX = Math.min(dataX, mapData.getWidth() - 1);
            dataZ = Math.max(dataZ, 0);
            dataZ = Math.min(dataZ, mapData.getHeight() - 1);
            byte biomeID = (byte)mapData.getBiomeID(dataX, dataZ);
            tint = this.tintFromFakePlacedBlock(blockState, loopBlockPos, biomeID);
        }
        catch (Exception e) {
            tint = -1;
        }
        return tint;
    }

    private int applyShape(class_2248 block, int color) {
        int alpha = color >> 24 & 0xFF;
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color >> 0 & 0xFF;
        if (block == BlockRepository.sign || block == BlockRepository.wallSign) {
            alpha = 31;
        } else if (Arrays.asList(BlockRepository.doorsArray).contains(block)) {
            alpha = 47;
        } else if (block == BlockRepository.ladder || block == BlockRepository.vine) {
            alpha = 15;
        }
        color = (alpha & 0xFF) << 24 | (red & 0xFF) << 16 | (green & 0xFF) << 8 | blue & 0xFF;
        return color;
    }

    @Override
    public int colorMultiplier(int color1, int color2) {
        int alpha1 = color1 >> 24 & 0xFF;
        int red1 = color1 >> 16 & 0xFF;
        int green1 = color1 >> 8 & 0xFF;
        int blue1 = color1 >> 0 & 0xFF;
        int alpha2 = color2 >> 24 & 0xFF;
        int red2 = color2 >> 16 & 0xFF;
        int green2 = color2 >> 8 & 0xFF;
        int blue2 = color2 >> 0 & 0xFF;
        int alpha = alpha1 * alpha2 / 255;
        int red = red1 * red2 / 255;
        int green = green1 * green2 / 255;
        int blue = blue1 * blue2 / 255;
        return (alpha & 0xFF) << 24 | (red & 0xFF) << 16 | (green & 0xFF) << 8 | blue & 0xFF;
    }

    @Override
    public int colorAdder(int color1, int color2) {
        float topAlpha = (float)(color1 >> 24 & 0xFF) / 255.0f;
        float red1 = (float)(color1 >> 16 & 0xFF) * topAlpha;
        float green1 = (float)(color1 >> 8 & 0xFF) * topAlpha;
        float blue1 = (float)(color1 >> 0 & 0xFF) * topAlpha;
        float bottomAlpha = (float)(color2 >> 24 & 0xFF) / 255.0f;
        float red2 = (float)(color2 >> 16 & 0xFF) * bottomAlpha * (1.0f - topAlpha);
        float green2 = (float)(color2 >> 8 & 0xFF) * bottomAlpha * (1.0f - topAlpha);
        float blue2 = (float)(color2 >> 0 & 0xFF) * bottomAlpha * (1.0f - topAlpha);
        float alpha = topAlpha + bottomAlpha * (1.0f - topAlpha);
        float red = (red1 + red2) / alpha;
        float green = (green1 + green2) / alpha;
        float blue = (blue1 + blue2) / alpha;
        return ((int)(alpha * 255.0f) & 0xFF) << 24 | ((int)red & 0xFF) << 16 | ((int)green & 0xFF) << 8 | (int)blue & 0xFF;
    }

    private void processCTM() {
        this.renderPassThreeBlendMode = "alpha";
        Properties properties = new Properties();
        class_2960 propertiesFile = new class_2960("minecraft", "optifine/renderpass.properties");
        try {
            InputStream input = this.game.method_1478().method_14486(propertiesFile).method_14482();
            if (input != null) {
                properties.load(input);
                input.close();
                this.renderPassThreeBlendMode = properties.getProperty("blend.3", "alpha");
            }
        }
        catch (IOException e) {
            this.renderPassThreeBlendMode = "alpha";
        }
        String namespace = "minecraft";
        for (class_2960 s : this.findResources(namespace, "/optifine/ctm", ".properties", true, false, true)) {
            try {
                this.loadCTM(s);
            }
            catch (NumberFormatException numberFormatException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        for (int t = 0; t < this.blockColors.length; ++t) {
            if (this.blockColors[t] == this.COLOR_FAILED_LOAD || this.blockColors[t] == this.COLOR_NOT_LOADED) continue;
            if ((this.blockColors[t] >> 24 & 0xFF) < 27) {
                this.blockColors[t] = this.blockColors[t] | 0x1B000000;
            }
            this.checkForBiomeTinting(this.dummyBlockPos, BlockRepository.getStateById(t), this.blockColors[t]);
        }
    }

    private void loadCTM(class_2960 propertiesFile) {
        if (propertiesFile == null) {
            return;
        }
        class_776 blockRendererDispatcher = this.game.method_1541();
        class_773 blockModelShapes = blockRendererDispatcher.method_3351();
        Properties properties = new Properties();
        try {
            InputStream input = this.game.method_1478().method_14486(propertiesFile).method_14482();
            if (input != null) {
                properties.load(input);
                input.close();
            }
        }
        catch (IOException e) {
            return;
        }
        String filePath = propertiesFile.method_12832();
        String method = properties.getProperty("method", "").trim().toLowerCase();
        String faces = properties.getProperty("faces", "").trim().toLowerCase();
        String matchBlocks = properties.getProperty("matchBlocks", "").trim().toLowerCase();
        String matchTiles = properties.getProperty("matchTiles", "").trim().toLowerCase();
        String metadata = properties.getProperty("metadata", "").trim().toLowerCase();
        String tiles = properties.getProperty("tiles", "").trim();
        String biomes = properties.getProperty("biomes", "").trim().toLowerCase();
        String renderPass = properties.getProperty("renderPass", "").trim().toLowerCase();
        metadata = metadata.replaceAll("\\s+", ",");
        HashSet<Object> blockStates = new HashSet<Object>();
        blockStates.addAll(this.parseBlocksList(matchBlocks, metadata));
        String directory = filePath.substring(0, filePath.lastIndexOf("/") + 1);
        String[] tilesParsed = this.parseStringList(tiles);
        String tilePath = directory + "0";
        if (tilesParsed.length > 0) {
            tilePath = tilesParsed[0].trim();
        }
        if (tilePath.startsWith("~")) {
            tilePath = tilePath.replace("~", "optifine");
        } else if (!tilePath.contains("/")) {
            tilePath = directory + tilePath;
        }
        if (!tilePath.toLowerCase().endsWith(".png")) {
            tilePath = tilePath + ".png";
        }
        String[] biomesArray = biomes.split(" ");
        if (blockStates.size() == 0) {
            class_2248 block = null;
            Pattern pattern = Pattern.compile(".*/block_(.+).properties");
            Matcher matcher = pattern.matcher(filePath);
            if (matcher.find()) {
                block = this.getBlockFromName(matcher.group(1));
                if (block != null) {
                    Set<class_2680> matching = this.parseBlockMetadata(block, metadata);
                    if (matching.size() == 0) {
                        matching.addAll((Collection<class_2680>)block.method_9595().method_11662());
                    }
                    blockStates.addAll(matching);
                }
            } else {
                if (matchTiles.equals("")) {
                    matchTiles = filePath.substring(filePath.lastIndexOf("/") + 1, filePath.lastIndexOf(".properties"));
                }
                if (!matchTiles.contains(":")) {
                    matchTiles = "minecraft:blocks/" + matchTiles;
                }
                class_2960 matchID = new class_2960(matchTiles);
                class_1058 compareIcon = (class_1058)this.game.method_1549(class_1059.field_5275).apply(matchID);
                if (compareIcon.method_4598() != class_1047.method_4539()) {
                    ArrayList<class_2680> tmpList = new ArrayList<class_2680>();
                    for (class_2248 class_22482 : class_2378.field_11146) {
                        for (class_2680 blockState : class_22482.method_9595().method_11662()) {
                            try {
                                class_1087 bakedModel = blockModelShapes.method_3335(blockState);
                                ArrayList<class_777> quads = new ArrayList<class_777>();
                                quads.addAll(bakedModel.method_4707(blockState, class_2350.field_11036, this.random));
                                quads.addAll(bakedModel.method_4707(blockState, null, this.random));
                                BlockModel model = new BlockModel(quads);
                                model.setFailedToLoadCoords(this.failedToLoadX, this.failedToLoadY);
                                if (model.numberOfFaces() <= 0) continue;
                                ArrayList<BlockModel.BlockFace> blockFaces = model.getFaces();
                                for (int i = 0; i < blockFaces.size(); ++i) {
                                    float maxV;
                                    float minV;
                                    float maxU;
                                    BlockModel.BlockFace face = model.getFaces().get(i);
                                    float minU = face.getMinU();
                                    if (!this.similarEnough(minU, maxU = face.getMaxU(), minV = face.getMinV(), maxV = face.getMaxV(), compareIcon.method_4594(), compareIcon.method_4577(), compareIcon.method_4593(), compareIcon.method_4575())) continue;
                                    tmpList.add(blockState);
                                }
                            }
                            catch (Exception bakedModel) {
                            }
                        }
                    }
                    blockStates.addAll(tmpList);
                }
            }
        }
        if (blockStates.size() == 0) {
            return;
        }
        if (!method.equals("horizontal") && !method.startsWith("overlay") && (method.equals("sandstone") || method.equals("top") || faces.contains("top") || faces.contains("all") || faces.length() == 0)) {
            try {
                class_2960 pngResource = new class_2960(propertiesFile.method_12836(), tilePath);
                InputStream is = this.game.method_1478().method_14486(pngResource).method_14482();
                Image top = ImageIO.read(is);
                is.close();
                top = top.getScaledInstance(1, 1, 4);
                BufferedImage topBuff = new BufferedImage(top.getWidth(null), top.getHeight(null), 6);
                Graphics2D gfx = topBuff.createGraphics();
                gfx.drawImage(top, 0, 0, null);
                gfx.dispose();
                int topRGB = topBuff.getRGB(0, 0);
                if ((topRGB >> 24 & 0xFF) == 0) {
                    return;
                }
                for (class_2680 class_26802 : blockStates) {
                    int blockStateID;
                    topRGB = topBuff.getRGB(0, 0);
                    if (class_26802.method_11614() == BlockRepository.cobweb) {
                        topRGB |= 0xFF000000;
                    }
                    if (renderPass.equals("3")) {
                        topRGB = this.processRenderPassThree(topRGB);
                        blockStateID = BlockRepository.getStateId(class_26802);
                        int baseRGB = this.blockColors[blockStateID];
                        if (baseRGB != this.COLOR_FAILED_LOAD && baseRGB != this.COLOR_NOT_LOADED) {
                            topRGB = this.colorMultiplier(baseRGB, topRGB);
                        }
                    }
                    if (BlockRepository.shapedBlocks.contains(class_26802.method_11614())) {
                        topRGB = this.applyShape(class_26802.method_11614(), topRGB);
                    }
                    blockStateID = BlockRepository.getStateId(class_26802);
                    if (!biomes.equals("")) {
                        this.biomeTextureAvailable.add(blockStateID);
                        for (int r = 0; r < biomesArray.length; ++r) {
                            int biomeInt = this.parseBiomeName(biomesArray[r]);
                            if (biomeInt == -1) continue;
                            this.blockBiomeSpecificColors.put("" + blockStateID + " " + biomeInt, topRGB);
                        }
                        continue;
                    }
                    this.blockColors[blockStateID] = topRGB;
                }
            }
            catch (IOException e) {
                System.err.println("error getting CTM block from " + propertiesFile.method_12832() + ": " + filePath + " " + class_2378.field_11146.method_10221((Object)((class_2680)blockStates.iterator().next()).method_11614()).toString() + " " + tilePath);
                e.printStackTrace();
            }
        }
    }

    private boolean similarEnough(float a, float b, float c, float d, float one, float two, float three, float four) {
        boolean similar = (double)Math.abs(a - one) < 1.0E-4;
        similar = similar && (double)Math.abs(b - two) < 1.0E-4;
        similar = similar && (double)Math.abs(c - three) < 1.0E-4;
        similar = similar && (double)Math.abs(d - four) < 1.0E-4;
        return similar;
    }

    private int processRenderPassThree(int rgb) {
        if (this.renderPassThreeBlendMode.equals("color") || this.renderPassThreeBlendMode.equals("overlay")) {
            int red = rgb >> 16 & 0xFF;
            int green = rgb >> 8 & 0xFF;
            int blue = rgb >> 0 & 0xFF;
            float colorAverage = (float)(red + blue + green) / 3.0f;
            float lighteningFactor = (colorAverage - 127.5f) * 2.0f;
            red += (int)((float)red * (lighteningFactor / 255.0f));
            int newAlpha = (int)Math.abs(lighteningFactor);
            rgb = newAlpha << 24 | (red & 0xFF) << 16 | ((green += (int)((float)red * (lighteningFactor / 255.0f))) & 0xFF) << 8 | (blue += (int)((float)red * (lighteningFactor / 255.0f))) & 0xFF;
        }
        return rgb;
    }

    private String[] parseStringList(String list) {
        ArrayList<String> tmpList = new ArrayList<String>();
        for (String token : list.split("\\s+")) {
            token = token.trim();
            try {
                if (token.matches("^\\d+$")) {
                    tmpList.add("" + Integer.parseInt(token));
                    continue;
                }
                if (token.matches("^\\d+-\\d+$")) {
                    String[] t = token.split("-");
                    int min = Integer.parseInt(t[0]);
                    int max = Integer.parseInt(t[1]);
                    for (int i = min; i <= max; ++i) {
                        tmpList.add("" + i);
                    }
                    continue;
                }
                if (token == null || token == "") continue;
                tmpList.add(token);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        String[] a = new String[tmpList.size()];
        for (int i = 0; i < a.length; ++i) {
            a[i] = (String)tmpList.get(i);
        }
        return a;
    }

    private Set<class_2680> parseBlocksList(String blocks, String metadataLine) {
        HashSet<class_2680> blockStates = new HashSet<class_2680>();
        for (String blockString : blocks.split("\\s+")) {
            String metadata = metadataLine;
            blockString = blockString.trim();
            String[] blockComponents = blockString.split(":");
            int tokensUsed = 0;
            class_2248 block = null;
            block = this.getBlockFromName(blockComponents[0]);
            if (block != null) {
                tokensUsed = 1;
            } else if (blockComponents.length > 1 && (block = this.getBlockFromName(blockComponents[0] + ":" + blockComponents[1])) != null) {
                tokensUsed = 2;
            }
            if (block == null) continue;
            if (blockComponents.length > tokensUsed) {
                metadata = blockComponents[tokensUsed];
                for (int t = tokensUsed + 1; t < blockComponents.length; ++t) {
                    metadata = metadata + ":" + blockComponents[t];
                }
            }
            blockStates.addAll(this.parseBlockMetadata(block, metadata));
        }
        return blockStates;
    }

    private <T extends Comparable<T>, V extends T> Set<class_2680> parseBlockMetadata(class_2248 block, String metadataList) {
        HashSet<class_2680> blockStates = new HashSet<class_2680>();
        if (metadataList.equals("")) {
            blockStates.addAll((Collection<class_2680>)block.method_9595().method_11662());
        } else {
            HashSet<String> valuePairs = new HashSet<String>();
            for (String metadata : metadataList.split(":")) {
                metadata.trim();
                if (!metadata.contains("=")) continue;
                valuePairs.add(metadata);
            }
            if (valuePairs.size() > 0) {
                for (class_2680 blockState : block.method_9595().method_11662()) {
                    boolean matches = true;
                    for (String pair : valuePairs) {
                        String[] values;
                        class_2769 property;
                        String[] propertyAndValues = pair.split("\\s*=\\s*", 5);
                        if (propertyAndValues.length != 2 || (property = block.method_9595().method_11663(propertyAndValues[0])) == null) continue;
                        boolean valueIncluded = false;
                        for (String value : values = propertyAndValues[1].split(",")) {
                            if (property.method_11902() == Integer.class && value.matches("^\\d+-\\d+$")) {
                                String[] range = value.split("-");
                                int min = Integer.parseInt(range[0]);
                                int max = Integer.parseInt(range[1]);
                                int intValue = (Integer)Integer.class.cast(blockState.method_11654(property));
                                if (intValue < min || intValue > max) continue;
                                valueIncluded = true;
                                continue;
                            }
                            if (blockState.method_11654(property).equals(property.method_11900(value))) continue;
                            valueIncluded = true;
                        }
                        matches = matches && valueIncluded;
                    }
                    if (!matches) continue;
                    blockStates.add(blockState);
                }
            }
        }
        return blockStates;
    }

    private int parseBiomeName(String name) {
        class_1959 biome = (class_1959)class_2378.field_11153.method_10223(new class_2960(name));
        if (biome != null) {
            return class_2378.field_11153.method_10249((Object)biome);
        }
        return -1;
    }

    private List<class_2960> findResources(String namespace, String directory, String suffixMaybeNull, boolean recursive, boolean directories, boolean sortByFilename) {
        if (directory == null) {
            directory = "";
        }
        if (directory.startsWith("/")) {
            directory = directory.substring(1);
        }
        String suffix = suffixMaybeNull == null ? "" : suffixMaybeNull;
        ArrayList<class_2960> resources = new ArrayList<class_2960>();
        Collection candidates = this.game.method_1478().method_14488(directory, asset -> asset.endsWith(suffix));
        for (class_2960 candidate : candidates) {
            if (!candidate.method_12836().equals(namespace)) continue;
            resources.add(candidate);
        }
        if (sortByFilename) {
            Collections.sort(resources, new Comparator<class_2960>(){

                @Override
                public int compare(class_2960 o1, class_2960 o2) {
                    String f2;
                    String f1 = o1.method_12832().replaceAll(".*/", "").replaceFirst("\\.properties", "");
                    int result = f1.compareTo(f2 = o2.method_12832().replaceAll(".*/", "").replaceFirst("\\.properties", ""));
                    if (result != 0) {
                        return result;
                    }
                    return o1.method_12832().compareTo(o2.method_12832());
                }
            });
        } else {
            Collections.sort(resources, new Comparator<class_2960>(){

                @Override
                public int compare(class_2960 o1, class_2960 o2) {
                    return o1.method_12832().compareTo(o2.method_12832());
                }
            });
        }
        return resources;
    }

    private void processColorProperties() {
        ArrayList<class_2960> unusedPNGs = new ArrayList<class_2960>();
        unusedPNGs.addAll(this.findResources("minecraft", "/optifine/colormap/blocks", ".png", true, false, true));
        Properties properties = new Properties();
        try {
            InputStream input = this.game.method_1478().method_14486(new class_2960("optifine/color.properties")).method_14482();
            if (input != null) {
                properties.load(input);
                input.close();
            }
        }
        catch (IOException input) {
            // empty catch block
        }
        class_2680 blockState = BlockRepository.lilypad.method_9564();
        int blockStateID = BlockRepository.getStateId(blockState);
        int lilyRGB = this.getBlockColor(blockStateID);
        int lilypadMultiplier = 2129968;
        String lilypadMultiplierString = properties.getProperty("lilypad");
        if (lilypadMultiplierString != null) {
            lilypadMultiplier = Integer.parseInt(lilypadMultiplierString, 16);
        }
        for (class_2680 padBlockState : BlockRepository.lilypad.method_9595().method_11662()) {
            blockStateID = BlockRepository.getStateId(padBlockState);
            this.blockColors[blockStateID] = this.colorMultiplier(lilyRGB, lilypadMultiplier | 0xFF000000);
            this.blockColorsWithDefaultTint[blockStateID] = this.blockColors[blockStateID];
        }
        Enumeration<?> e = properties.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!key.startsWith("palette.block")) continue;
            String filename = key.substring("palette.block.".length());
            filename = filename.replace("~", "optifine");
            this.processColorProperty(new class_2960(filename), properties.getProperty(key));
        }
        for (class_2960 resource : this.findResources("minecraft", "/optifine/colormap/blocks", ".properties", true, false, true)) {
            Properties colorProperties;
            block10: {
                colorProperties = new Properties();
                try {
                    InputStream input = this.game.method_1478().method_14486(resource).method_14482();
                    if (input == null) break block10;
                    colorProperties.load(input);
                    input.close();
                }
                catch (IOException e2) {
                    break;
                }
            }
            String names = colorProperties.getProperty("blocks");
            class_2960 resourcePNG = new class_2960(resource.method_12836(), resource.method_12832().replace(".properties", ".png"));
            unusedPNGs.remove(resourcePNG);
            if (names == null) continue;
            this.processColorProperty(resourcePNG, names);
        }
        for (class_2960 resource : unusedPNGs) {
            String name = resource.method_12832();
            System.out.println("processing name: " + name);
            name = name.substring(name.lastIndexOf("/") + 1, name.lastIndexOf(".png"));
            System.out.println("processed name: " + name);
            this.processColorProperty(resource, "minecraft:" + name);
        }
    }

    private void processColorProperty(class_2960 resource, String list) {
        Object[] tints = new Integer[this.sizeOfBiomeArray];
        Arrays.fill(tints, (Object)-1);
        boolean swamp = resource.method_12832().contains("/swamp");
        BufferedImage tintColors = null;
        try {
            InputStream is = this.game.method_1478().method_14486(resource).method_14482();
            tintColors = ImageIO.read(is);
            is.close();
        }
        catch (IOException e) {
            return;
        }
        BufferedImage tintColorsBuff = new BufferedImage(((Image)tintColors).getWidth(null), ((Image)tintColors).getHeight(null), 1);
        Graphics2D gfx = tintColorsBuff.createGraphics();
        gfx.drawImage((Image)tintColors, 0, 0, null);
        gfx.dispose();
        for (int t = 0; t < this.sizeOfBiomeArray; ++t) {
            class_1959 biome = (class_1959)class_2378.field_11153.method_10200(t);
            if (biome == null) continue;
            double var1 = class_3532.method_15363((float)biome.method_21740(new class_2338(0, 64, 0)), (float)0.0f, (float)1.0f);
            double var2 = class_3532.method_15363((float)biome.method_8715(), (float)0.0f, (float)1.0f);
            var2 *= var1;
            var1 = 1.0 - var1;
            var2 = 1.0 - var2;
            int tintMult = tintColorsBuff.getRGB((int)((double)(tintColorsBuff.getWidth() - 1) * var1), (int)((double)(tintColorsBuff.getHeight() - 1) * var2)) & 0xFFFFFF;
            if (tintMult == 0 || swamp && biome != class_1972.field_9471 && biome != class_1972.field_9479) continue;
            tints[t] = tintMult;
        }
        HashSet<class_2680> blockStates = new HashSet<class_2680>();
        blockStates.addAll(this.parseBlocksList(list, ""));
        for (class_2680 blockState : blockStates) {
            int blockStateID = BlockRepository.getStateId(blockState);
            Integer[] previousTints = this.blockTintTables.get(blockStateID);
            if (swamp && previousTints == null) {
                class_2960 defaultResource = resource.method_12832().contains("grass") ? new class_2960("textures/colormap/grass.png") : new class_2960("textures/colormap/foliage.png");
                String stateString = blockState.toString().toLowerCase();
                stateString = stateString.replaceAll("^block", "");
                stateString = stateString.replace("{", "");
                stateString = stateString.replace("}", "");
                stateString = stateString.replace("[", ":");
                stateString = stateString.replace("]", "");
                stateString = stateString.replace(",", ":");
                this.processColorProperty(defaultResource, stateString);
                previousTints = this.blockTintTables.get(blockStateID);
            }
            if (previousTints != null) {
                for (int s = 0; s < this.sizeOfBiomeArray; ++s) {
                    if ((Integer)tints[s] != -1) continue;
                    tints[s] = previousTints[s];
                }
            }
            this.blockColorsWithDefaultTint[blockStateID] = this.colorMultiplier(this.getBlockColor(blockStateID), (int)((Integer)tints[4] | 0xFF000000));
            this.blockTintTables.put(blockStateID, (Integer[])tints);
            this.biomeTintsAvailable.add(blockStateID);
        }
    }

    private class_2248 getBlockFromName(String name) {
        try {
            class_2960 resourceLocation = new class_2960(name);
            if (class_2378.field_11146.method_10250(resourceLocation)) {
                return (class_2248)class_2378.field_11146.method_10223(resourceLocation);
            }
            return null;
        }
        catch (class_151 e) {
            return null;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    static interface ColorResolver {
        public int getColorAtPos(class_2680 var1, class_1959 var2, class_2338 var3);
    }
}

