/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.api.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import mcp.mobius.waila.api.IBlockDecorator;
import mcp.mobius.waila.api.IComponentProvider;
import mcp.mobius.waila.api.IEntityComponentProvider;
import mcp.mobius.waila.api.IRegistrar;
import mcp.mobius.waila.api.IServerDataProvider;
import mcp.mobius.waila.api.ITooltipRenderer;
import mcp.mobius.waila.api.TooltipPosition;
import mcp.mobius.waila.api.impl.config.ConfigEntry;
import mcp.mobius.waila.api.impl.config.PluginConfig;
import net.minecraft.class_1309;
import net.minecraft.class_2586;
import net.minecraft.class_2960;

public class WailaRegistrar
implements IRegistrar {
    public static final WailaRegistrar INSTANCE = new WailaRegistrar();
    final Map<Class, List<IComponentProvider>> blockStackProviders = Maps.newLinkedHashMap();
    final EnumMap<TooltipPosition, Map<Class, List<IComponentProvider>>> blockComponentProviders = new EnumMap(TooltipPosition.class);
    final Map<Class, List<IServerDataProvider<class_2586>>> blockDataProviders = Maps.newLinkedHashMap();
    final Map<Class, List<IEntityComponentProvider>> entityOverrideProviders = Maps.newLinkedHashMap();
    final Map<Class, List<IEntityComponentProvider>> entityStackProviders = Maps.newLinkedHashMap();
    final EnumMap<TooltipPosition, Map<Class, List<IEntityComponentProvider>>> entityComponentProviders = new EnumMap(TooltipPosition.class);
    final Map<Class, List<IServerDataProvider<class_1309>>> entityDataProviders = Maps.newLinkedHashMap();
    final Map<Class, List<IBlockDecorator>> blockDecorators = Maps.newLinkedHashMap();
    final Map<class_2960, ITooltipRenderer> tooltipRenderers = Maps.newLinkedHashMap();

    WailaRegistrar() {
        for (TooltipPosition position : TooltipPosition.values()) {
            this.blockComponentProviders.put(position, new LinkedHashMap());
            this.entityComponentProviders.put(position, new LinkedHashMap());
        }
    }

    @Override
    public void addConfig(class_2960 key, boolean defaultValue) {
        PluginConfig.INSTANCE.addConfig(new ConfigEntry(key, defaultValue, false));
    }

    @Override
    public void addSyncedConfig(class_2960 key, boolean defaultValue) {
        PluginConfig.INSTANCE.addConfig(new ConfigEntry(key, defaultValue, true));
    }

    @Override
    public void registerStackProvider(IComponentProvider dataProvider, Class block) {
        this.registerProvider(dataProvider, block, this.blockStackProviders);
    }

    @Override
    public void registerComponentProvider(IComponentProvider dataProvider, TooltipPosition position, Class block) {
        this.registerProvider(dataProvider, block, this.blockComponentProviders.get((Object)position));
    }

    @Override
    public void registerBlockDataProvider(IServerDataProvider<class_2586> dataProvider, Class block) {
        this.registerProvider(dataProvider, block, this.blockDataProviders);
    }

    @Override
    public void registerOverrideEntityProvider(IEntityComponentProvider dataProvider, Class entity) {
        this.registerProvider(dataProvider, entity, this.entityOverrideProviders);
    }

    @Override
    public void registerEntityStackProvider(IEntityComponentProvider dataProvider, Class entity) {
        this.registerProvider(dataProvider, entity, this.entityStackProviders);
    }

    @Override
    public void registerComponentProvider(IEntityComponentProvider dataProvider, TooltipPosition position, Class entity) {
        this.registerProvider(dataProvider, entity, this.entityComponentProviders.get((Object)position));
    }

    @Override
    public void registerEntityDataProvider(IServerDataProvider<class_1309> dataProvider, Class entity) {
        this.registerProvider(dataProvider, entity, this.entityDataProviders);
    }

    @Override
    public void registerDecorator(IBlockDecorator decorator, Class block) {
        List decorators = this.blockDecorators.computeIfAbsent(block, b -> Lists.newArrayList());
        decorators.add(decorator);
    }

    @Override
    public void registerTooltipRenderer(class_2960 id, ITooltipRenderer renderer) {
        this.tooltipRenderers.put(id, renderer);
    }

    private <T, V extends Class<?>> void registerProvider(T dataProvider, V clazz, Map<V, List<T>> target) {
        if (clazz == null || dataProvider == null) {
            throw new RuntimeException(String.format("Trying to register a null provider or null block ! Please check the stacktrace to know what was the original registration method. [Provider : %s, Target : %s]", dataProvider.getClass().getName(), clazz));
        }
        List providers = target.computeIfAbsent((List)((Object)clazz), (Function<List, List<T>>)((Function<Class, List>)c -> Lists.newArrayList()));
        if (providers.contains(dataProvider)) {
            return;
        }
        providers.add(dataProvider);
    }

    public Map<Integer, List<IComponentProvider>> getHeadProviders(Object block) {
        return this.getProviders(block, this.blockComponentProviders.get((Object)TooltipPosition.HEAD));
    }

    public Map<Integer, List<IComponentProvider>> getBodyProviders(Object block) {
        return this.getProviders(block, this.blockComponentProviders.get((Object)TooltipPosition.BODY));
    }

    public Map<Integer, List<IComponentProvider>> getTailProviders(Object block) {
        return this.getProviders(block, this.blockComponentProviders.get((Object)TooltipPosition.TAIL));
    }

    public Map<Integer, List<IComponentProvider>> getStackProviders(Object block) {
        return this.getProviders(block, this.blockStackProviders);
    }

    public Map<Integer, List<IServerDataProvider<class_2586>>> getNBTProviders(Object block) {
        return this.getProviders(block, this.blockDataProviders);
    }

    public Map<Integer, List<IEntityComponentProvider>> getHeadEntityProviders(Object entity) {
        return this.getProviders(entity, this.entityComponentProviders.get((Object)TooltipPosition.HEAD));
    }

    public Map<Integer, List<IEntityComponentProvider>> getBodyEntityProviders(Object entity) {
        return this.getProviders(entity, this.entityComponentProviders.get((Object)TooltipPosition.BODY));
    }

    public Map<Integer, List<IEntityComponentProvider>> getTailEntityProviders(Object entity) {
        return this.getProviders(entity, this.entityComponentProviders.get((Object)TooltipPosition.TAIL));
    }

    public Map<Integer, List<IEntityComponentProvider>> getOverrideEntityProviders(Object entity) {
        return this.getProviders(entity, this.entityOverrideProviders);
    }

    public Map<Integer, List<IEntityComponentProvider>> getStackEntityProviders(Object entity) {
        return this.getProviders(entity, this.entityStackProviders);
    }

    public Map<Integer, List<IServerDataProvider<class_1309>>> getNBTEntityProviders(Object entity) {
        return this.getProviders(entity, this.entityDataProviders);
    }

    public Map<Integer, List<IBlockDecorator>> getBlockDecorators(Object block) {
        return this.getProviders(block, this.blockDecorators);
    }

    public ITooltipRenderer getTooltipRenderer(class_2960 id) {
        return this.tooltipRenderers.get(id);
    }

    private <T> Map<Integer, List<T>> getProviders(Object obj, Map<Class, List<T>> target) {
        TreeMap<Integer, List<T>> returnList = new TreeMap<Integer, List<T>>();
        Integer index = 0;
        for (Class clazz : target.keySet()) {
            if (clazz.isInstance(obj)) {
                returnList.put(index, target.get(clazz));
            }
            Integer n = index;
            Integer n2 = index = Integer.valueOf(index + 1);
        }
        return returnList;
    }

    public boolean hasStackProviders(Object block) {
        return this.hasProviders(block, this.blockStackProviders);
    }

    public boolean hasHeadProviders(Object block) {
        return this.hasProviders(block, this.blockComponentProviders.get((Object)TooltipPosition.HEAD));
    }

    public boolean hasBodyProviders(Object block) {
        return this.hasProviders(block, this.blockComponentProviders.get((Object)TooltipPosition.BODY));
    }

    public boolean hasTailProviders(Object block) {
        return this.hasProviders(block, this.blockComponentProviders.get((Object)TooltipPosition.TAIL));
    }

    public boolean hasNBTProviders(Object block) {
        return this.hasProviders(block, this.blockDataProviders);
    }

    public boolean hasHeadEntityProviders(Object entity) {
        return this.hasProviders(entity, this.entityComponentProviders.get((Object)TooltipPosition.HEAD));
    }

    public boolean hasBodyEntityProviders(Object entity) {
        return this.hasProviders(entity, this.entityComponentProviders.get((Object)TooltipPosition.BODY));
    }

    public boolean hasTailEntityProviders(Object entity) {
        return this.hasProviders(entity, this.entityComponentProviders.get((Object)TooltipPosition.TAIL));
    }

    public boolean hasOverrideEntityProviders(Object entity) {
        return this.hasProviders(entity, this.entityOverrideProviders);
    }

    public boolean hasStackEntityProviders(Object entity) {
        return this.hasProviders(entity, this.entityStackProviders);
    }

    public boolean hasNBTEntityProviders(Object entity) {
        return this.hasProviders(entity, this.entityDataProviders);
    }

    public boolean hasBlockDecorator(Object block) {
        return this.hasProviders(block, this.blockDecorators);
    }

    private <T> boolean hasProviders(Object obj, Map<Class, List<T>> target) {
        for (Class clazz : target.keySet()) {
            if (!clazz.isInstance(obj)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public static WailaRegistrar instance() {
        return INSTANCE;
    }
}

