/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.api.impl.config;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.impl.config.ConfigEntry;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2960;

public class PluginConfig
implements IPluginConfig {
    public static final PluginConfig INSTANCE = new PluginConfig();
    private final Map<class_2960, ConfigEntry> configs = Maps.newHashMap();

    private PluginConfig() {
    }

    public void addConfig(ConfigEntry entry) {
        this.configs.put(entry.getId(), entry);
    }

    @Override
    public Set<class_2960> getKeys(String namespace) {
        return this.getKeys().stream().filter(id -> id.method_12836().equals(namespace)).collect(Collectors.toSet());
    }

    @Override
    public Set<class_2960> getKeys() {
        return this.configs.keySet();
    }

    @Override
    public boolean get(class_2960 key, boolean defaultValue) {
        ConfigEntry entry = this.configs.get(key);
        return entry == null ? defaultValue : entry.getValue();
    }

    public Set<ConfigEntry> getSyncableConfigs() {
        return this.configs.values().stream().filter(ConfigEntry::isSynced).collect(Collectors.toSet());
    }

    public List<String> getNamespaces() {
        return this.configs.keySet().stream().sorted((o1, o2) -> o1.method_12836().compareToIgnoreCase(o2.method_12836())).map(class_2960::method_12836).distinct().collect(Collectors.toList());
    }

    public ConfigEntry getEntry(class_2960 key) {
        return this.configs.get(key);
    }

    public void set(class_2960 key, boolean value) {
        ConfigEntry entry = this.configs.computeIfAbsent(key, k -> new ConfigEntry((class_2960)k, value, true));
        entry.setValue(value);
    }

    public void reload() {
        File configFile = new File(FabricLoader.getInstance().getConfigDirectory(), "waila/waila_plugins.json");
        if (!configFile.exists()) {
            this.writeConfig(configFile, true);
        } else {
            Map config;
            try (FileReader reader = new FileReader(configFile);){
                config = (Map)new Gson().fromJson((Reader)reader, new TypeToken<Map<String, Map<String, Boolean>>>(){}.getType());
            }
            catch (IOException e) {
                config = Maps.newHashMap();
            }
            config.forEach((namespace, subMap) -> subMap.forEach((path, value) -> this.set(new class_2960(namespace, path), (boolean)value)));
        }
    }

    public void save() {
        File configFile = new File(FabricLoader.getInstance().getConfigDirectory(), "waila/waila_plugins.json");
        this.writeConfig(configFile, false);
    }

    private void writeConfig(File file, boolean reset) {
        HashMap config = Maps.newHashMap();
        this.configs.values().forEach(e -> {
            Map modConfig = config.computeIfAbsent(e.getId().method_12836(), k -> Maps.newHashMap());
            if (reset) {
                e.setValue(e.getDefaultValue());
            }
            modConfig.put(e.getId().method_12832(), e.getValue());
        });
        String json = new GsonBuilder().setPrettyPrinting().create().toJson((Object)config);
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        try (FileWriter writer = new FileWriter(file);){
            writer.write(json);
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }
}

