/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.gui;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import mcp.mobius.waila.gui.config.OptionsListWidget;
import mcp.mobius.waila.gui.config.value.OptionsEntryValue;
import net.minecraft.class_1074;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;

public abstract class GuiOptions
extends class_437 {
    private final class_437 parent;
    private final Runnable saver;
    private final Runnable canceller;
    private OptionsListWidget options;

    public GuiOptions(class_437 parent, class_2561 title, Runnable saver, Runnable canceller) {
        super(title);
        this.parent = parent;
        this.saver = saver;
        this.canceller = canceller;
    }

    public GuiOptions(class_437 parent, class_2561 title) {
        this(parent, title, null, null);
    }

    public void init(class_310 client, int width, int height) {
        super.init(client, width, height);
        this.options = this.getOptions();
        this.children.add(this.options);
        this.setFocused((class_364)this.options);
        if (this.saver != null && this.canceller != null) {
            this.addButton((class_339)new class_4185(width / 2 - 100, height - 25, 100, 20, class_1074.method_4662((String)"gui.done", (Object[])new Object[0]), w -> {
                this.options.save();
                this.saver.run();
                this.onClose();
            }));
            this.addButton((class_339)new class_4185(width / 2 + 5, height - 25, 100, 20, class_1074.method_4662((String)"gui.cancel", (Object[])new Object[0]), w -> {
                this.canceller.run();
                this.onClose();
            }));
        } else {
            this.addButton((class_339)new class_4185(width / 2 - 50, height - 25, 100, 20, class_1074.method_4662((String)"gui.done", (Object[])new Object[0]), w -> {
                this.options.save();
                this.onClose();
            }));
        }
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        this.options.render(mouseX, mouseY, partialTicks);
        this.drawCenteredString(this.font, this.title.method_10863(), this.width / 2, 12, 0xFFFFFF);
        super.render(mouseX, mouseY, partialTicks);
        if (mouseY < 32 || mouseY > this.height - 32) {
            return;
        }
        this.options.method_19355(mouseX, mouseY).ifPresent(element -> {
            OptionsEntryValue value;
            if (element instanceof OptionsEntryValue && class_1074.method_4663((String)(value = (OptionsEntryValue)((Object)element)).getDescription())) {
                int valueX = value.getX() + 10;
                String title = value.getTitle().method_10863();
                if (mouseX < valueX || mouseX > valueX + this.font.method_1727(title)) {
                    return;
                }
                ArrayList tooltip = Lists.newArrayList((Object[])new String[]{title});
                tooltip.addAll(this.font.method_1728(class_1074.method_4662((String)value.getDescription(), (Object[])new Object[0]), 200));
                this.renderTooltip(tooltip, mouseX, mouseY);
            }
        });
    }

    public void onClose() {
        this.minecraft.method_1507(this.parent);
    }

    public void addListener(class_364 listener) {
        this.children.add(listener);
    }

    public abstract OptionsListWidget getOptions();
}

