/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Rectangle;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.WailaClient;
import mcp.mobius.waila.addons.core.PluginCore;
import mcp.mobius.waila.api.event.WailaRenderEvent;
import mcp.mobius.waila.api.impl.DataAccessor;
import mcp.mobius.waila.api.impl.config.PluginConfig;
import mcp.mobius.waila.api.impl.config.WailaConfig;
import mcp.mobius.waila.overlay.DisplayUtil;
import mcp.mobius.waila.overlay.RayTracing;
import mcp.mobius.waila.overlay.Tooltip;
import mcp.mobius.waila.overlay.WailaTickHandler;
import net.minecraft.class_239;
import net.minecraft.class_310;
import net.minecraft.class_408;
import org.lwjgl.opengl.GL11;

public class OverlayRenderer {
    protected static boolean hasLight;
    protected static boolean hasDepthTest;
    protected static boolean hasRescaleNormal;
    protected static boolean hasColorMaterial;
    protected static boolean depthMask;
    protected static int depthFunc;

    public static void renderOverlay() {
        boolean isOnServer;
        if (WailaTickHandler.instance().tooltip == null) {
            return;
        }
        if (!Waila.CONFIG.get().getGeneral().shouldDisplayTooltip()) {
            return;
        }
        if (Waila.CONFIG.get().getGeneral().getDisplayMode() == WailaConfig.DisplayMode.HOLD_KEY && !WailaClient.showOverlay.method_1434()) {
            return;
        }
        class_310 mc = class_310.method_1551();
        if (mc.field_1755 != null && !(mc.field_1755 instanceof class_408) || mc.field_1687 == null) {
            return;
        }
        boolean bl = isOnServer = !mc.method_1542() || mc.field_1724.field_3944.method_2880().size() > 1;
        if (Waila.CONFIG.get().getGeneral().shouldHideFromPlayerList() && mc.field_1690.field_1907.method_1434() && isOnServer) {
            return;
        }
        if (!class_310.method_1498()) {
            return;
        }
        if (mc.field_1690.field_1866 && Waila.CONFIG.get().getGeneral().shouldHideFromDebug()) {
            return;
        }
        if (RayTracing.INSTANCE.getTarget() == null) {
            return;
        }
        if (RayTracing.INSTANCE.getTarget().method_17783() == class_239.class_240.field_1332 && !RayTracing.INSTANCE.getTargetStack().method_7960()) {
            OverlayRenderer.renderOverlay(WailaTickHandler.instance().tooltip);
        }
        if (RayTracing.INSTANCE.getTarget().method_17783() == class_239.class_240.field_1331 && PluginConfig.INSTANCE.get(PluginCore.CONFIG_SHOW_ENTITY)) {
            OverlayRenderer.renderOverlay(WailaTickHandler.instance().tooltip);
        }
    }

    public static void renderOverlay(Tooltip tooltip) {
        class_310.method_1551().method_16011().method_15396("Waila Overlay");
        RenderSystem.pushMatrix();
        OverlayRenderer.saveGLState();
        RenderSystem.scalef((float)Waila.CONFIG.get().getOverlay().getOverlayScale(), (float)Waila.CONFIG.get().getOverlay().getOverlayScale(), (float)1.0f);
        RenderSystem.disableRescaleNormal();
        RenderSystem.disableLighting();
        RenderSystem.disableDepthTest();
        WailaRenderEvent.Pre preEvent = new WailaRenderEvent.Pre(DataAccessor.INSTANCE, tooltip.getPosition());
        ((WailaRenderEvent.PreRender)WailaRenderEvent.WAILA_RENDER_PRE.invoker()).onPreRender(preEvent);
        Rectangle position = preEvent.getPosition();
        WailaConfig.ConfigOverlay.ConfigOverlayColor color = Waila.CONFIG.get().getOverlay().getColor();
        OverlayRenderer.drawTooltipBox(position.x, position.y, position.width, position.height, color.getBackgroundColor(), color.getGradientStart(), color.getGradientEnd());
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        tooltip.draw();
        RenderSystem.disableBlend();
        RenderSystem.enableRescaleNormal();
        if (tooltip.hasItem()) {
            DisplayUtil.renderStack(position.x + 5, position.y + position.height / 2 - 8, RayTracing.INSTANCE.getIdentifierStack());
        }
        WailaRenderEvent.Post postEvent = new WailaRenderEvent.Post(position);
        ((WailaRenderEvent.PostRender)WailaRenderEvent.WAILA_RENDER_POST.invoker()).onPostRender(postEvent);
        OverlayRenderer.loadGLState();
        RenderSystem.enableDepthTest();
        RenderSystem.popMatrix();
        class_310.method_1551().method_16011().method_15407();
    }

    public static void saveGLState() {
        hasLight = GL11.glGetBoolean((int)2896);
        hasDepthTest = GL11.glGetBoolean((int)2929);
        hasRescaleNormal = GL11.glGetBoolean((int)32826);
        hasColorMaterial = GL11.glGetBoolean((int)2903);
        depthFunc = GL11.glGetInteger((int)2932);
        depthMask = GL11.glGetBoolean((int)2930);
        GL11.glPushAttrib((int)1);
    }

    public static void loadGLState() {
        RenderSystem.depthMask((boolean)depthMask);
        RenderSystem.depthFunc((int)depthFunc);
        if (hasLight) {
            RenderSystem.enableLighting();
        } else {
            RenderSystem.disableLighting();
        }
        if (hasDepthTest) {
            RenderSystem.enableDepthTest();
        } else {
            RenderSystem.disableDepthTest();
        }
        if (hasRescaleNormal) {
            RenderSystem.enableRescaleNormal();
        } else {
            RenderSystem.disableRescaleNormal();
        }
        if (hasColorMaterial) {
            RenderSystem.enableColorMaterial();
        } else {
            RenderSystem.disableColorMaterial();
        }
        RenderSystem.popAttributes();
    }

    public static void drawTooltipBox(int x, int y, int w, int h, int bg, int grad1, int grad2) {
        DisplayUtil.drawGradientRect(x + 1, y, w - 1, 1, bg, bg);
        DisplayUtil.drawGradientRect(x + 1, y + h, w - 1, 1, bg, bg);
        DisplayUtil.drawGradientRect(x + 1, y + 1, w - 1, h - 1, bg, bg);
        DisplayUtil.drawGradientRect(x, y + 1, 1, h - 1, bg, bg);
        DisplayUtil.drawGradientRect(x + w, y + 1, 1, h - 1, bg, bg);
        DisplayUtil.drawGradientRect(x + 1, y + 2, 1, h - 3, grad1, grad2);
        DisplayUtil.drawGradientRect(x + w - 1, y + 2, 1, h - 3, grad1, grad2);
        DisplayUtil.drawGradientRect(x + 1, y + 1, w - 1, 1, grad1, grad1);
        DisplayUtil.drawGradientRect(x + 1, y + h - 1, w - 1, 1, grad2, grad2);
    }
}

