/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.overlay;

import com.mojang.text2speech.Narrator;
import java.util.List;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.ITaggableList;
import mcp.mobius.waila.api.TooltipPosition;
import mcp.mobius.waila.api.event.WailaTooltipEvent;
import mcp.mobius.waila.api.impl.DataAccessor;
import mcp.mobius.waila.api.impl.MetaDataProvider;
import mcp.mobius.waila.api.impl.TaggableList;
import mcp.mobius.waila.api.impl.TaggedTextComponent;
import mcp.mobius.waila.overlay.OverlayRenderer;
import mcp.mobius.waila.overlay.RayTracing;
import mcp.mobius.waila.overlay.Tooltip;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_408;
import net.minecraft.class_638;
import net.minecraft.class_746;

public class WailaTickHandler {
    public static WailaTickHandler INSTANCE = new WailaTickHandler();
    private static Narrator narrator;
    private static String lastNarration;
    public Tooltip tooltip = null;
    public MetaDataProvider handler = new MetaDataProvider();

    private WailaTickHandler() {
        WailaTooltipEvent.WAILA_HANDLE_TOOLTIP.register(event -> {
            if (!Waila.CONFIG.get().getGeneral().shouldDisplayTooltip()) {
                return;
            }
            if (WailaTickHandler.getNarrator().active() || !Waila.CONFIG.get().getGeneral().shouldEnableTextToSpeech()) {
                return;
            }
            if (event.getCurrentTip().isEmpty()) {
                return;
            }
            if (class_310.method_1551().field_1755 != null && !(class_310.method_1551().field_1755 instanceof class_408)) {
                return;
            }
            if (event.getAccessor().getBlock() == class_2246.field_10124 && event.getAccessor().getEntity() == null) {
                return;
            }
            String narrate = event.getCurrentTip().get(0).method_10863();
            if (lastNarration.equalsIgnoreCase(narrate)) {
                return;
            }
            WailaTickHandler.getNarrator().clear();
            WailaTickHandler.getNarrator().say(narrate, true);
            lastNarration = narrate;
        });
    }

    public void renderOverlay() {
        OverlayRenderer.renderOverlay();
    }

    public void tickClient() {
        if (!Waila.CONFIG.get().getGeneral().shouldDisplayTooltip()) {
            return;
        }
        class_310 client = class_310.method_1551();
        class_638 world = client.field_1687;
        class_746 player = client.field_1724;
        if (client.field_1774 == null) {
            return;
        }
        if (world != null && player != null) {
            RayTracing.INSTANCE.fire();
            class_239 target = RayTracing.INSTANCE.getTarget();
            TaggableList<class_2960, class_2561> currentTip = new TaggableList<class_2960, class_2561>(TaggedTextComponent::new);
            TaggableList<class_2960, class_2561> currentTipHead = new TaggableList<class_2960, class_2561>(TaggedTextComponent::new);
            TaggableList<class_2960, class_2561> currentTipBody = new TaggableList<class_2960, class_2561>(TaggedTextComponent::new);
            TaggableList<class_2960, class_2561> currentTipTail = new TaggableList<class_2960, class_2561>(TaggedTextComponent::new);
            if (target != null && target.method_17783() == class_239.class_240.field_1332) {
                class_1799 targetStack;
                DataAccessor accessor = DataAccessor.INSTANCE;
                accessor.set((class_1937)world, (class_1657)player, target);
                accessor.stack = targetStack = RayTracing.INSTANCE.getTargetStack();
                if (!targetStack.method_7960()) {
                    WailaTickHandler.instance().handler.gatherBlockComponents(accessor, currentTipHead, TooltipPosition.HEAD);
                    WailaTickHandler.instance().handler.gatherBlockComponents(accessor, currentTipBody, TooltipPosition.BODY);
                    WailaTickHandler.instance().handler.gatherBlockComponents(accessor, currentTipTail, TooltipPosition.TAIL);
                    this.combinePositions((class_1657)player, currentTip, currentTipHead, currentTipBody, currentTipTail);
                    this.tooltip = new Tooltip(currentTip, !targetStack.method_7960());
                }
            } else if (target != null && target.method_17783() == class_239.class_240.field_1331) {
                DataAccessor accessor = DataAccessor.INSTANCE;
                accessor.set((class_1937)world, (class_1657)player, target);
                class_1297 targetEnt = RayTracing.INSTANCE.getTargetEntity();
                if (targetEnt != null) {
                    WailaTickHandler.instance().handler.gatherEntityComponents(targetEnt, accessor, currentTipHead, TooltipPosition.HEAD);
                    WailaTickHandler.instance().handler.gatherEntityComponents(targetEnt, accessor, currentTipBody, TooltipPosition.BODY);
                    WailaTickHandler.instance().handler.gatherEntityComponents(targetEnt, accessor, currentTipTail, TooltipPosition.TAIL);
                    this.combinePositions((class_1657)player, currentTip, currentTipHead, currentTipBody, currentTipTail);
                    class_1799 displayItem = RayTracing.INSTANCE.getIdentifierStack();
                    this.tooltip = new Tooltip(currentTip, !displayItem.method_7960());
                }
            }
        }
    }

    private void combinePositions(class_1657 player, List<class_2561> currentTip, List<class_2561> currentTipHead, List<class_2561> currentTipBody, List<class_2561> currentTipTail) {
        if (Waila.CONFIG.get().getGeneral().shouldShiftForDetails() && !currentTipBody.isEmpty() && !player.method_5715()) {
            currentTipBody.clear();
            currentTipBody.add(new class_2588("tooltip.waila.sneak_for_details", new Object[0]).method_10862(new class_2583().method_10978(Boolean.valueOf(true))));
        }
        ((ITaggableList)currentTip).absorb((ITaggableList)currentTipHead);
        ((ITaggableList)currentTip).absorb((ITaggableList)currentTipBody);
        ((ITaggableList)currentTip).absorb((ITaggableList)currentTipTail);
    }

    private static Narrator getNarrator() {
        return narrator == null ? (narrator = Narrator.getNarrator()) : narrator;
    }

    public static WailaTickHandler instance() {
        if (INSTANCE == null) {
            INSTANCE = new WailaTickHandler();
        }
        return INSTANCE;
    }

    static {
        lastNarration = "";
    }
}

