/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.gui;

import com.google.common.collect.ImmutableList;
import fi.dy.masa.malilib.config.ConfigType;
import fi.dy.masa.malilib.config.ConfigUtils;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.gui.GuiConfigsBase;
import fi.dy.masa.malilib.gui.button.ButtonBase;
import fi.dy.masa.malilib.gui.button.ButtonGeneric;
import fi.dy.masa.malilib.gui.button.IButtonActionListener;
import fi.dy.masa.malilib.gui.widgets.WidgetListConfigOptions;
import fi.dy.masa.malilib.util.StringUtils;
import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.config.InfoToggle;
import fi.dy.masa.minihud.config.RendererToggle;
import fi.dy.masa.minihud.config.StructureToggle;
import fi.dy.masa.minihud.gui.GuiShapeManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_437;

public class GuiConfigs
extends GuiConfigsBase {
    public static ConfigGuiTab tab = ConfigGuiTab.INFO_TOGGLES;

    public GuiConfigs() {
        super(10, 50, "minihud", null, "minihud.gui.title.configs", new Object[0]);
    }

    public void initGui() {
        if (tab == ConfigGuiTab.SHAPES) {
            GuiBase.openGui((class_437)new GuiShapeManager());
            return;
        }
        super.initGui();
        this.clearOptions();
        int x = 10;
        int y = 26;
        int rows = 1;
        for (ConfigGuiTab tab : ConfigGuiTab.values()) {
            int width = this.getStringWidth(tab.getDisplayName()) + 10;
            if (x >= this.width - width - 10) {
                x = 10;
                y += 22;
                ++rows;
            }
            x += this.createButton(x, y, width, tab);
        }
        if (rows > 1) {
            int scrollbarPosition = ((WidgetListConfigOptions)this.getListWidget()).getScrollbar().getValue();
            this.setListPosition(this.getListX(), 50 + (rows - 1) * 22);
            this.reCreateListWidget();
            ((WidgetListConfigOptions)this.getListWidget()).getScrollbar().setValue(scrollbarPosition);
            ((WidgetListConfigOptions)this.getListWidget()).refreshEntries();
        }
    }

    private int createButton(int x, int y, int width, ConfigGuiTab tab) {
        ButtonGeneric button = new ButtonGeneric(x, y, width, 20, tab.getDisplayName(), new String[0]);
        button.setEnabled(GuiConfigs.tab != tab);
        this.addButton((ButtonBase)button, new ButtonListenerConfigTabs(tab, this));
        return button.getWidth() + 2;
    }

    protected int getConfigWidth() {
        ConfigGuiTab tab = GuiConfigs.tab;
        if (tab == ConfigGuiTab.GENERIC || tab == ConfigGuiTab.STRUCTURES) {
            return 200;
        }
        if (tab == ConfigGuiTab.COLORS || tab == ConfigGuiTab.INFO_LINE_ORDER || tab == ConfigGuiTab.INFO_TOGGLES) {
            return 100;
        }
        return super.getConfigWidth();
    }

    protected boolean useKeybindSearch() {
        return tab == ConfigGuiTab.INFO_HOTKEYS || tab == ConfigGuiTab.RENDERER_HOTKEYS;
    }

    public List<GuiConfigsBase.ConfigOptionWrapper> getConfigs() {
        Object configs;
        ConfigGuiTab tab = GuiConfigs.tab;
        if (tab == ConfigGuiTab.GENERIC) {
            configs = Configs.Generic.OPTIONS;
        } else if (tab == ConfigGuiTab.COLORS) {
            configs = Configs.Colors.OPTIONS;
        } else if (tab == ConfigGuiTab.INFO_TOGGLES) {
            configs = ConfigUtils.createConfigWrapperForType((ConfigType)ConfigType.BOOLEAN, (List)ImmutableList.copyOf((Object[])InfoToggle.values()));
        } else if (tab == ConfigGuiTab.INFO_LINE_ORDER) {
            configs = ConfigUtils.createConfigWrapperForType((ConfigType)ConfigType.INTEGER, (List)ImmutableList.copyOf((Object[])InfoToggle.values()));
        } else if (tab == ConfigGuiTab.INFO_HOTKEYS) {
            configs = ConfigUtils.createConfigWrapperForType((ConfigType)ConfigType.HOTKEY, (List)ImmutableList.copyOf((Object[])InfoToggle.values()));
        } else {
            if (tab == ConfigGuiTab.STRUCTURES) {
                ArrayList<Object> list = new ArrayList<Object>();
                list.addAll((Collection<Object>)StructureToggle.getToggleConfigs());
                list.addAll((Collection<Object>)StructureToggle.getHotkeys());
                list.addAll((Collection<Object>)StructureToggle.getColorConfigs());
                return GuiConfigsBase.ConfigOptionWrapper.createFor(list);
            }
            if (tab == ConfigGuiTab.RENDERER_HOTKEYS) {
                configs = ConfigUtils.createConfigWrapperForType((ConfigType)ConfigType.HOTKEY, (List)ImmutableList.copyOf((Object[])RendererToggle.values()));
            } else {
                return Collections.emptyList();
            }
        }
        return GuiConfigsBase.ConfigOptionWrapper.createFor(configs);
    }

    public static enum ConfigGuiTab {
        GENERIC("minihud.gui.button.config_gui.generic"),
        COLORS("minihud.gui.button.config_gui.colors"),
        INFO_TOGGLES("minihud.gui.button.config_gui.info_toggles"),
        INFO_LINE_ORDER("minihud.gui.button.config_gui.info_line_order"),
        INFO_HOTKEYS("minihud.gui.button.config_gui.info_hotkeys"),
        STRUCTURES("minihud.gui.button.config_gui.structures"),
        RENDERER_HOTKEYS("minihud.gui.button.config_gui.renderer_hotkeys"),
        SHAPES("minihud.gui.button.config_gui.shapes");

        private final String translationKey;

        private ConfigGuiTab(String translationKey) {
            this.translationKey = translationKey;
        }

        public String getDisplayName() {
            return StringUtils.translate((String)this.translationKey, (Object[])new Object[0]);
        }
    }

    private static class ButtonListenerConfigTabs
    implements IButtonActionListener {
        private final GuiConfigs parent;
        private final ConfigGuiTab tab;

        public ButtonListenerConfigTabs(ConfigGuiTab tab, GuiConfigs parent) {
            this.tab = tab;
            this.parent = parent;
        }

        public void actionPerformedWithButton(ButtonBase button, int mouseButton) {
            tab = this.tab;
            if (this.tab == ConfigGuiTab.SHAPES) {
                GuiBase.openGui((class_437)new GuiShapeManager());
            } else {
                this.parent.reCreateListWidget();
                ((WidgetListConfigOptions)this.parent.getListWidget()).resetScrollbarPosition();
                this.parent.initGui();
            }
        }
    }
}

