/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.gui;

import fi.dy.masa.malilib.config.IConfigOptionList;
import fi.dy.masa.malilib.config.IConfigOptionListEntry;
import fi.dy.masa.malilib.config.options.ConfigOptionList;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.gui.GuiRenderLayerEditBase;
import fi.dy.masa.malilib.gui.GuiTextFieldDouble;
import fi.dy.masa.malilib.gui.GuiTextFieldGeneric;
import fi.dy.masa.malilib.gui.button.ButtonBase;
import fi.dy.masa.malilib.gui.button.ButtonGeneric;
import fi.dy.masa.malilib.gui.button.ConfigButtonOptionList;
import fi.dy.masa.malilib.gui.button.IButtonActionListener;
import fi.dy.masa.malilib.gui.interfaces.ITextFieldListener;
import fi.dy.masa.malilib.interfaces.ICoordinateValueModifier;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.BlockSnap;
import fi.dy.masa.malilib.util.GuiUtils;
import fi.dy.masa.malilib.util.LayerRange;
import fi.dy.masa.malilib.util.PositionUtils;
import fi.dy.masa.malilib.util.StringUtils;
import fi.dy.masa.minihud.renderer.shapes.ShapeBase;
import fi.dy.masa.minihud.renderer.shapes.ShapeDespawnSphere;
import net.minecraft.class_243;
import net.minecraft.class_746;

public class GuiShapeEditor
extends GuiRenderLayerEditBase {
    private final ShapeBase shape;
    private ConfigOptionList configBlockSnap;
    private int colorY;

    public GuiShapeEditor(ShapeBase shape) {
        this.shape = shape;
        this.title = StringUtils.translate((String)"minihud.gui.title.shape_editor", (Object[])new Object[0]);
        this.configBlockSnap = new ConfigOptionList("blockSnap", (IConfigOptionListEntry)BlockSnap.NONE, "");
    }

    public void initGui() {
        super.initGui();
        int x = 10;
        int y = 26;
        this.createLayerEditControls(x, y, this.getLayerRange());
        this.createShapeEditorElements(x, this.nextY);
        this.createColorInput(22, this.nextY);
    }

    protected LayerRange getLayerRange() {
        return this.shape.getLayerRange();
    }

    protected void drawContents(int mouseX, int mouseY, float partialTicks) {
        int x = 96;
        int y = this.colorY;
        RenderUtils.drawRect((int)x, (int)(y + 0), (int)19, (int)19, (int)-1);
        RenderUtils.drawRect((int)(x + 1), (int)(y + 1), (int)17, (int)17, (int)-16777216);
        RenderUtils.drawRect((int)(x + 2), (int)(y + 2), (int)15, (int)15, (int)(0xFF000000 | this.shape.getColor().intValue));
    }

    private void createColorInput(int x, int y) {
        String label = StringUtils.translate((String)"minihud.gui.label.color", (Object[])new Object[0]);
        int w = this.getStringWidth(label);
        this.addLabel(x, y, w, 14, -1, new String[]{label});
        GuiTextFieldGeneric textField = new GuiTextFieldGeneric(x, y += 12, 70, 17, this.textRenderer);
        textField.method_1880(12);
        textField.method_1852(String.format("#%08X", this.shape.getColor().intValue));
        this.addTextField(textField, new TextFieldListenerColor(this.shape));
        this.nextY = y + 20;
        this.colorY = y - 1;
    }

    private void createShapeEditorElements(int x, int y) {
        switch (this.shape.getType()) {
            case DESPAWN_SPHERE: {
                this.createShapeEditorElementsDespawnSphere(x, y);
            }
        }
    }

    private void createShapeEditorElementsDespawnSphere(int x, int y) {
        this.addLabel(x, y, 60, 14, -1, new String[]{StringUtils.translate((String)"minihud.gui.label.center_colon", (Object[])new Object[0])});
        ShapeDespawnSphere shape = (ShapeDespawnSphere)this.shape;
        GuiUtils.createVec3dInputsVertical((int)x, (int)(y += 12), (int)120, (class_243)shape.getCenter(), (ICoordinateValueModifier)new DespawnSphereEditor(shape, this), (boolean)true, (GuiBase)this);
        ButtonGeneric button = new ButtonGeneric(x + 11, y += 54, -1, false, "malilib.gui.button.render_layers_gui.set_here", new Object[0]);
        this.addButton((ButtonBase)button, new ButtonListenerDespawnSphere(shape, this));
        String label = StringUtils.translate((String)"minihud.gui.label.margin_colon", (Object[])new Object[0]);
        int w = this.getStringWidth(label);
        this.addLabel(x + 12, y += 30, w, 12, -1, new String[]{label});
        GuiTextFieldDouble txtField = new GuiTextFieldDouble(x + 12, y += 12, 60, 16, this.textRenderer);
        txtField.method_1852(String.valueOf(shape.getMargin()));
        this.addTextField((GuiTextFieldGeneric)txtField, new TextFieldListenerMargin(shape));
        this.nextY = y += 20;
        w = this.getSnapButtonWidth();
        this.configBlockSnap.setOptionListValue((IConfigOptionListEntry)shape.getBlockSnap());
        ConfigButtonOptionList buttonSnap = new ConfigButtonOptionList(x + 11, y += 36, w, 20, (IConfigOptionList)this.configBlockSnap, "minihud.gui.label.block_snap");
        ButtonListenerDespawnSphereBlockSnap listener = new ButtonListenerDespawnSphereBlockSnap(shape, this);
        this.addButton((ButtonBase)buttonSnap, listener);
        y += 22;
    }

    private int getSnapButtonWidth() {
        int width = 0;
        for (BlockSnap val : BlockSnap.values()) {
            width = Math.max(width, this.getStringWidth(StringUtils.translate((String)"minihud.gui.label.block_snap", (Object[])new Object[]{val.getDisplayName()})) + 10);
        }
        return width;
    }

    private static class TextFieldListenerMargin
    implements ITextFieldListener<GuiTextFieldDouble> {
        private final ShapeDespawnSphere shape;

        private TextFieldListenerMargin(ShapeDespawnSphere shape) {
            this.shape = shape;
        }

        public boolean onTextChange(GuiTextFieldDouble textField) {
            try {
                this.shape.setMargin(Double.parseDouble(textField.method_1882()));
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
    }

    private static class TextFieldListenerColor
    implements ITextFieldListener<GuiTextFieldGeneric> {
        private final ShapeBase shape;

        private TextFieldListenerColor(ShapeBase shape) {
            this.shape = shape;
        }

        public boolean onTextChange(GuiTextFieldGeneric textField) {
            this.shape.setColorFromString(textField.method_1882());
            return false;
        }
    }

    private static class ButtonListenerDespawnSphereBlockSnap
    implements IButtonActionListener {
        private final GuiShapeEditor gui;
        private final ShapeDespawnSphere shape;

        private ButtonListenerDespawnSphereBlockSnap(ShapeDespawnSphere shape, GuiShapeEditor gui) {
            this.shape = shape;
            this.gui = gui;
        }

        public void actionPerformedWithButton(ButtonBase button, int mouseButton) {
            this.shape.setBlockSnap((BlockSnap)this.gui.configBlockSnap.getOptionListValue());
        }
    }

    private static class ButtonListenerDespawnSphere
    implements IButtonActionListener {
        private final GuiShapeEditor gui;
        private final ShapeDespawnSphere shape;

        private ButtonListenerDespawnSphere(ShapeDespawnSphere shape, GuiShapeEditor gui) {
            this.shape = shape;
            this.gui = gui;
        }

        public void actionPerformedWithButton(ButtonBase button, int mouseButton) {
            class_746 player = this.gui.mc.field_1724;
            if (player != null) {
                this.shape.setCenter(player.method_19538());
                this.gui.initGui();
            }
        }
    }

    private static class DespawnSphereEditor
    implements ICoordinateValueModifier {
        private final GuiShapeEditor gui;
        private final ShapeDespawnSphere shape;

        private DespawnSphereEditor(ShapeDespawnSphere shape, GuiShapeEditor gui) {
            this.shape = shape;
            this.gui = gui;
        }

        public boolean modifyValue(PositionUtils.CoordinateType type, int amount) {
            this.shape.setCenter(PositionUtils.modifyValue((PositionUtils.CoordinateType)type, (class_243)this.shape.getCenter(), (double)amount));
            this.gui.initGui();
            return true;
        }

        public boolean setValueFromString(PositionUtils.CoordinateType type, String newValue) {
            try {
                this.shape.setCenter(PositionUtils.setValue((PositionUtils.CoordinateType)type, (class_243)this.shape.getCenter(), (double)Double.parseDouble(newValue)));
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
    }
}

