/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import fi.dy.masa.malilib.config.IConfigDouble;
import fi.dy.masa.malilib.config.options.ConfigColor;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.Color4f;
import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.config.RendererToggle;
import fi.dy.masa.minihud.renderer.OverlayRendererBase;
import fi.dy.masa.minihud.renderer.RenderObjectBase;
import fi.dy.masa.minihud.util.LightLevelMarkerMode;
import fi.dy.masa.minihud.util.LightLevelNumberMode;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_1948;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2818;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3568;
import net.minecraft.class_3610;

public class OverlayRendererLightLevel
extends OverlayRendererBase {
    private static final class_2960 TEXTURE_NUMBERS = new class_2960("minihud", "textures/misc/light_level_numbers.png");
    private final List<LightLevelInfo> lightInfos = new ArrayList<LightLevelInfo>();
    private final class_2338.class_2339 mutablePos = new class_2338.class_2339();
    private class_2350 lastDirection = class_2350.field_11043;
    private static boolean needsUpdate;

    public static void setNeedsUpdate() {
        needsUpdate = true;
    }

    @Override
    public boolean shouldRender(class_310 mc) {
        return RendererToggle.OVERLAY_LIGHT_LEVEL.getBooleanValue();
    }

    @Override
    public boolean needsUpdate(class_1297 entity, class_310 mc) {
        return needsUpdate || this.lastUpdatePos == null || Math.abs(entity.method_23317() - (double)this.lastUpdatePos.method_10263()) > 4.0 || Math.abs(entity.method_23318() - (double)this.lastUpdatePos.method_10264()) > 4.0 || Math.abs(entity.method_23321() - (double)this.lastUpdatePos.method_10260()) > 4.0 || Configs.Generic.LIGHT_LEVEL_NUMBER_ROTATION.getBooleanValue() && this.lastDirection != entity.method_5735();
    }

    @Override
    public void update(class_1297 entity, class_310 mc) {
        class_2338 pos = new class_2338(entity);
        RenderObjectBase renderQuads = (RenderObjectBase)this.renderObjects.get(0);
        RenderObjectBase renderLines = (RenderObjectBase)this.renderObjects.get(1);
        BUFFER_1.method_1328(renderQuads.getGlMode(), class_290.field_1575);
        BUFFER_2.method_1328(renderLines.getGlMode(), class_290.field_1576);
        this.updateLightLevels((class_1937)mc.field_1687, pos);
        this.renderLightLevels(mc);
        BUFFER_1.method_1326();
        BUFFER_2.method_1326();
        renderQuads.uploadData(BUFFER_1);
        renderLines.uploadData(BUFFER_2);
        this.lastUpdatePos = pos;
        this.lastDirection = entity.method_5735();
        needsUpdate = false;
    }

    @Override
    protected void preRender(double x, double y, double z) {
        super.preRender(x, y, z);
        RenderUtils.bindTexture((class_2960)TEXTURE_NUMBERS);
        RenderSystem.enableTexture();
    }

    @Override
    protected void postRender(double x, double y, double z) {
        RenderSystem.disableTexture();
    }

    @Override
    public void allocateGlResources() {
        this.allocateBuffer(7, class_290.field_1575);
        this.allocateBuffer(1, class_290.field_1576);
    }

    private void renderLightLevels(class_310 mc) {
        int count = this.lightInfos.size();
        if (count > 0) {
            class_287 bufferQuads = BUFFER_1;
            class_287 bufferLines = BUFFER_2;
            class_2350 numberFacing = Configs.Generic.LIGHT_LEVEL_NUMBER_ROTATION.getBooleanValue() ? mc.field_1724.method_5735() : class_2350.field_11043;
            LightLevelNumberMode numberMode = (LightLevelNumberMode)Configs.Generic.LIGHT_LEVEL_NUMBER_MODE.getOptionListValue();
            LightLevelMarkerMode markerMode = (LightLevelMarkerMode)Configs.Generic.LIGHT_LEVEL_MARKER_MODE.getOptionListValue();
            boolean useColoredNumbers = Configs.Generic.LIGHT_LEVEL_COLORED_NUMBERS.getBooleanValue();
            int lightThreshold = Configs.Generic.LIGHT_LEVEL_THRESHOLD.getIntegerValue();
            if (numberMode == LightLevelNumberMode.BLOCK || numberMode == LightLevelNumberMode.BOTH) {
                this.renderNumbers(LightLevelNumberMode.BLOCK, (IConfigDouble)Configs.Generic.LIGHT_LEVEL_NUMBER_OFFSET_BLOCK_X, (IConfigDouble)Configs.Generic.LIGHT_LEVEL_NUMBER_OFFSET_BLOCK_Y, Configs.Colors.LIGHT_LEVEL_NUMBER_BLOCK_LIT, Configs.Colors.LIGHT_LEVEL_NUMBER_BLOCK_DARK, useColoredNumbers, lightThreshold, numberFacing, bufferQuads);
            }
            if (numberMode == LightLevelNumberMode.SKY || numberMode == LightLevelNumberMode.BOTH) {
                this.renderNumbers(LightLevelNumberMode.SKY, (IConfigDouble)Configs.Generic.LIGHT_LEVEL_NUMBER_OFFSET_SKY_X, (IConfigDouble)Configs.Generic.LIGHT_LEVEL_NUMBER_OFFSET_SKY_Y, Configs.Colors.LIGHT_LEVEL_NUMBER_SKY_LIT, Configs.Colors.LIGHT_LEVEL_NUMBER_SKY_DARK, useColoredNumbers, lightThreshold, numberFacing, bufferQuads);
            }
            if (markerMode == LightLevelMarkerMode.SQUARE) {
                this.renderMarkers(this::renderLightLevelSquare, lightThreshold, bufferLines);
            } else if (markerMode == LightLevelMarkerMode.CROSS) {
                this.renderMarkers(this::renderLightLevelCross, lightThreshold, bufferLines);
            }
        }
    }

    private void renderNumbers(LightLevelNumberMode mode, IConfigDouble cfgOffX, IConfigDouble cfgOffZ, ConfigColor cfgColorLit, ConfigColor cfgColorDark, boolean useColoredNumbers, int lightThreshold, class_2350 numberFacing, class_287 buffer) {
        Color4f colorDark;
        Color4f colorLit;
        double tmpZ;
        double tmpX;
        double dx = 0.0;
        double dy = 0.0;
        double dz = 0.0;
        double ox = cfgOffX.getDoubleValue();
        double oz = cfgOffZ.getDoubleValue();
        switch (numberFacing) {
            case field_11043: {
                tmpX = dx - ox;
                tmpZ = dz - oz;
                break;
            }
            case field_11035: {
                tmpX = dx + ox;
                tmpZ = dz + oz;
                break;
            }
            case field_11039: {
                tmpX = dx - oz;
                tmpZ = dz + ox;
                break;
            }
            case field_11034: {
                tmpX = dx + oz;
                tmpZ = dz - ox;
                break;
            }
            default: {
                tmpX = dx - ox;
                tmpZ = dz - oz;
            }
        }
        if (useColoredNumbers) {
            colorLit = cfgColorLit.getColor();
            colorDark = cfgColorDark.getColor();
        } else {
            colorLit = Color4f.fromColor((int)-1);
            colorDark = Color4f.fromColor((int)-1);
        }
        this.renderLightLevelNumbers(tmpX, dy, tmpZ, numberFacing, lightThreshold, mode, colorLit, colorDark, buffer);
    }

    private void renderMarkers(IMarkerRenderer renderer, int lightThreshold, class_287 buffer) {
        double markerSize = Configs.Generic.LIGHT_LEVEL_MARKER_SIZE.getDoubleValue();
        Color4f colorLit = Configs.Colors.LIGHT_LEVEL_MARKER_LIT.getColor();
        Color4f colorDark = Configs.Colors.LIGHT_LEVEL_MARKER_DARK.getColor();
        double offset1 = (1.0 - markerSize) / 2.0;
        double offset2 = 1.0 - offset1;
        int count = this.lightInfos.size();
        for (int i = 0; i < count; ++i) {
            LightLevelInfo info = this.lightInfos.get(i);
            if (info.block >= lightThreshold) continue;
            class_2338 pos = info.pos;
            Color4f color = info.sky >= lightThreshold ? colorLit : colorDark;
            renderer.render(pos.method_10263(), pos.method_10264(), pos.method_10260(), color, offset1, offset2, buffer);
        }
    }

    private void renderLightLevelNumbers(double dx, double dy, double dz, class_2350 facing, int lightThreshold, LightLevelNumberMode numberMode, Color4f colorLit, Color4f colorDark, class_287 buffer) {
        int count = this.lightInfos.size();
        for (int i = 0; i < count; ++i) {
            LightLevelInfo info = this.lightInfos.get(i);
            class_2338 pos = info.pos;
            double x = (double)pos.method_10263() - dx;
            double z = (double)pos.method_10260() - dz;
            int lightLevel = numberMode == LightLevelNumberMode.BLOCK ? info.block : info.sky;
            Color4f color = lightLevel >= lightThreshold ? colorLit : colorDark;
            this.renderLightLevelTextureColor(x, (double)pos.method_10264() - dy, z, facing, lightLevel, color, buffer);
        }
    }

    private void renderLightLevelTextureColor(double x, double y, double z, class_2350 facing, int lightLevel, Color4f color, class_287 buffer) {
        float w = 0.25f;
        float u = (float)(lightLevel & 3) * w;
        float v = (float)(lightLevel >> 2) * w;
        y += 0.005;
        switch (facing) {
            case field_11043: {
                buffer.method_22912(x, y, z).method_22913(u, v).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(x, y, z + 1.0).method_22913(u, v + w).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(x + 1.0, y, z + 1.0).method_22913(u + w, v + w).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(x + 1.0, y, z).method_22913(u + w, v).method_22915(color.r, color.g, color.b, color.a).method_1344();
                break;
            }
            case field_11035: {
                buffer.method_22912(x + 1.0, y, z + 1.0).method_22913(u, v).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(x + 1.0, y, z).method_22913(u, v + w).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(x, y, z).method_22913(u + w, v + w).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(x, y, z + 1.0).method_22913(u + w, v).method_22915(color.r, color.g, color.b, color.a).method_1344();
                break;
            }
            case field_11034: {
                buffer.method_22912(x + 1.0, y, z).method_22913(u, v).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(x, y, z).method_22913(u, v + w).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(x, y, z + 1.0).method_22913(u + w, v + w).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(x + 1.0, y, z + 1.0).method_22913(u + w, v).method_22915(color.r, color.g, color.b, color.a).method_1344();
                break;
            }
            case field_11039: {
                buffer.method_22912(x, y, z + 1.0).method_22913(u, v).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(x + 1.0, y, z + 1.0).method_22913(u, v + w).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(x + 1.0, y, z).method_22913(u + w, v + w).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(x, y, z).method_22913(u + w, v).method_22915(color.r, color.g, color.b, color.a).method_1344();
                break;
            }
        }
    }

    private void renderLightLevelCross(double x, double y, double z, Color4f color, double offset1, double offset2, class_287 buffer) {
        buffer.method_22912(x + offset1, y += 0.005, z + offset1).method_22915(color.r, color.g, color.b, color.a).method_1344();
        buffer.method_22912(x + offset2, y, z + offset2).method_22915(color.r, color.g, color.b, color.a).method_1344();
        buffer.method_22912(x + offset1, y, z + offset2).method_22915(color.r, color.g, color.b, color.a).method_1344();
        buffer.method_22912(x + offset2, y, z + offset1).method_22915(color.r, color.g, color.b, color.a).method_1344();
    }

    private void renderLightLevelSquare(double x, double y, double z, Color4f color, double offset1, double offset2, class_287 buffer) {
        buffer.method_22912(x + offset1, y += 0.005, z + offset1).method_22915(color.r, color.g, color.b, color.a).method_1344();
        buffer.method_22912(x + offset1, y, z + offset2).method_22915(color.r, color.g, color.b, color.a).method_1344();
        buffer.method_22912(x + offset1, y, z + offset2).method_22915(color.r, color.g, color.b, color.a).method_1344();
        buffer.method_22912(x + offset2, y, z + offset2).method_22915(color.r, color.g, color.b, color.a).method_1344();
        buffer.method_22912(x + offset2, y, z + offset2).method_22915(color.r, color.g, color.b, color.a).method_1344();
        buffer.method_22912(x + offset2, y, z + offset1).method_22915(color.r, color.g, color.b, color.a).method_1344();
        buffer.method_22912(x + offset2, y, z + offset1).method_22915(color.r, color.g, color.b, color.a).method_1344();
        buffer.method_22912(x + offset1, y, z + offset1).method_22915(color.r, color.g, color.b, color.a).method_1344();
    }

    private void updateLightLevels(class_1937 world, class_2338 center) {
        this.lightInfos.clear();
        int radius = Configs.Generic.LIGHT_LEVEL_RANGE.getIntegerValue();
        int minX = center.method_10263() - radius;
        int minY = center.method_10264() - radius;
        int minZ = center.method_10260() - radius;
        int maxX = center.method_10263() + radius;
        int maxY = center.method_10264() + radius;
        int maxZ = center.method_10260() + radius;
        int minCX = minX >> 4;
        int minCZ = minZ >> 4;
        int maxCX = maxX >> 4;
        int maxCZ = maxZ >> 4;
        class_3568 lightingProvider = world.method_8398().method_12130();
        for (int cx = minCX; cx <= maxCX; ++cx) {
            int startX = Math.max(cx << 4, minX);
            int endX = Math.min((cx << 4) + 15, maxX);
            for (int cz = minCZ; cz <= maxCZ; ++cz) {
                int startZ = Math.max(cz << 4, minZ);
                int endZ = Math.min((cz << 4) + 15, maxZ);
                class_2818 chunk = world.method_8497(cx, cz);
                for (int x = startX; x <= endX; ++x) {
                    for (int z = startZ; z <= endZ; ++z) {
                        int startY = Math.max(minY, 0);
                        int endY = Math.min(maxY, chunk.method_12031() + 15);
                        for (int y = startY; y <= endY; ++y) {
                            if (!this.canSpawnAt(x, y, z, (class_2791)chunk, world)) continue;
                            this.mutablePos.method_10103(x, y, z);
                            int block = lightingProvider.method_15562(class_1944.field_9282).method_15543((class_2338)this.mutablePos);
                            int sky = lightingProvider.method_15562(class_1944.field_9284).method_15543((class_2338)this.mutablePos);
                            this.lightInfos.add(new LightLevelInfo(new class_2338(x, y, z), block, sky));
                        }
                    }
                }
            }
        }
    }

    private boolean canSpawnAt(int x, int y, int z, class_2791 chunk, class_1937 world) {
        boolean spawnable;
        this.mutablePos.method_10103(x, y - 1, z);
        class_2680 state = chunk.method_8320((class_2338)this.mutablePos);
        if (!state.method_11611((class_1922)world, (class_2338)this.mutablePos, class_1299.field_6137)) {
            return false;
        }
        class_2248 block = state.method_11614();
        boolean bl = spawnable = block != class_2246.field_9987 && block != class_2246.field_10499;
        if (spawnable) {
            this.mutablePos.method_10103(x, y, z);
            state = chunk.method_8320((class_2338)this.mutablePos);
            if (class_1948.method_8662((class_1922)world, (class_2338)this.mutablePos, (class_2680)state, (class_3610)state.method_11618())) {
                this.mutablePos.method_10103(x, y + 1, z);
                state = chunk.method_8320((class_2338)this.mutablePos);
                return class_1948.method_8662((class_1922)world, (class_2338)this.mutablePos, (class_2680)state, (class_3610)state.method_11618());
            }
        }
        return false;
    }

    public static class LightLevelInfo {
        public final class_2338 pos;
        public final int block;
        public final int sky;

        public LightLevelInfo(class_2338 pos, int block, int sky) {
            this.pos = pos;
            this.block = block;
            this.sky = sky;
        }
    }

    private static interface IMarkerRenderer {
        public void render(double var1, double var3, double var5, Color4f var7, double var8, double var10, class_287 var12);
    }
}

