/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import fi.dy.masa.malilib.util.JsonUtils;
import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.config.RendererToggle;
import fi.dy.masa.minihud.renderer.OverlayRendererBase;
import fi.dy.masa.minihud.renderer.RenderObjectBase;
import fi.dy.masa.minihud.renderer.RenderUtils;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_290;
import net.minecraft.class_310;

public class OverlayRendererRandomTickableChunks
extends OverlayRendererBase {
    @Nullable
    public static class_243 newPos;
    private static final class_2350[] HORIZONTALS;
    protected final RendererToggle toggle;
    protected class_243 pos = class_243.field_1353;

    public OverlayRendererRandomTickableChunks(RendererToggle toggle) {
        this.toggle = toggle;
    }

    @Override
    public boolean shouldRender(class_310 mc) {
        return this.toggle.getBooleanValue();
    }

    @Override
    public boolean needsUpdate(class_1297 entity, class_310 mc) {
        if (this.toggle == RendererToggle.OVERLAY_RANDOM_TICKS_FIXED) {
            return newPos != null;
        }
        if (this.toggle == RendererToggle.OVERLAY_RANDOM_TICKS_PLAYER) {
            return entity.method_23317() != this.pos.field_1352 || entity.method_23321() != this.pos.field_1350;
        }
        return false;
    }

    @Override
    public void update(class_1297 entity, class_310 mc) {
        if (this.toggle == RendererToggle.OVERLAY_RANDOM_TICKS_PLAYER) {
            this.pos = entity.method_5812();
        } else if (newPos != null) {
            this.pos = newPos;
            newPos = null;
        }
        int color = this.toggle == RendererToggle.OVERLAY_RANDOM_TICKS_PLAYER ? Configs.Colors.RANDOM_TICKS_PLAYER_OVERLAY_COLOR.getIntegerValue() : Configs.Colors.RANDOM_TICKS_FIXED_OVERLAY_COLOR.getIntegerValue();
        RenderObjectBase renderQuads = (RenderObjectBase)this.renderObjects.get(0);
        RenderObjectBase renderLines = (RenderObjectBase)this.renderObjects.get(1);
        BUFFER_1.method_1328(renderQuads.getGlMode(), class_290.field_1576);
        BUFFER_2.method_1328(renderLines.getGlMode(), class_290.field_1576);
        Set<class_1923> chunks = this.getRandomTickableChunks(this.pos);
        for (class_1923 pos : chunks) {
            this.renderChunkEdgesIfApplicable(pos, chunks, entity, color);
        }
        BUFFER_1.method_1326();
        BUFFER_2.method_1326();
        renderQuads.uploadData(BUFFER_1);
        renderLines.uploadData(BUFFER_2);
    }

    protected Set<class_1923> getRandomTickableChunks(class_243 posCenter) {
        HashSet<class_1923> set = new HashSet<class_1923>();
        int centerChunkX = (int)Math.floor(posCenter.field_1352) >> 4;
        int centerChunkZ = (int)Math.floor(posCenter.field_1350) >> 4;
        double maxRange = 16384.0;
        int r = 9;
        for (int cz = centerChunkZ - 9; cz <= centerChunkZ + 9; ++cz) {
            for (int cx = centerChunkX - 9; cx <= centerChunkX + 9; ++cx) {
                double dx = (double)(cx * 16 + 8) - posCenter.field_1352;
                double dz = (double)(cz * 16 + 8) - posCenter.field_1350;
                if (!(dx * dx + dz * dz < 16384.0)) continue;
                set.add(new class_1923(cx, cz));
            }
        }
        return set;
    }

    protected void renderChunkEdgesIfApplicable(class_1923 pos, Set<class_1923> chunks, class_1297 entity, int color) {
        for (class_2350 side : HORIZONTALS) {
            class_1923 posTmp = new class_1923(pos.field_9181 + side.method_10148(), pos.field_9180 + side.method_10165());
            if (chunks.contains(posTmp)) continue;
            RenderUtils.renderVerticalWallsOfLinesWithinRange(BUFFER_1, BUFFER_2, side.method_10166(), this.getStartPos(pos, side), this.getEndPos(pos, side), 512.0f, 256.0f, 16.0f, 16.0f, entity, color);
        }
    }

    protected class_2338 getStartPos(class_1923 chunkPos, class_2350 side) {
        switch (side) {
            case field_11043: {
                return new class_2338(chunkPos.field_9181 << 4, 0, chunkPos.field_9180 << 4);
            }
            case field_11035: {
                return new class_2338(chunkPos.field_9181 << 4, 0, (chunkPos.field_9180 << 4) + 16);
            }
            case field_11039: {
                return new class_2338(chunkPos.field_9181 << 4, 0, chunkPos.field_9180 << 4);
            }
            case field_11034: {
                return new class_2338((chunkPos.field_9181 << 4) + 16, 0, chunkPos.field_9180 << 4);
            }
        }
        return class_2338.field_10980;
    }

    protected class_2338 getEndPos(class_1923 chunkPos, class_2350 side) {
        switch (side) {
            case field_11043: {
                return new class_2338((chunkPos.field_9181 << 4) + 16, 256, chunkPos.field_9180 << 4);
            }
            case field_11035: {
                return new class_2338((chunkPos.field_9181 << 4) + 16, 256, (chunkPos.field_9180 << 4) + 16);
            }
            case field_11039: {
                return new class_2338(chunkPos.field_9181 << 4, 256, (chunkPos.field_9180 << 4) + 16);
            }
            case field_11034: {
                return new class_2338((chunkPos.field_9181 << 4) + 16, 256, (chunkPos.field_9180 << 4) + 16);
            }
        }
        return class_2338.field_10980;
    }

    @Override
    public void allocateGlResources() {
        this.allocateBuffer(7);
        this.allocateBuffer(1);
    }

    @Override
    public String getSaveId() {
        return this.toggle == RendererToggle.OVERLAY_RANDOM_TICKS_FIXED ? "random_tickable_chunks" : "";
    }

    @Override
    @Nullable
    public JsonObject toJson() {
        JsonObject obj = new JsonObject();
        obj.add("pos", (JsonElement)JsonUtils.vec3dToJson((class_243)this.pos));
        return obj;
    }

    @Override
    public void fromJson(JsonObject obj) {
        class_243 pos = JsonUtils.vec3dFromJson((JsonObject)obj, (String)"pos");
        if (pos != null && this.toggle == RendererToggle.OVERLAY_RANDOM_TICKS_FIXED) {
            newPos = pos;
        }
    }

    static {
        HORIZONTALS = new class_2350[]{class_2350.field_11043, class_2350.field_11035, class_2350.field_11039, class_2350.field_11034};
    }
}

