/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.Color4f;
import fi.dy.masa.malilib.util.JsonUtils;
import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.config.RendererToggle;
import fi.dy.masa.minihud.renderer.OverlayRendererBase;
import fi.dy.masa.minihud.renderer.RenderObjectBase;
import fi.dy.masa.minihud.util.DataStorage;
import fi.dy.masa.minihud.util.MiscUtils;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_310;
import net.minecraft.class_3532;

public class OverlayRendererSlimeChunks
extends OverlayRendererBase {
    public static double overlayTopY;
    protected boolean wasSeedKnown;
    protected long seed;
    protected double topY;

    @Override
    public boolean shouldRender(class_310 mc) {
        return RendererToggle.OVERLAY_SLIME_CHUNKS_OVERLAY.getBooleanValue() && DataStorage.getInstance().isWorldSeedKnown(mc.field_1687.field_9247.method_12460()) && mc.field_1687.field_9247.method_12462();
    }

    @Override
    public boolean needsUpdate(class_1297 entity, class_310 mc) {
        boolean isSeedKnown = DataStorage.getInstance().isWorldSeedKnown(entity.field_6026);
        long seed = DataStorage.getInstance().getWorldSeed(entity.field_6026);
        if (this.topY != overlayTopY || this.wasSeedKnown != isSeedKnown || this.seed != seed) {
            return true;
        }
        int ex = (int)Math.floor(entity.method_23317());
        int ez = (int)Math.floor(entity.method_23321());
        int lx = this.lastUpdatePos.method_10263();
        int lz = this.lastUpdatePos.method_10260();
        return Math.abs(lx - ex) > 16 || Math.abs(lz - ez) > 16;
    }

    @Override
    public void update(class_1297 entity, class_310 mc) {
        DataStorage data = DataStorage.getInstance();
        this.topY = overlayTopY;
        this.wasSeedKnown = data.isWorldSeedKnown(entity.field_6026);
        this.seed = data.getWorldSeed(entity.field_6026);
        if (this.wasSeedKnown) {
            int centerX = class_3532.method_15357((double)entity.method_23317()) >> 4;
            int centerZ = class_3532.method_15357((double)entity.method_23321()) >> 4;
            Color4f colorLines = Configs.Colors.SLIME_CHUNKS_OVERLAY_COLOR.getColor();
            Color4f colorSides = Color4f.fromColor((Color4f)colorLines, (float)(colorLines.a / 6.0f));
            class_2338.class_2340 pos1 = class_2338.class_2340.method_10109();
            class_2338.class_2340 pos2 = class_2338.class_2340.method_10109();
            int r = class_3532.method_15340((int)Configs.Generic.SLIME_CHUNK_OVERLAY_RADIUS.getIntegerValue(), (int)-1, (int)40);
            if (r == -1) {
                r = mc.field_1690.field_1870;
            }
            RenderObjectBase renderQuads = (RenderObjectBase)this.renderObjects.get(0);
            RenderObjectBase renderLines = (RenderObjectBase)this.renderObjects.get(1);
            BUFFER_1.method_1328(renderQuads.getGlMode(), class_290.field_1576);
            BUFFER_2.method_1328(renderLines.getGlMode(), class_290.field_1576);
            int topY = (int)Math.floor(this.topY);
            for (int xOff = -r; xOff <= r; ++xOff) {
                for (int zOff = -r; zOff <= r; ++zOff) {
                    int cx = centerX + xOff;
                    int cz = centerZ + zOff;
                    if (!MiscUtils.canSlimeSpawnInChunk(cx, cz, this.seed)) continue;
                    pos1.method_10113(cx << 4, 0, cz << 4);
                    pos2.method_10113((cx << 4) + 15, topY, (cz << 4) + 15);
                    RenderUtils.drawBoxWithEdgesBatched((class_2338)pos1, (class_2338)pos2, (Color4f)colorLines, (Color4f)colorSides, (class_287)BUFFER_1, (class_287)BUFFER_2);
                }
            }
            pos1.close();
            pos2.close();
            BUFFER_1.method_1326();
            BUFFER_2.method_1326();
            renderQuads.uploadData(BUFFER_1);
            renderLines.uploadData(BUFFER_2);
        }
    }

    @Override
    public void allocateGlResources() {
        this.allocateBuffer(7);
        this.allocateBuffer(1);
    }

    @Override
    public String getSaveId() {
        return "slime_chunks";
    }

    @Override
    public JsonObject toJson() {
        JsonObject obj = new JsonObject();
        obj.add("y_top", (JsonElement)new JsonPrimitive((Number)overlayTopY));
        return obj;
    }

    @Override
    public void fromJson(JsonObject obj) {
        overlayTopY = JsonUtils.getFloat((JsonObject)obj, (String)"y_top");
    }
}

