/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer;

import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.config.RendererToggle;
import fi.dy.masa.minihud.renderer.OverlayRendererBase;
import fi.dy.masa.minihud.renderer.RenderObjectBase;
import fi.dy.masa.minihud.renderer.RenderUtils;
import fi.dy.masa.minihud.util.DataStorage;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2878;
import net.minecraft.class_290;
import net.minecraft.class_310;
import org.apache.commons.lang3.tuple.Pair;

public class OverlayRendererSpawnChunks
extends OverlayRendererBase {
    protected static boolean needsUpdate = true;
    protected final RendererToggle toggle;

    public static void setNeedsUpdate() {
        needsUpdate = true;
    }

    public OverlayRendererSpawnChunks(RendererToggle toggle) {
        this.toggle = toggle;
    }

    @Override
    public boolean shouldRender(class_310 mc) {
        return this.toggle.getBooleanValue() && (this.toggle == RendererToggle.OVERLAY_SPAWN_CHUNK_OVERLAY_PLAYER || mc.field_1687 != null && mc.field_1687.field_9247 instanceof class_2878 && DataStorage.getInstance().isWorldSpawnKnown());
    }

    @Override
    public boolean needsUpdate(class_1297 entity, class_310 mc) {
        if (needsUpdate) {
            return true;
        }
        int ex = (int)Math.floor(entity.method_23317());
        int ez = (int)Math.floor(entity.method_23321());
        int lx = this.lastUpdatePos.method_10263();
        int lz = this.lastUpdatePos.method_10260();
        if (this.toggle == RendererToggle.OVERLAY_SPAWN_CHUNK_OVERLAY_PLAYER) {
            return ex != lx || ez != lz;
        }
        return Math.abs(lx - ex) > 16 || Math.abs(lz - ez) > 16;
    }

    @Override
    public void update(class_1297 entity, class_310 mc) {
        DataStorage data = DataStorage.getInstance();
        class_2338 spawn = this.toggle == RendererToggle.OVERLAY_SPAWN_CHUNK_OVERLAY_PLAYER ? new class_2338(entity) : data.getWorldSpawn();
        RenderObjectBase renderQuads = (RenderObjectBase)this.renderObjects.get(0);
        RenderObjectBase renderLines = (RenderObjectBase)this.renderObjects.get(1);
        BUFFER_1.method_1328(renderQuads.getGlMode(), class_290.field_1576);
        BUFFER_2.method_1328(renderLines.getGlMode(), class_290.field_1576);
        int colorEntity = this.toggle == RendererToggle.OVERLAY_SPAWN_CHUNK_OVERLAY_REAL ? Configs.Colors.SPAWN_REAL_ENTITY_OVERLAY_COLOR.getIntegerValue() : Configs.Colors.SPAWN_PLAYER_ENTITY_OVERLAY_COLOR.getIntegerValue();
        int colorLazy = this.toggle == RendererToggle.OVERLAY_SPAWN_CHUNK_OVERLAY_REAL ? Configs.Colors.SPAWN_REAL_LAZY_OVERLAY_COLOR.getIntegerValue() : Configs.Colors.SPAWN_PLAYER_LAZY_OVERLAY_COLOR.getIntegerValue();
        int colorOuter = this.toggle == RendererToggle.OVERLAY_SPAWN_CHUNK_OVERLAY_REAL ? Configs.Colors.SPAWN_REAL_OUTER_OVERLAY_COLOR.getIntegerValue() : Configs.Colors.SPAWN_PLAYER_OUTER_OVERLAY_COLOR.getIntegerValue();
        int rangeH = (mc.field_1690.field_1870 + 1) * 16;
        Pair<class_2338, class_2338> corners = this.getSpawnChunkCorners(spawn, 22);
        RenderUtils.renderVerticalWallsOfLinesWithinRange(BUFFER_1, BUFFER_2, (class_2338)corners.getLeft(), (class_2338)corners.getRight(), rangeH, 256.0f, 16.0f, 16.0f, entity, colorOuter);
        corners = this.getSpawnChunkCorners(spawn, 11);
        RenderUtils.renderVerticalWallsOfLinesWithinRange(BUFFER_1, BUFFER_2, (class_2338)corners.getLeft(), (class_2338)corners.getRight(), rangeH, 256.0f, 16.0f, 16.0f, entity, colorLazy);
        corners = this.getSpawnChunkCorners(spawn, 9);
        RenderUtils.renderVerticalWallsOfLinesWithinRange(BUFFER_1, BUFFER_2, (class_2338)corners.getLeft(), (class_2338)corners.getRight(), rangeH, 256.0f, 16.0f, 16.0f, entity, colorEntity);
        BUFFER_1.method_1326();
        BUFFER_2.method_1326();
        renderQuads.uploadData(BUFFER_1);
        renderLines.uploadData(BUFFER_2);
        needsUpdate = false;
    }

    @Override
    public void allocateGlResources() {
        this.allocateBuffer(7);
        this.allocateBuffer(1);
    }

    protected Pair<class_2338, class_2338> getSpawnChunkCorners(class_2338 worldSpawn, int chunkRange) {
        int cx = worldSpawn.method_10263() >> 4;
        int cz = worldSpawn.method_10260() >> 4;
        class_2338 pos1 = new class_2338(cx - chunkRange << 4, 0, cz - chunkRange << 4);
        class_2338 pos2 = new class_2338((cx + chunkRange << 4) + 15, 256, (cz + chunkRange << 4) + 15);
        return Pair.of((Object)pos1, (Object)pos2);
    }
}

