/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.Color4f;
import fi.dy.masa.malilib.util.IntBoundingBox;
import fi.dy.masa.minihud.config.RendererToggle;
import fi.dy.masa.minihud.renderer.OverlayRendererBase;
import fi.dy.masa.minihud.renderer.RenderObjectBase;
import fi.dy.masa.minihud.util.DataStorage;
import fi.dy.masa.minihud.util.MiscUtils;
import fi.dy.masa.minihud.util.StructureData;
import fi.dy.masa.minihud.util.StructureTypes;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_287;
import net.minecraft.class_2874;
import net.minecraft.class_2878;
import net.minecraft.class_290;
import net.minecraft.class_310;

public class OverlayRendererStructures
extends OverlayRendererBase {
    @Override
    public boolean shouldRender(class_310 mc) {
        if (!RendererToggle.OVERLAY_STRUCTURE_MAIN_TOGGLE.getBooleanValue()) {
            return false;
        }
        if (mc.field_1687.field_9247 instanceof class_2878) {
            for (StructureTypes.StructureType type : StructureTypes.StructureType.values()) {
                if (!type.isEnabled() || !type.existsInDimension(class_2874.field_13072)) continue;
                return true;
            }
            return false;
        }
        if (mc.field_1687.field_9247.method_12467()) {
            return StructureTypes.StructureType.NETHER_FORTRESS.isEnabled();
        }
        return StructureTypes.StructureType.END_CITY.isEnabled();
    }

    @Override
    public boolean needsUpdate(class_1297 entity, class_310 mc) {
        int hysteresis = 16;
        return DataStorage.getInstance().structureRendererNeedsUpdate() || Math.abs(entity.method_23317() - (double)this.lastUpdatePos.method_10263()) > (double)hysteresis || Math.abs(entity.method_23318() - (double)this.lastUpdatePos.method_10264()) > (double)hysteresis || Math.abs(entity.method_23321() - (double)this.lastUpdatePos.method_10260()) > (double)hysteresis;
    }

    @Override
    public void update(class_1297 entity, class_310 mc) {
        RenderObjectBase renderQuads = (RenderObjectBase)this.renderObjects.get(0);
        RenderObjectBase renderLines = (RenderObjectBase)this.renderObjects.get(1);
        BUFFER_1.method_1328(renderQuads.getGlMode(), class_290.field_1576);
        BUFFER_2.method_1328(renderLines.getGlMode(), class_290.field_1576);
        this.updateStructures(mc.field_1687.field_9247.method_12460(), this.lastUpdatePos, mc);
        BUFFER_1.method_1326();
        BUFFER_2.method_1326();
        renderQuads.uploadData(BUFFER_1);
        renderLines.uploadData(BUFFER_2);
    }

    @Override
    public void allocateGlResources() {
        this.allocateBuffer(7);
        this.allocateBuffer(1);
    }

    private void updateStructures(class_2874 dimensionType, class_2338 playerPos, class_310 mc) {
        ArrayListMultimap<StructureTypes.StructureType, StructureData> structures = DataStorage.getInstance().getCopyOfStructureData();
        int maxRange = (mc.field_1690.field_1870 + 4) * 16;
        for (StructureTypes.StructureType type : StructureTypes.StructureType.values()) {
            List structureData;
            if (!type.isEnabled() || !type.existsInDimension(dimensionType) || (structureData = structures.get((Object)type)).isEmpty()) continue;
            this.renderStructuresWithinRange(type, structureData, playerPos, maxRange);
        }
    }

    private void renderStructuresWithinRange(StructureTypes.StructureType type, Collection<StructureData> structureData, class_2338 playerPos, int maxRange) {
        for (StructureData structure : structureData) {
            if (!MiscUtils.isStructureWithinRange(structure.getBoundingBox(), playerPos, maxRange)) continue;
            this.renderStructure(type, structure);
        }
    }

    private void renderStructure(StructureTypes.StructureType type, StructureData structure) {
        Color4f color = type.getToggle().getColorMain().getColor();
        ImmutableList<IntBoundingBox> components = structure.getComponents();
        RenderUtils.drawBox((IntBoundingBox)structure.getBoundingBox(), (Color4f)color, (class_287)BUFFER_1, (class_287)BUFFER_2);
        if (!(components.isEmpty() || components.size() <= 1 && MiscUtils.areBoxesEqual((IntBoundingBox)components.get(0), structure.getBoundingBox()))) {
            color = type.getToggle().getColorComponents().getColor();
            for (IntBoundingBox bb : components) {
                RenderUtils.drawBox((IntBoundingBox)bb, (Color4f)color, (class_287)BUFFER_1, (class_287)BUFFER_2);
            }
        }
    }
}

