/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.systems.RenderSystem;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.JsonUtils;
import fi.dy.masa.minihud.config.RendererToggle;
import fi.dy.masa.minihud.renderer.IOverlayRenderer;
import fi.dy.masa.minihud.renderer.OverlayRendererBase;
import fi.dy.masa.minihud.renderer.OverlayRendererBlockGrid;
import fi.dy.masa.minihud.renderer.OverlayRendererLightLevel;
import fi.dy.masa.minihud.renderer.OverlayRendererRandomTickableChunks;
import fi.dy.masa.minihud.renderer.OverlayRendererRegion;
import fi.dy.masa.minihud.renderer.OverlayRendererSlimeChunks;
import fi.dy.masa.minihud.renderer.OverlayRendererSpawnChunks;
import fi.dy.masa.minihud.renderer.OverlayRendererSpawnableColumnHeights;
import fi.dy.masa.minihud.renderer.OverlayRendererStructures;
import fi.dy.masa.minihud.renderer.shapes.ShapeBase;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_290;
import net.minecraft.class_291;
import net.minecraft.class_296;
import net.minecraft.class_310;
import net.minecraft.class_4493;
import net.minecraft.class_4587;

public class RenderContainer {
    public static final RenderContainer INSTANCE = new RenderContainer();
    private final List<OverlayRendererBase> renderers = new ArrayList<OverlayRendererBase>();
    protected boolean resourcesAllocated;
    protected int countActive;

    private RenderContainer() {
        this.addRenderer(new OverlayRendererBlockGrid());
        this.addRenderer(new OverlayRendererLightLevel());
        this.addRenderer(new OverlayRendererRandomTickableChunks(RendererToggle.OVERLAY_RANDOM_TICKS_FIXED));
        this.addRenderer(new OverlayRendererRandomTickableChunks(RendererToggle.OVERLAY_RANDOM_TICKS_PLAYER));
        this.addRenderer(new OverlayRendererRegion());
        this.addRenderer(new OverlayRendererSlimeChunks());
        this.addRenderer(new OverlayRendererSpawnableColumnHeights());
        this.addRenderer(new OverlayRendererSpawnChunks(RendererToggle.OVERLAY_SPAWN_CHUNK_OVERLAY_REAL));
        this.addRenderer(new OverlayRendererSpawnChunks(RendererToggle.OVERLAY_SPAWN_CHUNK_OVERLAY_PLAYER));
        this.addRenderer(new OverlayRendererStructures());
    }

    private void addRenderer(OverlayRendererBase renderer) {
        if (this.resourcesAllocated) {
            renderer.allocateGlResources();
        }
        this.renderers.add(renderer);
    }

    public void addShapeRenderer(ShapeBase renderer) {
        this.addRenderer(renderer);
    }

    public void removeShapeRenderer(ShapeBase renderer) {
        this.renderers.remove(renderer);
        if (this.resourcesAllocated) {
            renderer.deleteGlResources();
        }
    }

    public void render(class_1297 entity, class_310 mc, float partialTicks, class_4587 matrixStack) {
        this.update(entity, mc);
        this.draw(entity, mc, partialTicks, matrixStack);
    }

    protected void update(class_1297 entity, class_310 mc) {
        this.allocateResourcesIfNeeded();
        this.countActive = 0;
        for (int i = 0; i < this.renderers.size(); ++i) {
            OverlayRendererBase renderer = this.renderers.get(i);
            if (!renderer.shouldRender(mc)) continue;
            if (renderer.needsUpdate(entity, mc)) {
                renderer.lastUpdatePos = new class_2338(entity);
                renderer.update(entity, mc);
            }
            ++this.countActive;
        }
    }

    protected void draw(class_1297 entity, class_310 mc, float partialTicks, class_4587 matrixStack) {
        if (this.resourcesAllocated && this.countActive > 0) {
            RenderSystem.pushMatrix();
            RenderSystem.disableTexture();
            RenderSystem.alphaFunc((int)516, (float)0.01f);
            RenderSystem.disableCull();
            RenderSystem.enableDepthTest();
            RenderSystem.disableLighting();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.polygonOffset((float)-3.0f, (float)-3.0f);
            RenderSystem.enablePolygonOffset();
            RenderUtils.setupBlend();
            RenderUtils.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            class_4493.method_21913((int)32884);
            class_4493.method_21913((int)32886);
            class_243 cameraPos = mc.field_1773.method_19418().method_19326();
            for (int i = 0; i < this.renderers.size(); ++i) {
                IOverlayRenderer renderer = this.renderers.get(i);
                if (!renderer.shouldRender(mc)) continue;
                renderer.draw(cameraPos.field_1352, cameraPos.field_1351, cameraPos.field_1350, matrixStack);
            }
            class_291.method_1354();
            RenderSystem.clearCurrentColor();
            for (class_296 element : class_290.field_1576.method_1357()) {
                class_296.class_298 usage = element.method_1382();
                switch (usage) {
                    case field_1633: {
                        class_4493.method_21911((int)32884);
                        break;
                    }
                    case field_1632: {
                        class_4493.method_21911((int)32886);
                        RenderSystem.clearCurrentColor();
                    }
                }
            }
            RenderSystem.polygonOffset((float)0.0f, (float)0.0f);
            RenderSystem.disablePolygonOffset();
            RenderUtils.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableBlend();
            RenderSystem.enableDepthTest();
            RenderSystem.enableLighting();
            RenderSystem.enableCull();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableTexture();
            RenderSystem.popMatrix();
        }
    }

    protected void allocateResourcesIfNeeded() {
        if (!this.resourcesAllocated) {
            this.deleteGlResources();
            this.allocateGlResources();
        }
    }

    protected void allocateGlResources() {
        if (!this.resourcesAllocated) {
            for (int i = 0; i < this.renderers.size(); ++i) {
                this.renderers.get(i).allocateGlResources();
            }
            this.resourcesAllocated = true;
        }
    }

    protected void deleteGlResources() {
        if (this.resourcesAllocated) {
            for (int i = 0; i < this.renderers.size(); ++i) {
                this.renderers.get(i).deleteGlResources();
            }
            this.resourcesAllocated = false;
        }
    }

    public JsonObject toJson() {
        JsonObject obj = new JsonObject();
        for (int i = 0; i < this.renderers.size(); ++i) {
            OverlayRendererBase renderer = this.renderers.get(i);
            String id = renderer.getSaveId();
            if (id.isEmpty()) continue;
            obj.add(id, (JsonElement)renderer.toJson());
        }
        return obj;
    }

    public void fromJson(JsonObject obj) {
        for (int i = 0; i < this.renderers.size(); ++i) {
            OverlayRendererBase renderer = this.renderers.get(i);
            String id = renderer.getSaveId();
            if (id.isEmpty() || !JsonUtils.hasObject((JsonObject)obj, (String)id)) continue;
            renderer.fromJson(obj.get(id).getAsJsonObject());
        }
    }
}

