/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer.shapes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import fi.dy.masa.malilib.interfaces.IRangeChangeListener;
import fi.dy.masa.malilib.util.Color4f;
import fi.dy.masa.malilib.util.JsonUtils;
import fi.dy.masa.malilib.util.LayerRange;
import fi.dy.masa.malilib.util.StringUtils;
import fi.dy.masa.minihud.config.RendererToggle;
import fi.dy.masa.minihud.renderer.OverlayRendererBase;
import fi.dy.masa.minihud.renderer.shapes.ShapeManager;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_310;

public abstract class ShapeBase
extends OverlayRendererBase
implements IRangeChangeListener {
    protected final ShapeManager.ShapeTypes type;
    protected final LayerRange layerRange;
    protected final class_310 mc;
    protected Color4f color;
    protected boolean enabled;
    protected boolean needsUpdate;

    public ShapeBase(ShapeManager.ShapeTypes type, Color4f color) {
        this.type = type;
        this.color = color;
        this.layerRange = new LayerRange((IRangeChangeListener)this);
        this.mc = class_310.method_1551();
        this.needsUpdate = true;
    }

    public abstract List<String> getWidgetHoverLines();

    public ShapeManager.ShapeTypes getType() {
        return this.type;
    }

    public LayerRange getLayerRange() {
        return this.layerRange;
    }

    public Color4f getColor() {
        return this.color;
    }

    public void setColorFromString(String newValue) {
        int newColor = StringUtils.getColor((String)newValue, (int)0);
        if (newColor != this.color.intValue) {
            this.color = Color4f.fromColor((int)newColor);
            this.setNeedsUpdate();
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void toggleEnabled() {
        boolean bl = this.enabled = !this.enabled;
        if (this.enabled) {
            this.setNeedsUpdate();
        }
    }

    public void setNeedsUpdate() {
        this.needsUpdate = true;
    }

    @Override
    public boolean shouldRender(class_310 mc) {
        return this.enabled && RendererToggle.SHAPE_RENDERER.getBooleanValue();
    }

    @Override
    public boolean needsUpdate(class_1297 entity, class_310 mc) {
        return this.needsUpdate;
    }

    public void updateAll() {
        this.setNeedsUpdate();
    }

    public void updateBetweenX(int minX, int maxX) {
        this.setNeedsUpdate();
    }

    public void updateBetweenY(int minY, int maxY) {
        this.setNeedsUpdate();
    }

    public void updateBetweenZ(int minZ, int maxZ) {
        this.setNeedsUpdate();
    }

    @Override
    public JsonObject toJson() {
        JsonObject obj = new JsonObject();
        obj.add("type", (JsonElement)new JsonPrimitive(this.type.getId()));
        obj.add("enabled", (JsonElement)new JsonPrimitive(Boolean.valueOf(this.enabled)));
        obj.add("layers", (JsonElement)this.layerRange.toJson());
        return obj;
    }

    @Override
    public void fromJson(JsonObject obj) {
        this.enabled = JsonUtils.getBoolean((JsonObject)obj, (String)"enabled");
        if (JsonUtils.hasObject((JsonObject)obj, (String)"layers")) {
            this.layerRange.fromJson(JsonUtils.getNestedObject((JsonObject)obj, (String)"layers", (boolean)false));
        }
    }
}

