/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer.shapes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.blaze3d.systems.RenderSystem;
import fi.dy.masa.malilib.util.BlockSnap;
import fi.dy.masa.malilib.util.Color4f;
import fi.dy.masa.malilib.util.JsonUtils;
import fi.dy.masa.malilib.util.Quadrant;
import fi.dy.masa.malilib.util.StringUtils;
import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.renderer.RenderObjectBase;
import fi.dy.masa.minihud.renderer.shapes.ShapeBase;
import fi.dy.masa.minihud.renderer.shapes.ShapeManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_310;
import net.minecraft.class_4587;

public class ShapeDespawnSphere
extends ShapeBase {
    private static final class_2350[] FACING_ALL = new class_2350[]{class_2350.field_11033, class_2350.field_11036, class_2350.field_11043, class_2350.field_11035, class_2350.field_11039, class_2350.field_11034};
    protected class_243 center = class_243.field_1353;
    protected class_243 effectiveCenter = class_243.field_1353;
    protected final class_243[] quadrantCenters = new class_243[4];
    protected class_243 lastUpdatePos = class_243.field_1353;
    protected BlockSnap snap = BlockSnap.NONE;
    protected double margin = 0.5;
    protected long lastUpdateTime;

    public ShapeDespawnSphere() {
        super(ShapeManager.ShapeTypes.DESPAWN_SPHERE, Configs.Colors.DESPAWN_SPHERE_OVERLAY_COLOR.getColor());
        if (this.mc.field_1724 != null) {
            this.setCenter(this.mc.field_1724.method_19538());
        } else {
            this.setCenter(class_243.field_1353);
        }
    }

    public class_243 getCenter() {
        return this.center;
    }

    public void setCenter(class_243 center) {
        this.center = center;
        this.updateEffectiveCenter();
    }

    private void updateQuadrantPoints() {
        class_243 center = this.effectiveCenter;
        this.quadrantCenters[Quadrant.NORTH_WEST.ordinal()] = new class_243(center.field_1352 - this.margin, center.field_1351, center.field_1350 - this.margin);
        this.quadrantCenters[Quadrant.NORTH_EAST.ordinal()] = new class_243(center.field_1352 + this.margin, center.field_1351, center.field_1350 - this.margin);
        this.quadrantCenters[Quadrant.SOUTH_WEST.ordinal()] = new class_243(center.field_1352 - this.margin, center.field_1351, center.field_1350 + this.margin);
        this.quadrantCenters[Quadrant.SOUTH_EAST.ordinal()] = new class_243(center.field_1352 + this.margin, center.field_1351, center.field_1350 + this.margin);
        this.setNeedsUpdate();
    }

    private void updateEffectiveCenter() {
        class_243 center = this.center;
        this.effectiveCenter = this.snap == BlockSnap.CENTER ? new class_243(Math.floor(center.field_1352) + 0.5, Math.floor(center.field_1351), Math.floor(center.field_1350) + 0.5) : (this.snap == BlockSnap.CORNER ? new class_243(Math.floor(center.field_1352), Math.floor(center.field_1351), Math.floor(center.field_1350)) : center);
        this.updateQuadrantPoints();
    }

    public double getMargin() {
        return this.margin;
    }

    public void setMargin(double margin) {
        this.margin = margin;
        this.updateQuadrantPoints();
    }

    public BlockSnap getBlockSnap() {
        return this.snap;
    }

    public void setBlockSnap(BlockSnap snap) {
        this.snap = snap;
        this.updateEffectiveCenter();
    }

    @Override
    public void update(class_1297 entity, class_310 mc) {
        this.renderSphereBlock();
        this.needsUpdate = false;
        this.lastUpdatePos = entity.method_19538();
        this.lastUpdateTime = System.currentTimeMillis();
    }

    @Override
    public void allocateGlResources() {
        this.allocateBuffer(7);
    }

    @Override
    public void draw(double x, double y, double z, class_4587 matrixStack) {
        RenderSystem.pushMatrix();
        this.preRender(x, y, z);
        matrixStack.method_22903();
        matrixStack.method_22904(-x, -y, -z);
        ((RenderObjectBase)this.renderObjects.get(0)).draw(matrixStack);
        RenderSystem.polygonMode((int)1032, (int)6913);
        RenderSystem.disableBlend();
        ((RenderObjectBase)this.renderObjects.get(0)).draw(matrixStack);
        RenderSystem.polygonMode((int)1032, (int)6914);
        RenderSystem.enableBlend();
        matrixStack.method_22909();
        RenderSystem.popMatrix();
    }

    @Override
    public JsonObject toJson() {
        JsonObject obj = super.toJson();
        obj.add("center", (JsonElement)JsonUtils.vec3dToJson((class_243)this.center));
        obj.add("snap", (JsonElement)new JsonPrimitive(this.snap.getStringValue()));
        obj.add("margin", (JsonElement)new JsonPrimitive((Number)this.margin));
        obj.add("color", (JsonElement)new JsonPrimitive((Number)this.color.intValue));
        return obj;
    }

    @Override
    public void fromJson(JsonObject obj) {
        class_243 center;
        super.fromJson(obj);
        this.margin = JsonUtils.getDouble((JsonObject)obj, (String)"margin");
        if (JsonUtils.hasString((JsonObject)obj, (String)"snap")) {
            this.snap = BlockSnap.fromStringStatic((String)JsonUtils.getString((JsonObject)obj, (String)"snap"));
        }
        if ((center = JsonUtils.vec3dFromJson((JsonObject)obj, (String)"center")) != null) {
            this.setCenter(center);
        }
        if (JsonUtils.hasInteger((JsonObject)obj, (String)"color")) {
            this.color = Color4f.fromColor((int)JsonUtils.getInteger((JsonObject)obj, (String)"color"));
        }
    }

    @Override
    public List<String> getWidgetHoverLines() {
        ArrayList<String> lines = new ArrayList<String>();
        class_243 c = this.center;
        lines.add(StringUtils.translate((String)"minihud.gui.label.center_value", (Object[])new Object[]{String.format("x: %.2f, y: %.2f, z: %.2f", c.field_1352, c.field_1351, c.field_1350)}));
        lines.add(StringUtils.translate((String)"minihud.gui.label.block_snap", (Object[])new Object[]{this.snap.getDisplayName()}));
        lines.add(StringUtils.translate((String)"minihud.gui.label.margin_value", (Object[])new Object[]{String.format("%.2f", this.margin)}));
        if (this.snap != BlockSnap.NONE) {
            c = this.effectiveCenter;
            lines.add(StringUtils.translate((String)"minihud.gui.label.effective_center_value", (Object[])new Object[]{String.format("x: %.2f, y: %.2f, z: %.2f", c.field_1352, c.field_1351, c.field_1350)}));
        }
        return lines;
    }

    protected void renderSphereBlock() {
        RenderObjectBase renderQuads = (RenderObjectBase)this.renderObjects.get(0);
        BUFFER_1.method_1328(renderQuads.getGlMode(), class_290.field_1576);
        Color4f colorQuad = this.color;
        class_2338 posCenter = new class_2338(this.effectiveCenter);
        class_2338.class_2339 posMutable = new class_2338.class_2339();
        HashSet<class_2338> spherePositions = new HashSet<class_2338>();
        posMutable.method_10101((class_2382)posCenter);
        this.addPositionsOnRing(spherePositions, posMutable, class_2350.field_11034);
        posMutable.method_10101((class_2382)posCenter);
        this.addPositionsOnRing(spherePositions, posMutable, class_2350.field_11036);
        for (int i = 1; i < 130; ++i) {
            posMutable.method_10103(posCenter.method_10263(), posCenter.method_10264() - i, posCenter.method_10260());
            this.addPositionsOnRing(spherePositions, posMutable, class_2350.field_11034);
            posMutable.method_10103(posCenter.method_10263(), posCenter.method_10264() + i, posCenter.method_10260());
            this.addPositionsOnRing(spherePositions, posMutable, class_2350.field_11034);
            posMutable.method_10103(posCenter.method_10263() - i, posCenter.method_10264(), posCenter.method_10260());
            this.addPositionsOnRing(spherePositions, posMutable, class_2350.field_11036);
            posMutable.method_10103(posCenter.method_10263() + i, posCenter.method_10264(), posCenter.method_10260());
            this.addPositionsOnRing(spherePositions, posMutable, class_2350.field_11036);
        }
        for (class_2338 pos : spherePositions) {
            for (int i = 0; i < 6; ++i) {
                class_2350 side = FACING_ALL[i];
                posMutable.method_10101((class_2382)pos).method_10098(side);
                if (!this.layerRange.isPositionWithinRange(pos) || spherePositions.contains(posMutable) || !this.isAdjacentPositionOutside(pos, side)) continue;
                ShapeDespawnSphere.renderBlockSideQuads(pos, side, BUFFER_1, colorQuad);
            }
        }
        BUFFER_1.method_1326();
        renderQuads.uploadData(BUFFER_1);
    }

    private void addPositionsOnRing(HashSet<class_2338> positions, class_2338.class_2339 posMutable, class_2350 direction) {
        if (this.movePositionToRing(posMutable, direction)) {
            class_2338 posFirst = posMutable.method_10062();
            positions.add(posFirst);
            int failsafe = 860;
            class_2350.class_2351 axis = direction.method_10166();
            while (--failsafe > 0 && (direction = axis == class_2350.class_2351.field_11052 ? this.getNextPositionOnRingVertical(posMutable, direction) : this.getNextPositionOnRing(posMutable, direction)) != null && !posMutable.equals((Object)posFirst)) {
                positions.add(posMutable.method_10062());
            }
        }
    }

    private boolean movePositionToRing(class_2338.class_2339 posMutable, class_2350 dir) {
        int x = posMutable.method_10263();
        int y = posMutable.method_10264();
        int z = posMutable.method_10260();
        int xNext = x;
        int yNext = y;
        int zNext = z;
        int failsafe = 0;
        int failsafeMax = 140;
        while (this.isPositionWithinRange(xNext, yNext, zNext) && ++failsafe < 140) {
            x = xNext;
            y = yNext;
            z = zNext;
            xNext += dir.method_10148();
            yNext += dir.method_10164();
            zNext += dir.method_10165();
        }
        if (failsafe > 0) {
            posMutable.method_10103(x, y, z);
            return true;
        }
        return false;
    }

    @Nullable
    private class_2350 getNextPositionOnRing(class_2338.class_2339 posMutable, class_2350 dir) {
        class_2350 dirOut = dir;
        class_2350 ccw90 = ShapeDespawnSphere.getNextDirRotating(dir);
        int y = posMutable.method_10264();
        for (int i = 0; i < 4; ++i) {
            int z;
            int x = posMutable.method_10263() + dir.method_10148();
            if (this.isPositionWithinRange(x, y, z = posMutable.method_10260() + dir.method_10165())) {
                posMutable.method_10103(x, y, z);
                return dirOut;
            }
            x = posMutable.method_10263() + dir.method_10148() + ccw90.method_10148();
            if (this.isPositionWithinRange(x, y, z = posMutable.method_10260() + dir.method_10165() + ccw90.method_10165())) {
                posMutable.method_10103(x, y, z);
                return dirOut;
            }
            dirOut = dir;
            dir = ShapeDespawnSphere.getNextDirRotating(dir);
            ccw90 = ShapeDespawnSphere.getNextDirRotating(dir);
        }
        return null;
    }

    @Nullable
    private class_2350 getNextPositionOnRingVertical(class_2338.class_2339 posMutable, class_2350 dir) {
        class_2350 dirOut = dir;
        class_2350 ccw90 = ShapeDespawnSphere.getNextDirRotatingVertical(dir);
        for (int i = 0; i < 4; ++i) {
            int z;
            int y;
            int x = posMutable.method_10263() + dir.method_10148();
            if (this.isPositionWithinRange(x, y = posMutable.method_10264() + dir.method_10164(), z = posMutable.method_10260() + dir.method_10165())) {
                posMutable.method_10103(x, y, z);
                return dirOut;
            }
            x = posMutable.method_10263() + dir.method_10148() + ccw90.method_10148();
            if (this.isPositionWithinRange(x, y = posMutable.method_10264() + dir.method_10164() + ccw90.method_10164(), z = posMutable.method_10260() + dir.method_10165() + ccw90.method_10165())) {
                posMutable.method_10103(x, y, z);
                return dirOut;
            }
            dirOut = dir;
            dir = ShapeDespawnSphere.getNextDirRotatingVertical(dir);
            ccw90 = ShapeDespawnSphere.getNextDirRotatingVertical(dir);
        }
        return null;
    }

    private boolean isPositionWithinRange(int x, int y, int z) {
        double dz;
        double dy;
        double dx;
        double maxDistSq = 16384.0;
        class_243 quadrantCenter = this.quadrantCenters[Quadrant.getQuadrant((int)x, (int)z, (class_243)this.effectiveCenter).ordinal()];
        return quadrantCenter.method_1028(dx = (double)x + 0.5, dy = (double)(y + 1), dz = (double)z + 0.5) < 16384.0 || this.effectiveCenter.method_1028(dx, dy, dz) < 16384.0;
    }

    private boolean isAdjacentPositionOutside(class_2338 pos, class_2350 dir) {
        double z;
        double y;
        double x;
        double maxDistSq = 16384.0;
        class_243 quadrantCenter = this.quadrantCenters[Quadrant.getQuadrant((int)pos.method_10263(), (int)pos.method_10260(), (class_243)this.effectiveCenter).ordinal()];
        return quadrantCenter.method_1028(x = (double)(pos.method_10263() + dir.method_10148()) + 0.5, y = (double)(pos.method_10264() + dir.method_10164() + 1), z = (double)(pos.method_10260() + dir.method_10165()) + 0.5) >= 16384.0 && this.effectiveCenter.method_1028(x, y, z) >= 16384.0;
    }

    private static class_2350 getNextDirRotating(class_2350 dirIn) {
        switch (dirIn) {
            case field_11034: {
                return class_2350.field_11043;
            }
            case field_11043: {
                return class_2350.field_11039;
            }
            case field_11039: {
                return class_2350.field_11035;
            }
            case field_11035: {
                return class_2350.field_11034;
            }
        }
        return class_2350.field_11043;
    }

    private static class_2350 getNextDirRotatingVertical(class_2350 dirIn) {
        switch (dirIn) {
            case field_11036: {
                return class_2350.field_11043;
            }
            case field_11043: {
                return class_2350.field_11033;
            }
            case field_11033: {
                return class_2350.field_11035;
            }
            case field_11035: {
                return class_2350.field_11036;
            }
        }
        return class_2350.field_11043;
    }

    public static void renderBlockSideQuads(class_2338 pos, class_2350 side, class_287 buffer, Color4f color) {
        double x = pos.method_10263();
        double y = pos.method_10264();
        double z = pos.method_10260();
        switch (side) {
            case field_11033: {
                buffer.method_22912(x, y, z).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(x + 1.0, y, z).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(x + 1.0, y, z + 1.0).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(x, y, z + 1.0).method_22915(color.r, color.g, color.b, color.a).method_1344();
                break;
            }
            case field_11036: {
                buffer.method_22912(x, y + 1.0, z).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(x, y + 1.0, z + 1.0).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(x + 1.0, y + 1.0, z + 1.0).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(x + 1.0, y + 1.0, z).method_22915(color.r, color.g, color.b, color.a).method_1344();
                break;
            }
            case field_11043: {
                buffer.method_22912(x, y, z).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(x, y + 1.0, z).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(x + 1.0, y + 1.0, z).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(x + 1.0, y, z).method_22915(color.r, color.g, color.b, color.a).method_1344();
                break;
            }
            case field_11035: {
                buffer.method_22912(x, y, z + 1.0).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(x + 1.0, y, z + 1.0).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(x + 1.0, y + 1.0, z + 1.0).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(x, y + 1.0, z + 1.0).method_22915(color.r, color.g, color.b, color.a).method_1344();
                break;
            }
            case field_11039: {
                buffer.method_22912(x, y, z).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(x, y, z + 1.0).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(x, y + 1.0, z + 1.0).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(x, y + 1.0, z).method_22915(color.r, color.g, color.b, color.a).method_1344();
                break;
            }
            case field_11034: {
                buffer.method_22912(x + 1.0, y, z).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(x + 1.0, y + 1.0, z).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(x + 1.0, y + 1.0, z + 1.0).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(x + 1.0, y, z + 1.0).method_22915(color.r, color.g, color.b, color.a).method_1344();
            }
        }
    }

    public static void renderBlockSideLines(class_2338 pos, class_2350 side, class_287 buffer, Color4f color) {
        double x = pos.method_10263();
        double y = pos.method_10264();
        double z = pos.method_10260();
        switch (side) {
            case field_11033: {
                buffer.method_22912(x, y, z).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(x + 1.0, y, z).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(x + 1.0, y, z).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(x + 1.0, y, z + 1.0).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(x + 1.0, y, z + 1.0).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(x, y, z + 1.0).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(x, y, z + 1.0).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(x, y, z).method_22915(color.r, color.g, color.b, color.a).method_1344();
                break;
            }
            case field_11036: {
                buffer.method_22912(x, y + 1.0, z).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(x, y + 1.0, z + 1.0).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(x, y + 1.0, z + 1.0).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(x + 1.0, y + 1.0, z + 1.0).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(x + 1.0, y + 1.0, z + 1.0).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(x + 1.0, y + 1.0, z).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(x + 1.0, y + 1.0, z).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(x, y + 1.0, z).method_22915(color.r, color.g, color.b, color.a).method_1344();
                break;
            }
            case field_11043: {
                buffer.method_22912(x, y, z).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(x, y + 1.0, z).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(x, y + 1.0, z).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(x + 1.0, y + 1.0, z).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(x + 1.0, y + 1.0, z).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(x + 1.0, y, z).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(x + 1.0, y, z).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(x, y, z).method_22915(color.r, color.g, color.b, color.a).method_1344();
                break;
            }
            case field_11035: {
                buffer.method_22912(x, y, z + 1.0).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(x + 1.0, y, z + 1.0).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(x + 1.0, y, z + 1.0).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(x + 1.0, y + 1.0, z + 1.0).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(x + 1.0, y + 1.0, z + 1.0).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(x, y + 1.0, z + 1.0).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(x, y + 1.0, z + 1.0).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(x, y, z + 1.0).method_22915(color.r, color.g, color.b, color.a).method_1344();
                break;
            }
            case field_11039: {
                buffer.method_22912(x, y, z).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(x, y, z + 1.0).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(x, y, z + 1.0).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(x, y + 1.0, z + 1.0).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(x, y + 1.0, z + 1.0).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(x, y + 1.0, z).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(x, y + 1.0, z).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(x, y, z).method_22915(color.r, color.g, color.b, color.a).method_1344();
                break;
            }
            case field_11034: {
                buffer.method_22912(x + 1.0, y, z).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(x + 1.0, y + 1.0, z).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(x + 1.0, y + 1.0, z).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(x + 1.0, y + 1.0, z + 1.0).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(x + 1.0, y + 1.0, z + 1.0).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(x + 1.0, y, z + 1.0).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(x + 1.0, y, z + 1.0).method_22915(color.r, color.g, color.b, color.a).method_1344();
                buffer.method_22912(x + 1.0, y, z).method_22915(color.r, color.g, color.b, color.a).method_1344();
            }
        }
    }
}

