/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.util;

import com.google.common.collect.MapMaker;
import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.config.RendererToggle;
import fi.dy.masa.minihud.mixin.IMixinEntityNavigation;
import io.netty.buffer.Unpooled;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.class_11;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1408;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2658;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_863;
import net.minecraft.class_869;
import net.minecraft.class_9;
import net.minecraft.server.MinecraftServer;

public class DebugInfoUtils {
    private static boolean neighborUpdateEnabled;
    private static boolean pathfindingEnabled;
    private static int tickCounter;
    private static final Map<class_1297, class_11> OLD_PATHS;

    public static void sendPacketDebugPath(MinecraftServer server, int entityId, class_11 path, float maxDistance) {
        class_2540 buffer = new class_2540(Unpooled.buffer());
        buffer.writeInt(entityId);
        buffer.writeFloat(maxDistance);
        DebugInfoUtils.writePathToBuffer(buffer, path);
        class_2658 packet = new class_2658(class_2658.field_12161, buffer);
        server.method_3760().method_14581((class_2596)packet);
    }

    private static void writeBlockPosToBuffer(class_2540 buf, class_2338 pos) {
        buf.writeInt(pos.method_10263());
        buf.writeInt(pos.method_10264());
        buf.writeInt(pos.method_10260());
    }

    private static void writePathPointToBuffer(class_2540 buf, class_9 node) {
        buf.writeInt(node.field_40);
        buf.writeInt(node.field_39);
        buf.writeInt(node.field_38);
        buf.writeFloat(node.field_46);
        buf.writeFloat(node.field_43);
        buf.writeBoolean(node.field_42);
        buf.writeInt(node.field_41.ordinal());
        buf.writeFloat(node.field_47);
    }

    public static class_2540 writePathTobuffer(class_11 path) {
        class_2540 buffer = new class_2540(Unpooled.buffer());
        DebugInfoUtils.writePathToBuffer(buffer, path);
        return buffer;
    }

    private static void writePathToBuffer(class_2540 buf, class_11 path) {
        class_9 destination = path.method_45();
        class_2338 target = path.method_48();
        if (destination != null) {
            buf.writeBoolean(path.method_21655());
            buf.writeInt(path.method_39());
            buf.writeInt(0);
            DebugInfoUtils.writeBlockPosToBuffer(buf, target);
            List nodes = path.method_19314();
            class_9[] openSet = path.method_22880();
            class_9[] closedSet = path.method_22881();
            buf.writeInt(nodes.size());
            for (class_9 point : nodes) {
                DebugInfoUtils.writePathPointToBuffer(buf, point);
            }
            buf.writeInt(openSet.length);
            for (class_9 point : openSet) {
                DebugInfoUtils.writePathPointToBuffer(buf, point);
            }
            buf.writeInt(closedSet.length);
            for (class_9 point : closedSet) {
                DebugInfoUtils.writePathPointToBuffer(buf, point);
            }
        }
    }

    public static void onNeighborNotify(class_1937 world, final class_2338 pos, final EnumSet<class_2350> notifiedSides) {
        if (neighborUpdateEnabled && !world.field_9236) {
            final long time = world.method_8510();
            class_310.method_1551().execute(new Runnable(){

                @Override
                public void run() {
                    for (class_2350 side : notifiedSides) {
                        ((class_869)class_310.method_1551().field_1709.field_4535).method_3870(time, pos.method_10093(side));
                    }
                }
            });
        }
    }

    public static void onServerTickEnd(MinecraftServer server) {
        class_310 mc = class_310.method_1551();
        if (pathfindingEnabled && mc.field_1687 != null && ++tickCounter >= 10) {
            tickCounter = 0;
            class_3218 world = server.method_3847(mc.field_1687.field_9247.method_12460());
            if (world != null) {
                Predicate<class_1297> predicate = entity -> entity instanceof class_1308 && entity.method_5805();
                for (class_1297 entity2 : world.method_18198(null, predicate)) {
                    boolean isSamepath;
                    class_1408 navigator = ((class_1308)entity2).method_5942();
                    if (navigator == null || !DebugInfoUtils.isAnyPlayerWithinRange(world, entity2, 64.0)) continue;
                    class_11 path = navigator.method_6345();
                    class_11 old = OLD_PATHS.get(entity2);
                    if (path == null) continue;
                    boolean bl = isSamepath = old != null && old.method_41(path);
                    if (old != null && isSamepath && old.method_39() == path.method_39()) continue;
                    int id = entity2.method_5628();
                    float maxDistance = Configs.Generic.DEBUG_RENDERER_PATH_MAX_DIST.getBooleanValue() ? ((IMixinEntityNavigation)navigator).getMaxDistanceToWaypoint() : 0.0f;
                    DebugInfoUtils.sendPacketDebugPath(server, id, path, maxDistance);
                    if (!isSamepath) {
                        class_2540 buf = DebugInfoUtils.writePathTobuffer(path);
                        OLD_PATHS.put(entity2, class_11.method_34((class_2540)buf));
                        continue;
                    }
                    if (old == null) continue;
                    old.method_42(path.method_39());
                }
            }
        }
    }

    private static boolean isAnyPlayerWithinRange(class_3218 world, class_1297 entity, double range) {
        for (int i = 0; i < world.method_18456().size(); ++i) {
            class_1657 player = (class_1657)world.method_18456().get(i);
            double distSq = player.method_5649(entity.method_23317(), entity.method_23318(), entity.method_23321());
            if (!(range < 0.0) && !(distSq < range * range)) continue;
            return true;
        }
        return false;
    }

    public static void toggleDebugRenderer(RendererToggle config) {
        if (config == RendererToggle.DEBUG_NEIGHBOR_UPDATES) {
            neighborUpdateEnabled = config.getBooleanValue();
        } else if (config == RendererToggle.DEBUG_PATH_FINDING) {
            pathfindingEnabled = config.getBooleanValue();
        }
    }

    public static void renderVanillaDebug(class_4587 matrixStack, class_4597.class_4598 vtx, double cameraX, double cameraY, double cameraZ) {
        class_863 renderer = class_310.method_1551().field_1709;
        if (RendererToggle.DEBUG_COLLISION_BOXES.getBooleanValue()) {
            renderer.field_4534.method_23109(matrixStack, (class_4597)vtx, cameraX, cameraY, cameraZ);
        }
        if (RendererToggle.DEBUG_NEIGHBOR_UPDATES.getBooleanValue()) {
            renderer.field_4535.method_23109(matrixStack, (class_4597)vtx, cameraX, cameraY, cameraZ);
        }
        if (RendererToggle.DEBUG_PATH_FINDING.getBooleanValue()) {
            renderer.field_4523.method_23109(matrixStack, (class_4597)vtx, cameraX, cameraY, cameraZ);
        }
        if (RendererToggle.DEBUG_SOLID_FACES.getBooleanValue()) {
            renderer.field_4517.method_23109(matrixStack, (class_4597)vtx, cameraX, cameraY, cameraZ);
        }
        if (RendererToggle.DEBUG_WATER.getBooleanValue()) {
            renderer.field_4528.method_23109(matrixStack, (class_4597)vtx, cameraX, cameraY, cameraZ);
        }
    }

    static {
        OLD_PATHS = new MapMaker().weakKeys().weakValues().makeMap();
    }
}

