/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.util;

import com.google.common.collect.ImmutableList;
import fi.dy.masa.malilib.util.IntBoundingBox;
import fi.dy.masa.minihud.util.StructureTypes;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3449;

public class StructureData {
    public static final int CARPET_STRUCTURE_ID_OUTER_BOUNDING_BOX = 0;
    public static final int CARPET_STRUCTURE_ID_END_CITY = 1;
    public static final int CARPET_STRUCTURE_ID_FORTRESS = 2;
    public static final int CARPET_STRUCTURE_ID_TEMPLE = 3;
    public static final int CARPET_STRUCTURE_ID_VILLAGE = 4;
    public static final int CARPET_STRUCTURE_ID_STRONGHOLD = 5;
    public static final int CARPET_STRUCTURE_ID_MINESHAFT = 6;
    public static final int CARPET_STRUCTURE_ID_MONUMENT = 7;
    public static final int CARPET_STRUCTURE_ID_MANSION = 8;
    private final StructureTypes.StructureType type;
    private final IntBoundingBox mainBox;
    private final ImmutableList<IntBoundingBox> componentBoxes;
    private long refreshTime;

    private StructureData(StructureTypes.StructureType type, IntBoundingBox mainBox, ImmutableList<IntBoundingBox> componentBoxes, long refreshTime) {
        this(type, mainBox, componentBoxes);
        this.refreshTime = refreshTime;
    }

    private StructureData(StructureTypes.StructureType type, IntBoundingBox mainBox, ImmutableList<IntBoundingBox> componentBoxes) {
        this.type = type;
        this.mainBox = mainBox;
        this.componentBoxes = componentBoxes;
    }

    public StructureTypes.StructureType getStructureType() {
        return this.type;
    }

    public IntBoundingBox getBoundingBox() {
        return this.mainBox;
    }

    public ImmutableList<IntBoundingBox> getComponents() {
        return this.componentBoxes;
    }

    public long getRefreshTime() {
        return this.refreshTime;
    }

    public static StructureData fromStructureStart(StructureTypes.StructureType type, class_3449 structure) {
        ImmutableList.Builder builder = ImmutableList.builder();
        List components = structure.method_14963();
        for (class_3443 component : components) {
            builder.add((Object)IntBoundingBox.fromVanillaBox((class_3341)component.method_14935()));
        }
        return new StructureData(type, IntBoundingBox.fromVanillaBox((class_3341)structure.method_14968()), (ImmutableList<IntBoundingBox>)builder.build());
    }

    @Nullable
    public static StructureData fromStructureStartTag(class_2487 tag, long currentTime) {
        if (tag.method_10573("BB", 11) && tag.method_10573("Children", 9)) {
            StructureTypes.StructureType type = StructureTypes.byStructureId(tag.method_10558("id"));
            ImmutableList.Builder builder = ImmutableList.builder();
            class_2499 pieces = tag.method_10554("Children", 10);
            int count = pieces.size();
            for (int i = 0; i < count; ++i) {
                class_2487 pieceTag = pieces.method_10602(i);
                builder.add((Object)IntBoundingBox.fromArray((int[])pieceTag.method_10561("BB")));
            }
            return new StructureData(type, IntBoundingBox.fromArray((int[])tag.method_10561("BB")), (ImmutableList<IntBoundingBox>)builder.build(), currentTime);
        }
        return null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.componentBoxes == null ? 0 : this.componentBoxes.hashCode());
        result = 31 * result + (this.mainBox == null ? 0 : this.mainBox.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        StructureData other = (StructureData)obj;
        if (this.componentBoxes == null ? other.componentBoxes != null : !this.componentBoxes.equals(other.componentBoxes)) {
            return false;
        }
        if (this.mainBox == null ? other.mainBox != null : !this.mainBox.equals((Object)other.mainBox)) {
            return false;
        }
        return this.type == other.type;
    }
}

