/*
 * Decompiled with CFR 0.152.
 */
package io.github.prospector.modmenu.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.prospector.modmenu.ModMenu;
import io.github.prospector.modmenu.config.ModMenuConfigManager;
import io.github.prospector.modmenu.gui.ModListEntry;
import io.github.prospector.modmenu.gui.ModsScreen;
import io.github.prospector.modmenu.gui.entries.ChildEntry;
import io.github.prospector.modmenu.gui.entries.IndependentEntry;
import io.github.prospector.modmenu.gui.entries.ParentEntry;
import io.github.prospector.modmenu.util.HardcodedUtil;
import io.github.prospector.modmenu.util.ModListSearch;
import io.github.prospector.modmenu.util.TestModContainer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_1043;
import net.minecraft.class_2588;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_310;
import net.minecraft.class_333;
import net.minecraft.class_350;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4280;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModListWidget
extends class_4280<ModListEntry>
implements AutoCloseable {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final boolean DEBUG = Boolean.getBoolean("modmenu.debug");
    private final Map<Path, class_1043> modIconsCache = new HashMap<Path, class_1043>();
    private final ModsScreen parent;
    private List<ModContainer> modContainerList = null;
    private Set<ModContainer> addedMods = new HashSet<ModContainer>();
    private String selectedModId = null;
    private boolean scrolling;

    public ModListWidget(class_310 client, int width, int height, int y1, int y2, int entryHeight, String searchTerm, ModListWidget list, ModsScreen parent) {
        super(client, width, height, y1, y2, entryHeight);
        this.parent = parent;
        if (list != null) {
            this.modContainerList = list.modContainerList;
        }
        this.filter(searchTerm, false);
        this.setScrollAmount(parent.getScrollPercent() * (double)Math.max(0, this.getMaxPosition() - (this.field_19086 - this.field_19085 - 4)));
    }

    public void setScrollAmount(double amount) {
        super.setScrollAmount(amount);
        int denominator = Math.max(0, this.getMaxPosition() - (this.field_19086 - this.field_19085 - 4));
        if (denominator <= 0) {
            this.parent.updateScrollPercent(0.0);
        } else {
            this.parent.updateScrollPercent(this.getScrollAmount() / (double)Math.max(0, this.getMaxPosition() - (this.field_19086 - this.field_19085 - 4)));
        }
    }

    protected boolean isFocused() {
        return this.parent.getFocused() == this;
    }

    public void select(ModListEntry entry) {
        this.setSelected(entry);
        if (entry != null) {
            ModMetadata metadata = entry.getMetadata();
            class_333.field_2054.method_19788(new class_2588("narrator.select", new Object[]{HardcodedUtil.formatFabricModuleName(metadata.getName())}).getString());
        }
    }

    public void setSelected(ModListEntry entry) {
        super.setSelected((class_350.class_351)entry);
        this.selectedModId = entry.getMetadata().getId();
        this.parent.updateSelectedEntry((ModListEntry)this.getSelected());
    }

    protected boolean isSelectedItem(int index) {
        ModListEntry selected = (ModListEntry)this.getSelected();
        return selected != null && selected.getMetadata().getId().equals(((ModListEntry)this.getEntry(index)).getMetadata().getId());
    }

    public int addEntry(ModListEntry entry) {
        if (this.addedMods.contains(entry.container)) {
            return 0;
        }
        this.addedMods.add(entry.container);
        int i = super.addEntry((class_350.class_351)entry);
        if (entry.getMetadata().getId().equals(this.selectedModId)) {
            this.setSelected(entry);
        }
        return i;
    }

    protected boolean removeEntry(ModListEntry entry) {
        this.addedMods.remove(entry.container);
        return super.removeEntry((class_350.class_351)entry);
    }

    protected ModListEntry remove(int index) {
        this.addedMods.remove(((ModListEntry)this.getEntry((int)index)).container);
        return (ModListEntry)super.remove(index);
    }

    public void reloadFilters() {
        this.filter(this.parent.getSearchInput(), true, false);
    }

    public void filter(String searchTerm, boolean refresh) {
        this.filter(searchTerm, refresh, true);
    }

    private void filter(String searchTerm, boolean refresh, boolean search) {
        this.clearEntries();
        this.addedMods.clear();
        ArrayList<ModContainer> mods = FabricLoader.getInstance().getAllMods();
        if (DEBUG) {
            mods = new ArrayList<ModContainer>(mods);
            mods.addAll(TestModContainer.getTestModContainers());
        }
        if (this.modContainerList == null || refresh) {
            this.modContainerList = new ArrayList<ModContainer>();
            this.modContainerList.addAll(mods);
            this.modContainerList.sort(ModMenuConfigManager.getConfig().getSorting().getComparator());
        }
        boolean validSearch = ModListSearch.validSearchQuery(searchTerm);
        List<ModContainer> matched = ModListSearch.search(this.parent, searchTerm, this.modContainerList);
        for (ModContainer container : matched) {
            ModMetadata metadata = container.getMetadata();
            String modId = metadata.getId();
            boolean library = ModMenu.LIBRARY_MODS.contains(modId);
            if (library && !ModMenuConfigManager.getConfig().showLibraries() || ModMenu.PARENT_MAP.values().contains(container)) continue;
            if (ModMenu.PARENT_MAP.keySet().contains(container)) {
                List children = ModMenu.PARENT_MAP.get((Object)container);
                children.sort(ModMenuConfigManager.getConfig().getSorting().getComparator());
                ParentEntry parent = new ParentEntry(container, children, this);
                this.addEntry(parent);
                if (!this.parent.showModChildren.contains(modId)) continue;
                List<ModContainer> validChildren = ModListSearch.search(this.parent, searchTerm, children);
                for (ModContainer child : validChildren) {
                    this.addEntry(new ChildEntry(child, parent, this, validChildren.indexOf(child) == validChildren.size() - 1));
                }
                continue;
            }
            this.addEntry(new IndependentEntry(container, this));
        }
        if (this.parent.getSelectedEntry() != null && !this.children().isEmpty() || this.getSelected() != null && ((ModListEntry)this.getSelected()).getMetadata() != this.parent.getSelectedEntry().getMetadata()) {
            for (ModListEntry entry : this.children()) {
                if (!entry.getMetadata().equals(this.parent.getSelectedEntry().getMetadata())) continue;
                this.setSelected(entry);
            }
        } else if (this.getSelected() == null && !this.children().isEmpty() && this.getEntry(0) != null) {
            this.setSelected((ModListEntry)this.getEntry(0));
        }
        if (this.getScrollAmount() > (double)Math.max(0, this.getMaxPosition() - (this.field_19086 - this.field_19085 - 4))) {
            this.setScrollAmount(Math.max(0, this.getMaxPosition() - (this.field_19086 - this.field_19085 - 4)));
        }
    }

    protected void renderList(int x, int y, int mouseX, int mouseY, float delta) {
        int itemCount = this.getItemCount();
        class_289 tessellator_1 = class_289.method_1348();
        class_287 buffer = tessellator_1.method_1349();
        for (int index = 0; index < itemCount; ++index) {
            int entryLeft;
            int entryTop = this.getRowTop(index) + 2;
            int entryBottom = this.getRowTop(index) + this.itemHeight;
            if (entryBottom < this.field_19085 || entryTop > this.field_19086) continue;
            int entryHeight = this.itemHeight - 4;
            ModListEntry entry = (ModListEntry)this.getEntry(index);
            int rowWidth = this.getRowWidth();
            if (this.renderSelection && this.isSelectedItem(index)) {
                entryLeft = this.getRowLeft() - 2 + entry.getXOffset();
                int selectionRight = x + rowWidth + 2;
                RenderSystem.disableTexture();
                float float_2 = this.isFocused() ? 1.0f : 0.5f;
                RenderSystem.color4f((float)float_2, (float)float_2, (float)float_2, (float)1.0f);
                buffer.method_1328(7, class_290.field_1592);
                buffer.method_22912((double)entryLeft, (double)(entryTop + entryHeight + 2), 0.0).method_1344();
                buffer.method_22912((double)selectionRight, (double)(entryTop + entryHeight + 2), 0.0).method_1344();
                buffer.method_22912((double)selectionRight, (double)(entryTop - 2), 0.0).method_1344();
                buffer.method_22912((double)entryLeft, (double)(entryTop - 2), 0.0).method_1344();
                tessellator_1.method_1350();
                RenderSystem.color4f((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                buffer.method_1328(7, class_290.field_1592);
                buffer.method_22912((double)(entryLeft + 1), (double)(entryTop + entryHeight + 1), 0.0).method_1344();
                buffer.method_22912((double)(selectionRight - 1), (double)(entryTop + entryHeight + 1), 0.0).method_1344();
                buffer.method_22912((double)(selectionRight - 1), (double)(entryTop - 1), 0.0).method_1344();
                buffer.method_22912((double)(entryLeft + 1), (double)(entryTop - 1), 0.0).method_1344();
                tessellator_1.method_1350();
                RenderSystem.enableTexture();
            }
            entryLeft = this.getRowLeft();
            entry.render(index, entryTop, entryLeft, rowWidth, entryHeight, mouseX, mouseY, this.isMouseOver(mouseX, mouseY) && Objects.equals((Object)this.getEntryAtPos(mouseX, mouseY), (Object)entry), delta);
        }
    }

    protected void updateScrollingState(double double_1, double double_2, int int_1) {
        super.updateScrollingState(double_1, double_2, int_1);
        this.scrolling = int_1 == 0 && double_1 >= (double)this.getScrollbarPosition() && double_1 < (double)(this.getScrollbarPosition() + 6);
    }

    public boolean mouseClicked(double double_1, double double_2, int int_1) {
        this.updateScrollingState(double_1, double_2, int_1);
        if (!this.isMouseOver(double_1, double_2)) {
            return false;
        }
        ModListEntry entry = this.getEntryAtPos(double_1, double_2);
        if (entry != null) {
            if (entry.mouseClicked(double_1, double_2, int_1)) {
                this.setFocused((class_364)entry);
                this.setDragging(true);
                return true;
            }
        } else if (int_1 == 0) {
            this.clickedHeader((int)(double_1 - (double)(this.field_19088 + this.width / 2 - this.getRowWidth() / 2)), (int)(double_2 - (double)this.field_19085) + (int)this.getScrollAmount() - 4);
            return true;
        }
        return this.scrolling;
    }

    public final ModListEntry getEntryAtPos(double x, double y) {
        int int_5 = class_3532.method_15357((double)(y - (double)this.field_19085)) - this.headerHeight + (int)this.getScrollAmount() - 4;
        int index = int_5 / this.itemHeight;
        return x < (double)this.getScrollbarPosition() && x >= (double)this.getRowLeft() && x <= (double)(this.getRowLeft() + this.getRowWidth()) && index >= 0 && int_5 >= 0 && index < this.getItemCount() ? (ModListEntry)((Object)this.children().get(index)) : null;
    }

    protected int getScrollbarPosition() {
        return this.width - 6;
    }

    public int getRowWidth() {
        return this.width - (Math.max(0, this.getMaxPosition() - (this.field_19086 - this.field_19085 - 4)) > 0 ? 18 : 12);
    }

    protected int getRowLeft() {
        return this.field_19088 + 6;
    }

    public int getWidth() {
        return this.width;
    }

    public int getTop() {
        return this.field_19085;
    }

    public ModsScreen getParent() {
        return this.parent;
    }

    protected int getMaxPosition() {
        return super.getMaxPosition() + 4;
    }

    public int getDisplayedCount() {
        return this.children().size();
    }

    public int getDisplayedCountFor(Set<String> set) {
        int count = 0;
        for (ModListEntry c : this.children()) {
            if (!set.contains(c.getMetadata().getId())) continue;
            ++count;
        }
        return count;
    }

    @Override
    public void close() {
        for (class_1043 tex : this.modIconsCache.values()) {
            tex.close();
        }
    }

    class_1043 getCachedModIcon(Path path) {
        return this.modIconsCache.get(path);
    }

    void cacheModIcon(Path path, class_1043 tex) {
        this.modIconsCache.put(path, tex);
    }

    public Set<ModContainer> getCurrentModSet() {
        return this.addedMods;
    }
}

