/*
 * Decompiled with CFR 0.152.
 */
package io.github.prospector.modmenu.gui;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import io.github.prospector.modmenu.ModMenu;
import io.github.prospector.modmenu.config.ModMenuConfigManager;
import io.github.prospector.modmenu.gui.DescriptionListWidget;
import io.github.prospector.modmenu.gui.ModListEntry;
import io.github.prospector.modmenu.gui.ModListWidget;
import io.github.prospector.modmenu.gui.ModMenuTexturedButtonWidget;
import io.github.prospector.modmenu.util.BadgeRenderer;
import io.github.prospector.modmenu.util.HardcodedUtil;
import io.github.prospector.modmenu.util.RenderUtils;
import java.io.File;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.fabricmc.loader.api.metadata.Person;
import net.minecraft.class_1074;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_407;
import net.minecraft.class_4185;
import net.minecraft.class_437;

public class ModsScreen
extends class_437 {
    private static final class_2960 FILTERS_BUTTON_LOCATION = new class_2960("modmenu", "textures/gui/filters_button.png");
    private static final class_2960 CONFIGURE_BUTTON_LOCATION = new class_2960("modmenu", "textures/gui/configure_button.png");
    private final String textTitle;
    private class_342 searchBox;
    private DescriptionListWidget descriptionListWidget;
    private class_437 parent;
    private ModListWidget modList;
    private String tooltip;
    private ModListEntry selected;
    private BadgeRenderer badgeRenderer;
    private double scrollPercent = 0.0;
    private boolean init = false;
    private boolean filterOptionsShown = false;
    private int paneY;
    private int paneWidth;
    private int rightPaneX;
    private int searchBoxX;
    private int filtersX;
    private int filtersWidth;
    private int searchRowWidth;
    public Set<String> showModChildren = new HashSet<String>();

    public ModsScreen(class_437 previousGui) {
        super((class_2561)new class_2588("modmenu.title", new Object[0]));
        this.parent = previousGui;
        this.textTitle = this.title.method_10863();
    }

    public boolean mouseScrolled(double double_1, double double_2, double double_3) {
        if (this.modList.isMouseOver(double_1, double_2)) {
            return this.modList.mouseScrolled(double_1, double_2, double_3);
        }
        if (this.descriptionListWidget.isMouseOver(double_1, double_2)) {
            return this.descriptionListWidget.mouseScrolled(double_1, double_2, double_3);
        }
        return false;
    }

    public void tick() {
        this.searchBox.method_1865();
    }

    protected void init() {
        Objects.requireNonNull(this.minecraft).field_1774.method_1462(true);
        this.paneY = 48;
        this.paneWidth = this.width / 2 - 8;
        this.rightPaneX = this.width - this.paneWidth;
        int searchBoxWidth = this.paneWidth - 32 - 22;
        this.searchBoxX = this.paneWidth / 2 - searchBoxWidth / 2 - 11;
        this.searchBox = new class_342(this.font, this.searchBoxX, 22, searchBoxWidth, 20, this.searchBox, class_1074.method_4662((String)"selectWorld.search", (Object[])new Object[0]));
        this.searchBox.method_1863(string_1 -> this.modList.filter((String)string_1, false));
        this.modList = new ModListWidget(this.minecraft, this.paneWidth, this.height, this.paneY + 19, this.height - 36, 36, this.searchBox.method_1882(), this.modList, this);
        this.modList.setLeftPos(0);
        this.font.getClass();
        this.descriptionListWidget = new DescriptionListWidget(this.minecraft, this.paneWidth, this.height, this.paneY + 60, this.height - 36, 9 + 1, this);
        this.descriptionListWidget.setLeftPos(this.rightPaneX);
        ModMenuTexturedButtonWidget configureButton = new ModMenuTexturedButtonWidget(this.width - 24, this.paneY, 20, 20, 0, 0, CONFIGURE_BUTTON_LOCATION, 32, 64, button -> {
            String modid = Objects.requireNonNull(this.selected).getMetadata().getId();
            class_437 screen = ModMenu.getConfigScreen(modid, this);
            if (screen != null) {
                this.minecraft.method_1507(screen);
            } else {
                ModMenu.openConfigScreen(modid);
            }
        }, class_1074.method_4662((String)"modmenu.configure", (Object[])new Object[0])){

            public void render(int mouseX, int mouseY, float delta) {
                String modid;
                if (this.isHovered()) {
                    ModsScreen.this.setTooltip(class_1074.method_4662((String)"modmenu.configure", (Object[])new Object[0]));
                }
                this.active = ModsScreen.this.selected != null ? ModMenu.hasConfigScreenFactory(modid = ModsScreen.this.selected.getMetadata().getId()) || ModMenu.hasLegacyConfigScreenTask(modid) : false;
                this.visible = this.active;
                super.render(mouseX, mouseY, delta);
            }

            @Override
            public void renderButton(int int_1, int int_2, float float_1) {
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                super.renderButton(int_1, int_2, float_1);
            }
        };
        int urlButtonWidths = this.paneWidth / 2 - 2;
        int cappedButtonWidth = Math.min(urlButtonWidths, 200);
        class_4185 websiteButton = new class_4185(this.rightPaneX + urlButtonWidths / 2 - cappedButtonWidth / 2, this.paneY + 36, Math.min(urlButtonWidths, 200), 20, class_1074.method_4662((String)"modmenu.website", (Object[])new Object[0]), button -> {
            ModMetadata metadata = Objects.requireNonNull(this.selected).getMetadata();
            this.minecraft.method_1507((class_437)new class_407(bool -> {
                if (bool) {
                    class_156.method_668().method_670((String)metadata.getContact().get("homepage").get());
                }
                this.minecraft.method_1507((class_437)this);
            }, (String)metadata.getContact().get("homepage").get(), true));
        }){

            public void render(int var1, int var2, float var3) {
                this.visible = ModsScreen.this.selected != null;
                this.active = this.visible && ModsScreen.this.selected.getMetadata().getContact().get("homepage").isPresent();
                super.render(var1, var2, var3);
            }
        };
        class_4185 issuesButton = new class_4185(this.rightPaneX + urlButtonWidths + 4 + urlButtonWidths / 2 - cappedButtonWidth / 2, this.paneY + 36, Math.min(urlButtonWidths, 200), 20, class_1074.method_4662((String)"modmenu.issues", (Object[])new Object[0]), button -> {
            ModMetadata metadata = Objects.requireNonNull(this.selected).getMetadata();
            this.minecraft.method_1507((class_437)new class_407(bool -> {
                if (bool) {
                    class_156.method_668().method_670((String)metadata.getContact().get("issues").get());
                }
                this.minecraft.method_1507((class_437)this);
            }, (String)metadata.getContact().get("issues").get(), true));
        }){

            public void render(int var1, int var2, float var3) {
                this.visible = ModsScreen.this.selected != null;
                this.active = this.visible && ModsScreen.this.selected.getMetadata().getContact().get("issues").isPresent();
                super.render(var1, var2, var3);
            }
        };
        this.children.add(this.searchBox);
        this.addButton((class_339)new ModMenuTexturedButtonWidget(this.paneWidth / 2 + searchBoxWidth / 2 - 10 + 2, 22, 20, 20, 0, 0, FILTERS_BUTTON_LOCATION, 32, 64, button -> {
            this.filterOptionsShown = !this.filterOptionsShown;
        }){

            public void render(int int_1, int int_2, float float_1) {
                super.render(int_1, int_2, float_1);
                if (this.isHovered()) {
                    ModsScreen.this.setTooltip(class_1074.method_4662((String)"modmenu.toggleFilterOptions", (Object[])new Object[0]));
                }
            }
        });
        String showLibrariesText = class_1074.method_4662((String)"modmenu.showLibraries", (Object[])new Object[]{class_1074.method_4662((String)("modmenu.showLibraries." + ModMenuConfigManager.getConfig().showLibraries()), (Object[])new Object[0])});
        String sortingText = class_1074.method_4662((String)"modmenu.sorting", (Object[])new Object[]{class_1074.method_4662((String)ModMenuConfigManager.getConfig().getSorting().getTranslationKey(), (Object[])new Object[0])});
        int showLibrariesWidth = this.font.method_1727(showLibrariesText) + 20;
        int sortingWidth = this.font.method_1727(sortingText) + 20;
        this.filtersWidth = showLibrariesWidth + sortingWidth + 2;
        this.searchRowWidth = this.searchBoxX + searchBoxWidth + 22;
        this.updateFiltersX();
        this.addButton((class_339)new class_4185(this.filtersX, 45, sortingWidth, 20, sortingText, button -> {
            ModMenuConfigManager.getConfig().toggleSortMode();
            this.modList.reloadFilters();
        }){

            public void render(int mouseX, int mouseY, float delta) {
                RenderSystem.translated((double)0.0, (double)0.0, (double)1.0);
                this.visible = ModsScreen.this.filterOptionsShown;
                this.setMessage(class_1074.method_4662((String)"modmenu.sorting", (Object[])new Object[]{class_1074.method_4662((String)ModMenuConfigManager.getConfig().getSorting().getTranslationKey(), (Object[])new Object[0])}));
                super.render(mouseX, mouseY, delta);
            }
        });
        this.addButton((class_339)new class_4185(this.filtersX + sortingWidth + 2, 45, showLibrariesWidth, 20, class_1074.method_4662((String)"modmenu.showLibraries", (Object[])new Object[]{class_1074.method_4662((String)("modmenu.showLibraries." + ModMenuConfigManager.getConfig().showLibraries()), (Object[])new Object[0])}), button -> {
            ModMenuConfigManager.getConfig().toggleShowLibraries();
            this.modList.reloadFilters();
        }){

            public void render(int mouseX, int mouseY, float delta) {
                RenderSystem.translated((double)0.0, (double)0.0, (double)1.0);
                this.visible = ModsScreen.this.filterOptionsShown;
                this.setMessage(class_1074.method_4662((String)"modmenu.showLibraries", (Object[])new Object[]{class_1074.method_4662((String)("modmenu.showLibraries." + ModMenuConfigManager.getConfig().showLibraries()), (Object[])new Object[0])}));
                super.render(mouseX, mouseY, delta);
            }
        });
        this.children.add(this.modList);
        this.addButton((class_339)configureButton);
        this.addButton((class_339)websiteButton);
        this.addButton((class_339)issuesButton);
        this.children.add(this.descriptionListWidget);
        this.addButton((class_339)new class_4185(this.width / 2 - 154, this.height - 28, 150, 20, class_1074.method_4662((String)"modmenu.modsFolder", (Object[])new Object[0]), button -> class_156.method_668().method_672(new File(FabricLoader.getInstance().getGameDirectory(), "mods"))));
        this.addButton((class_339)new class_4185(this.width / 2 + 4, this.height - 28, 150, 20, class_1074.method_4662((String)"gui.done", (Object[])new Object[0]), button -> this.minecraft.method_1507(this.parent)));
        this.method_20085((class_364)this.searchBox);
        this.init = true;
    }

    public boolean keyPressed(int int_1, int int_2, int int_3) {
        return super.keyPressed(int_1, int_2, int_3) || this.searchBox.keyPressed(int_1, int_2, int_3);
    }

    public boolean charTyped(char char_1, int int_1) {
        return this.searchBox.charTyped(char_1, int_1);
    }

    public void render(int mouseX, int mouseY, float delta) {
        ModsScreen.overlayBackground(this.paneWidth, 0, this.rightPaneX, this.height, 64, 64, 64, 255, 255);
        this.tooltip = null;
        ModListEntry selectedEntry = this.selected;
        if (selectedEntry != null) {
            this.descriptionListWidget.render(mouseX, mouseY, delta);
        }
        this.modList.render(mouseX, mouseY, delta);
        this.searchBox.render(mouseX, mouseY, delta);
        RenderSystem.disableBlend();
        this.drawCenteredString(this.font, this.textTitle, this.modList.getWidth() / 2, 8, 0xFFFFFF);
        super.render(mouseX, mouseY, delta);
        String fullModCount = this.computeModCountText(true);
        if (this.updateFiltersX()) {
            if (this.filterOptionsShown) {
                if (!ModMenuConfigManager.getConfig().showLibraries() || this.font.method_1727(fullModCount) <= this.filtersX - 5) {
                    this.font.method_1729(fullModCount, (float)this.searchBoxX, 52.0f, 0xFFFFFF);
                } else {
                    this.font.method_1729(this.computeModCountText(false), (float)this.searchBoxX, 46.0f, 0xFFFFFF);
                    this.font.method_1729(this.computeLibraryCountText(), (float)this.searchBoxX, 57.0f, 0xFFFFFF);
                }
            } else if (!ModMenuConfigManager.getConfig().showLibraries() || this.font.method_1727(fullModCount) <= this.modList.getWidth() - 5) {
                this.drawCenteredString(this.font, fullModCount, this.modList.getWidth() / 2, 52, 0xFFFFFF);
            } else {
                this.drawCenteredString(this.font, this.computeModCountText(false), this.modList.getWidth() / 2, 46, 0xFFFFFF);
                this.drawCenteredString(this.font, this.computeLibraryCountText(), this.modList.getWidth() / 2, 57, 0xFFFFFF);
            }
        }
        if (selectedEntry != null) {
            ModMetadata metadata = selectedEntry.getMetadata();
            int x = this.rightPaneX;
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.selected.bindIconTexture();
            RenderSystem.enableBlend();
            ModsScreen.blit((int)x, (int)this.paneY, (float)0.0f, (float)0.0f, (int)32, (int)32, (int)32, (int)32);
            RenderSystem.disableBlend();
            this.font.getClass();
            int lineSpacing = 9 + 1;
            int imageOffset = 36;
            String name = metadata.getName();
            String trimmedName = name = HardcodedUtil.formatFabricModuleName(name);
            int maxNameWidth = this.width - (x + imageOffset);
            if (this.font.method_1727(name) > maxNameWidth) {
                trimmedName = this.font.method_1714(name, maxNameWidth - this.font.method_1727("...")) + "...";
            }
            this.font.method_1729(trimmedName, (float)(x + imageOffset), (float)(this.paneY + 1), 0xFFFFFF);
            if (mouseX > x + imageOffset && mouseY > this.paneY + 1) {
                this.font.getClass();
                if (mouseY < this.paneY + 1 + 9 && mouseX < x + imageOffset + this.font.method_1727(trimmedName)) {
                    this.setTooltip(class_1074.method_4662((String)"modmenu.modIdToolTip", (Object[])new Object[]{metadata.getId()}));
                }
            }
            if (this.init || this.badgeRenderer == null || this.badgeRenderer.getMetadata() != metadata) {
                this.badgeRenderer = new BadgeRenderer(x + imageOffset + Objects.requireNonNull(this.minecraft).field_1772.method_1727(trimmedName) + 2, this.paneY, this.width - 28, selectedEntry.container, this);
                this.init = false;
            }
            this.badgeRenderer.draw(mouseX, mouseY);
            this.font.method_1729("v" + metadata.getVersion().getFriendlyString(), (float)(x + imageOffset), (float)(this.paneY + 2 + lineSpacing), 0x808080);
            ArrayList names = new ArrayList();
            metadata.getAuthors().stream().filter(Objects::nonNull).map(Person::getName).filter(Objects::nonNull).forEach(names::add);
            if (!names.isEmpty()) {
                String authors = names.size() > 1 ? Joiner.on((String)", ").join(names) : (String)names.get(0);
                RenderUtils.drawWrappedString(class_1074.method_4662((String)"modmenu.authorPrefix", (Object[])new Object[]{authors}), x + imageOffset, this.paneY + 2 + lineSpacing * 2, this.paneWidth - imageOffset - 4, 1, 0x808080);
            }
            if (this.tooltip != null) {
                this.renderTooltip(Lists.newArrayList((Iterable)Splitter.on((String)"\n").split((CharSequence)this.tooltip)), mouseX, mouseY);
            }
        }
    }

    private String computeModCountText(boolean includeLibs) {
        int[] rootMods = this.formatModCount(ModMenu.ROOT_NONLIB_MODS);
        if (includeLibs && ModMenuConfigManager.getConfig().showLibraries()) {
            int[] rootLibs = this.formatModCount(ModMenu.ROOT_LIBRARIES);
            return ModsScreen.translateNumeric("modmenu.showingModsLibraries", rootMods, rootLibs);
        }
        return ModsScreen.translateNumeric("modmenu.showingMods", new int[][]{rootMods});
    }

    private String computeLibraryCountText() {
        if (ModMenuConfigManager.getConfig().showLibraries()) {
            int[] rootLibs = this.formatModCount(ModMenu.ROOT_LIBRARIES);
            return ModsScreen.translateNumeric("modmenu.showingLibraries", new int[][]{rootLibs});
        }
        return null;
    }

    private static String translateNumeric(String key, int[] ... args) {
        Object[] realArgs = new Object[args.length];
        for (int i = 0; i < args.length; ++i) {
            NumberFormat nf = NumberFormat.getInstance();
            if (args[i].length == 1) {
                realArgs[i] = nf.format(args[i][0]);
                continue;
            }
            assert (args[i].length == 2);
            realArgs[i] = nf.format(args[i][0]) + "/" + nf.format(args[i][1]);
        }
        int[] override = new int[args.length];
        Arrays.fill(override, -1);
        for (int i = 0; i < args.length; ++i) {
            int[] arg = args[i];
            if (arg == null) {
                throw new NullPointerException("args[" + i + "]");
            }
            if (arg.length != 1) continue;
            override[i] = arg[0];
        }
        String lastKey = key;
        for (int flags = (1 << args.length) - 1; flags >= 0; --flags) {
            StringBuilder fullKey = new StringBuilder(key);
            for (int i = 0; i < args.length; ++i) {
                fullKey.append('.');
                if ((flags & 1 << i) != 0 && override[i] != -1) {
                    fullKey.append(override[i]);
                    continue;
                }
                fullKey.append('a');
            }
            lastKey = fullKey.toString();
            if (!class_1074.method_4663((String)lastKey)) continue;
            return class_1074.method_4662((String)lastKey, (Object[])realArgs);
        }
        return class_1074.method_4662((String)lastKey, (Object[])realArgs);
    }

    private int[] formatModCount(Set<String> set) {
        int total;
        int visible = this.modList.getDisplayedCountFor(set);
        if (visible == (total = set.size())) {
            return new int[]{total};
        }
        return new int[]{visible, total};
    }

    static void overlayBackground(int x1, int y1, int x2, int y2, int red, int green, int blue, int startAlpha, int endAlpha) {
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_1349();
        Objects.requireNonNull(class_310.method_1551()).method_1531().method_22813(class_332.BACKGROUND_LOCATION);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        buffer.method_1328(7, class_290.field_1575);
        buffer.method_22912((double)x1, (double)y2, 0.0).method_22913((float)x1 / 32.0f, (float)y2 / 32.0f).method_1336(red, green, blue, endAlpha).method_1344();
        buffer.method_22912((double)x2, (double)y2, 0.0).method_22913((float)x2 / 32.0f, (float)y2 / 32.0f).method_1336(red, green, blue, endAlpha).method_1344();
        buffer.method_22912((double)x2, (double)y1, 0.0).method_22913((float)x2 / 32.0f, (float)y1 / 32.0f).method_1336(red, green, blue, startAlpha).method_1344();
        buffer.method_22912((double)x1, (double)y1, 0.0).method_22913((float)x1 / 32.0f, (float)y1 / 32.0f).method_1336(red, green, blue, startAlpha).method_1344();
        tessellator.method_1350();
    }

    public void onClose() {
        super.onClose();
        this.modList.close();
    }

    private void setTooltip(String tooltip) {
        this.tooltip = tooltip;
    }

    ModListEntry getSelectedEntry() {
        return this.selected;
    }

    void updateSelectedEntry(ModListEntry entry) {
        if (entry != null) {
            this.selected = entry;
        }
    }

    double getScrollPercent() {
        return this.scrollPercent;
    }

    void updateScrollPercent(double scrollPercent) {
        this.scrollPercent = scrollPercent;
    }

    public String getSearchInput() {
        return this.searchBox.method_1882();
    }

    private boolean updateFiltersX() {
        if (this.filtersWidth + this.font.method_1727(this.computeModCountText(true)) + 20 >= this.searchRowWidth && (this.filtersWidth + this.font.method_1727(this.computeModCountText(false)) + 20 >= this.searchRowWidth || this.filtersWidth + this.font.method_1727(this.computeLibraryCountText()) + 20 >= this.searchRowWidth)) {
            this.filtersX = this.paneWidth / 2 - this.filtersWidth / 2;
            return !this.filterOptionsShown;
        }
        this.filtersX = this.searchRowWidth - this.filtersWidth + 1;
        return true;
    }
}

