/*
 * Decompiled with CFR 0.152.
 */
package com.misterpemodder.shulkerboxtooltip.api.provider;

import com.misterpemodder.shulkerboxtooltip.api.provider.PreviewProvider;
import com.misterpemodder.shulkerboxtooltip.impl.ShulkerBoxTooltip;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2585;
import net.minecraft.class_2588;

public class BlockEntityPreviewProvider
implements PreviewProvider {
    protected final int maxInvSize;
    protected final boolean canUseLootTables;

    public BlockEntityPreviewProvider(int maxInvSize, boolean canUseLootTables) {
        this.maxInvSize = maxInvSize;
        this.canUseLootTables = canUseLootTables;
    }

    @Override
    public boolean shouldDisplay(class_1799 stack) {
        class_2487 blockEntityTag = stack.method_7941("BlockEntityTag");
        if (blockEntityTag == null || this.canUseLootTables && blockEntityTag.method_10573("LootTable", 8) || !blockEntityTag.method_10573("Items", 9)) {
            return false;
        }
        return !blockEntityTag.method_10554("Items", 10).isEmpty();
    }

    @Override
    public boolean showTooltipHints(class_1799 stack) {
        return stack.method_7941("BlockEntityTag") != null;
    }

    @Override
    public List<class_1799> getInventory(class_1799 stack) {
        class_2499 itemList;
        class_2371 inv = class_2371.method_10213((int)this.maxInvSize, (Object)class_1799.field_8037);
        class_2487 blockEntityTag = stack.method_7941("BlockEntityTag");
        if (blockEntityTag != null && blockEntityTag.method_10573("Items", 9) && (itemList = blockEntityTag.method_10554("Items", 10)) != null) {
            int len = itemList.size();
            for (int i = 0; i < len; ++i) {
                byte slot;
                class_2487 itemTag = itemList.method_10602(i);
                class_1799 s = class_1799.method_7915((class_2487)itemTag);
                if (!itemTag.method_10573("Slot", 1) || (slot = itemTag.method_10571("Slot")) >= this.maxInvSize) continue;
                inv.set(slot, s);
            }
        }
        return inv;
    }

    @Override
    public int getInventoryMaxSize(class_1799 stack) {
        return this.maxInvSize;
    }

    @Override
    public List<class_2561> addTooltip(class_1799 stack) {
        class_2487 blockEntityTag;
        class_2487 compound = stack.method_7969();
        class_2583 style = new class_2583().method_10977(class_124.field_1080);
        if (this.canUseLootTables && compound != null && compound.method_10573("BlockEntityTag", 10) && (blockEntityTag = compound.method_10562("BlockEntityTag")) != null && blockEntityTag.method_10573("LootTable", 8)) {
            switch (ShulkerBoxTooltip.config.main.lootTableInfoType) {
                case HIDE: {
                    return Collections.singletonList(new class_2585("???????").method_10862(style));
                }
                case SIMPLE: {
                    return Collections.singletonList(new class_2588("shulkerboxtooltip.hint.lootTable", new Object[0]).method_10862(style));
                }
            }
            return Arrays.asList(new class_2588("shulkerboxtooltip.hint.lootTable.advanced", new Object[0]).method_10864(": "), new class_2585(" " + blockEntityTag.method_10558("LootTable")).method_10862(style));
        }
        List<class_1799> inventory = this.getInventory(stack);
        if (inventory != null) {
            int item_count = 0;
            for (class_1799 s : inventory) {
                if (s.method_7909() == class_1802.field_8162) continue;
                ++item_count;
            }
            if (item_count > 0) {
                return Collections.singletonList(new class_2588("container.shulkerbox.contains", new Object[]{item_count}).method_10862(style));
            }
        }
        return Collections.singletonList(new class_2588("container.shulkerbox.empty", new Object[0]).method_10862(style));
    }
}

