/*
 * Decompiled with CFR 0.152.
 */
package com.misterpemodder.shulkerboxtooltip.impl;

import com.misterpemodder.shulkerboxtooltip.api.PreviewType;
import com.misterpemodder.shulkerboxtooltip.api.provider.EmptyPreviewProvider;
import com.misterpemodder.shulkerboxtooltip.api.provider.PreviewProvider;
import com.misterpemodder.shulkerboxtooltip.api.renderer.PreviewRenderer;
import com.misterpemodder.shulkerboxtooltip.impl.ShulkerBoxTooltip;
import com.misterpemodder.shulkerboxtooltip.impl.config.Configuration;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2371;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4493;
import net.minecraft.class_918;

@Environment(value=EnvType.CLIENT)
public class DefaultPreviewRenderer
implements PreviewRenderer {
    private static final class_2960 TEXTURE = new class_2960("shulkerboxtooltip", "textures/gui/shulker_box_tooltip.png");
    public static final DefaultPreviewRenderer INSTANCE = new DefaultPreviewRenderer();
    private class_310 client = class_310.method_1551();
    private class_327 textRenderer;
    private class_918 itemRenderer;
    private final List<ItemStackCompactor> items;
    private class_1799 previewStack;
    private PreviewType previewType;
    private PreviewProvider provider;
    private int maxRowSize;

    private DefaultPreviewRenderer() {
        this.textRenderer = this.client.field_1772;
        this.itemRenderer = this.client.method_1480();
        this.items = new ArrayList<ItemStackCompactor>();
        this.previewType = PreviewType.FULL;
        this.maxRowSize = 9;
        this.setPreview(new class_1799((class_1935)class_1802.field_8162), EmptyPreviewProvider.INSTANCE);
    }

    @Override
    public void setPreview(class_1799 stack, PreviewProvider provider) {
        List<class_1799> inventory = provider.getInventory(stack);
        boolean ignoreData = ShulkerBoxTooltip.config.main.compactPreviewTagBehavior != Configuration.CompactPreviewTagBehavior.SEPARATE;
        this.provider = provider;
        int rowSize = provider.getMaxRowSize(stack);
        this.maxRowSize = provider.getMaxRowSize(stack);
        if (rowSize == 0) {
            rowSize = ShulkerBoxTooltip.config.main.defaultMaxRowSize;
        }
        this.maxRowSize = rowSize <= 0 ? 9 : rowSize;
        this.items.clear();
        if (!inventory.isEmpty()) {
            HashMap<ItemKey, ItemStackCompactor> compactors = new HashMap<ItemKey, ItemStackCompactor>();
            int len = inventory.size();
            for (int i = 0; i < len; ++i) {
                class_1799 s = inventory.get(i);
                if (s == class_1799.field_8037) continue;
                ItemKey k = new ItemKey(s, ignoreData);
                ItemStackCompactor compactor = (ItemStackCompactor)compactors.get(k);
                if (compactor == null) {
                    compactor = new ItemStackCompactor(provider.getInventoryMaxSize(stack));
                    compactors.put(k, compactor);
                }
                compactor.add(s, i);
            }
            this.items.addAll(compactors.values());
            this.items.sort(Comparator.reverseOrder());
        }
        this.previewStack = stack.method_7972();
    }

    @Override
    public void setPreviewType(PreviewType type) {
        this.previewType = type;
    }

    @Override
    public int getWidth() {
        return 14 + Math.min(this.maxRowSize, this.getInvSize()) * 18;
    }

    @Override
    public int getHeight() {
        return 14 + (int)Math.ceil((double)this.getInvSize() / (double)this.maxRowSize) * 18;
    }

    public void blitZOffset(class_287 builder, int x, int y, int u, int v, int w, int h, double zOffset) {
        builder.method_22912((double)x, (double)(y + h), zOffset).method_22913((float)u * 0.00390625f, (float)(v + h) * 0.00390625f).method_1344();
        builder.method_22912((double)(x + w), (double)(y + h), zOffset).method_22913((float)(u + w) * 0.00390625f, (float)(v + h) * 0.00390625f).method_1344();
        builder.method_22912((double)(x + w), (double)y, zOffset).method_22913((float)(u + w) * 0.00390625f, (float)(v + 0) * 0.00390625f).method_1344();
        builder.method_22912((double)x, (double)y, zOffset).method_22913((float)u * 0.00390625f, (float)v * 0.00390625f).method_1344();
    }

    private int getInvSize() {
        return this.previewType == PreviewType.COMPACT ? Math.max(1, this.items.size()) : this.provider.getInventoryMaxSize(this.previewStack);
    }

    private void drawBackground(int x, int y) {
        int s;
        float[] color;
        if (ShulkerBoxTooltip.config.main.coloredPreview) {
            color = this.provider.getWindowColor(this.previewStack);
            if (color == null || color.length < 3) {
                color = PreviewProvider.DEFAULT_COLOR;
            }
        } else {
            color = PreviewProvider.DEFAULT_COLOR;
        }
        class_4493.method_22000((float)color[0], (float)color[1], (float)color[2], (float)1.0f);
        this.client.method_1531().method_22813(TEXTURE);
        class_308.method_1450();
        class_287 builder = class_289.method_1348().method_1349();
        builder.method_1328(7, class_290.field_1585);
        double zOffset = 800.0;
        int invSize = this.getInvSize();
        int xOffset = 7;
        int yOffset = 7;
        int rowSize = Math.min(this.maxRowSize, invSize);
        int rowWidth = rowSize * 18;
        this.blitZOffset(builder, x, y, 0, 0, 7, 7, 800.0);
        for (int size = rowSize; size > 0; size -= 9) {
            int s2 = Math.min(size, 9);
            this.blitZOffset(builder, x + xOffset, y, 7, 0, s2 * 18, 7, 800.0);
            xOffset += s2 * 18;
        }
        this.blitZOffset(builder, x + rowWidth + 7, y, 169, 0, 7, 7, 800.0);
        int rowTexYPos = 7;
        while (invSize > 0) {
            xOffset = 7;
            this.blitZOffset(builder, x, y + yOffset, 0, rowTexYPos, 7, 18, 800.0);
            for (int rSize = rowSize; rSize > 0; rSize -= 9) {
                s = Math.min(rSize, 9);
                this.blitZOffset(builder, x + xOffset, y + yOffset, 7, rowTexYPos, s * 18, 18, 800.0);
                xOffset += s * 18;
            }
            this.blitZOffset(builder, x + xOffset, y + yOffset, 169, rowTexYPos, 7, 18, 800.0);
            yOffset += 18;
            invSize -= rowSize;
            rowTexYPos = rowTexYPos >= 43 ? 7 : rowTexYPos + 18;
        }
        xOffset = 7;
        this.blitZOffset(builder, x, y + yOffset, 0, 61, 7, 7, 800.0);
        for (int size = rowSize; size > 0; size -= 9) {
            s = Math.min(size, 9);
            this.blitZOffset(builder, x + xOffset, y + yOffset, 7, 61, s * 18, 7, 800.0);
            xOffset += s * 18;
        }
        this.blitZOffset(builder, x + rowWidth + 7, y + yOffset, 169, 61, 7, 7, 800.0);
        builder.method_1326();
        RenderSystem.enableAlphaTest();
        class_286.method_1309((class_287)builder);
        class_308.method_22890();
    }

    @Override
    public void draw(int x, int y) {
        if (this.items.isEmpty() || this.previewType == PreviewType.NO_PREVIEW) {
            return;
        }
        this.drawBackground(x, y);
        this.itemRenderer.field_4730 = 700.0f;
        if (this.previewType == PreviewType.COMPACT) {
            int s = this.items.size();
            for (int i = 0; i < s; ++i) {
                ItemStackCompactor compactor = this.items.get(i);
                int xOffset = 8 + x + 18 * (i % this.maxRowSize);
                int yOffset = 8 + y + 18 * (i / this.maxRowSize);
                class_1799 stack = compactor.getMerged();
                this.itemRenderer.method_4026((class_1309)this.client.field_1724, stack, xOffset, yOffset);
                this.itemRenderer.method_4025(this.textRenderer, stack, xOffset, yOffset);
            }
        } else {
            for (ItemStackCompactor compactor : this.items) {
                int size = compactor.size();
                for (int i = 0; i < size; ++i) {
                    int xOffset = 8 + x + 18 * (i % this.maxRowSize);
                    int yOffset = 8 + y + 18 * (i / this.maxRowSize);
                    class_1799 stack = compactor.get(i);
                    this.itemRenderer.method_4026((class_1309)this.client.field_1724, stack, xOffset, yOffset);
                    this.itemRenderer.method_4025(this.textRenderer, stack, xOffset, yOffset);
                }
            }
        }
        this.itemRenderer.field_4730 = 0.0f;
    }

    private class ItemKey {
        private final class_1792 item;
        private final int id;
        private final class_2487 data;
        private final boolean ignoreData;

        public ItemKey(class_1799 stack, boolean ignoreData) {
            this.item = stack.method_7909();
            this.id = class_2378.field_11142.method_10249((Object)this.item);
            this.data = stack.method_7969();
            this.ignoreData = ignoreData;
        }

        public int hashCode() {
            return 31 * this.id + (this.ignoreData || this.data == null ? 0 : this.data.hashCode());
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ItemKey)) {
                return false;
            }
            ItemKey key = (ItemKey)other;
            return key.item == this.item && key.id == this.id && (this.ignoreData || Objects.equals(key.data, this.data));
        }
    }

    protected static class ItemStackCompactor
    implements Comparable<ItemStackCompactor> {
        private class_1799 merged = class_1799.field_8037;
        private class_2371<class_1799> subItems;
        private int firstSlot;

        public ItemStackCompactor(int slotCount) {
            this.subItems = class_2371.method_10213((int)slotCount, (Object)class_1799.field_8037);
            this.firstSlot = Integer.MAX_VALUE;
        }

        public class_1799 getMerged() {
            return this.merged;
        }

        public void add(class_1799 stack, int slot) {
            if (slot < 0 || slot >= this.subItems.size()) {
                return;
            }
            this.subItems.set(slot, (Object)stack);
            if (slot < this.firstSlot) {
                this.firstSlot = slot;
            }
            if (this.merged == class_1799.field_8037) {
                this.merged = stack.method_7972();
                if (ShulkerBoxTooltip.config.main.compactPreviewTagBehavior == Configuration.CompactPreviewTagBehavior.IGNORE) {
                    this.merged.method_7980(null);
                }
            } else {
                this.merged.method_7933(stack.method_7947());
            }
        }

        public class_1799 get(int slot) {
            return (class_1799)this.subItems.get(slot);
        }

        public int size() {
            return this.subItems.size();
        }

        @Override
        public int compareTo(ItemStackCompactor other) {
            int ret = this.merged.method_7947() - other.merged.method_7947();
            if (ret != 0) {
                return ret;
            }
            return other.firstSlot - this.firstSlot;
        }
    }
}

