/*
 * Decompiled with CFR 0.152.
 */
package com.misterpemodder.shulkerboxtooltip.impl;

import com.misterpemodder.shulkerboxtooltip.api.PreviewType;
import com.misterpemodder.shulkerboxtooltip.api.ShulkerBoxTooltipApi;
import com.misterpemodder.shulkerboxtooltip.api.provider.BlockEntityPreviewProvider;
import com.misterpemodder.shulkerboxtooltip.api.provider.PreviewProvider;
import com.misterpemodder.shulkerboxtooltip.api.renderer.PreviewRenderer;
import com.misterpemodder.shulkerboxtooltip.impl.config.Configuration;
import com.misterpemodder.shulkerboxtooltip.impl.hook.ShulkerPreviewPosGetter;
import com.misterpemodder.shulkerboxtooltip.impl.provider.FurnacePreviewProvider;
import com.misterpemodder.shulkerboxtooltip.impl.provider.ShulkerBoxPreviewProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_437;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Environment(value=EnvType.CLIENT)
public final class ShulkerBoxTooltip
implements ClientModInitializer,
ShulkerBoxTooltipApi {
    public static Configuration config;
    public static String MOD_ID;
    public static final Logger LOGGER;
    private static Map<class_1792, PreviewProvider> previewItems;

    public void onInitializeClient() {
        config = Configuration.register();
    }

    @Override
    public String getModId() {
        return MOD_ID;
    }

    @Override
    public void registerProviders(Map<PreviewProvider, List<class_1792>> providers) {
        providers.put(new ShulkerBoxPreviewProvider(), (List<class_1792>)class_156.method_654(new ArrayList(), items -> {
            items.add(class_1802.field_8545);
            items.add(class_1802.field_8722);
            items.add(class_1802.field_8380);
            items.add(class_1802.field_8050);
            items.add(class_1802.field_8829);
            items.add(class_1802.field_8271);
            items.add(class_1802.field_8548);
            items.add(class_1802.field_8520);
            items.add(class_1802.field_8627);
            items.add(class_1802.field_8451);
            items.add(class_1802.field_8213);
            items.add(class_1802.field_8816);
            items.add(class_1802.field_8350);
            items.add(class_1802.field_8584);
            items.add(class_1802.field_8461);
            items.add(class_1802.field_8676);
            items.add(class_1802.field_8268);
        }));
        providers.put(new BlockEntityPreviewProvider(27, true), Arrays.asList(class_1802.field_8106, class_1802.field_8247, class_1802.field_16307));
        providers.put(new FurnacePreviewProvider(), Arrays.asList(class_1802.field_8732, class_1802.field_16306, class_1802.field_16309));
        providers.put(new BlockEntityPreviewProvider(9, true), Arrays.asList(class_1802.field_8357, class_1802.field_8878));
        providers.put(new BlockEntityPreviewProvider(5, true), Collections.singletonList(class_1802.field_8239));
        providers.put(new BlockEntityPreviewProvider(5, false), Collections.singletonList(class_1802.field_8740));
    }

    private static boolean shouldDisplayPreview() {
        return ShulkerBoxTooltip.config.main.alwaysOn || class_437.hasShiftDown();
    }

    @Nullable
    public static class_2561 getTooltipHint(class_1799 stack, PreviewProvider provider) {
        String keyHint;
        boolean shouldDisplay = ShulkerBoxTooltip.shouldDisplayPreview();
        if (!ShulkerBoxTooltip.config.main.enablePreview || !provider.shouldDisplay(stack) || shouldDisplay && class_437.hasAltDown()) {
            return null;
        }
        boolean fullPreviewAvailable = provider.isFullPreviewAvailable(stack);
        if (!fullPreviewAvailable && shouldDisplay) {
            return null;
        }
        String string = shouldDisplay ? (ShulkerBoxTooltip.config.main.alwaysOn ? "Alt" : "Alt+Shift") : (keyHint = "Shift");
        String contentHint = ShulkerBoxTooltip.getCurrentPreviewType(fullPreviewAvailable) == PreviewType.NO_PREVIEW ? (ShulkerBoxTooltip.config.main.swapModes ? provider.getFullTooltipHintLangKey(stack) : provider.getTooltipHintLangKey(stack)) : (ShulkerBoxTooltip.config.main.swapModes ? provider.getTooltipHintLangKey(stack) : provider.getFullTooltipHintLangKey(stack));
        return new class_2585(keyHint + ": ").method_10862(new class_2583().method_10977(class_124.field_1065)).method_10852(new class_2588(contentHint, new Object[0]).method_10862(new class_2583().method_10977(class_124.field_1068)));
    }

    public static PreviewType getCurrentPreviewType(boolean hasFullPreviewMode) {
        boolean shouldDisplay = ShulkerBoxTooltip.shouldDisplayPreview();
        if (shouldDisplay && !hasFullPreviewMode) {
            return PreviewType.COMPACT;
        }
        if (ShulkerBoxTooltip.config.main.swapModes) {
            if (shouldDisplay) {
                return class_437.hasAltDown() ? PreviewType.COMPACT : PreviewType.FULL;
            }
        } else if (shouldDisplay) {
            return class_437.hasAltDown() ? PreviewType.FULL : PreviewType.COMPACT;
        }
        return PreviewType.NO_PREVIEW;
    }

    public static boolean hasShulkerBoxPreview(class_1799 stack) {
        if (ShulkerBoxTooltip.config.main.enablePreview) {
            PreviewProvider provider = ShulkerBoxTooltip.getPreviewProviderForStack(stack);
            return provider != null && provider.shouldDisplay(stack) && ShulkerBoxTooltip.getCurrentPreviewType(provider.isFullPreviewAvailable(stack)) != PreviewType.NO_PREVIEW;
        }
        return false;
    }

    public static void initPreviewItemsMap() {
        if (previewItems == null) {
            previewItems = ShulkerBoxTooltip.buildPreviewItemsMap();
        }
    }

    private static Map<class_1792, PreviewProvider> buildPreviewItemsMap() {
        HashMap<class_1792, PreviewProvider> previewItems = new HashMap<class_1792, PreviewProvider>();
        List apiImpls = FabricLoader.getInstance().getEntrypoints(MOD_ID, ShulkerBoxTooltipApi.class);
        HashMap<PreviewProvider, List<class_1792>> providers = new HashMap<PreviewProvider, List<class_1792>>();
        for (ShulkerBoxTooltipApi impl : apiImpls) {
            impl.registerProviders(providers);
            for (Map.Entry entry : providers.entrySet()) {
                for (class_1792 item : (List)entry.getValue()) {
                    previewItems.put(item, (PreviewProvider)entry.getKey());
                }
            }
            providers.clear();
        }
        return previewItems;
    }

    @Nullable
    public static PreviewProvider getPreviewProviderForStack(class_1799 stack) {
        return previewItems == null ? null : previewItems.get(stack.method_7909());
    }

    public static void drawShulkerBoxPreview(class_437 screen, class_1799 stack, int mouseX, int mouseY) {
        PreviewProvider provider = ShulkerBoxTooltip.getPreviewProviderForStack(stack);
        if (provider == null) {
            return;
        }
        PreviewRenderer renderer = provider.getRenderer();
        if (renderer == null) {
            renderer = PreviewRenderer.getDefaultRendererInstance();
        }
        renderer.setPreview(stack, provider);
        renderer.setPreviewType(ShulkerBoxTooltip.getCurrentPreviewType(provider.isFullPreviewAvailable(stack)));
        int x = Math.min(((ShulkerPreviewPosGetter)screen).shulkerboxtooltip$getStartX() - 1, screen.width - renderer.getWidth());
        int y = ((ShulkerPreviewPosGetter)screen).shulkerboxtooltip$getBottomY() + 1;
        int h = renderer.getHeight();
        if (ShulkerBoxTooltip.config.main.lockPreview || y + h > screen.height) {
            y = ((ShulkerPreviewPosGetter)screen).shulkerboxtooltip$getTopY() - h;
        }
        renderer.draw(x, y);
    }

    public static void modifyStackTooltip(class_1799 stack, List<class_2561> tooltip) {
        PreviewProvider provider = ShulkerBoxTooltip.getPreviewProviderForStack(stack);
        if (provider != null && provider.showTooltipHints(stack)) {
            class_2561 hint;
            if (ShulkerBoxTooltip.config.main.tooltipType == Configuration.ShulkerBoxTooltipType.MOD) {
                tooltip.addAll(provider.addTooltip(stack));
            }
            if ((hint = ShulkerBoxTooltip.getTooltipHint(stack, provider)) != null) {
                tooltip.add(hint);
            }
        }
    }

    static {
        MOD_ID = "shulkerboxtooltip";
        LOGGER = LogManager.getLogger((String)"ShulkerBoxTooltip");
        previewItems = null;
    }
}

