/*
 * Decompiled with CFR 0.152.
 */
package com.misterpemodder.shulkerboxtooltip.impl.config;

import com.misterpemodder.shulkerboxtooltip.impl.config.AutoTooltip;
import com.misterpemodder.shulkerboxtooltip.impl.config.Validator;
import java.lang.reflect.Constructor;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import me.sargunvohra.mcmods.autoconfig1u.AutoConfig;
import me.sargunvohra.mcmods.autoconfig1u.ConfigData;
import me.sargunvohra.mcmods.autoconfig1u.annotation.Config;
import me.sargunvohra.mcmods.autoconfig1u.annotation.ConfigEntry;
import me.sargunvohra.mcmods.autoconfig1u.gui.registry.GuiRegistry;
import me.sargunvohra.mcmods.autoconfig1u.serializer.GsonConfigSerializer;
import me.shedaniel.clothconfig2.gui.entries.SelectionListEntry;
import me.shedaniel.clothconfig2.gui.entries.TooltipListEntry;
import net.minecraft.class_2477;

@Config(name="shulkerboxtooltip")
@Config.Gui.Background(value="minecraft:textures/block/purpur_block.png")
public class Configuration
implements ConfigData {
    @ConfigEntry.Category(value="main")
    @ConfigEntry.Gui.TransitiveObject
    public MainCategory main = new MainCategory();

    public static Configuration register() {
        AutoConfig.register(Configuration.class, GsonConfigSerializer::new);
        GuiRegistry registry = AutoConfig.getGuiRegistry(Configuration.class);
        registry.registerAnnotationTransformer((guis, i13n, field, config, defaults, guiProvider) -> guis.stream().peek(gui -> {
            if (gui instanceof TooltipListEntry) {
                String key = i13n + ".tooltip";
                ((TooltipListEntry)gui).setTooltipSupplier(() -> Optional.of(class_2477.method_10517().method_10520(key).split("\n")));
            }
        }).collect(Collectors.toList()), new Class[]{AutoTooltip.class});
        registry.registerAnnotationTransformer((guis, i13n, field, config, defaults, guiProvider) -> guis.stream().peek(gui -> {
            try {
                Constructor<? extends Function<Object, Optional<String>>> constructor = field.getAnnotation(Validator.class).value().getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                Function<Object, Optional<String>> validator = constructor.newInstance(new Object[0]);
                gui.setErrorSupplier(() -> (Optional)validator.apply(gui.getValue()));
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException("Couldn't create config validator", e);
            }
        }).collect(Collectors.toList()), new Class[]{Validator.class});
        return (Configuration)AutoConfig.getConfigHolder(Configuration.class).getConfig();
    }

    private static class GreaterThanZero
    implements Function<Object, Optional<String>> {
        private GreaterThanZero() {
        }

        @Override
        public Optional<String> apply(Object value) {
            Class<?> valueClass = value.getClass();
            if (valueClass.equals(Integer.class) && (Integer)value <= 0) {
                return Optional.of(class_2477.method_10517().method_10520("shulkerboxtooltip.config.validator.greater_than_zero"));
            }
            return Optional.empty();
        }
    }

    public static enum LootTableInfoType implements SelectionListEntry.Translatable
    {
        HIDE,
        SIMPLE,
        ADVANCED;


        public String getKey() {
            return "shulkerboxtooltip.lootTableInfoType." + this.name().toLowerCase();
        }
    }

    public static enum CompactPreviewTagBehavior implements SelectionListEntry.Translatable
    {
        IGNORE,
        FIRST_ITEM,
        SEPARATE;


        public String getKey() {
            return "shulkerboxtooltip.compactPreviewTagBehavior." + this.name().toLowerCase();
        }
    }

    public static enum ShulkerBoxTooltipType implements SelectionListEntry.Translatable
    {
        VANILLA,
        MOD,
        NONE;


        public String getKey() {
            return "shulkerboxtooltip.tooltipType." + this.name().toLowerCase();
        }
    }

    public static class MainCategory {
        @AutoTooltip
        public boolean enablePreview = true;
        @AutoTooltip
        public boolean lockPreview = false;
        @AutoTooltip
        public boolean swapModes = false;
        @AutoTooltip
        public boolean alwaysOn = false;
        @AutoTooltip
        public ShulkerBoxTooltipType tooltipType = ShulkerBoxTooltipType.MOD;
        @AutoTooltip
        public CompactPreviewTagBehavior compactPreviewTagBehavior = CompactPreviewTagBehavior.SEPARATE;
        @AutoTooltip
        public LootTableInfoType lootTableInfoType = LootTableInfoType.HIDE;
        @AutoTooltip
        public boolean coloredPreview = true;
        @AutoTooltip
        @Validator(value=GreaterThanZero.class)
        public int defaultMaxRowSize = 9;
    }
}

