/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.itemscroller.event;

import fi.dy.masa.itemscroller.config.Configs;
import fi.dy.masa.itemscroller.config.Hotkeys;
import fi.dy.masa.itemscroller.event.KeybindCallbacks;
import fi.dy.masa.itemscroller.event.RenderEventHandler;
import fi.dy.masa.itemscroller.recipes.RecipeStorage;
import fi.dy.masa.itemscroller.util.AccessorUtils;
import fi.dy.masa.itemscroller.util.InputUtils;
import fi.dy.masa.itemscroller.util.InventoryUtils;
import fi.dy.masa.itemscroller.util.MoveAction;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.hotkeys.IHotkey;
import fi.dy.masa.malilib.hotkeys.IKeybindManager;
import fi.dy.masa.malilib.hotkeys.IKeybindProvider;
import fi.dy.masa.malilib.hotkeys.IKeyboardInputHandler;
import fi.dy.masa.malilib.hotkeys.IMouseInputHandler;
import fi.dy.masa.malilib.util.GuiUtils;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_465;
import net.minecraft.class_481;

public class InputHandler
implements IKeybindProvider,
IKeyboardInputHandler,
IMouseInputHandler {
    private final KeybindCallbacks callbacks = KeybindCallbacks.getInstance();

    public void addKeysToMap(IKeybindManager manager) {
        for (IHotkey iHotkey : Hotkeys.HOTKEY_LIST) {
            manager.addKeybindToMap(iHotkey.getKeybind());
        }
    }

    public void addHotkeys(IKeybindManager manager) {
        manager.addHotkeysForCategory("Item Scroller", "itemscroller.hotkeys.category.hotkeys", Hotkeys.HOTKEY_LIST);
    }

    public boolean onKeyInput(int keyCode, int scanCode, int modifiers, boolean eventKeyState) {
        if (InputUtils.isRecipeViewOpen() && eventKeyState) {
            int recipeIndexChange;
            int index = -1;
            RecipeStorage recipes = RecipeStorage.getInstance();
            int oldIndex = recipes.getSelection();
            int recipesPerPage = recipes.getRecipeCountPerPage();
            int n = recipeIndexChange = GuiBase.isShiftDown() ? recipesPerPage : recipesPerPage / 2;
            if (keyCode >= 49 && keyCode <= 57) {
                index = class_3532.method_15340((int)(keyCode - 49), (int)0, (int)8);
            } else if (keyCode == 265 && oldIndex > 0) {
                index = oldIndex - 1;
            } else if (keyCode == 264 && oldIndex < recipes.getTotalRecipeCount() - 1) {
                index = oldIndex + 1;
            } else if (keyCode == 263 && oldIndex >= recipeIndexChange) {
                index = oldIndex - recipeIndexChange;
            } else if (keyCode == 262 && oldIndex < recipes.getTotalRecipeCount() - recipeIndexChange) {
                index = oldIndex + recipeIndexChange;
            }
            if (index >= 0) {
                recipes.changeSelectedRecipe(index);
                return true;
            }
        }
        return this.handleInput(keyCode, eventKeyState, 0.0);
    }

    public boolean onMouseScroll(int mouseX, int mouseY, double amount) {
        return this.handleInput(-1, false, amount);
    }

    public boolean onMouseClick(int mouseX, int mouseY, int eventButton, boolean eventButtonState) {
        return this.handleInput(eventButton - 100, eventButtonState, 0.0);
    }

    private boolean handleInput(int keyCode, boolean keyState, double dWheel) {
        MoveAction action = InventoryUtils.getActiveMoveAction();
        if (action != MoveAction.NONE && !InputUtils.isActionKeyActive(action)) {
            InventoryUtils.stopDragging();
        }
        class_310 mc = class_310.method_1551();
        boolean cancel = false;
        if (this.callbacks.functionalityEnabled() && mc.field_1724 != null) {
            boolean isAttack = InputUtils.isAttack(keyCode);
            boolean isUse = InputUtils.isUse(keyCode);
            boolean isPickBlock = InputUtils.isPickBlock(keyCode);
            boolean isAttackUseOrPick = isAttack || isUse || isPickBlock;
            int mouseX = fi.dy.masa.malilib.util.InputUtils.getMouseX();
            int mouseY = fi.dy.masa.malilib.util.InputUtils.getMouseY();
            if (GuiUtils.getCurrentScreen() instanceof class_465 && !(GuiUtils.getCurrentScreen() instanceof class_481) && !Configs.GUI_BLACKLIST.contains(GuiUtils.getCurrentScreen().getClass().getName())) {
                class_465 gui = (class_465)GuiUtils.getCurrentScreen();
                RecipeStorage recipes = RecipeStorage.getInstance();
                if (dWheel != 0.0) {
                    if (InputUtils.isRecipeViewOpen()) {
                        recipes.scrollSelection(dWheel < 0.0);
                        cancel = true;
                    } else {
                        cancel = InventoryUtils.tryMoveItems((class_465<? extends class_1703>)gui, recipes, dWheel > 0.0);
                    }
                } else {
                    class_1735 slot = AccessorUtils.getSlotUnderMouse(gui);
                    boolean isShiftDown = GuiBase.isShiftDown();
                    if (keyState && isAttackUseOrPick) {
                        int hoveredRecipeId = RenderEventHandler.instance().getHoveredRecipeId(mouseX, mouseY, recipes, gui);
                        if (hoveredRecipeId >= 0) {
                            InventoryUtils.handleRecipeClick((class_465<? extends class_1703>)gui, mc, recipes, hoveredRecipeId, isAttack, isUse, isPickBlock, isShiftDown);
                            return true;
                        }
                        if (isPickBlock && InputUtils.isRecipeViewOpen() && InventoryUtils.isCraftingSlot((class_465<? extends class_1703>)gui, slot)) {
                            recipes.storeCraftingRecipeToCurrentSelection(slot, gui, true);
                            cancel = true;
                        }
                    }
                    InventoryUtils.checkForItemPickup(mc);
                    if (keyState && (isAttack || isUse)) {
                        InventoryUtils.storeSourceSlotCandidate(slot, mc);
                    }
                    if (Configs.Toggles.RIGHT_CLICK_CRAFT_STACK.getBooleanValue() && isUse && keyState && InventoryUtils.isCraftingSlot((class_465<? extends class_1703>)gui, slot)) {
                        InventoryUtils.rightClickCraftOneStack((class_465<? extends class_1703>)gui);
                    } else if (Configs.Toggles.SHIFT_PLACE_ITEMS.getBooleanValue() && isAttack && isShiftDown && InventoryUtils.canShiftPlaceItems((class_465<? extends class_1703>)gui)) {
                        cancel |= InventoryUtils.shiftPlaceItems(slot, (class_465<? extends class_1703>)gui);
                    } else if (Configs.Toggles.SHIFT_DROP_ITEMS.getBooleanValue() && isAttack && isShiftDown && InputUtils.canShiftDropItems(gui, mc, mouseX, mouseY)) {
                        cancel |= InventoryUtils.shiftDropItems((class_465<? extends class_1703>)gui);
                    }
                }
            }
        }
        return cancel;
    }

    public void onMouseMove(int mouseX, int mouseY) {
        class_310 mc = class_310.method_1551();
        if (this.callbacks.functionalityEnabled() && mc.field_1724 != null && GuiUtils.getCurrentScreen() instanceof class_465 && !Configs.GUI_BLACKLIST.contains(GuiUtils.getCurrentScreen().getClass().getName())) {
            this.handleDragging((class_465)GuiUtils.getCurrentScreen(), mc, mouseX, mouseY, false);
        }
    }

    private boolean handleDragging(class_465<?> gui, class_310 mc, int mouseX, int mouseY, boolean isClick) {
        MoveAction action = InventoryUtils.getActiveMoveAction();
        if (InputUtils.isActionKeyActive(action)) {
            return InventoryUtils.dragMoveItems(gui, mc, action, mouseX, mouseY, false);
        }
        if (action != MoveAction.NONE) {
            InventoryUtils.stopDragging();
        }
        return false;
    }
}

