/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.itemscroller.event;

import com.mojang.blaze3d.systems.RenderSystem;
import fi.dy.masa.itemscroller.config.Configs;
import fi.dy.masa.itemscroller.recipes.RecipePattern;
import fi.dy.masa.itemscroller.recipes.RecipeStorage;
import fi.dy.masa.itemscroller.util.AccessorUtils;
import fi.dy.masa.itemscroller.util.InputUtils;
import fi.dy.masa.itemscroller.util.InventoryUtils;
import fi.dy.masa.malilib.render.InventoryOverlay;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.GuiUtils;
import fi.dy.masa.malilib.util.StringUtils;
import java.nio.FloatBuffer;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_311;
import net.minecraft.class_327;
import net.minecraft.class_4493;
import net.minecraft.class_465;

public class RenderEventHandler {
    private static final RenderEventHandler INSTANCE = new RenderEventHandler();
    private static final class_243 LIGHT0_POS = new class_243(0.2, 1.0, -0.7).method_1029();
    private static final class_243 LIGHT1_POS = new class_243(-0.2, 1.0, 0.7).method_1029();
    private static final FloatBuffer FLOAT_BUFFER = class_311.method_1597((int)4);
    private final class_310 mc = class_310.method_1551();
    private int recipeListX;
    private int recipeListY;
    private int recipesPerColumn;
    private int columnWidth;
    private int columns;
    private int numberTextWidth;
    private int gapColumn;
    private int entryHeight;
    private double scale;

    public static RenderEventHandler instance() {
        return INSTANCE;
    }

    public void onDrawBackgroundPost() {
        if (GuiUtils.getCurrentScreen() instanceof class_465 && InputUtils.isRecipeViewOpen()) {
            class_465 gui = (class_465)GuiUtils.getCurrentScreen();
            RecipeStorage recipes = RecipeStorage.getInstance();
            int first = recipes.getFirstVisibleRecipeId();
            int countPerPage = recipes.getRecipeCountPerPage();
            int lastOnPage = first + countPerPage - 1;
            this.calculateRecipePositions(gui);
            RenderSystem.pushMatrix();
            RenderSystem.translatef((float)this.recipeListX, (float)this.recipeListY, (float)0.0f);
            RenderSystem.scaled((double)this.scale, (double)this.scale, (double)1.0);
            String str = StringUtils.translate((String)"itemscroller.gui.label.recipe_page", (Object[])new Object[]{first / countPerPage + 1, recipes.getTotalRecipeCount() / countPerPage});
            this.mc.field_1772.method_1729(str, 16.0f, -12.0f, -1061109568);
            int i = 0;
            for (int recipeId = first; recipeId <= lastOnPage; ++recipeId) {
                class_1799 stack = recipes.getRecipe(recipeId).getResult();
                boolean selected = recipeId == recipes.getSelection();
                int row = i % this.recipesPerColumn;
                int column = i / this.recipesPerColumn;
                this.renderStoredRecipeStack(stack, recipeId, row, column, gui, selected);
                ++i;
            }
            if (Configs.Generic.CRAFTING_RENDER_RECIPE_ITEMS.getBooleanValue()) {
                int mouseY;
                int mouseX = fi.dy.masa.malilib.util.InputUtils.getMouseX();
                int recipeId = this.getHoveredRecipeId(mouseX, mouseY = fi.dy.masa.malilib.util.InputUtils.getMouseY(), recipes, gui);
                RecipePattern recipe = recipeId >= 0 ? recipes.getRecipe(recipeId) : recipes.getSelectedRecipe();
                this.renderRecipeItems(recipe, recipes.getRecipeCountPerPage(), gui);
            }
            RenderSystem.popMatrix();
            RenderSystem.enableBlend();
        }
    }

    public void onDrawScreenPost() {
        if (GuiUtils.getCurrentScreen() instanceof class_465 && InputUtils.isRecipeViewOpen()) {
            RecipePattern recipe;
            class_1799 stack;
            class_465 gui = (class_465)this.mc.field_1755;
            RecipeStorage recipes = RecipeStorage.getInstance();
            int mouseX = fi.dy.masa.malilib.util.InputUtils.getMouseX();
            int mouseY = fi.dy.masa.malilib.util.InputUtils.getMouseY();
            int recipeId = this.getHoveredRecipeId(mouseX, mouseY, recipes, gui);
            float offset = 300.0f;
            RenderSystem.pushMatrix();
            RenderSystem.translatef((float)0.0f, (float)0.0f, (float)offset);
            if (recipeId >= 0) {
                RecipePattern recipe2 = recipes.getRecipe(recipeId);
                this.renderHoverTooltip(mouseX, mouseY, recipe2, gui);
            } else if (Configs.Generic.CRAFTING_RENDER_RECIPE_ITEMS.getBooleanValue() && !InventoryUtils.isStackEmpty(stack = this.getHoveredRecipeIngredient(mouseX, mouseY, recipe = recipes.getSelectedRecipe(), recipes.getRecipeCountPerPage(), gui))) {
                InventoryOverlay.renderStackToolTip((int)mouseX, (int)mouseY, (class_1799)stack, (class_310)this.mc);
            }
            RenderSystem.popMatrix();
        }
    }

    private void calculateRecipePositions(class_465<?> gui) {
        RecipeStorage recipes = RecipeStorage.getInstance();
        int gapHorizontal = 2;
        int gapVertical = 2;
        int stackBaseHeight = 16;
        int guiLeft = AccessorUtils.getGuiLeft(gui);
        this.recipesPerColumn = 9;
        this.columns = (int)Math.ceil((double)recipes.getRecipeCountPerPage() / (double)this.recipesPerColumn);
        this.numberTextWidth = 12;
        this.gapColumn = 4;
        int usableHeight = GuiUtils.getScaledWindowHeight();
        int usableWidth = guiLeft;
        double gapScaleVertical = 0.8888888888888888;
        int maxStackDimensionsVertical = (int)((double)usableHeight / ((double)this.recipesPerColumn + 1.2) * gapScaleVertical);
        double gapScaleHorizontal = 0.8888888888888888;
        int maxStackDimensionsHorizontal = (int)((double)(usableWidth - this.columns * (this.numberTextWidth + this.gapColumn)) / ((double)(this.columns + 3) + 0.8) * gapScaleHorizontal);
        int stackDimensions = Math.min(maxStackDimensionsVertical, maxStackDimensionsHorizontal);
        this.scale = (double)stackDimensions / 16.0;
        this.entryHeight = 18;
        this.recipeListX = guiLeft - (int)((double)(this.columns * (16 + this.numberTextWidth + this.gapColumn) + 2) * this.scale);
        this.recipeListY = (int)((double)this.entryHeight * this.scale);
        this.columnWidth = 16 + this.numberTextWidth + this.gapColumn;
    }

    private void renderHoverTooltip(int mouseX, int mouseY, RecipePattern recipe, class_465<?> gui) {
        class_1799 stack = recipe.getResult();
        if (!InventoryUtils.isStackEmpty(stack)) {
            InventoryOverlay.renderStackToolTip((int)mouseX, (int)mouseY, (class_1799)stack, (class_310)this.mc);
        }
    }

    public int getHoveredRecipeId(int mouseX, int mouseY, RecipeStorage recipes, class_465<?> gui) {
        if (InputUtils.isRecipeViewOpen()) {
            this.calculateRecipePositions(gui);
            int stackDimensions = (int)(16.0 * this.scale);
            for (int column = 0; column < this.columns; ++column) {
                int startX = this.recipeListX + (int)((double)(column * this.columnWidth + this.gapColumn + this.numberTextWidth) * this.scale);
                if (mouseX < startX || mouseX > startX + stackDimensions) continue;
                for (int row = 0; row < this.recipesPerColumn; ++row) {
                    int startY = this.recipeListY + (int)((double)(row * this.entryHeight) * this.scale);
                    if (mouseY < startY || mouseY > startY + stackDimensions) continue;
                    return recipes.getFirstVisibleRecipeId() + column * this.recipesPerColumn + row;
                }
            }
        }
        return -1;
    }

    private void renderStoredRecipeStack(class_1799 stack, int recipeId, int row, int column, class_465<?> gui, boolean selected) {
        class_327 font = this.mc.field_1772;
        String indexStr = String.valueOf(recipeId + 1);
        int x = column * this.columnWidth + this.gapColumn + this.numberTextWidth;
        int y = row * this.entryHeight;
        this.renderStackAt(stack, x, y, selected);
        double scale = 0.75;
        x = x - (int)((double)font.method_1727(indexStr) * scale) - 2;
        int n = row * this.entryHeight + this.entryHeight / 2;
        font.getClass();
        y = n - 9 / 2;
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)x, (float)y, (float)0.0f);
        RenderSystem.scaled((double)scale, (double)scale, (double)0.0);
        font.method_1729(indexStr, 0.0f, 0.0f, 0xC0C0C0);
        RenderSystem.popMatrix();
    }

    private void renderRecipeItems(RecipePattern recipe, int recipeCountPerPage, class_465<?> gui) {
        class_1799[] items = recipe.getRecipeItems();
        int recipeDimensions = (int)Math.ceil(Math.sqrt(recipe.getRecipeLength()));
        int x = -49;
        int y = 3 * this.entryHeight;
        int i = 0;
        for (int row = 0; row < recipeDimensions; ++row) {
            int col = 0;
            while (col < recipeDimensions) {
                int xOff = col * 17;
                int yOff = row * 17;
                this.renderStackAt(items[i], x + xOff, y + yOff, false);
                ++col;
                ++i;
            }
        }
    }

    private class_1799 getHoveredRecipeIngredient(int mouseX, int mouseY, RecipePattern recipe, int recipeCountPerPage, class_465<?> gui) {
        int recipeDimensions = (int)Math.ceil(Math.sqrt(recipe.getRecipeLength()));
        int scaledStackDimensions = (int)(16.0 * this.scale);
        int scaledGridEntry = (int)(17.0 * this.scale);
        int x = this.recipeListX - (int)(49.0 * this.scale);
        int y = this.recipeListY + (int)((double)(3 * this.entryHeight) * this.scale);
        if (mouseX >= x && mouseX <= x + recipeDimensions * scaledGridEntry && mouseY >= y && mouseY <= y + recipeDimensions * scaledGridEntry) {
            int i = 0;
            for (int row = 0; row < recipeDimensions; ++row) {
                int col = 0;
                while (col < recipeDimensions) {
                    int xOff = col * scaledGridEntry;
                    int yOff = row * scaledGridEntry;
                    int xStart = x + xOff;
                    int yStart = y + yOff;
                    if (mouseX >= xStart && mouseX < xStart + scaledStackDimensions && mouseY >= yStart && mouseY < yStart + scaledStackDimensions) {
                        return recipe.getRecipeItems()[i];
                    }
                    ++col;
                    ++i;
                }
            }
        }
        return class_1799.field_8037;
    }

    private void renderStackAt(class_1799 stack, int x, int y, boolean border) {
        RenderSystem.pushMatrix();
        int w = 16;
        if (border) {
            RenderUtils.drawRect((int)(x - 1), (int)(y - 1), (int)17, (int)1, (int)-1);
            RenderUtils.drawRect((int)(x - 1), (int)y, (int)1, (int)17, (int)-1);
            RenderUtils.drawRect((int)(x + 16), (int)(y - 1), (int)1, (int)17, (int)-1);
            RenderUtils.drawRect((int)x, (int)(y + 16), (int)17, (int)1, (int)-1);
            RenderUtils.drawRect((int)x, (int)y, (int)16, (int)16, (int)0x20FFFFFF);
        } else {
            RenderUtils.drawRect((int)x, (int)y, (int)16, (int)16, (int)0x20FFFFFF);
        }
        if (!InventoryUtils.isStackEmpty(stack)) {
            class_308.method_24211();
            stack = stack.method_7972();
            InventoryUtils.setStackSize(stack, 1);
            this.mc.method_1480().field_4730 += 100.0f;
            this.mc.method_1480().method_4026((class_1309)this.mc.field_1724, stack, x, y);
            this.mc.method_1480().field_4730 -= 100.0f;
        }
        RenderSystem.popMatrix();
    }

    public static void enableGUIStandardItemLighting(float scale) {
        RenderSystem.pushMatrix();
        RenderSystem.rotatef((float)-30.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderSystem.rotatef((float)165.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        RenderEventHandler.enableStandardItemLighting(scale);
        RenderSystem.popMatrix();
    }

    public static void enableStandardItemLighting(float scale) {
        RenderSystem.enableLighting();
        class_4493.method_21944((int)0);
        class_4493.method_21944((int)1);
        RenderSystem.enableColorMaterial();
        RenderSystem.colorMaterial((int)1032, (int)5634);
        float lightStrength = 0.3f * scale;
        float ambientLightStrength = 0.4f;
        class_4493.method_21960((int)16384, (int)4611, (FloatBuffer)RenderEventHandler.singletonBuffer((float)RenderEventHandler.LIGHT0_POS.field_1352, (float)RenderEventHandler.LIGHT0_POS.field_1351, (float)RenderEventHandler.LIGHT0_POS.field_1350, 0.0f));
        class_4493.method_21960((int)16384, (int)4609, (FloatBuffer)RenderEventHandler.singletonBuffer(lightStrength, lightStrength, lightStrength, 1.0f));
        class_4493.method_21960((int)16384, (int)4608, (FloatBuffer)RenderEventHandler.singletonBuffer(0.0f, 0.0f, 0.0f, 1.0f));
        class_4493.method_21960((int)16384, (int)4610, (FloatBuffer)RenderEventHandler.singletonBuffer(0.0f, 0.0f, 0.0f, 1.0f));
        class_4493.method_21960((int)16385, (int)4611, (FloatBuffer)RenderEventHandler.singletonBuffer((float)RenderEventHandler.LIGHT1_POS.field_1352, (float)RenderEventHandler.LIGHT1_POS.field_1351, (float)RenderEventHandler.LIGHT1_POS.field_1350, 0.0f));
        class_4493.method_21960((int)16385, (int)4609, (FloatBuffer)RenderEventHandler.singletonBuffer(lightStrength, lightStrength, lightStrength, 1.0f));
        class_4493.method_21960((int)16385, (int)4608, (FloatBuffer)RenderEventHandler.singletonBuffer(0.0f, 0.0f, 0.0f, 1.0f));
        class_4493.method_21960((int)16385, (int)4610, (FloatBuffer)RenderEventHandler.singletonBuffer(0.0f, 0.0f, 0.0f, 1.0f));
        RenderSystem.shadeModel((int)7424);
        class_4493.method_21963((int)2899, (FloatBuffer)RenderEventHandler.singletonBuffer(ambientLightStrength, ambientLightStrength, ambientLightStrength, 1.0f));
    }

    private static FloatBuffer singletonBuffer(float val1, float val2, float val3, float val4) {
        FLOAT_BUFFER.clear();
        FLOAT_BUFFER.put(val1).put(val2).put(val3).put(val4);
        FLOAT_BUFFER.flip();
        return FLOAT_BUFFER;
    }
}

