/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.itemscroller.recipes;

import fi.dy.masa.itemscroller.recipes.CraftingHandler;
import fi.dy.masa.itemscroller.util.InventoryUtils;
import javax.annotation.Nonnull;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_465;

public class RecipePattern {
    private class_1799 result = InventoryUtils.EMPTY_STACK;
    private class_1799[] recipe = new class_1799[9];

    public RecipePattern() {
        this.ensureRecipeSizeAndClearRecipe(9);
    }

    public void ensureRecipeSize(int size) {
        if (this.getRecipeLength() != size) {
            this.recipe = new class_1799[size];
        }
    }

    public void clearRecipe() {
        for (int i = 0; i < this.recipe.length; ++i) {
            this.recipe[i] = InventoryUtils.EMPTY_STACK;
        }
        this.result = InventoryUtils.EMPTY_STACK;
    }

    public void ensureRecipeSizeAndClearRecipe(int size) {
        this.ensureRecipeSize(size);
        this.clearRecipe();
    }

    public void storeCraftingRecipe(class_1735 slot, class_465<? extends class_1703> gui, boolean clearIfEmpty) {
        CraftingHandler.SlotRange range = CraftingHandler.getCraftingGridSlots(gui, slot);
        if (range != null) {
            if (slot.method_7681()) {
                int gridSize = range.getSlotCount();
                int numSlots = gui.method_17577().field_7761.size();
                this.ensureRecipeSizeAndClearRecipe(gridSize);
                int i = 0;
                for (int s = range.getFirst(); i < gridSize && s < numSlots; ++i, ++s) {
                    class_1735 slotTmp = gui.method_17577().method_7611(s);
                    this.recipe[i] = slotTmp.method_7681() ? slotTmp.method_7677().method_7972() : InventoryUtils.EMPTY_STACK;
                }
                this.result = slot.method_7677().method_7972();
            } else if (clearIfEmpty) {
                this.clearRecipe();
            }
        }
    }

    public void copyRecipeFrom(RecipePattern other) {
        int size = other.getRecipeLength();
        class_1799[] otherRecipe = other.getRecipeItems();
        this.ensureRecipeSizeAndClearRecipe(size);
        for (int i = 0; i < size; ++i) {
            this.recipe[i] = !InventoryUtils.isStackEmpty(otherRecipe[i]) ? otherRecipe[i].method_7972() : InventoryUtils.EMPTY_STACK;
        }
        this.result = !InventoryUtils.isStackEmpty(other.getResult()) ? other.getResult().method_7972() : InventoryUtils.EMPTY_STACK;
    }

    public void readFromNBT(@Nonnull class_2487 nbt) {
        if (nbt.method_10573("Result", 10) && nbt.method_10573("Ingredients", 9)) {
            class_2499 tagIngredients = nbt.method_10554("Ingredients", 10);
            int count = tagIngredients.size();
            int length = nbt.method_10550("Length");
            if (length > 0) {
                this.ensureRecipeSizeAndClearRecipe(length);
            }
            for (int i = 0; i < count; ++i) {
                class_2487 tag = tagIngredients.method_10602(i);
                int slot = tag.method_10550("Slot");
                if (slot < 0 || slot >= this.recipe.length) continue;
                this.recipe[slot] = class_1799.method_7915((class_2487)tag);
            }
            this.result = class_1799.method_7915((class_2487)nbt.method_10562("Result"));
        }
    }

    @Nonnull
    public class_2487 writeToNBT(@Nonnull class_2487 nbt) {
        if (this.isValid()) {
            class_2487 tag = new class_2487();
            this.result.method_7953(tag);
            nbt.method_10569("Length", this.recipe.length);
            nbt.method_10566("Result", (class_2520)tag);
            class_2499 tagIngredients = new class_2499();
            for (int i = 0; i < this.recipe.length; ++i) {
                if (InventoryUtils.isStackEmpty(this.recipe[i])) continue;
                tag = new class_2487();
                tag.method_10569("Slot", i);
                this.recipe[i].method_7953(tag);
                tagIngredients.add((Object)tag);
            }
            nbt.method_10566("Ingredients", (class_2520)tagIngredients);
        }
        return nbt;
    }

    public class_1799 getResult() {
        return this.result;
    }

    public int getRecipeLength() {
        return this.recipe.length;
    }

    public class_1799[] getRecipeItems() {
        return this.recipe;
    }

    public boolean isValid() {
        return !InventoryUtils.isStackEmpty(this.getResult());
    }
}

