/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.itemscroller.util;

import fi.dy.masa.itemscroller.ItemScroller;
import fi.dy.masa.itemscroller.config.Configs;
import fi.dy.masa.itemscroller.config.Hotkeys;
import fi.dy.masa.itemscroller.recipes.CraftingHandler;
import fi.dy.masa.itemscroller.recipes.RecipePattern;
import fi.dy.masa.itemscroller.recipes.RecipeStorage;
import fi.dy.masa.itemscroller.util.AccessorUtils;
import fi.dy.masa.itemscroller.util.InputUtils;
import fi.dy.masa.itemscroller.util.ItemType;
import fi.dy.masa.itemscroller.util.MoveAction;
import fi.dy.masa.itemscroller.util.MoveAmount;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1715;
import net.minecraft.class_1727;
import net.minecraft.class_1728;
import net.minecraft.class_1731;
import net.minecraft.class_1735;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1914;
import net.minecraft.class_1916;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import net.minecraft.class_465;
import net.minecraft.class_481;
import net.minecraft.class_490;
import net.minecraft.class_492;
import net.minecraft.class_638;
import net.minecraft.class_746;

public class InventoryUtils {
    private static MoveAction activeMoveAction = MoveAction.NONE;
    private static int lastPosX;
    private static int lastPosY;
    private static int slotNumberLast;
    private static final Set<Integer> DRAGGED_SLOTS;
    private static WeakReference<class_1735> sourceSlotCandidate;
    private static WeakReference<class_1735> sourceSlot;
    private static class_1799 stackInCursorLast;
    public static final class_1799 EMPTY_STACK;

    public static void onSlotChangedCraftingGrid(class_1657 player, class_1715 craftMatrix, class_1731 inventoryCraftResult) {
        class_1937 world = player.method_5770();
        if (Configs.Generic.CLIENT_CRAFTING_FIX.getBooleanValue() && world.field_9236 && world instanceof class_638 && player instanceof class_746) {
            class_1799 stack = class_1799.field_8037;
            Optional optional = ((class_638)world).method_8433().method_8132(class_3956.field_17545, (class_1263)craftMatrix, world);
            if (optional.isPresent()) {
                class_3955 recipe = (class_3955)optional.get();
                if (recipe.method_8118() || !world.method_8450().method_8355(class_1928.field_19407) || ((class_746)player).method_3130().method_14878((class_1860)recipe)) {
                    inventoryCraftResult.method_7662((class_1860)recipe);
                    stack = recipe.method_8116((class_1263)craftMatrix);
                }
                inventoryCraftResult.method_5447(0, stack);
            }
        }
    }

    public static String getStackString(class_1799 stack) {
        if (!InventoryUtils.isStackEmpty(stack)) {
            class_2960 rl = class_2378.field_11142.method_10221((Object)stack.method_7909());
            return String.format("[%s - display: %s - NBT: %s] (%s)", rl != null ? rl.toString() : "null", stack.method_7964().getString(), stack.method_7969() != null ? stack.method_7969().toString() : "<no NBT>", stack.toString());
        }
        return "<empty>";
    }

    public static void debugPrintSlotInfo(class_465<? extends class_1703> gui, class_1735 slot) {
        if (slot == null) {
            ItemScroller.logger.info("slot was null");
            return;
        }
        boolean hasSlot = gui.method_17577().field_7761.contains(slot);
        class_1263 inv = slot.field_7871;
        String stackStr = InventoryUtils.getStackString(slot.method_7677());
        ItemScroller.logger.info(String.format("slot: slotNumber: %d, getSlotIndex(): %d, getHasStack(): %s, slot class: %s, inv class: %s, Container's slot list has slot: %s, stack: %s, numSlots: %d", slot.field_7874, AccessorUtils.getSlotIndex(slot), slot.method_7681(), slot.getClass().getName(), inv != null ? inv.getClass().getName() : "<null>", hasSlot ? " true" : "false", stackStr, gui.method_17577().field_7761.size()));
    }

    private static boolean isValidSlot(class_1735 slot, class_465<? extends class_1703> gui, boolean requireItems) {
        class_1703 container = gui.method_17577();
        return container != null && container.field_7761 != null && slot != null && container.field_7761.contains(slot) && (!requireItems || slot.method_7681()) && !Configs.SLOT_BLACKLIST.contains(slot.getClass().getName());
    }

    public static boolean isCraftingSlot(class_465<? extends class_1703> gui, @Nullable class_1735 slot) {
        return slot != null && CraftingHandler.getCraftingGridSlots(gui, slot) != null;
    }

    private static boolean inventoryExistsAbove(class_1735 slot, class_1703 container) {
        for (class_1735 slotTmp : container.field_7761) {
            if (slotTmp.field_7872 >= slot.field_7872 || InventoryUtils.areSlotsInSameInventory(slot, slotTmp)) continue;
            return true;
        }
        return false;
    }

    public static boolean canShiftPlaceItems(class_465<? extends class_1703> gui) {
        class_1735 slot = AccessorUtils.getSlotUnderMouse(gui);
        class_310 mc = class_310.method_1551();
        class_1799 stackCursor = mc.field_1724.field_7514.method_7399();
        return slot != null && !InventoryUtils.isStackEmpty(stackCursor) && InventoryUtils.isValidSlot(slot, gui, false) && !slot.method_7681() && slot.method_7680(stackCursor);
    }

    public static boolean tryMoveItems(class_465<? extends class_1703> gui, RecipeStorage recipes, boolean scrollingUp) {
        class_1735 slot = AccessorUtils.getSlotUnderMouse(gui);
        class_310 mc = class_310.method_1551();
        if (slot == null || !InventoryUtils.isStackEmpty(mc.field_1724.field_7514.method_7399())) {
            return false;
        }
        boolean villagerHandling = Configs.Toggles.SCROLL_VILLAGER.getBooleanValue() && gui instanceof class_492 && slot instanceof class_1727;
        boolean craftingHandling = Configs.Toggles.CRAFTING_FEATURES.getBooleanValue() && InventoryUtils.isCraftingSlot(gui, slot);
        boolean keyActiveMoveEverything = Hotkeys.MODIFIER_MOVE_EVERYTHING.getKeybind().isKeybindHeld();
        boolean keyActiveMoveMatching = Hotkeys.MODIFIER_MOVE_MATCHING.getKeybind().isKeybindHeld();
        boolean keyActiveMoveStacks = Hotkeys.MODIFIER_MOVE_STACK.getKeybind().isKeybindHeld();
        boolean nonSingleMove = keyActiveMoveEverything || keyActiveMoveMatching || keyActiveMoveStacks;
        boolean moveToOtherInventory = scrollingUp;
        if (Configs.Generic.SLOT_POSITION_AWARE_SCROLL_DIRECTION.getBooleanValue()) {
            boolean above = InventoryUtils.inventoryExistsAbove(slot, gui.method_17577());
            boolean bl = moveToOtherInventory = above == scrollingUp;
        }
        if (Configs.Generic.REVERSE_SCROLL_DIRECTION_SINGLE.getBooleanValue() && !nonSingleMove || Configs.Generic.REVERSE_SCROLL_DIRECTION_STACKS.getBooleanValue() && nonSingleMove) {
            moveToOtherInventory = !moveToOtherInventory;
        }
        if (!InventoryUtils.isValidSlot(slot, gui, !villagerHandling && !craftingHandling)) {
            return false;
        }
        if (craftingHandling) {
            return InventoryUtils.tryMoveItemsCrafting(recipes, slot, gui, moveToOtherInventory, keyActiveMoveStacks, keyActiveMoveEverything);
        }
        if (villagerHandling) {
            return InventoryUtils.tryMoveItemsVillager((class_492)gui, slot, moveToOtherInventory, keyActiveMoveStacks);
        }
        if (!Configs.Toggles.SCROLL_SINGLE.getBooleanValue() && !nonSingleMove || !Configs.Toggles.SCROLL_STACKS.getBooleanValue() && keyActiveMoveStacks || !Configs.Toggles.SCROLL_MATCHING.getBooleanValue() && keyActiveMoveMatching || !Configs.Toggles.SCROLL_EVERYTHING.getBooleanValue() && keyActiveMoveEverything) {
            return false;
        }
        if (keyActiveMoveEverything) {
            InventoryUtils.tryMoveStacks(slot, gui, false, moveToOtherInventory, false);
        } else {
            if (keyActiveMoveMatching) {
                InventoryUtils.tryMoveStacks(slot, gui, true, moveToOtherInventory, false);
                return true;
            }
            if (keyActiveMoveStacks) {
                InventoryUtils.tryMoveStacks(slot, gui, true, moveToOtherInventory, true);
            } else {
                class_1799 stack = slot.method_7677();
                if (moveToOtherInventory) {
                    InventoryUtils.tryMoveSingleItemToOtherInventory(slot, gui);
                } else if (InventoryUtils.getStackSize(stack) < slot.method_7676(stack)) {
                    InventoryUtils.tryMoveSingleItemToThisInventory(slot, gui);
                }
            }
        }
        return false;
    }

    public static boolean dragMoveItems(class_465<? extends class_1703> gui, class_310 mc, MoveAction action, int mouseX, int mouseY, boolean isClick) {
        if (!InventoryUtils.isStackEmpty(mc.field_1724.field_7514.method_7399())) {
            lastPosX = mouseX;
            lastPosY = mouseY;
            InventoryUtils.stopDragging();
            return false;
        }
        boolean cancel = false;
        if (isClick && action != MoveAction.NONE) {
            slotNumberLast = -1;
            lastPosX = mouseX;
            lastPosY = mouseY;
            activeMoveAction = action;
            cancel = InventoryUtils.dragMoveFromSlotAtPosition(gui, mouseX, mouseY, action);
        } else {
            action = activeMoveAction;
        }
        if (activeMoveAction != MoveAction.NONE && !cancel) {
            int absY;
            int distX = mouseX - lastPosX;
            int distY = mouseY - lastPosY;
            int absX = Math.abs(distX);
            if (absX > (absY = Math.abs(distY))) {
                int inc = distX > 0 ? 1 : -1;
                int x = lastPosX;
                while (true) {
                    int y = absX != 0 ? lastPosY + (x - lastPosX) * distY / absX : mouseY;
                    InventoryUtils.dragMoveFromSlotAtPosition(gui, x, y, action);
                    if (x != mouseX) {
                        x += inc;
                        continue;
                    }
                    break;
                }
            } else {
                int inc = distY > 0 ? 1 : -1;
                int y = lastPosY;
                while (true) {
                    int x = absY != 0 ? lastPosX + (y - lastPosY) * distX / absY : mouseX;
                    InventoryUtils.dragMoveFromSlotAtPosition(gui, x, y, action);
                    if (y == mouseY) break;
                    y += inc;
                }
            }
        }
        lastPosX = mouseX;
        lastPosY = mouseY;
        class_1735 slot = AccessorUtils.getSlotAtPosition(gui, mouseX, mouseY);
        if (slot != null) {
            if (gui instanceof class_481) {
                int slotNumber;
                boolean isPlayerInv = ((class_481)gui).method_2469() == class_1761.field_7918.method_7741();
                slotNumberLast = slotNumber = isPlayerInv ? AccessorUtils.getSlotIndex(slot) : slot.field_7874;
            } else {
                slotNumberLast = slot.field_7874;
            }
        } else {
            slotNumberLast = -1;
        }
        return cancel;
    }

    public static void stopDragging() {
        activeMoveAction = MoveAction.NONE;
        DRAGGED_SLOTS.clear();
    }

    private static boolean dragMoveFromSlotAtPosition(class_465<? extends class_1703> gui, int x, int y, MoveAction action) {
        boolean flag;
        if (gui instanceof class_481) {
            return InventoryUtils.dragMoveFromSlotAtPositionCreative(gui, x, y, action);
        }
        class_1735 slot = AccessorUtils.getSlotAtPosition(gui, x, y);
        class_310 mc = class_310.method_1551();
        MoveAmount amount = InputUtils.getMoveAmount(action);
        boolean bl = flag = slot != null && InventoryUtils.isValidSlot(slot, gui, true) && slot.method_7674((class_1657)mc.field_1724);
        if (flag && slot.field_7874 != slotNumberLast && (amount != MoveAmount.MOVE_ONE || !DRAGGED_SLOTS.contains(slot.field_7874))) {
            switch (action) {
                case MOVE_TO_OTHER_MOVE_ONE: {
                    InventoryUtils.tryMoveSingleItemToOtherInventory(slot, gui);
                    break;
                }
                case MOVE_TO_OTHER_LEAVE_ONE: {
                    InventoryUtils.tryMoveAllButOneItemToOtherInventory(slot, gui);
                    break;
                }
                case MOVE_TO_OTHER_STACKS: {
                    InventoryUtils.shiftClickSlot(gui, slot.field_7874);
                    break;
                }
                case MOVE_TO_OTHER_MATCHING: {
                    InventoryUtils.tryMoveStacks(slot, gui, true, true, false);
                    break;
                }
                case DROP_ONE: {
                    InventoryUtils.clickSlot(gui, slot.field_7874, 0, class_1713.field_7795);
                    break;
                }
                case DROP_LEAVE_ONE: {
                    InventoryUtils.leftClickSlot(gui, slot.field_7874);
                    InventoryUtils.rightClickSlot(gui, slot.field_7874);
                    InventoryUtils.dropItemsFromCursor(gui);
                    break;
                }
                case DROP_STACKS: {
                    InventoryUtils.clickSlot(gui, slot.field_7874, 1, class_1713.field_7795);
                    break;
                }
                case MOVE_DOWN_MOVE_ONE: 
                case MOVE_DOWN_LEAVE_ONE: 
                case MOVE_DOWN_STACKS: 
                case MOVE_DOWN_MATCHING: {
                    InventoryUtils.tryMoveItemsVertically(gui, slot, false, amount);
                    break;
                }
                case MOVE_UP_MOVE_ONE: 
                case MOVE_UP_LEAVE_ONE: 
                case MOVE_UP_STACKS: 
                case MOVE_UP_MATCHING: {
                    InventoryUtils.tryMoveItemsVertically(gui, slot, true, amount);
                    break;
                }
            }
            DRAGGED_SLOTS.add(slot.field_7874);
        }
        return true;
    }

    private static boolean dragMoveFromSlotAtPositionCreative(class_465<? extends class_1703> gui, int x, int y, MoveAction action) {
        int slotNumber;
        boolean isPlayerInv;
        class_481 guiCreative = (class_481)gui;
        class_1735 slot = AccessorUtils.getSlotAtPosition(gui, x, y);
        boolean bl = isPlayerInv = guiCreative.method_2469() == class_1761.field_7918.method_7741();
        if (slot == null || slot.getClass() != class_1735.class && !isPlayerInv) {
            return false;
        }
        class_310 mc = class_310.method_1551();
        MoveAmount amount = InputUtils.getMoveAmount(action);
        boolean flag = slot != null && InventoryUtils.isValidSlot(slot, gui, true) && slot.method_7674((class_1657)mc.field_1724);
        boolean cancel = flag && (amount == MoveAmount.LEAVE_ONE || amount == MoveAmount.MOVE_ONE);
        int n = slotNumber = isPlayerInv ? AccessorUtils.getSlotIndex(slot) : slot.field_7874;
        if (flag && slotNumber != slotNumberLast && !DRAGGED_SLOTS.contains(slotNumber)) {
            switch (action) {
                case MOVE_TO_OTHER_MOVE_ONE: 
                case SCROLL_TO_OTHER_MOVE_ONE: {
                    InventoryUtils.leftClickSlot((class_465<? extends class_1703>)guiCreative, slot, slotNumber);
                    InventoryUtils.rightClickSlot((class_465<? extends class_1703>)guiCreative, slot, slotNumber);
                    InventoryUtils.shiftClickSlot((class_465<? extends class_1703>)guiCreative, slot, slotNumber);
                    InventoryUtils.leftClickSlot((class_465<? extends class_1703>)guiCreative, slot, slotNumber);
                    cancel = true;
                    break;
                }
                case MOVE_TO_OTHER_LEAVE_ONE: {
                    if (!isPlayerInv) {
                        InventoryUtils.leftClickSlot((class_465<? extends class_1703>)guiCreative, slot, slotNumber);
                        InventoryUtils.rightClickSlot((class_465<? extends class_1703>)guiCreative, slot, slotNumber);
                        class_1735 slotFirst = (class_1735)gui.method_17577().field_7761.get(0);
                        InventoryUtils.leftClickSlot((class_465<? extends class_1703>)guiCreative, slotFirst, slotFirst.field_7874);
                    }
                    cancel = true;
                    break;
                }
                case MOVE_TO_OTHER_STACKS: 
                case SCROLL_TO_OTHER_STACKS: {
                    InventoryUtils.shiftClickSlot(gui, slot, slotNumber);
                    cancel = true;
                    break;
                }
                case DROP_ONE: {
                    InventoryUtils.clickSlot(gui, slot.field_7874, 0, class_1713.field_7795);
                    break;
                }
                case DROP_LEAVE_ONE: {
                    InventoryUtils.leftClickSlot(gui, slot.field_7874);
                    InventoryUtils.rightClickSlot(gui, slot.field_7874);
                    InventoryUtils.dropItemsFromCursor(gui);
                    break;
                }
                case DROP_STACKS: {
                    InventoryUtils.clickSlot(gui, slot.field_7874, 1, class_1713.field_7795);
                    cancel = true;
                    break;
                }
                case MOVE_DOWN_MOVE_ONE: 
                case MOVE_DOWN_LEAVE_ONE: 
                case MOVE_DOWN_STACKS: {
                    InventoryUtils.tryMoveItemsVertically(gui, slot, false, amount);
                    cancel = true;
                    break;
                }
                case MOVE_UP_MOVE_ONE: 
                case MOVE_UP_LEAVE_ONE: 
                case MOVE_UP_STACKS: {
                    InventoryUtils.tryMoveItemsVertically(gui, slot, true, amount);
                    cancel = true;
                    break;
                }
            }
            DRAGGED_SLOTS.add(slotNumber);
        }
        return cancel;
    }

    public static void dropStacks(class_465<? extends class_1703> gui, class_1799 stackReference, class_1735 slotReference, boolean sameInventory) {
        if (slotReference != null && !InventoryUtils.isStackEmpty(stackReference)) {
            class_1703 container = gui.method_17577();
            stackReference = stackReference.method_7972();
            for (class_1735 slot : container.field_7761) {
                if (InventoryUtils.areSlotsInSameInventory(slot, slotReference) != sameInventory || !InventoryUtils.areStacksEqual(slot.method_7677(), stackReference)) continue;
                InventoryUtils.dropStack(gui, slot.field_7874);
            }
        }
    }

    public static boolean shiftDropItems(class_465<? extends class_1703> gui) {
        class_1799 stackReference = class_310.method_1551().field_1724.field_7514.method_7399();
        if (!InventoryUtils.isStackEmpty(stackReference) && sourceSlot != null) {
            stackReference = stackReference.method_7972();
            InventoryUtils.dropItemsFromCursor(gui);
            InventoryUtils.dropStacks(gui, stackReference, (class_1735)sourceSlot.get(), true);
            return true;
        }
        return false;
    }

    public static boolean shiftPlaceItems(class_1735 slot, class_465<? extends class_1703> gui) {
        InventoryUtils.leftClickSlot(gui, slot.field_7874);
        DRAGGED_SLOTS.add(slot.field_7874);
        InventoryUtils.tryMoveStacks(slot, gui, true, false, false);
        return true;
    }

    public static void storeSourceSlotCandidate(class_1735 slot, class_310 mc) {
        if (slot != null) {
            class_1799 stackCursor = mc.field_1724.field_7514.method_7399();
            class_1799 stack = EMPTY_STACK;
            if (!InventoryUtils.isStackEmpty(stackCursor)) {
                stack = new class_1799((class_1935)stackCursor.method_7909(), InventoryUtils.getStackSize(stackCursor));
            }
            sourceSlotCandidate = new WeakReference<class_1735>(slot);
            stackInCursorLast = stack;
        }
    }

    public static void checkForItemPickup(class_310 mc) {
        class_1799 stackCursor = mc.field_1724.field_7514.method_7399();
        if (!InventoryUtils.isStackEmpty(stackCursor) && !stackCursor.method_7929(stackInCursorLast) && sourceSlotCandidate != null) {
            sourceSlot = new WeakReference(sourceSlotCandidate.get());
        }
    }

    private static boolean tryMoveItemsVillager(class_492 gui, class_1735 slot, boolean moveToOtherInventory, boolean fullStacks) {
        if (fullStacks) {
            if (!moveToOtherInventory) {
                InventoryUtils.tryMoveItemsToMerchantBuySlots(gui, true);
            } else if (slot.method_7681()) {
                InventoryUtils.tryMoveStacks(slot, (class_465<? extends class_1703>)gui, true, true, true);
            } else {
                InventoryUtils.tryMoveStacks(slot, (class_465<? extends class_1703>)gui, false, true, false);
            }
        } else if (!moveToOtherInventory) {
            InventoryUtils.tryMoveItemsToMerchantBuySlots(gui, false);
        } else if (slot.method_7681()) {
            InventoryUtils.moveOneSetOfItemsFromSlotToPlayerInventory((class_465<? extends class_1703>)gui, slot);
        }
        return false;
    }

    private static boolean tryMoveSingleItemToOtherInventory(class_1735 slot, class_465<? extends class_1703> gui) {
        int targetSlot;
        class_1799 stackOrig = slot.method_7677();
        class_1703 container = gui.method_17577();
        class_310 mc = class_310.method_1551();
        if (!InventoryUtils.isStackEmpty(mc.field_1724.field_7514.method_7399()) || !slot.method_7674((class_1657)mc.field_1724) || InventoryUtils.getStackSize(stackOrig) > 1 && !slot.method_7680(stackOrig)) {
            return false;
        }
        if (InventoryUtils.getStackSize(stackOrig) <= stackOrig.method_7914()) {
            return InventoryUtils.clickSlotsToMoveSingleItemByShiftClick(gui, slot.field_7874);
        }
        class_1799 stack = stackOrig.method_7972();
        InventoryUtils.setStackSize(stack, 1);
        class_1799[] originalStacks = InventoryUtils.getOriginalStacks(container);
        slot.method_7673(stack);
        container.method_7601((class_1657)mc.field_1724, slot.field_7874);
        if (!slot.method_7681() && (targetSlot = InventoryUtils.getTargetSlot(container, originalStacks)) >= 0) {
            ((class_1735)container.field_7761.get(targetSlot)).method_7671(1);
            InventoryUtils.restoreOriginalStacks(container, originalStacks);
            return InventoryUtils.clickSlotsToMoveSingleItem(gui, slot.field_7874, targetSlot);
        }
        slot.method_7673(stackOrig);
        return false;
    }

    private static boolean tryMoveAllButOneItemToOtherInventory(class_1735 slot, class_465<? extends class_1703> gui) {
        class_310 mc = class_310.method_1551();
        class_746 player = mc.field_1724;
        class_1799 stackOrig = slot.method_7677().method_7972();
        if (InventoryUtils.getStackSize(stackOrig) == 1 || InventoryUtils.getStackSize(stackOrig) > stackOrig.method_7914() || !slot.method_7674((class_1657)player) || !slot.method_7680(stackOrig)) {
            return true;
        }
        InventoryUtils.rightClickSlot(gui, slot.field_7874);
        class_1799 stackInCursor = player.field_7514.method_7399();
        if (InventoryUtils.isStackEmpty(stackInCursor)) {
            return false;
        }
        int stackInCursorSizeOrig = InventoryUtils.getStackSize(stackInCursor);
        int tempSlotNum = -1;
        for (class_1735 slotTmp : gui.method_17577().field_7761) {
            class_1799 stackInSlot;
            if (slotTmp.field_7874 == slot.field_7874 || !InventoryUtils.areSlotsInSameInventory(slotTmp, slot, true) || !slotTmp.method_7680(stackInCursor) || !slotTmp.method_7674((class_1657)player) || !InventoryUtils.isStackEmpty(stackInSlot = slotTmp.method_7677()) && !InventoryUtils.areStacksEqual(stackInSlot, stackInCursor)) continue;
            InventoryUtils.rightClickSlot(gui, slotTmp.field_7874);
            stackInCursor = player.field_7514.method_7399();
            if (!InventoryUtils.isStackEmpty(stackInCursor) && InventoryUtils.getStackSize(stackInCursor) >= stackInCursorSizeOrig) continue;
            tempSlotNum = slotTmp.field_7874;
            break;
        }
        if (!InventoryUtils.isStackEmpty(player.field_7514.method_7399())) {
            InventoryUtils.leftClickSlot(gui, slot.field_7874);
        }
        if (tempSlotNum != -1) {
            InventoryUtils.shiftClickSlot(gui, slot.field_7874);
            InventoryUtils.rightClickSlot(gui, tempSlotNum);
            InventoryUtils.rightClickSlot(gui, slot.field_7874);
            if (!InventoryUtils.isStackEmpty(player.field_7514.method_7399())) {
                InventoryUtils.leftClickSlot(gui, tempSlotNum);
            }
            return true;
        }
        boolean treatHotbarAsDifferent = gui.getClass() == class_490.class;
        List<Integer> slots = InventoryUtils.getSlotNumbersOfEmptySlots(gui.method_17577(), slot, false, treatHotbarAsDifferent, false);
        if (slots.isEmpty()) {
            slots = InventoryUtils.getSlotNumbersOfMatchingStacks(gui.method_17577(), slot, false, slot.method_7677(), true, treatHotbarAsDifferent, false);
        }
        if (!slots.isEmpty()) {
            InventoryUtils.leftClickSlot(gui, slot.field_7874);
            InventoryUtils.rightClickSlot(gui, slot.field_7874);
            for (int slotNum : slots) {
                class_1735 slotTmp = gui.method_17577().method_7611(slotNum);
                stackInCursor = player.field_7514.method_7399();
                if (InventoryUtils.isStackEmpty(stackInCursor)) {
                    return true;
                }
                if (!slotTmp.method_7680(stackInCursor)) continue;
                InventoryUtils.leftClickSlot(gui, slotNum);
            }
            if (!InventoryUtils.isStackEmpty(stackInCursor)) {
                InventoryUtils.leftClickSlot(gui, slot.field_7874);
            }
        }
        return false;
    }

    private static boolean tryMoveSingleItemToThisInventory(class_1735 slot, class_465<? extends class_1703> gui) {
        class_1703 container = gui.method_17577();
        class_1799 stackOrig = slot.method_7677();
        class_310 mc = class_310.method_1551();
        if (!slot.method_7680(stackOrig)) {
            return false;
        }
        for (int slotNum = container.field_7761.size() - 1; slotNum >= 0; --slotNum) {
            class_1735 slotTmp = (class_1735)container.field_7761.get(slotNum);
            class_1799 stackTmp = slotTmp.method_7677();
            if (InventoryUtils.areSlotsInSameInventory(slotTmp, slot) || InventoryUtils.isStackEmpty(stackTmp) || !slotTmp.method_7674((class_1657)mc.field_1724) || InventoryUtils.getStackSize(stackTmp) != 1 && !slotTmp.method_7680(stackTmp) || !InventoryUtils.areStacksEqual(stackTmp, stackOrig)) continue;
            return InventoryUtils.clickSlotsToMoveSingleItem(gui, slotTmp.field_7874, slot.field_7874);
        }
        return false;
    }

    public static void tryMoveStacks(class_1735 slot, class_465<? extends class_1703> gui, boolean matchingOnly, boolean toOtherInventory, boolean firstOnly) {
        InventoryUtils.tryMoveStacks(slot.method_7677(), slot, gui, matchingOnly, toOtherInventory, firstOnly);
    }

    private static void tryMoveStacks(class_1799 stackReference, class_1735 slot, class_465<? extends class_1703> gui, boolean matchingOnly, boolean toOtherInventory, boolean firstOnly) {
        int maxSlot;
        class_1703 container = gui.method_17577();
        for (int i = maxSlot = container.field_7761.size() - 1; i >= 0; --i) {
            class_1735 slotTmp = (class_1735)container.field_7761.get(i);
            if (slotTmp.field_7874 == slot.field_7874 || InventoryUtils.areSlotsInSameInventory(slotTmp, slot) != toOtherInventory || !slotTmp.method_7681() || matchingOnly && !InventoryUtils.areStacksEqual(stackReference, slotTmp.method_7677())) continue;
            boolean success = InventoryUtils.shiftClickSlotWithCheck(gui, slotTmp.field_7874);
            if (!success && Configs.Toggles.SCROLL_STACKS_FALLBACK.getBooleanValue()) {
                InventoryUtils.clickSlotsToMoveItemsFromSlot(slotTmp, gui, toOtherInventory);
            }
            if (!firstOnly) continue;
            return;
        }
        if (toOtherInventory && !InventoryUtils.shiftClickSlotWithCheck(gui, slot.field_7874)) {
            InventoryUtils.clickSlotsToMoveItemsFromSlot(slot, gui, toOtherInventory);
        }
    }

    private static void tryMoveItemsToMerchantBuySlots(class_492 gui, boolean fillStacks) {
        class_1916 list = ((class_1728)gui.method_17577()).method_17438();
        int index = AccessorUtils.getSelectedMerchantRecipe(gui);
        if (list == null || list.size() <= index) {
            return;
        }
        class_1914 recipe = (class_1914)list.get(index);
        if (recipe == null) {
            return;
        }
        class_1799 buy1 = recipe.method_19272();
        class_1799 buy2 = recipe.method_8247();
        if (!InventoryUtils.isStackEmpty(buy1)) {
            InventoryUtils.fillBuySlot((class_465<? extends class_1703>)gui, 0, buy1, fillStacks);
        }
        if (!InventoryUtils.isStackEmpty(buy2)) {
            InventoryUtils.fillBuySlot((class_465<? extends class_1703>)gui, 1, buy2, fillStacks);
        }
    }

    private static void fillBuySlot(class_465<? extends class_1703> gui, int slotNum, class_1799 buyStack, boolean fillStacks) {
        class_1735 slot = gui.method_17577().method_7611(slotNum);
        class_1799 existingStack = slot.method_7677();
        class_310 mc = class_310.method_1551();
        if (!InventoryUtils.isStackEmpty(existingStack) && !InventoryUtils.areStacksEqual(buyStack, existingStack)) {
            InventoryUtils.shiftClickSlot(gui, slotNum);
        }
        if (InventoryUtils.isStackEmpty(existingStack = slot.method_7677()) || InventoryUtils.areStacksEqual(buyStack, existingStack)) {
            InventoryUtils.moveItemsFromInventory(gui, slotNum, (class_1263)mc.field_1724.field_7514, buyStack, fillStacks);
        }
    }

    public static void handleRecipeClick(class_465<? extends class_1703> gui, class_310 mc, RecipeStorage recipes, int hoveredRecipeId, boolean isLeftClick, boolean isRightClick, boolean isPickBlock, boolean isShiftDown) {
        if (isLeftClick || isRightClick) {
            boolean changed = recipes.getSelection() != hoveredRecipeId;
            recipes.changeSelectedRecipe(hoveredRecipeId);
            if (changed) {
                InventoryUtils.clearFirstCraftingGridOfItems(recipes.getSelectedRecipe(), gui, false);
            } else {
                InventoryUtils.tryMoveItemsToFirstCraftingGrid(recipes.getRecipe(hoveredRecipeId), gui, isShiftDown);
            }
            if (isRightClick) {
                class_1735 outputSlot = CraftingHandler.getFirstCraftingOutputSlotForGui(gui);
                boolean dropKeyDown = mc.field_1690.field_1869.method_1434();
                if (outputSlot != null) {
                    if (dropKeyDown) {
                        if (isShiftDown) {
                            if (Configs.Generic.CARPET_CTRL_Q_CRAFTING.getBooleanValue()) {
                                InventoryUtils.dropStack(gui, outputSlot.field_7874);
                            } else {
                                InventoryUtils.dropStacksUntilEmpty(gui, outputSlot.field_7874);
                            }
                        } else {
                            InventoryUtils.dropItem(gui, outputSlot.field_7874);
                        }
                    } else if (isShiftDown) {
                        InventoryUtils.shiftClickSlot(gui, outputSlot.field_7874);
                    } else {
                        InventoryUtils.moveOneSetOfItemsFromSlotToPlayerInventory(gui, outputSlot);
                    }
                }
            }
        } else if (isPickBlock) {
            InventoryUtils.clearFirstCraftingGridOfAllItems(gui);
        }
    }

    public static void tryMoveItemsToFirstCraftingGrid(RecipePattern recipe, class_465<? extends class_1703> gui, boolean fillStacks) {
        class_1735 craftingOutputSlot = CraftingHandler.getFirstCraftingOutputSlotForGui(gui);
        if (craftingOutputSlot != null) {
            InventoryUtils.tryMoveItemsToCraftingGridSlots(recipe, craftingOutputSlot, gui, fillStacks);
        }
    }

    public static void loadRecipeItemsToGridForOutputSlotUnderMouse(RecipePattern recipe, class_465<? extends class_1703> gui) {
        class_1735 slot = AccessorUtils.getSlotUnderMouse(gui);
        InventoryUtils.loadRecipeItemsToGridForOutputSlot(recipe, gui, slot);
    }

    private static void loadRecipeItemsToGridForOutputSlot(RecipePattern recipe, class_465<? extends class_1703> gui, class_1735 outputSlot) {
        if (outputSlot != null && InventoryUtils.isCraftingSlot(gui, outputSlot) && !InventoryUtils.isStackEmpty(recipe.getResult())) {
            InventoryUtils.tryMoveItemsToCraftingGridSlots(recipe, outputSlot, gui, false);
        }
    }

    private static boolean tryMoveItemsCrafting(RecipeStorage recipes, class_1735 slot, class_465<? extends class_1703> gui, boolean moveToOtherInventory, boolean moveStacks, boolean moveEverything) {
        RecipePattern recipe = recipes.getSelectedRecipe();
        class_1799 stackRecipeOutput = recipe.getResult();
        if (moveToOtherInventory) {
            if (slot.method_7681()) {
                if (InventoryUtils.areStacksEqual(slot.method_7677(), stackRecipeOutput)) {
                    if (moveEverything) {
                        InventoryUtils.craftAsManyItemsAsPossible(recipe, slot, gui);
                    } else if (moveStacks) {
                        InventoryUtils.shiftClickSlot(gui, slot.field_7874);
                    } else {
                        InventoryUtils.moveOneSetOfItemsFromSlotToPlayerInventory(gui, slot);
                    }
                }
            } else {
                InventoryUtils.clearCraftingGridOfAllItems(gui, CraftingHandler.getCraftingGridSlots(gui, slot));
            }
        } else if (!moveToOtherInventory && !InventoryUtils.isStackEmpty(stackRecipeOutput)) {
            InventoryUtils.tryMoveItemsToCraftingGridSlots(recipe, slot, gui, moveStacks);
        }
        return false;
    }

    private static void craftAsManyItemsAsPossible(RecipePattern recipe, class_1735 slot, class_465<? extends class_1703> gui) {
        class_1799 result = recipe.getResult();
        for (int failSafe = 1024; failSafe > 0 && slot.method_7681() && InventoryUtils.areStacksEqual(slot.method_7677(), result); --failSafe) {
            InventoryUtils.shiftClickSlot(gui, slot.field_7874);
            if (slot.method_7681() && InventoryUtils.areStacksEqual(slot.method_7677(), result)) break;
            InventoryUtils.tryMoveItemsToCraftingGridSlots(recipe, slot, gui, true);
        }
    }

    public static void clearFirstCraftingGridOfItems(RecipePattern recipe, class_465<? extends class_1703> gui, boolean clearNonMatchingOnly) {
        class_1735 craftingOutputSlot = CraftingHandler.getFirstCraftingOutputSlotForGui(gui);
        if (craftingOutputSlot != null) {
            CraftingHandler.SlotRange range = CraftingHandler.getCraftingGridSlots(gui, craftingOutputSlot);
            InventoryUtils.clearCraftingGridOfItems(recipe, gui, range, clearNonMatchingOnly);
        }
    }

    public static void clearFirstCraftingGridOfAllItems(class_465<? extends class_1703> gui) {
        class_1735 craftingOutputSlot = CraftingHandler.getFirstCraftingOutputSlotForGui(gui);
        if (craftingOutputSlot != null) {
            CraftingHandler.SlotRange range = CraftingHandler.getCraftingGridSlots(gui, craftingOutputSlot);
            InventoryUtils.clearCraftingGridOfAllItems(gui, range);
        }
    }

    private static boolean clearCraftingGridOfItems(RecipePattern recipe, class_465<? extends class_1703> gui, CraftingHandler.SlotRange range, boolean clearNonMatchingOnly) {
        int invSlots = gui.method_17577().field_7761.size();
        int rangeSlots = range.getSlotCount();
        int recipeSize = recipe.getRecipeLength();
        int slotCount = Math.min(rangeSlots, recipeSize);
        int i = 0;
        for (int slotNum = range.getFirst(); i < slotCount && slotNum < invSlots; ++i, ++slotNum) {
            class_1735 slotTmp = gui.method_17577().method_7611(slotNum);
            if (slotTmp == null || !slotTmp.method_7681() || clearNonMatchingOnly && InventoryUtils.areStacksEqual(recipe.getRecipeItems()[i], slotTmp.method_7677())) continue;
            InventoryUtils.shiftClickSlot(gui, slotNum);
            if (!slotTmp.method_7681()) continue;
            return false;
        }
        return true;
    }

    private static boolean clearCraftingGridOfAllItems(class_465<? extends class_1703> gui, CraftingHandler.SlotRange range) {
        int invSlots = gui.method_17577().field_7761.size();
        int rangeSlots = range.getSlotCount();
        boolean clearedAll = true;
        int i = 0;
        for (int slotNum = range.getFirst(); i < rangeSlots && slotNum < invSlots; ++i, ++slotNum) {
            class_1735 slotTmp = gui.method_17577().method_7611(slotNum);
            if (slotTmp == null || !slotTmp.method_7681()) continue;
            InventoryUtils.shiftClickSlot(gui, slotNum);
            if (!slotTmp.method_7681()) continue;
            clearedAll = false;
        }
        return clearedAll;
    }

    private static boolean tryMoveItemsToCraftingGridSlots(RecipePattern recipe, class_1735 slot, class_465<? extends class_1703> gui, boolean fillStacks) {
        class_1703 container = gui.method_17577();
        int numSlots = container.field_7761.size();
        CraftingHandler.SlotRange range = CraftingHandler.getCraftingGridSlots(gui, slot);
        if (range != null && range.getLast() < numSlots && recipe.getRecipeLength() <= range.getSlotCount()) {
            if (!InventoryUtils.clearCraftingGridOfItems(recipe, gui, range, true)) {
                return false;
            }
            class_1735 slotGridFirst = container.method_7611(range.getFirst());
            Map<ItemType, List<Integer>> ingredientSlots = ItemType.getSlotsPerItem(recipe.getRecipeItems());
            for (Map.Entry<ItemType, List<Integer>> entry : ingredientSlots.entrySet()) {
                class_1799 ingredientReference = entry.getKey().getStack();
                List<Integer> recipeSlots = entry.getValue();
                ArrayList<Integer> targetSlots = new ArrayList<Integer>();
                for (int s : recipeSlots) {
                    targetSlots.add(s + range.getFirst());
                }
                if (fillStacks) {
                    InventoryUtils.fillCraftingGrid(gui, slotGridFirst, ingredientReference, targetSlots);
                    continue;
                }
                InventoryUtils.moveOneRecipeItemIntoCraftingGrid(gui, slotGridFirst, ingredientReference, targetSlots);
            }
        }
        return false;
    }

    private static void fillCraftingGrid(class_465<? extends class_1703> gui, class_1735 slotGridFirst, class_1799 ingredientReference, List<Integer> targetSlots) {
        class_1703 container = gui.method_17577();
        class_310 mc = class_310.method_1551();
        class_746 player = mc.field_1724;
        int slotNum = -1;
        int slotReturn = -1;
        int sizeOrig = 0;
        if (InventoryUtils.isStackEmpty(ingredientReference)) {
            return;
        }
        while ((slotNum = InventoryUtils.getSlotNumberOfLargestMatchingStackFromDifferentInventory(container, slotGridFirst, ingredientReference)) >= 0) {
            if (slotReturn == -1) {
                slotReturn = slotNum;
            }
            InventoryUtils.leftClickSlot(gui, slotNum);
            class_1799 stackCursor = player.field_7514.method_7399();
            if (!InventoryUtils.areStacksEqual(ingredientReference, stackCursor)) break;
            sizeOrig = InventoryUtils.getStackSize(stackCursor);
            InventoryUtils.dragSplitItemsIntoSlots(gui, targetSlots);
            stackCursor = player.field_7514.method_7399();
            if (!InventoryUtils.isStackEmpty(stackCursor)) {
                if (InventoryUtils.getStackSize(stackCursor) >= sizeOrig) break;
                InventoryUtils.leftClickSlot(gui, slotReturn);
                if (!InventoryUtils.isStackEmpty(player.field_7514.method_7399())) {
                    slotReturn = slotNum;
                    InventoryUtils.leftClickSlot(gui, slotReturn);
                }
            }
            if (InventoryUtils.isStackEmpty(player.field_7514.method_7399())) continue;
            break;
        }
        if (slotNum >= 0 && !InventoryUtils.isStackEmpty(player.field_7514.method_7399())) {
            InventoryUtils.leftClickSlot(gui, slotNum);
        }
    }

    public static void rightClickCraftOneStack(class_465<? extends class_1703> gui) {
        class_1735 slot = AccessorUtils.getSlotUnderMouse(gui);
        class_310 mc = class_310.method_1551();
        class_1661 inv = mc.field_1724.field_7514;
        class_1799 stackCursor = inv.method_7399();
        if (slot == null || !slot.method_7681() || !InventoryUtils.isStackEmpty(stackCursor) && !InventoryUtils.areStacksEqual(slot.method_7677(), stackCursor)) {
            return;
        }
        int sizeLast = 0;
        while (true) {
            InventoryUtils.rightClickSlot(gui, slot.field_7874);
            stackCursor = inv.method_7399();
            if (InventoryUtils.isStackEmpty(stackCursor) || InventoryUtils.getStackSize(stackCursor) <= sizeLast || InventoryUtils.getStackSize(stackCursor) >= stackCursor.method_7914() || !InventoryUtils.areStacksEqual(slot.method_7677(), stackCursor)) break;
            sizeLast = InventoryUtils.getStackSize(stackCursor);
        }
    }

    public static void craftEverythingPossibleWithCurrentRecipe(RecipePattern recipe, class_465<? extends class_1703> gui) {
        CraftingHandler.SlotRange range;
        class_1735 slot = CraftingHandler.getFirstCraftingOutputSlotForGui(gui);
        if (slot != null && !InventoryUtils.isStackEmpty(recipe.getResult()) && (range = CraftingHandler.getCraftingGridSlots(gui, slot)) != null) {
            if (!InventoryUtils.clearCraftingGridOfItems(recipe, gui, range, false)) {
                return;
            }
            InventoryUtils.tryMoveItemsToCraftingGridSlots(recipe, slot, gui, true);
            if (slot.method_7681()) {
                InventoryUtils.craftAsManyItemsAsPossible(recipe, slot, gui);
            }
        }
    }

    public static void moveAllCraftingResultsToOtherInventory(RecipePattern recipe, class_465<? extends class_1703> gui) {
        if (!InventoryUtils.isStackEmpty(recipe.getResult())) {
            class_1735 slot = null;
            class_1799 stackResult = recipe.getResult().method_7972();
            for (class_1735 slotTmp : gui.method_17577().field_7761) {
                if (!InventoryUtils.areStacksEqual(slotTmp.method_7677(), stackResult) || !InventoryUtils.inventoryExistsAbove(slotTmp, gui.method_17577())) continue;
                slot = slotTmp;
                break;
            }
            if (slot != null) {
                List<Integer> slots = InventoryUtils.getSlotNumbersOfMatchingStacks(gui.method_17577(), slot, true, stackResult, false, false, false);
                for (int slotNum : slots) {
                    InventoryUtils.shiftClickSlot(gui, slotNum);
                }
            }
        }
    }

    public static void throwAllCraftingResultsToGround(RecipePattern recipe, class_465<? extends class_1703> gui) {
        class_1735 slot = CraftingHandler.getFirstCraftingOutputSlotForGui(gui);
        if (slot != null && !InventoryUtils.isStackEmpty(recipe.getResult())) {
            InventoryUtils.dropStacks(gui, recipe.getResult(), slot, false);
        }
    }

    private static int putSingleItemIntoSlots(class_465<? extends class_1703> gui, List<Integer> targetSlots, int startIndex) {
        int slotNum;
        class_310 mc = class_310.method_1551();
        class_1799 stackInCursor = mc.field_1724.field_7514.method_7399();
        if (InventoryUtils.isStackEmpty(stackInCursor)) {
            return 0;
        }
        int numSlots = gui.method_17577().field_7761.size();
        int numItems = InventoryUtils.getStackSize(stackInCursor);
        int loops = Math.min(numItems, targetSlots.size() - startIndex);
        int count = 0;
        for (int i = 0; i < loops && (slotNum = targetSlots.get(startIndex + i).intValue()) < numSlots; ++i) {
            InventoryUtils.rightClickSlot(gui, slotNum);
            ++count;
        }
        return count;
    }

    public static void moveOneSetOfItemsFromSlotToPlayerInventory(class_465<? extends class_1703> gui, class_1735 slot) {
        List<Integer> slots;
        InventoryUtils.leftClickSlot(gui, slot.field_7874);
        class_310 mc = class_310.method_1551();
        class_1799 stackCursor = mc.field_1724.field_7514.method_7399();
        if (!InventoryUtils.isStackEmpty(stackCursor) && !InventoryUtils.moveItemFromCursorToSlots(gui, slots = InventoryUtils.getSlotNumbersOfMatchingStacks(gui.method_17577(), slot, false, stackCursor, true, true, false))) {
            slots = InventoryUtils.getSlotNumbersOfEmptySlotsInPlayerInventory(gui.method_17577(), false);
            InventoryUtils.moveItemFromCursorToSlots(gui, slots);
        }
    }

    private static void moveOneRecipeItemIntoCraftingGrid(class_465<? extends class_1703> gui, class_1735 slotGridFirst, class_1799 ingredientReference, List<Integer> targetSlots) {
        int filled;
        class_1703 container = gui.method_17577();
        class_310 mc = class_310.method_1551();
        int slotNum = -1;
        int slotCount = targetSlots.size();
        for (int index = 0; index < slotCount && (slotNum = InventoryUtils.getSlotNumberOfSmallestStackFromDifferentInventory(container, slotGridFirst, ingredientReference, slotCount)) >= 0; index += filled) {
            InventoryUtils.leftClickSlot(gui, slotNum);
            if (!InventoryUtils.areStacksEqual(ingredientReference, mc.field_1724.field_7514.method_7399())) break;
            filled = InventoryUtils.putSingleItemIntoSlots(gui, targetSlots, index);
            if (filled >= 1) continue;
            break;
        }
        if (slotNum >= 0 && !InventoryUtils.isStackEmpty(mc.field_1724.field_7514.method_7399())) {
            InventoryUtils.leftClickSlot(gui, slotNum);
        }
    }

    private static boolean moveItemFromCursorToSlots(class_465<? extends class_1703> gui, List<Integer> slotNumbers) {
        class_310 mc = class_310.method_1551();
        class_1661 inv = mc.field_1724.field_7514;
        for (int slotNum : slotNumbers) {
            InventoryUtils.leftClickSlot(gui, slotNum);
            if (!InventoryUtils.isStackEmpty(inv.method_7399())) continue;
            return true;
        }
        return false;
    }

    private static void moveItemsFromInventory(class_465<? extends class_1703> gui, int slotTo, class_1263 invSrc, class_1799 stackTemplate, boolean fillStacks) {
        class_1703 container = gui.method_17577();
        for (class_1735 slot : container.field_7761) {
            if (slot == null || slot.field_7871 != invSrc || !InventoryUtils.areStacksEqual(stackTemplate, slot.method_7677())) continue;
            if (fillStacks) {
                if (InventoryUtils.clickSlotsToMoveItems(gui, slot.field_7874, slotTo)) continue;
                break;
            }
            InventoryUtils.clickSlotsToMoveSingleItem(gui, slot.field_7874, slotTo);
            break;
        }
    }

    private static int getSlotNumberOfLargestMatchingStackFromDifferentInventory(class_1703 container, class_1735 slotReference, class_1799 stackReference) {
        int slotNum = -1;
        int largest = 0;
        for (class_1735 slot : container.field_7761) {
            int stackSize;
            if (InventoryUtils.areSlotsInSameInventory(slot, slotReference) || !slot.method_7681() || !InventoryUtils.areStacksEqual(stackReference, slot.method_7677()) || (stackSize = InventoryUtils.getStackSize(slot.method_7677())) <= largest) continue;
            slotNum = slot.field_7874;
            largest = stackSize;
        }
        return slotNum;
    }

    private static int getSlotNumberOfSmallestStackFromDifferentInventory(class_1703 container, class_1735 slotReference, class_1799 stackReference, int idealSize) {
        int slotNum = -1;
        int smallest = Integer.MAX_VALUE;
        for (class_1735 slot : container.field_7761) {
            int stackSize;
            if (InventoryUtils.areSlotsInSameInventory(slot, slotReference) || !slot.method_7681() || !InventoryUtils.areStacksEqual(stackReference, slot.method_7677()) || (stackSize = InventoryUtils.getStackSize(slot.method_7677())) >= smallest || stackSize < idealSize) continue;
            slotNum = slot.field_7874;
            smallest = stackSize;
        }
        if (slotNum == -1) {
            int largest = 0;
            for (class_1735 slot : container.field_7761) {
                int stackSize;
                if (InventoryUtils.areSlotsInSameInventory(slot, slotReference) || !slot.method_7681() || !InventoryUtils.areStacksEqual(stackReference, slot.method_7677()) || (stackSize = InventoryUtils.getStackSize(slot.method_7677())) <= largest) continue;
                slotNum = slot.field_7874;
                largest = stackSize;
            }
        }
        return slotNum;
    }

    private static List<Integer> getSlotNumbersOfMatchingStacks(class_1703 container, class_1735 slotReference, boolean sameInventory, class_1799 stackReference, boolean preferPartial, boolean treatHotbarAsDifferent, boolean reverse) {
        int i;
        ArrayList<Integer> slots = new ArrayList<Integer>(64);
        int maxSlot = container.field_7761.size() - 1;
        int increment = reverse ? -1 : 1;
        int n = i = reverse ? maxSlot : 0;
        while (i >= 0 && i <= maxSlot) {
            class_1735 slot = container.method_7611(i);
            if (slot != null && slot.method_7681() && InventoryUtils.areSlotsInSameInventory(slot, slotReference, treatHotbarAsDifferent) == sameInventory && InventoryUtils.areStacksEqual(slot.method_7677(), stackReference)) {
                if (InventoryUtils.getStackSize(slot.method_7677()) < stackReference.method_7914() == preferPartial) {
                    slots.add(0, slot.field_7874);
                } else {
                    slots.add(slot.field_7874);
                }
            }
            i += increment;
        }
        return slots;
    }

    private static List<Integer> getSlotNumbersOfMatchingStacks(class_1703 container, class_1799 stackReference, boolean preferPartial) {
        ArrayList<Integer> slots = new ArrayList<Integer>(64);
        int maxSlot = container.field_7761.size() - 1;
        for (int i = 0; i <= maxSlot; ++i) {
            class_1735 slot = container.method_7611(i);
            if (slot == null || !slot.method_7681() || !InventoryUtils.areStacksEqual(slot.method_7677(), stackReference)) continue;
            if (InventoryUtils.getStackSize(slot.method_7677()) < stackReference.method_7914() == preferPartial) {
                slots.add(0, slot.field_7874);
                continue;
            }
            slots.add(slot.field_7874);
        }
        return slots;
    }

    private static List<Integer> getSlotNumbersOfEmptySlots(class_1703 container, class_1735 slotReference, boolean sameInventory, boolean treatHotbarAsDifferent, boolean reverse) {
        int i;
        ArrayList<Integer> slots = new ArrayList<Integer>(64);
        int maxSlot = container.field_7761.size() - 1;
        int increment = reverse ? -1 : 1;
        int n = i = reverse ? maxSlot : 0;
        while (i >= 0 && i <= maxSlot) {
            class_1735 slot = container.method_7611(i);
            if (slot != null && !slot.method_7681() && InventoryUtils.areSlotsInSameInventory(slot, slotReference, treatHotbarAsDifferent) == sameInventory) {
                slots.add(slot.field_7874);
            }
            i += increment;
        }
        return slots;
    }

    private static List<Integer> getSlotNumbersOfEmptySlotsInPlayerInventory(class_1703 container, boolean reverse) {
        int i;
        ArrayList<Integer> slots = new ArrayList<Integer>(64);
        int maxSlot = container.field_7761.size() - 1;
        int increment = reverse ? -1 : 1;
        int n = i = reverse ? maxSlot : 0;
        while (i >= 0 && i <= maxSlot) {
            class_1735 slot = container.method_7611(i);
            if (slot != null && slot.field_7871 instanceof class_1661 && !slot.method_7681()) {
                slots.add(slot.field_7874);
            }
            i += increment;
        }
        return slots;
    }

    public static boolean areStacksEqual(class_1799 stack1, class_1799 stack2) {
        return !stack1.method_7960() && stack1.method_7929(stack2) && class_1799.method_7975((class_1799)stack1, (class_1799)stack2);
    }

    private static boolean areSlotsInSameInventory(class_1735 slot1, class_1735 slot2) {
        return InventoryUtils.areSlotsInSameInventory(slot1, slot2, false);
    }

    private static boolean areSlotsInSameInventory(class_1735 slot1, class_1735 slot2, boolean treatHotbarAsDifferent) {
        if (slot1.field_7871 == slot2.field_7871) {
            if (treatHotbarAsDifferent && slot1.field_7871 instanceof class_1661) {
                int index1 = AccessorUtils.getSlotIndex(slot1);
                int index2 = AccessorUtils.getSlotIndex(slot2);
                return index1 == 40 || index2 == 40 || index1 < 9 == index2 < 9;
            }
            return true;
        }
        return false;
    }

    private static class_1799[] getOriginalStacks(class_1703 container) {
        class_1799[] originalStacks = new class_1799[container.field_7761.size()];
        for (int i = 0; i < originalStacks.length; ++i) {
            originalStacks[i] = ((class_1735)container.field_7761.get(i)).method_7677().method_7972();
        }
        return originalStacks;
    }

    private static void restoreOriginalStacks(class_1703 container, class_1799[] originalStacks) {
        for (int i = 0; i < originalStacks.length; ++i) {
            class_1799 stackSlot = container.method_7611(i).method_7677();
            if (InventoryUtils.areStacksEqual(stackSlot, originalStacks[i]) && (InventoryUtils.isStackEmpty(stackSlot) || InventoryUtils.getStackSize(stackSlot) == InventoryUtils.getStackSize(originalStacks[i]))) continue;
            container.method_7619(i, originalStacks[i]);
        }
    }

    private static int getTargetSlot(class_1703 container, class_1799[] originalStacks) {
        List slots = container.field_7761;
        for (int i = 0; i < originalStacks.length; ++i) {
            class_1799 stackOrig = originalStacks[i];
            class_1799 stackNew = ((class_1735)slots.get(i)).method_7677();
            if ((!InventoryUtils.isStackEmpty(stackOrig) || InventoryUtils.isStackEmpty(stackNew)) && (InventoryUtils.isStackEmpty(stackOrig) || InventoryUtils.isStackEmpty(stackNew) || InventoryUtils.getStackSize(stackNew) != InventoryUtils.getStackSize(stackOrig) + 1)) continue;
            return i;
        }
        return -1;
    }

    private static void clickSlotsToMoveItemsFromSlot(class_1735 slotFrom, class_465<? extends class_1703> gui, boolean toOtherInventory) {
        class_310 mc = class_310.method_1551();
        class_746 player = mc.field_1724;
        InventoryUtils.leftClickSlot(gui, slotFrom.field_7874);
        if (InventoryUtils.isStackEmpty(player.field_7514.method_7399())) {
            return;
        }
        for (class_1735 slotDst : gui.method_17577().field_7761) {
            class_1799 stackDst = slotDst.method_7677();
            if (InventoryUtils.areSlotsInSameInventory(slotDst, slotFrom) != toOtherInventory && (InventoryUtils.isStackEmpty(stackDst) || InventoryUtils.areStacksEqual(stackDst, player.field_7514.method_7399()))) {
                InventoryUtils.leftClickSlot(gui, slotDst.field_7874);
            }
            if (!InventoryUtils.isStackEmpty(player.field_7514.method_7399())) continue;
            return;
        }
        if (!InventoryUtils.isStackEmpty(player.field_7514.method_7399())) {
            InventoryUtils.leftClickSlot(gui, slotFrom.field_7874);
        }
    }

    private static boolean clickSlotsToMoveSingleItem(class_465<? extends class_1703> gui, int slotFrom, int slotTo) {
        class_310 mc = class_310.method_1551();
        class_1799 stack = ((class_1735)gui.method_17577().field_7761.get(slotFrom)).method_7677();
        if (InventoryUtils.isStackEmpty(stack)) {
            return false;
        }
        if (InventoryUtils.getStackSize(stack) > 1) {
            InventoryUtils.rightClickSlot(gui, slotFrom);
        } else {
            InventoryUtils.leftClickSlot(gui, slotFrom);
        }
        InventoryUtils.rightClickSlot(gui, slotTo);
        if (!InventoryUtils.isStackEmpty(mc.field_1724.field_7514.method_7399())) {
            InventoryUtils.leftClickSlot(gui, slotFrom);
        }
        return true;
    }

    private static boolean clickSlotsToMoveSingleItemByShiftClick(class_465<? extends class_1703> gui, int slotFrom) {
        class_310 mc = class_310.method_1551();
        class_1735 slot = (class_1735)gui.method_17577().field_7761.get(slotFrom);
        class_1799 stack = slot.method_7677();
        if (InventoryUtils.isStackEmpty(stack)) {
            return false;
        }
        if (InventoryUtils.getStackSize(stack) > 1) {
            InventoryUtils.leftClickSlot(gui, slotFrom);
            if (slot.method_7681()) {
                InventoryUtils.leftClickSlot(gui, slotFrom);
                return false;
            }
            InventoryUtils.rightClickSlot(gui, slotFrom);
        }
        InventoryUtils.shiftClickSlot(gui, slotFrom);
        if (!InventoryUtils.isStackEmpty(mc.field_1724.field_7514.method_7399())) {
            InventoryUtils.leftClickSlot(gui, slotFrom);
        }
        return true;
    }

    private static boolean clickSlotsToMoveItems(class_465<? extends class_1703> gui, int slotFrom, int slotTo) {
        class_310 mc = class_310.method_1551();
        class_746 player = mc.field_1724;
        InventoryUtils.leftClickSlot(gui, slotFrom);
        if (InventoryUtils.isStackEmpty(player.field_7514.method_7399())) {
            return false;
        }
        boolean ret = true;
        int size = InventoryUtils.getStackSize(player.field_7514.method_7399());
        InventoryUtils.leftClickSlot(gui, slotTo);
        if (!InventoryUtils.isStackEmpty(player.field_7514.method_7399())) {
            ret = InventoryUtils.getStackSize(player.field_7514.method_7399()) != size;
            InventoryUtils.leftClickSlot(gui, slotFrom);
        }
        return ret;
    }

    public static void dropStacksUntilEmpty(class_465<? extends class_1703> gui, int slotNum) {
        if (slotNum >= 0 && slotNum < gui.method_17577().field_7761.size()) {
            class_1735 slot = gui.method_17577().method_7611(slotNum);
            int failsafe = 64;
            while (failsafe-- > 0 && slot.method_7681()) {
                InventoryUtils.dropStack(gui, slotNum);
            }
        }
    }

    public static void dropStacksWhileHasItem(class_465<? extends class_1703> gui, int slotNum, class_1799 stackReference) {
        if (slotNum >= 0 && slotNum < gui.method_17577().field_7761.size()) {
            class_1735 slot = gui.method_17577().method_7611(slotNum);
            int failsafe = 256;
            while (failsafe-- > 0 && InventoryUtils.areStacksEqual(slot.method_7677(), stackReference)) {
                InventoryUtils.dropStack(gui, slotNum);
            }
        }
    }

    private static boolean shiftClickSlotWithCheck(class_465<? extends class_1703> gui, int slotNum) {
        class_1735 slot = gui.method_17577().method_7611(slotNum);
        if (slot == null || !slot.method_7681()) {
            return false;
        }
        int sizeOrig = InventoryUtils.getStackSize(slot.method_7677());
        InventoryUtils.shiftClickSlot(gui, slotNum);
        return !slot.method_7681() || InventoryUtils.getStackSize(slot.method_7677()) != sizeOrig;
    }

    public static boolean tryMoveItemsVertically(class_465<? extends class_1703> gui, class_1735 slot, boolean moveUp, MoveAmount amount) {
        class_310 mc = class_310.method_1551();
        if (slot == null || !InventoryUtils.isStackEmpty(mc.field_1724.field_7514.method_7399())) {
            return false;
        }
        List<Integer> slots = InventoryUtils.getVerticallyFurthestSuitableSlotsForStackInSlot(gui.method_17577(), slot, moveUp);
        if (slots.isEmpty()) {
            return false;
        }
        if (amount == MoveAmount.FULL_STACKS) {
            InventoryUtils.moveStackToSlots(gui, slot, slots, false);
        } else if (amount == MoveAmount.MOVE_ONE) {
            InventoryUtils.moveOneItemToFirstValidSlot(gui, slot, slots);
        } else if (amount == MoveAmount.LEAVE_ONE) {
            InventoryUtils.moveStackToSlots(gui, slot, slots, true);
        } else if (amount == MoveAmount.ALL_MATCHING) {
            InventoryUtils.moveMatchingStacksToSlots(gui, slot, moveUp);
        }
        return true;
    }

    private static void moveMatchingStacksToSlots(class_465<? extends class_1703> gui, class_1735 slot, boolean moveUp) {
        List<Integer> matchingSlots = InventoryUtils.getSlotNumbersOfMatchingStacks(gui.method_17577(), slot, true, slot.method_7677(), true, true, false);
        List<Integer> targetSlots = InventoryUtils.getSlotNumbersOfEmptySlots(gui.method_17577(), slot, false, true, false);
        targetSlots.addAll(InventoryUtils.getSlotNumbersOfEmptySlots(gui.method_17577(), slot, true, true, false));
        targetSlots.addAll(matchingSlots);
        Collections.sort(matchingSlots, new SlotVerticalSorterSlotNumbers(gui.method_17577(), !moveUp));
        Collections.sort(targetSlots, new SlotVerticalSorterSlotNumbers(gui.method_17577(), moveUp));
        for (int i = 0; i < matchingSlots.size(); ++i) {
            int srcSlotNum = matchingSlots.get(i);
            class_1735 srcSlot = gui.method_17577().method_7611(srcSlotNum);
            class_1735 lastSlot = InventoryUtils.moveStackToSlots(gui, srcSlot, targetSlots, false);
            if (lastSlot != null && lastSlot.field_7874 != srcSlot.field_7874 && lastSlot.field_7872 > srcSlot.field_7872 != moveUp) continue;
            return;
        }
    }

    private static class_1735 moveStackToSlots(class_465<? extends class_1703> gui, class_1735 slotFrom, List<Integer> slotsTo, boolean leaveOne) {
        class_310 mc = class_310.method_1551();
        class_1661 inv = mc.field_1724.field_7514;
        class_1735 lastSlot = null;
        if (!slotFrom.method_7681()) {
            return null;
        }
        InventoryUtils.leftClickSlot(gui, slotFrom.field_7874);
        if (leaveOne) {
            InventoryUtils.rightClickSlot(gui, slotFrom.field_7874);
        }
        for (int slotNum : slotsTo) {
            if (InventoryUtils.isStackEmpty(inv.method_7399())) break;
            class_1735 dstSlot = gui.method_17577().method_7611(slotNum);
            if (!dstSlot.method_7680(inv.method_7399()) || dstSlot.method_7681() && !InventoryUtils.areStacksEqual(dstSlot.method_7677(), inv.method_7399())) continue;
            InventoryUtils.leftClickSlot(gui, slotNum);
            lastSlot = dstSlot;
        }
        if (!InventoryUtils.isStackEmpty(inv.method_7399())) {
            InventoryUtils.leftClickSlot(gui, slotFrom.field_7874);
        }
        return lastSlot;
    }

    private static void moveOneItemToFirstValidSlot(class_465<? extends class_1703> gui, class_1735 slotFrom, List<Integer> slotsTo) {
        class_310 mc = class_310.method_1551();
        class_1661 inv = mc.field_1724.field_7514;
        InventoryUtils.rightClickSlot(gui, slotFrom.field_7874);
        if (InventoryUtils.isStackEmpty(inv.method_7399())) {
            return;
        }
        int sizeOrig = InventoryUtils.getStackSize(inv.method_7399());
        for (int slotNum : slotsTo) {
            InventoryUtils.rightClickSlot(gui, slotNum);
            class_1799 stackCursor = inv.method_7399();
            if (!InventoryUtils.isStackEmpty(stackCursor) && InventoryUtils.getStackSize(stackCursor) == sizeOrig) continue;
            break;
        }
        if (!InventoryUtils.isStackEmpty(inv.method_7399())) {
            InventoryUtils.leftClickSlot(gui, slotFrom.field_7874);
        }
    }

    private static List<Integer> getVerticallyFurthestSuitableSlotsForStackInSlot(class_1703 container, class_1735 slotIn, boolean above) {
        if (slotIn == null || !slotIn.method_7681()) {
            return Collections.emptyList();
        }
        ArrayList<Integer> slotNumbers = new ArrayList<Integer>();
        class_1799 stackSlot = slotIn.method_7677();
        for (class_1735 slotTmp : container.field_7761) {
            class_1799 stackTmp;
            if (slotTmp.field_7874 == slotIn.field_7874 || slotTmp.field_7872 == slotIn.field_7872 || above != slotTmp.field_7872 < slotIn.field_7872 || (!InventoryUtils.isStackEmpty(stackTmp = slotTmp.method_7677()) || !slotTmp.method_7680(stackSlot)) && (!InventoryUtils.areStacksEqual(stackTmp, stackSlot) || slotTmp.method_7676(stackTmp) <= InventoryUtils.getStackSize(stackTmp))) continue;
            slotNumbers.add(slotTmp.field_7874);
        }
        Collections.sort(slotNumbers, new SlotVerticalSorterSlotNumbers(container, above));
        return slotNumbers;
    }

    public static void tryClearCursor(class_465<? extends class_1703> gui, class_310 mc) {
        class_1799 stackCursor = mc.field_1724.field_7514.method_7399();
        if (!InventoryUtils.isStackEmpty(stackCursor)) {
            List<Integer> emptySlots = InventoryUtils.getSlotNumbersOfEmptySlotsInPlayerInventory(gui.method_17577(), false);
            if (!emptySlots.isEmpty()) {
                InventoryUtils.leftClickSlot(gui, emptySlots.get(0));
            } else {
                List<Integer> matchingSlots = InventoryUtils.getSlotNumbersOfMatchingStacks(gui.method_17577(), stackCursor, true);
                if (!matchingSlots.isEmpty()) {
                    for (int slotNum : matchingSlots) {
                        class_1735 slot = gui.method_17577().method_7611(slotNum);
                        class_1799 stackSlot = slot.method_7677();
                        if (slot == null || !InventoryUtils.areStacksEqual(stackSlot, stackCursor) || InventoryUtils.getStackSize(stackSlot) >= stackCursor.method_7914()) break;
                        InventoryUtils.leftClickSlot(gui, slotNum);
                        stackCursor = mc.field_1724.field_7514.method_7399();
                    }
                }
            }
        }
        if (!InventoryUtils.isStackEmpty(mc.field_1724.field_7514.method_7399())) {
            InventoryUtils.dropItemsFromCursor(gui);
        }
    }

    public static void resetLastSlotNumber() {
        slotNumberLast = -1;
    }

    public static MoveAction getActiveMoveAction() {
        return activeMoveAction;
    }

    public static void clickSlot(class_465<? extends class_1703> gui, int slotNum, int mouseButton, class_1713 type) {
        if (slotNum >= 0 && slotNum < gui.method_17577().field_7761.size()) {
            class_1735 slot = gui.method_17577().method_7611(slotNum);
            InventoryUtils.clickSlot(gui, slot, slotNum, mouseButton, type);
        } else {
            try {
                class_310 mc = class_310.method_1551();
                mc.field_1761.method_2906(gui.method_17577().field_7763, slotNum, mouseButton, type, (class_1657)mc.field_1724);
            }
            catch (Exception e) {
                ItemScroller.logger.warn("Exception while emulating a slot click: gui: '{}', slotNum: {}, mouseButton; {}, SlotActionType: {}", (Object)gui.getClass().getName(), (Object)slotNum, (Object)mouseButton, (Object)type, (Object)e);
            }
        }
    }

    public static void clickSlot(class_465<? extends class_1703> gui, class_1735 slot, int slotNum, int mouseButton, class_1713 type) {
        try {
            AccessorUtils.handleMouseClick(gui, slot, slotNum, mouseButton, type);
        }
        catch (Exception e) {
            ItemScroller.logger.warn("Exception while emulating a slot click: gui: '{}', slotNum: {}, mouseButton; {}, SlotActionType: {}", (Object)gui.getClass().getName(), (Object)slotNum, (Object)mouseButton, (Object)type, (Object)e);
        }
    }

    public static void leftClickSlot(class_465<? extends class_1703> gui, class_1735 slot, int slotNumber) {
        InventoryUtils.clickSlot(gui, slot, slotNumber, 0, class_1713.field_7790);
    }

    public static void rightClickSlot(class_465<? extends class_1703> gui, class_1735 slot, int slotNumber) {
        InventoryUtils.clickSlot(gui, slot, slotNumber, 1, class_1713.field_7790);
    }

    public static void shiftClickSlot(class_465<? extends class_1703> gui, class_1735 slot, int slotNumber) {
        InventoryUtils.clickSlot(gui, slot, slotNumber, 0, class_1713.field_7794);
    }

    public static void leftClickSlot(class_465<? extends class_1703> gui, int slotNum) {
        InventoryUtils.clickSlot(gui, slotNum, 0, class_1713.field_7790);
    }

    public static void rightClickSlot(class_465<? extends class_1703> gui, int slotNum) {
        InventoryUtils.clickSlot(gui, slotNum, 1, class_1713.field_7790);
    }

    public static void shiftClickSlot(class_465<? extends class_1703> gui, int slotNum) {
        InventoryUtils.clickSlot(gui, slotNum, 0, class_1713.field_7794);
    }

    public static void dropItemsFromCursor(class_465<? extends class_1703> gui) {
        InventoryUtils.clickSlot(gui, -999, 0, class_1713.field_7790);
    }

    public static void dropItem(class_465<? extends class_1703> gui, int slotNum) {
        InventoryUtils.clickSlot(gui, slotNum, 0, class_1713.field_7795);
    }

    public static void dropStack(class_465<? extends class_1703> gui, int slotNum) {
        InventoryUtils.clickSlot(gui, slotNum, 1, class_1713.field_7795);
    }

    public static void swapSlots(class_465<? extends class_1703> gui, int slotNum, int otherSlot) {
        InventoryUtils.clickSlot(gui, slotNum, 0, class_1713.field_7791);
        InventoryUtils.clickSlot(gui, otherSlot, 0, class_1713.field_7791);
        InventoryUtils.clickSlot(gui, slotNum, 0, class_1713.field_7791);
    }

    private static void dragSplitItemsIntoSlots(class_465<? extends class_1703> gui, List<Integer> targetSlots) {
        int slotNum;
        class_310 mc = class_310.method_1551();
        class_1799 stackInCursor = mc.field_1724.field_7514.method_7399();
        if (InventoryUtils.isStackEmpty(stackInCursor)) {
            return;
        }
        if (targetSlots.size() == 1) {
            InventoryUtils.leftClickSlot(gui, targetSlots.get(0));
            return;
        }
        int numSlots = gui.method_17577().field_7761.size();
        int loops = targetSlots.size();
        InventoryUtils.clickSlot(gui, -999, 0, class_1713.field_7789);
        for (int i = 0; i < loops && (slotNum = targetSlots.get(i).intValue()) < numSlots; ++i) {
            InventoryUtils.clickSlot(gui, targetSlots.get(i), 1, class_1713.field_7789);
        }
        InventoryUtils.clickSlot(gui, -999, 2, class_1713.field_7789);
    }

    public static boolean isStackEmpty(class_1799 stack) {
        return stack.method_7960();
    }

    public static int getStackSize(class_1799 stack) {
        return stack.method_7947();
    }

    public static void setStackSize(class_1799 stack, int size) {
        stack.method_7939(size);
    }

    static {
        DRAGGED_SLOTS = new HashSet<Integer>();
        sourceSlotCandidate = null;
        sourceSlot = null;
        stackInCursorLast = class_1799.field_8037;
        EMPTY_STACK = class_1799.field_8037;
    }

    private static class SlotVerticalSorterSlotNumbers
    implements Comparator<Integer> {
        private final class_1703 container;
        private final boolean topToBottom;

        public SlotVerticalSorterSlotNumbers(class_1703 container, boolean topToBottom) {
            this.container = container;
            this.topToBottom = topToBottom;
        }

        @Override
        public int compare(Integer slotNum1, Integer slotNum2) {
            class_1735 slot1 = this.container.method_7611(slotNum1.intValue());
            class_1735 slot2 = this.container.method_7611(slotNum2.intValue());
            if (slot1.field_7872 == slot2.field_7872) {
                return slot1.field_7874 < slot2.field_7874 == this.topToBottom ? -1 : 1;
            }
            return slot1.field_7872 < slot2.field_7872 == this.topToBottom ? -1 : 1;
        }
    }
}

