/*
 * Decompiled with CFR 0.152.
 */
package de.guntram.mcmod.durabilityviewer.handler;

import de.guntram.mcmod.durabilityviewer.client.gui.Corner;
import de.guntram.mcmod.fabrictools.ConfigChangedEvent;
import de.guntram.mcmod.fabrictools.Configuration;
import de.guntram.mcmod.fabrictools.ModConfigurationHandler;
import java.io.File;
import net.minecraft.class_124;

public class ConfigurationHandler
implements ModConfigurationHandler {
    private static ConfigurationHandler instance;
    private Configuration config;
    private class_124 tooltipColor;
    private String configFileName;
    private int corner = 0;
    private int color = 5;
    private boolean effectDuration;
    private int minPercent = 10;
    private int minDurability = 100;
    private boolean showPlayerServerName;
    private boolean useCustomSound;
    private int showDamageOverPercent;
    private boolean armorAroundHotbar;
    private boolean showChestIcon;
    private boolean showAllTrinkets;

    public static ConfigurationHandler getInstance() {
        if (instance == null) {
            instance = new ConfigurationHandler();
        }
        return instance;
    }

    public void load(File configFile) {
        if (this.config == null) {
            this.config = new Configuration(configFile);
            this.configFileName = configFile.getPath();
            this.loadConfig();
        }
    }

    public static String getConfigFileName() {
        return ConfigurationHandler.getInstance().configFileName;
    }

    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("Durability Viewer")) {
            this.loadConfig();
        }
    }

    private void loadConfig() {
        this.corner = this.config.getInt("HUD Corner", 0, this.corner, 0, 3, "Corner 0 to 3 - bottom right, bottom left, top right, top left");
        this.armorAroundHotbar = this.config.getBoolean("Armor around hotbar", 0, this.armorAroundHotbar, "Render armor around hotbar (instead of with tools)");
        this.color = this.config.getInt("Tooltip Color", 0, this.color, 0, 15, "Minecraft Color 0 .. 15");
        this.effectDuration = this.config.getBoolean("Effect Duration", 0, true, "Show effect durations");
        this.minPercent = this.config.getInt("Minimum Percent", 0, this.minPercent, 1, 100, "Play sound when durability below X percent");
        this.minDurability = this.config.getInt("Minimum Durability", 0, this.minDurability, 1, 1500, "Play sound when durability below X");
        this.showPlayerServerName = this.config.getBoolean("Set window title", 0, true, "Set window title to player and server name");
        this.showDamageOverPercent = this.config.getInt("Percent to show damage", 0, 80, 0, 100, "Show damage instead of durability while the item is still better than this %");
        this.showChestIcon = this.config.getBoolean("Show chest icon", 0, true, "Show chest icon with number of free inventory slots");
        this.showAllTrinkets = this.config.getBoolean("Show all trinkets", 0, true, "If you have the trinkets mod, show all trinkets even when they don't have durability/damage");
        this.tooltipColor = class_124.method_534((int)this.color);
        if (this.config.hasChanged()) {
            this.config.save();
        }
    }

    public static class_124 getTooltipColor() {
        return ConfigurationHandler.getInstance().tooltipColor;
    }

    public static Corner getCorner() {
        return Corner.values()[ConfigurationHandler.getInstance().corner];
    }

    public Configuration getConfig() {
        return ConfigurationHandler.getInstance().config;
    }

    public static boolean showEffectDuration() {
        return ConfigurationHandler.getInstance().effectDuration;
    }

    public static int getMinPercent() {
        return ConfigurationHandler.getInstance().minPercent;
    }

    public static int getMinDurability() {
        return ConfigurationHandler.getInstance().minDurability;
    }

    public static boolean showPlayerServerName() {
        return ConfigurationHandler.getInstance().showPlayerServerName;
    }

    public static int showDamageOverPercent() {
        return ConfigurationHandler.getInstance().showDamageOverPercent;
    }

    public static boolean getArmorAroundHotbar() {
        return ConfigurationHandler.getInstance().armorAroundHotbar;
    }

    public static boolean getShowChestIcon() {
        return ConfigurationHandler.getInstance().showChestIcon;
    }

    public static boolean getShowAllTrinkets() {
        return ConfigurationHandler.getInstance().showAllTrinkets;
    }

    public static boolean useCustomSound() {
        return false;
    }
}

