/*
 * Decompiled with CFR 0.152.
 */
package io.github.jsnimda.inventoryprofiles.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import fi.dy.masa.malilib.config.ConfigUtils;
import fi.dy.masa.malilib.config.IConfigHandler;
import fi.dy.masa.malilib.util.FileUtils;
import fi.dy.masa.malilib.util.JsonUtils;
import io.github.jsnimda.inventoryprofiles.config.Configs;
import java.io.File;

public class ConfigHandler
implements IConfigHandler {
    private static final String CONFIG_FILE_NAME = "inventoryprofiles.json";

    public static File getConfigDirectory() {
        return new File(FileUtils.getConfigDirectory(), "inventoryprofiles");
    }

    public static void loadFromFile() {
        JsonElement element;
        File configFile = new File(ConfigHandler.getConfigDirectory(), CONFIG_FILE_NAME);
        if (configFile.exists() && configFile.isFile() && configFile.canRead() && (element = JsonUtils.parseJsonFile((File)configFile)) != null && element.isJsonObject()) {
            JsonObject root = element.getAsJsonObject();
            ConfigUtils.readConfigBase((JsonObject)root, (String)"Generic", Configs.Generic.LIST);
            ConfigUtils.readHotkeyToggleOptions((JsonObject)root, (String)"TweaksHotkeys", (String)"TweaksValues", Configs.Tweaks.LIST);
            ConfigUtils.readConfigBase((JsonObject)root, (String)"AdvancedOptions", Configs.AdvancedOptions.LIST);
        }
    }

    public static void saveToFile() {
        File dir = ConfigHandler.getConfigDirectory();
        if (dir.exists() && dir.isDirectory() || dir.mkdirs()) {
            JsonObject root = new JsonObject();
            ConfigUtils.writeConfigBase((JsonObject)root, (String)"Generic", Configs.Generic.LIST);
            ConfigUtils.writeHotkeyToggleOptions((JsonObject)root, (String)"TweaksHotkeys", (String)"TweaksValues", Configs.Tweaks.LIST);
            ConfigUtils.writeConfigBase((JsonObject)root, (String)"AdvancedOptions", Configs.AdvancedOptions.LIST);
            JsonUtils.writeJsonToFile((JsonObject)root, (File)new File(dir, CONFIG_FILE_NAME));
        }
    }

    public void load() {
        ConfigHandler.loadFromFile();
    }

    public void save() {
        ConfigHandler.saveToFile();
    }
}

