/*
 * Decompiled with CFR 0.152.
 */
package io.github.jsnimda.inventoryprofiles.config;

import fi.dy.masa.malilib.config.IConfigBase;
import fi.dy.masa.malilib.config.IConfigOptionListEntry;
import fi.dy.masa.malilib.config.IHotkeyTogglable;
import fi.dy.masa.malilib.config.options.ConfigBoolean;
import fi.dy.masa.malilib.config.options.ConfigBooleanHotkeyed;
import fi.dy.masa.malilib.config.options.ConfigHotkey;
import fi.dy.masa.malilib.config.options.ConfigInteger;
import fi.dy.masa.malilib.config.options.ConfigOptionList;
import fi.dy.masa.malilib.hotkeys.IHotkey;
import fi.dy.masa.malilib.hotkeys.KeyAction;
import fi.dy.masa.malilib.hotkeys.KeybindSettings;
import io.github.jsnimda.inventoryprofiles.sorter.predefined.SortingMethodOption;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class Configs {
    public static final KeybindSettings GUI_ALLOW_EXTRA = KeybindSettings.create((KeybindSettings.Context)KeybindSettings.Context.GUI, (KeyAction)KeyAction.PRESS, (boolean)true, (boolean)true, (boolean)false, (boolean)true);
    public static final String TRANSLATION_KEY_COMMENT_PREFIX = "inventoryprofiles.config.comment.";
    public static final String TRANSLATION_KEY_PRETTYNAME_PREFIX = "inventoryprofiles.config.prettyname.";

    public static Cfg as(String name) {
        return new Cfg(name);
    }

    private static class Cfg {
        public static List<IConfigBase> list = new ArrayList<IConfigBase>();
        String name;
        String comment;
        String prettyName;

        public static <T> List<T> listAs(Class<T> clazz) {
            return list.stream().filter(clazz::isInstance).map(clazz::cast).collect(Collectors.toList());
        }

        public static void flush() {
            list = new ArrayList<IConfigBase>();
        }

        public Cfg(String name) {
            this.name = name;
            this.comment = Configs.TRANSLATION_KEY_COMMENT_PREFIX + name;
            this.prettyName = name;
        }

        public ConfigHotkey hotkey(String defaultStorageString) {
            return (ConfigHotkey)this.add((IConfigBase)new ConfigHotkey(this.name, defaultStorageString, this.comment, this.prettyName));
        }

        public ConfigHotkey hotkey(String defaultStorageString, KeybindSettings settings) {
            return (ConfigHotkey)this.add((IConfigBase)new ConfigHotkey(this.name, defaultStorageString, settings, this.comment, this.prettyName));
        }

        public ConfigBoolean bool(boolean defaultValue) {
            return (ConfigBoolean)this.add((IConfigBase)new ConfigBoolean(this.name, defaultValue, this.comment, this.prettyName));
        }

        public ConfigBooleanHotkeyed hotkeyedBool(boolean defaultValue, String defaultHotkey) {
            return (ConfigBooleanHotkeyed)this.add((IConfigBase)new ConfigBooleanHotkeyed(this.name, defaultValue, defaultHotkey, this.comment, this.prettyName));
        }

        public ConfigInteger integer(int defaultValue, int minValue, int maxValue) {
            return (ConfigInteger)this.add((IConfigBase)new ConfigInteger(this.name, defaultValue, minValue, maxValue, this.comment));
        }

        public IConfigBase add(IConfigBase ele) {
            list.add(ele);
            return ele;
        }
    }

    public static class AdvancedOptions {
        public static final ConfigBoolean ADD_INTERVAL_BETWEEN_CLICKS = Configs.as("addIntervalBetweenClicks").bool(false);
        public static final ConfigInteger INTERVAL_BETWEEN_CLICKS_MS = Configs.as("intervalBetweenClicksMs").integer(10, 1, 500);
        public static final ConfigBoolean SORT_RESTOCK_HOTBAR = Configs.as("sortRestockHotbar").bool(true);
        public static final ConfigBoolean SHOW_INVENTORY_BUTTON_TOOLTIPS = Configs.as("showInventoryButtonTooltips").bool(true);
        public static final ConfigBoolean INVENTORY_SHOW_PROFILE_BUTTONS = Configs.as("inventoryShowProfileButtons").bool(true);
        public static final ConfigBoolean INVENTORY_SHOW_SORT_BUTTONS = Configs.as("inventoryShowSortButtons").bool(true);
        public static final ConfigBoolean INVENTORY_SHOW_MOVE_ALL_BUTTONS = Configs.as("inventoryShowMoveAllButtons").bool(true);
        public static final ConfigBoolean SORT_CURSOR_POINTING = Configs.as("sortCursorPointing").bool(false);
        public static final ConfigBoolean STOP_CLICKING_IF_GUI_CLOSE = Configs.as("stopClickingIfGuiClose").bool(false);
        public static final ConfigBoolean DEBUG_LOGS = Configs.as("debugLogs").bool(false);
        public static final List<IConfigBase> LIST = Cfg.list;

        static {
            Cfg.flush();
        }
    }

    public static class Tweaks {
        public static final ConfigBooleanHotkeyed INSTANT_MINING_COOLDOWN = Configs.as("instantMiningCooldown").hotkeyedBool(false, "");
        public static final ConfigBooleanHotkeyed DISABLE_BLOCK_BREAKING_COOLDOWN = Configs.as("disableBlockBreakingCooldown").hotkeyedBool(false, "");
        public static final ConfigBooleanHotkeyed DISABLE_ITEM_USE_COOLDOWN = Configs.as("disableItemUseCooldown").hotkeyedBool(false, "");
        public static final ConfigBooleanHotkeyed PREVENT_CLOSE_GUI_DROP_ITEM = Configs.as("preventCloseGuiDropItem").hotkeyedBool(false, "");
        public static final ConfigBooleanHotkeyed DISABLE_SCREEN_SHAKING_ON_DAMAGE = Configs.as("disbleScreenShakingOnDamage").hotkeyedBool(false, "");
        public static final ConfigBooleanHotkeyed DISABLE_LAVA_FOG = Configs.as("disableLavaFog").hotkeyedBool(false, "");
        public static final List<IHotkeyTogglable> LIST = Cfg.listAs(IHotkeyTogglable.class);

        static {
            Cfg.flush();
        }
    }

    public static class Generic {
        public static final ConfigHotkey OPEN_CONFIG_GUI = Configs.as("openConfigGui").hotkey("R,C");
        public static final ConfigOptionList SORTING_METHOD = new ConfigOptionList("sortingMethod", (IConfigOptionListEntry)SortingMethodOption.DEFAULT, "inventoryprofiles.config.comment.sortingMethod");
        public static final ConfigHotkey SORT_INVENTORY;
        public static final ConfigHotkey SORT_INVENTORY_BY_GROUP_COLUMNS;
        public static final ConfigHotkey SORT_INVENTORY_BY_GROUP_ROWS;
        public static final ConfigBoolean ENABLE_SWITCH_PROFILE_HOTKEY;
        public static final ConfigHotkey SWITCH_PROFILE;
        public static final ConfigHotkey MOVE_ALL_CONTAINER_EXISTING_ITEMS;
        public static final List<IConfigBase> LIST;
        public static final List<IHotkey> HOTKEY_LIST;

        static {
            Cfg.list.add((IConfigBase)SORTING_METHOD);
            SORT_INVENTORY = Configs.as("sortInventory").hotkey("R", GUI_ALLOW_EXTRA);
            SORT_INVENTORY_BY_GROUP_COLUMNS = Configs.as("sortInventoryByGroupColumns").hotkey("", GUI_ALLOW_EXTRA);
            SORT_INVENTORY_BY_GROUP_ROWS = Configs.as("sortInventoryByGroupRows").hotkey("", GUI_ALLOW_EXTRA);
            ENABLE_SWITCH_PROFILE_HOTKEY = Configs.as("enableSwitchProfileHoykey").bool(false);
            SWITCH_PROFILE = Configs.as("switchProfile").hotkey("R", KeybindSettings.RELEASE_ALLOW_EXTRA);
            MOVE_ALL_CONTAINER_EXISTING_ITEMS = Configs.as("moveAllContainerExistingItems").hotkey("", GUI_ALLOW_EXTRA);
            LIST = Cfg.list;
            HOTKEY_LIST = Cfg.listAs(IHotkey.class);
            Cfg.flush();
        }
    }
}

