/*
 * Decompiled with CFR 0.152.
 */
package io.github.jsnimda.inventoryprofiles.config;

import io.github.jsnimda.inventoryprofiles.sorter.util.Current;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ProfileSet {
    public static final HashMap<String, Integer> SLOT_MAP;
    public final String profileName;
    public final Map<String, String> options = new HashMap<String, String>();
    public final List<Profile> profiles = new ArrayList<Profile>();

    public static int getSlotId(String slotName) {
        if ("weapon.mainhand".equals(slotName)) {
            return 36 + Current.selectedSlot();
        }
        return SLOT_MAP.get(slotName);
    }

    public static boolean isValidSlotName(String slotName) {
        return "weapon.mainhand".equals(slotName) || SLOT_MAP.containsKey(slotName);
    }

    public void addOption(String key, String value) {
        this.options.put(key, value);
    }

    public Profile addProfile() {
        Profile p = new Profile();
        this.profiles.add(p);
        return p;
    }

    public ProfileSet(String profileName) {
        this.profileName = profileName;
    }

    static {
        int i;
        SLOT_MAP = new HashMap();
        SLOT_MAP.put("armor.head", 5);
        SLOT_MAP.put("armor.chest", 6);
        SLOT_MAP.put("armor.legs", 7);
        SLOT_MAP.put("armor.feet", 8);
        for (i = 0; i < 27; ++i) {
            SLOT_MAP.put("inventory." + i, 9 + i);
        }
        for (i = 0; i < 9; ++i) {
            SLOT_MAP.put("hotbar." + i, 36 + i);
        }
        SLOT_MAP.put("weapon.offhand", 45);
    }

    public static class ProfilePreferenceEntry {
        public final String slotName;
        public final String items;

        public ProfilePreferenceEntry(String slotName, String items) {
            this.slotName = slotName;
            this.items = items;
        }
    }

    public static class Profile {
        public final List<ProfilePreferenceEntry> preferences = new ArrayList<ProfilePreferenceEntry>();

        public void addPreference(String slotName, String items) {
            this.preferences.add(new ProfilePreferenceEntry(slotName, items));
        }
    }
}

