/*
 * Decompiled with CFR 0.152.
 */
package io.github.jsnimda.inventoryprofiles.config;

import io.github.jsnimda.inventoryprofiles.Log;
import io.github.jsnimda.inventoryprofiles.config.IndentParser;
import io.github.jsnimda.inventoryprofiles.config.ProfileSet;
import io.github.jsnimda.inventoryprofiles.sorter.util.Current;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_2960;
import org.apache.commons.io.IOUtils;

public class ProfilesConfigHandler {
    public static final String FILE_VERSION_STRING = "PROFILES/0.1.0";
    public static final String CONFIG_FILE_NAME = "Profiles.custom.txt";
    public static final String CONFIG_DEFAULT_FILE_NAME = "Profiles.default.0.1.0.txt";
    public static final String CLASSPATH_FILE_NAME = "configs/profiles.default.txt";
    private static class_2960 identifier;
    private static String defaultContent;
    private static Map<String, ProfileSet> defaulProfileSets;
    private static File dir;

    public static void init() {
        identifier = new class_2960("inventoryprofiles", CLASSPATH_FILE_NAME);
        try {
            InputStream inputStream = Current.resourceManager().method_14486(identifier).method_14482();
            defaultContent = IOUtils.toString((InputStream)inputStream, (String)"UTF-8");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Map<String, ProfileSet> getDefauProfileSets() {
        if (defaulProfileSets == null) {
            defaulProfileSets = Parser.parse(defaultContent);
        }
        return defaulProfileSets;
    }

    static {
        defaulProfileSets = null;
    }

    public static class Parser {
        private static final Pattern PROFILE_LINE_REGEX = Pattern.compile("^([\\w.-]+)(?:\\s*\\(\\s*(.*?)\\s*\\)\\s*|\\s.*)$");
        private static final Pattern VALID_PROFILE_OPTIONS_REGEX = Pattern.compile("^(?:\\s*?[\\w.-]+\\s*=\\s*[\\w.-]+\\s*?|\\s*?)(?:,(?:\\s*?[\\w.-]+\\s*=\\s*[\\w.-]+\\s*?|\\s*?))*$");
        private static final Pattern OPTION_KEY_VALUE_PAIR_REGEX = Pattern.compile("([\\w.-]+)\\s*=\\s*([\\w.-]+)");
        private static final Pattern PREF_REGEX = Pattern.compile("^\\S+");
        private HashMap<String, ProfileSet> profileSets = new HashMap();
        private final List<String> lines;

        private static void err(String msg) {
            Log.warn("[inventoryprofiles][Profiles.custom.txt] " + msg);
        }

        public Map<String, ProfileSet> parse() {
            if (this.lines.isEmpty() || this.lines.get(0).trim().isEmpty()) {
                Parser.err("File not loaded. Empty file.");
                return Collections.emptyMap();
            }
            if (!this.lines.get(0).trim().equals(ProfilesConfigHandler.FILE_VERSION_STRING)) {
                Parser.err("File not loaded. Version mismatch (first line not equal to \"PROFILES/0.1.0\").");
                return Collections.emptyMap();
            }
            List<String> profileSetsContent = this.lines.subList(1, this.lines.size());
            IndentParser indentResult = IndentParser.parse(profileSetsContent, 2);
            for (IndentParser.ErrorMessage msg : indentResult.errorMsgs) {
                Parser.err("Line " + (msg.lineNumber + 1) + " was skipped. " + msg.message);
            }
            for (IndentParser.Section section : indentResult.root.children) {
                this.parseSectionAsLevel0(section);
            }
            return this.profileSets;
        }

        private void parseOptions(String profileName, String optionsString) {
            ProfileSet ps = this.createOrGetProfileSet(profileName);
            Matcher m = OPTION_KEY_VALUE_PAIR_REGEX.matcher(optionsString);
            while (m.find()) {
                ps.addOption(m.group(1), m.group(2));
            }
        }

        private void addProfile(String profileName, List<IndentParser.Section> children) {
            ProfileSet ps = this.createOrGetProfileSet(profileName);
            ProfileSet.Profile p = ps.addProfile();
            for (IndentParser.Section pref : children) {
                String s = pref.text.trim();
                for (IndentParser.Section subpref : pref.children) {
                    s = s + " " + subpref.text.trim();
                }
                Matcher m = PREF_REGEX.matcher(s);
                if (m.find()) {
                    String slotName = m.group(0);
                    if (ProfileSet.isValidSlotName(slotName)) {
                        p.addPreference(slotName, s.substring(slotName.length()).trim());
                        continue;
                    }
                    Parser.err("Line " + (pref.lineNumber + 1) + " was skipped. Invalid slot name.");
                    continue;
                }
                Parser.err("Line " + (pref.lineNumber + 1) + " was skipped. Invalid syntax.");
            }
        }

        private void parseSectionAsLevel0(IndentParser.Section section) {
            Matcher profileLineValidator = PROFILE_LINE_REGEX.matcher(section.text);
            if (profileLineValidator.matches()) {
                String profileName = profileLineValidator.group(1);
                String profileOptions = profileLineValidator.group(2);
                if (profileOptions != null) {
                    Matcher optionsValidator = VALID_PROFILE_OPTIONS_REGEX.matcher(profileOptions);
                    if (optionsValidator.matches()) {
                        this.parseOptions(profileName, optionsValidator.group(0));
                    } else {
                        Parser.err("Profile options at line " + (section.lineNumber + 1) + "was skipped. Invalid syntax.");
                    }
                } else {
                    this.addProfile(profileName, section.children);
                }
            } else {
                Parser.err("Line " + (section.lineNumber + 1) + " was skipped. Invalid profile name.");
            }
        }

        private ProfileSet createOrGetProfileSet(String name) {
            if (!this.profileSets.containsKey(name)) {
                this.profileSets.put(name, new ProfileSet(name));
            }
            return this.profileSets.get(name);
        }

        public Parser(List<String> lines) {
            this.lines = lines;
        }

        public static Map<String, ProfileSet> parse(List<String> lines) {
            return new Parser(lines).parse();
        }

        public static Map<String, ProfileSet> parse(String defaultContent) {
            return Parser.parse(Arrays.asList(defaultContent.split("(\r\n|\r|\n)")));
        }
    }
}

