/*
 * Decompiled with CFR 0.152.
 */
package io.github.jsnimda.inventoryprofiles.gui;

import com.google.common.collect.ImmutableList;
import fi.dy.masa.malilib.config.ConfigType;
import fi.dy.masa.malilib.config.ConfigUtils;
import fi.dy.masa.malilib.config.IConfigBase;
import fi.dy.masa.malilib.gui.GuiConfigsBase;
import fi.dy.masa.malilib.gui.button.ButtonBase;
import fi.dy.masa.malilib.gui.button.ButtonGeneric;
import fi.dy.masa.malilib.gui.button.IButtonActionListener;
import fi.dy.masa.malilib.gui.widgets.WidgetListConfigOptions;
import fi.dy.masa.malilib.util.StringUtils;
import io.github.jsnimda.inventoryprofiles.config.Configs;
import io.github.jsnimda.inventoryprofiles.sorter.util.Current;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_437;

public class GuiConfigs
extends GuiConfigsBase {
    private static ConfigGuiTab tab = ConfigGuiTab.GENERIC;

    public GuiConfigs() {
        this(Current.screen());
    }

    public GuiConfigs(@Nullable class_437 parent) {
        super(10, 50, "inventoryprofiles", parent, "inventoryprofiles.gui.title.configs", new Object[0]);
    }

    public void initGui() {
        super.initGui();
        this.clearOptions();
        int x = 10;
        int y = 26;
        for (ConfigGuiTab tab : ConfigGuiTab.values()) {
            x += this.createButton(x, y, -1, tab) + 2;
        }
    }

    private int createButton(int x, int y, int width, ConfigGuiTab tab) {
        ButtonGeneric button = new ButtonGeneric(x, y, width, 20, tab.getDisplayName(), new String[0]);
        button.setEnabled(GuiConfigs.tab != tab);
        this.addButton((ButtonBase)button, new ButtonListener(tab, this));
        return button.getWidth();
    }

    protected int getConfigWidth() {
        ConfigGuiTab tab = GuiConfigs.tab;
        if (tab == ConfigGuiTab.GENERIC) {
            return super.getConfigWidth();
        }
        return super.getConfigWidth();
    }

    public List<GuiConfigsBase.ConfigOptionWrapper> getConfigs() {
        return GuiConfigsBase.ConfigOptionWrapper.createFor(this.l());
    }

    private List<? extends IConfigBase> l() {
        ConfigGuiTab tab = GuiConfigs.tab;
        if (tab == ConfigGuiTab.GENERIC) {
            return Configs.Generic.LIST;
        }
        if (tab == ConfigGuiTab.TWEAK_VALUES) {
            return ConfigUtils.createConfigWrapperForType((ConfigType)ConfigType.BOOLEAN, (List)ImmutableList.copyOf(Configs.Tweaks.LIST));
        }
        if (tab == ConfigGuiTab.TWEAK_HOTKEYS) {
            return ConfigUtils.createConfigWrapperForType((ConfigType)ConfigType.HOTKEY, (List)ImmutableList.copyOf(Configs.Tweaks.LIST));
        }
        if (tab == ConfigGuiTab.ADVANCED_OPTIONS) {
            return Configs.AdvancedOptions.LIST;
        }
        return Collections.emptyList();
    }

    public static enum ConfigGuiTab {
        GENERIC("inventoryprofiles.gui.button.config_gui.generic"),
        ADVANCED_OPTIONS("inventoryprofiles.gui.button.config_gui.advanced_options"),
        TWEAK_VALUES("inventoryprofiles.gui.button.config_gui.tweak_values"),
        TWEAK_HOTKEYS("inventoryprofiles.gui.button.config_gui.tweak_hotkeys");

        private final String translationKey;

        private ConfigGuiTab(String translationKey) {
            this.translationKey = translationKey;
        }

        public String getDisplayName() {
            return StringUtils.translate((String)this.translationKey, (Object[])new Object[0]);
        }
    }

    private static class ButtonListener
    implements IButtonActionListener {
        private final GuiConfigs parent;
        private final ConfigGuiTab tab;

        public ButtonListener(ConfigGuiTab tab, GuiConfigs parent) {
            this.tab = tab;
            this.parent = parent;
        }

        public void actionPerformedWithButton(ButtonBase button, int mouseButton) {
            tab = this.tab;
            this.parent.reCreateListWidget();
            ((WidgetListConfigOptions)this.parent.getListWidget()).resetScrollbarPosition();
            this.parent.initGui();
        }
    }
}

