/*
 * Decompiled with CFR 0.152.
 */
package io.github.jsnimda.inventoryprofiles.gui.inject;

import fi.dy.masa.malilib.gui.GuiBase;
import io.github.jsnimda.inventoryprofiles.config.Configs;
import io.github.jsnimda.inventoryprofiles.gui.ToolTips;
import io.github.jsnimda.inventoryprofiles.sorter.VirtualSorterPort;
import io.github.jsnimda.inventoryprofiles.sorter.predefined.SortingMethodProviders;
import io.github.jsnimda.inventoryprofiles.sorter.util.ContainerActions;
import io.github.jsnimda.inventoryprofiles.sorter.util.ContainerCategory;
import io.github.jsnimda.inventoryprofiles.sorter.util.Current;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_1074;
import net.minecraft.class_1703;
import net.minecraft.class_1761;
import net.minecraft.class_2960;
import net.minecraft.class_339;
import net.minecraft.class_344;
import net.minecraft.class_3871;
import net.minecraft.class_3873;
import net.minecraft.class_3874;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_479;
import net.minecraft.class_481;
import net.minecraft.class_490;

public class GuiSortingButtons {
    public static final class_2960 TEXTURE = new class_2960("inventoryprofiles", "textures/gui/gui_buttons.png");
    public static final List<String> ROMAN_NUMBER = Arrays.asList("0", "I", "II", "III", "IV", "V", "VI", "VII", "VIII", "IX", "X", "XI", "XII");
    private static int left_base_x;
    private static int right_base_x;
    private static int player_y;
    private static int chest_y;
    private static ContainerCategory cate;

    public static List<class_339> gets(class_437 screen, class_1703 container, int left, int top, int containerWidth, int containerHeight) {
        ArrayList<class_339> list = new ArrayList<class_339>();
        left_base_x = left - 10;
        right_base_x = left + containerWidth - 17 - 36;
        player_y = top + containerHeight - 95;
        chest_y = top + 5;
        cate = ContainerCategory.of(container);
        if (!GuiSortingButtons.showMoveAllButton(cate) || cate == ContainerCategory.PLAYER_SURVIVAL) {
            right_base_x += 12;
        }
        if (cate == ContainerCategory.PLAYER_CREATIVE) {
            right_base_x -= 18;
        }
        if (!Configs.AdvancedOptions.INVENTORY_SHOW_PROFILE_BUTTONS.getBooleanValue() || cate == ContainerCategory.PLAYER_SURVIVAL || cate == ContainerCategory.PLAYER_CREATIVE) {
            // empty if block
        }
        if (Configs.AdvancedOptions.INVENTORY_SHOW_SORT_BUTTONS.getBooleanValue()) {
            if (cate == ContainerCategory.SORTABLE_3x3 || cate == ContainerCategory.SORTABLE_9xN || cate == ContainerCategory.SORTABLE_Nx3 || cate == ContainerCategory.UNKNOWN) {
                list.add((class_339)GuiSortingButtons.sortButton(true));
                list.add((class_339)GuiSortingButtons.sortColumnsButton(true));
                list.add((class_339)GuiSortingButtons.sortRowsButton(true));
            }
            if (cate == ContainerCategory.PLAYER_SURVIVAL || cate == ContainerCategory.PLAYER_CREATIVE) {
                list.add((class_339)GuiSortingButtons.sortButton(false));
                list.add((class_339)GuiSortingButtons.sortColumnsButton(false));
                list.add((class_339)GuiSortingButtons.sortRowsButton(false));
            }
        }
        if (Configs.AdvancedOptions.INVENTORY_SHOW_MOVE_ALL_BUTTONS.getBooleanValue() && GuiSortingButtons.showMoveAllButton(cate)) {
            list.add((class_339)GuiSortingButtons.moveAllButton(false));
            if (cate.isStorage()) {
                list.add((class_339)GuiSortingButtons.moveAllButton(true));
            }
        }
        return list;
    }

    public static boolean showMoveAllButton(ContainerCategory cate) {
        return cate.isStorage() || cate == ContainerCategory.CRAFTABLE_3x3 || cate == ContainerCategory.PLAYER_SURVIVAL;
    }

    public static SortButtonWidget profileButton(int profileId) {
        return new SortButtonWidget(left_base_x, player_y + 2 + 10 * profileId, 6 + profileId, 0, x -> {}, "inventoryprofiles.tooltip.profile_" + ROMAN_NUMBER.get(profileId) + "_button");
    }

    public static SortButtonWidget sortButton(boolean chestSide) {
        return new SortButtonWidget(right_base_x, chestSide ? chest_y : player_y, 1, 0, x -> VirtualSorterPort.doSort(!chestSide, SortingMethodProviders.current(), VirtualSorterPort.GroupingType.PRESERVED), "inventoryprofiles.tooltip.sort_button");
    }

    public static SortButtonWidget sortColumnsButton(boolean chestSide) {
        return new SortButtonWidget(right_base_x + 12, chestSide ? chest_y : player_y, 2, 0, x -> VirtualSorterPort.doSort(!chestSide, SortingMethodProviders.current(), VirtualSorterPort.GroupingType.COLUMNS), "inventoryprofiles.tooltip.sort_columns_button");
    }

    public static SortButtonWidget sortRowsButton(boolean chestSide) {
        return new SortButtonWidget(right_base_x + 24, chestSide ? chest_y : player_y, 3, 0, x -> VirtualSorterPort.doSort(!chestSide, SortingMethodProviders.current(), VirtualSorterPort.GroupingType.ROWS), "inventoryprofiles.tooltip.sort_rows_button");
    }

    public static SortButtonWidget moveAllButton(boolean chestSide) {
        return new SortButtonWidget(right_base_x + 36 - (cate == ContainerCategory.PLAYER_SURVIVAL ? 12 : 0), chestSide ? chest_y : player_y - (cate == ContainerCategory.PLAYER_SURVIVAL ? 12 : 0), chestSide ? 6 : 5, 0, x -> ContainerActions.moveAllAlike(chestSide, GuiBase.isShiftDown()), "inventoryprofiles.tooltip.move_all_button");
    }

    public static boolean isRecipeBookOpen() {
        if (Current.screen() instanceof class_490 || Current.screen() instanceof class_479) {
            return Current.recipeBook().method_14887();
        }
        if (Current.screen() instanceof class_3873) {
            return Current.recipeBook().method_14891();
        }
        if (Current.screen() instanceof class_3871) {
            return Current.recipeBook().method_17317();
        }
        if (Current.screen() instanceof class_3874) {
            return Current.recipeBook().method_17321();
        }
        return false;
    }

    public static class SortButtonWidget
    extends class_344 {
        String tooltipText = "";
        int originalX;

        public SortButtonWidget(int x, int y, int gx, int gy, class_4185.class_4241 pressAction, String tooltipText) {
            super(x, y, 10, 10, gx * 10, gy * 10, gy * 10 + 10, TEXTURE, pressAction);
            this.originalX = x;
            this.tooltipText = tooltipText;
        }

        public void renderButton(int int_1, int int_2, float float_1) {
            boolean isNarrow;
            this.x = this.originalX;
            if (Current.screen() instanceof class_481 && ((class_481)Current.screen()).method_2469() != class_1761.field_7918.method_7741()) {
                this.x = -20;
            }
            boolean bl = isNarrow = Current.screen().width < 379;
            if (GuiSortingButtons.isRecipeBookOpen() && !isNarrow) {
                this.x = this.originalX + 177 - 100;
            }
            super.renderButton(int_1, int_2, float_1);
            this.renderToolTip(int_1, int_2);
        }

        public void renderToolTip(int x, int y) {
            if (Configs.AdvancedOptions.SHOW_INVENTORY_BUTTON_TOOLTIPS.getBooleanValue() && this.isHovered() && !this.tooltipText.isEmpty()) {
                ToolTips.add(class_1074.method_4662((String)this.tooltipText, (Object[])new Object[0]), x, y);
            }
        }
    }
}

