/*
 * Decompiled with CFR 0.152.
 */
package io.github.jsnimda.inventoryprofiles.sorter;

import io.github.jsnimda.inventoryprofiles.Log;
import io.github.jsnimda.inventoryprofiles.config.Configs;
import io.github.jsnimda.inventoryprofiles.sorter.Click;
import io.github.jsnimda.inventoryprofiles.sorter.VirtualItemStack;
import io.github.jsnimda.inventoryprofiles.sorter.VirtualItemStacksSandbox;
import io.github.jsnimda.inventoryprofiles.sorter.VirtualItemType;
import io.github.jsnimda.inventoryprofiles.sorter.VirtualSlotsStats;
import io.github.jsnimda.inventoryprofiles.sorter.util.CodeUtils;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class DiffCalculator {
    private static HashMap<Integer, List<Score>> scoresLookupTable = new HashMap();

    public static List<Click> calcDiff(List<VirtualItemStack> fromItems, List<VirtualItemStack> toItems, boolean allowDrop) {
        if (fromItems.size() != toItems.size()) {
            throw new RuntimeException("sizes not match");
        }
        fromItems = VirtualSlotsStats.uniquify(fromItems);
        toItems = VirtualSlotsStats.uniquify(toItems);
        return new CalcDiffInstance(fromItems, toItems, allowDrop).calc();
    }

    private static void checkPossible(VirtualSlotsStats aStats, VirtualSlotsStats bStats, boolean allowDrop) {
        Map<VirtualItemType, Integer> a = aStats.getInfosAsMap(x -> x.totalCount);
        Map<VirtualItemType, Integer> b = bStats.getInfosAsMap(x -> x.totalCount);
        if (allowDrop ? !DiffCalculator.isSuperset(a, b) : !a.equals(b)) {
            Log.error("[inventoryprofiles] before map:");
            a.forEach((key, value) -> Log.error(key + ":" + value));
            Log.error("[inventoryprofiles] after map:");
            b.forEach((key, value) -> Log.error(key + ":" + value));
            throw new RuntimeException("Not possible from before to after!");
        }
    }

    private static boolean isSuperset(Map<VirtualItemType, Integer> superset, Map<VirtualItemType, Integer> subset) {
        for (VirtualItemType key : subset.keySet()) {
            if (!superset.containsKey(key)) {
                return false;
            }
            if (subset.get(key) <= superset.get(key)) continue;
            return false;
        }
        return true;
    }

    private static boolean matchExact(VirtualItemStack a, VirtualItemStack b) {
        return a.equals(b);
    }

    private static boolean matchType(VirtualItemStack a, VirtualItemStack b) {
        if (a.isEmpty()) {
            return true;
        }
        if (b.isEmpty()) {
            return false;
        }
        return a.sameType(b);
    }

    private static int lookupScore(int fromCount, int targetCount) {
        if (fromCount <= targetCount || targetCount <= 0) {
            throw new RuntimeException("unsupported");
        }
        return DiffCalculator.getScoreObject((int)fromCount, (int)targetCount).count;
    }

    private static Score getScoreObject(int fromCount, int targetCount) {
        if (fromCount <= targetCount || targetCount <= 0) {
            throw new RuntimeException("unsupported");
        }
        if (!scoresLookupTable.containsKey(fromCount)) {
            scoresLookupTable.put(fromCount, ScoresGenerator.scoresFor(fromCount));
        }
        return scoresLookupTable.get(fromCount).get(targetCount);
    }

    private static enum OperationType {
        MINUS_1,
        PLUS_1,
        DIVIDE_2;


        public String toString() {
            switch (this) {
                case MINUS_1: {
                    return "-1";
                }
                case PLUS_1: {
                    return "+1";
                }
                case DIVIDE_2: {
                    return "/2";
                }
            }
            throw new AssertionError((Object)"Unreachable");
        }
    }

    private static class Operation {
        public List<OperationType> ops;
        public int to;
        public int count;

        public Operation(List<OperationType> ops, int to, int count) {
            this.ops = ops;
            this.to = to;
            this.count = count;
        }
    }

    private static class Score {
        public int count;
        public List<List<OperationType>> opss = new ArrayList<List<OperationType>>();

        public Score(int count) {
            this.count = count;
        }

        public boolean shouldRightClick() {
            return this.opss.stream().anyMatch(x -> !x.isEmpty() && x.get(0) == OperationType.DIVIDE_2);
        }
    }

    private static class ScoresGenerator {
        private ScoresGenerator() {
        }

        public static List<Score> scoresFor(int fromCount) {
            ArrayList<Score> o = new ArrayList<Score>();
            for (int i = 0; i <= fromCount; ++i) {
                o.add(null);
            }
            LinkedList<Operation> arr = new LinkedList<Operation>();
            arr.add(ScoresGenerator.minus1(fromCount, new ArrayList<OperationType>(), 0));
            arr.add(ScoresGenerator.divide2(fromCount, new ArrayList<OperationType>(), 0));
            arr.add(ScoresGenerator.plus1(0, new ArrayList<OperationType>(), 2));
            while (!arr.isEmpty()) {
                Operation oper = (Operation)arr.poll();
                int k = oper.to;
                if (k <= 0 || k >= fromCount) continue;
                if (o.get(k) == null || oper.count < ((Score)o.get((int)k)).count) {
                    o.set(k, ScoresGenerator.initer(oper.count));
                }
                if (oper.count != ((Score)o.get((int)k)).count) continue;
                ((Score)o.get((int)k)).opss.add(oper.ops);
                arr.add(ScoresGenerator.minus1(k, oper.ops, oper.count));
                arr.add(ScoresGenerator.plus1(k, oper.ops, oper.count));
                arr.add(ScoresGenerator.divide2(k, oper.ops, oper.count));
            }
            return o;
        }

        private static Score initer(int count) {
            return new Score(count);
        }

        private static List<OperationType> concat(List<OperationType> ops, OperationType op) {
            ArrayList<OperationType> res = new ArrayList<OperationType>(ops);
            res.add(op);
            return res;
        }

        private static Operation minus1(int from, List<OperationType> ops, int count) {
            return new Operation(ScoresGenerator.concat(ops, OperationType.MINUS_1), from - 1, count + (!ops.isEmpty() && ops.get(ops.size() - 1) == OperationType.MINUS_1 ? 1 : 3));
        }

        private static Operation plus1(int from, List<OperationType> ops, int count) {
            return new Operation(ScoresGenerator.concat(ops, OperationType.PLUS_1), from + 1, count + 1);
        }

        private static Operation divide2(int from, List<OperationType> ops, int count) {
            return new Operation(ScoresGenerator.concat(ops, OperationType.DIVIDE_2), from / 2, count + 2);
        }
    }

    private static class CalcDiffInstance {
        public final List<VirtualItemStack> fromItems;
        public final List<VirtualItemStack> toItems;
        public final boolean allowDrop;
        public final VirtualItemStacksSandbox sandbox;
        private VirtualSlotsStats fromStats;
        private VirtualSlotsStats targetStats;
        private boolean allowRightClick = false;
        private Map<VirtualItemType, ScoreGroup> scoreGroups = new HashMap<VirtualItemType, ScoreGroup>();

        public CalcDiffInstance(List<VirtualItemStack> fromItems, List<VirtualItemStack> toItems, boolean allowDrop) {
            this.fromItems = fromItems;
            this.toItems = toItems;
            this.allowDrop = allowDrop;
            this.sandbox = new VirtualItemStacksSandbox(this.fromItems);
            this.fromStats = new VirtualSlotsStats(this.fromItems);
            this.targetStats = new VirtualSlotsStats(this.toItems);
        }

        private VirtualItemStack cursor() {
            return this.sandbox.cursor;
        }

        private List<VirtualItemStack> targets() {
            return this.toItems;
        }

        private VirtualItemStack target(int index) {
            return this.targets().get(index);
        }

        private List<VirtualItemStack> currents() {
            return this.sandbox.items;
        }

        private VirtualItemStack current(int index) {
            return this.currents().get(index);
        }

        private VirtualItemStack currentIfMatchType(int index) {
            if (this.matchType(index)) {
                return this.current(index);
            }
            return new VirtualItemStack(this.target((int)index).itemType, 0);
        }

        private boolean matchExact(int index) {
            return DiffCalculator.matchExact(this.current(index), this.target(index));
        }

        private boolean matchType(int index) {
            return DiffCalculator.matchType(this.current(index), this.target(index));
        }

        public List<Click> calc() {
            try {
                DiffCalculator.checkPossible(this.fromStats, this.targetStats, this.allowDrop);
                long st = System.nanoTime();
                if (!this.allowDrop) {
                    this.noDropInit();
                    this.doStageANoDrop();
                    this.doStageBNoDrop();
                }
                long ed = System.nanoTime();
                Log.debugLogs("[inventoryprofiles] Execute calcDiff() in " + (double)(ed - st) / 1000000.0 + " ms");
            }
            catch (Throwable e) {
                if (Configs.AdvancedOptions.DEBUG_LOGS.getBooleanValue()) {
                    e.printStackTrace();
                    return this.sandbox.clicks;
                }
                throw e;
            }
            return this.sandbox.clicks;
        }

        private void doStageANoDrop() {
            this.allowRightClick = false;
            this.doStage();
        }

        private void doStageBNoDrop() {
            this.allowRightClick = true;
            this.doStage();
        }

        private boolean match(int index) {
            return this.allowRightClick ? this.matchExact(index) : this.matchType(index);
        }

        private void doStage() {
            TreeSet<Integer> indexes = new TreeSet<Integer>();
            for (int i = 0; i < this.targets().size(); ++i) {
                if (this.match(i)) continue;
                indexes.add(i);
            }
            while (!indexes.isEmpty()) {
                Iterator it = indexes.iterator();
                while (it.hasNext() || !this.cursor().isEmpty()) {
                    if (this.cursor().isEmpty()) {
                        int sel = (Integer)it.next();
                        if (this.match(sel)) continue;
                        this.findPick(sel);
                        continue;
                    }
                    this.handleCursor();
                }
                it = indexes.iterator();
                while (it.hasNext()) {
                    if (!this.match((Integer)it.next())) continue;
                    it.remove();
                }
            }
        }

        private void findPick(int index) {
            if (this.target(index).isEmpty()) {
                this.sandbox.leftClick(index);
                return;
            }
            VirtualItemType type = this.target((int)index).itemType;
            if (!this.allowRightClick) {
                int sel = IntStream.range(0, this.currents().size()).filter(x -> !this.matchType(x) && this.current((int)x).itemType.equals(type)).findFirst().orElse(index);
                this.sandbox.leftClick(sel);
            } else {
                this.scoreGroups.get(type).handle();
            }
        }

        private void handleCursor() {
            VirtualItemType type = this.cursor().itemType;
            if (this.allowRightClick) {
                throw new RuntimeException("shouldn't reach here");
            }
            this.scoreGroups.get(type).handleCursor();
        }

        private void noDropInit() {
            this.targetStats.getInfos().values().forEach(x -> this.scoreGroups.put(x.type, new ScoreGroup((VirtualSlotsStats.ItemTypeStats)x)));
        }

        private static enum ActionType {
            LEFT_CLICK_ME,
            RIGHT_CLICK_ME,
            RIGHT_CLICK_OTHERS_THEN_LEFT_CLICK_ME;

        }

        private class GradingResult
        implements Comparable<GradingResult> {
            public int index;
            public int maxCount;
            public int currentCount;
            public int targetCount;
            public int cursorCount;
            public ActionType actionType = null;
            public int score = Integer.MAX_VALUE;

            public GradingResult(int index) {
                this.index = index;
                this.maxCount = CalcDiffInstance.this.target(index).getMaxCount();
                this.currentCount = ((CalcDiffInstance)CalcDiffInstance.this).currentIfMatchType((int)index).count;
                this.targetCount = ((CalcDiffInstance)CalcDiffInstance.this).target((int)index).count;
                if (!CalcDiffInstance.this.cursor().isEmpty() && !CalcDiffInstance.this.cursor().sameType(CalcDiffInstance.this.target(index))) {
                    throw new AssertionError();
                }
                this.cursorCount = ((CalcDiffInstance)CalcDiffInstance.this).cursor().count;
            }

            public GradingResult calc() {
                if (this.targetCount == this.currentCount) {
                    throw new RuntimeException("unsupported");
                }
                if (this.cursorCount == 0) {
                    throw new RuntimeException("unsupported");
                }
                if (this.currentCount >= this.maxCount) {
                    throw new RuntimeException("unsupported");
                }
                if (this.currentCount < this.targetCount && CalcDiffInstance.this.allowRightClick) {
                    if (this.cursorCount > this.targetCount - this.currentCount && this.scoreAfterRightClickOthersThenLeftClickMe() < this.score) {
                        this.actionType = ActionType.RIGHT_CLICK_OTHERS_THEN_LEFT_CLICK_ME;
                        this.score = this.scoreAfterRightClickOthersThenLeftClickMe();
                    }
                    if (this.scoreAfterRightClickMe() < this.score) {
                        this.actionType = ActionType.RIGHT_CLICK_ME;
                        this.score = this.scoreAfterRightClickMe();
                    }
                }
                if (this.scoreAfterLeftClickMe() < this.score) {
                    this.actionType = ActionType.LEFT_CLICK_ME;
                    this.score = this.scoreAfterLeftClickMe();
                }
                if (this.actionType == null) {
                    throw new AssertionError();
                }
                return this;
            }

            public int scoreIgnoreCursor() {
                return this.scoreIgnoreCursor(this.currentCount, this.targetCount);
            }

            public int scoreIgnoreCursor(int currentCount, int targetCount) {
                if (currentCount > targetCount) {
                    return DiffCalculator.lookupScore(currentCount, targetCount);
                }
                return targetCount - currentCount;
            }

            public int scoreAfterLeftClickMe() {
                if (this.cursorCount == 0) {
                    throw new RuntimeException("this shouldn't be called");
                }
                int afterCount = Math.min(this.cursorCount + this.currentCount, this.maxCount);
                int afterLeftover = this.currentCount + this.cursorCount - afterCount;
                return this.scoreIgnoreCursor(afterCount, this.targetCount) + (afterLeftover > 0 ? 2 : 1);
            }

            public int scoreAfterRightClickMe() {
                if (this.currentCount >= this.targetCount || this.cursorCount == 0) {
                    throw new RuntimeException("this shouldn't be called");
                }
                if (this.cursorCount <= this.targetCount - this.currentCount) {
                    return this.targetCount - this.currentCount;
                }
                return this.targetCount - this.currentCount + 1;
            }

            public int scoreAfterRightClickOthersThenLeftClickMe() {
                if (this.currentCount >= this.targetCount || this.cursorCount == 0 || this.cursorCount <= this.targetCount - this.currentCount) {
                    throw new RuntimeException("this shouldn't be called");
                }
                return this.cursorCount - (this.targetCount - this.currentCount) + 1;
            }

            public int decreased() {
                return this.scoreIgnoreCursor() - this.score;
            }

            @Override
            public int compareTo(GradingResult o) {
                if (this.actionType == null) {
                    throw new RuntimeException("unsupported");
                }
                if ((this.actionType == ActionType.RIGHT_CLICK_OTHERS_THEN_LEFT_CLICK_ME || o.actionType == ActionType.RIGHT_CLICK_OTHERS_THEN_LEFT_CLICK_ME) && this.score != o.score) {
                    return this.score - o.score;
                }
                if (this.decreased() != o.decreased()) {
                    return o.decreased() - this.decreased();
                }
                if (this.score != o.score) {
                    return this.score - o.score;
                }
                int cmp = o.targetCount - this.targetCount;
                return cmp == 0 ? this.index - o.index : cmp;
            }
        }

        private class ScoreGroup {
            public SortedSet<Integer> unmatches = new TreeSet<Integer>();
            public SortedSet<Integer> fullUnmatches = new TreeSet<Integer>();
            private List<Integer> beforePickScore;
            private List<Integer> sortedBeforePickScore;

            public ScoreGroup(VirtualSlotsStats.ItemTypeStats info) {
                info.indexes.forEach(x -> {
                    if (!CalcDiffInstance.this.matchExact(x)) {
                        this.unmatches.add((Integer)x);
                    }
                    if (!CalcDiffInstance.this.matchExact(x) && CalcDiffInstance.this.target(x).isFull()) {
                        this.fullUnmatches.add((Integer)x);
                    }
                });
            }

            public void handle() {
                while (!this.unmatches.isEmpty() || !CalcDiffInstance.this.cursor().isEmpty()) {
                    if (CalcDiffInstance.this.cursor().isEmpty()) {
                        this.pick();
                        continue;
                    }
                    this.handleCursor();
                }
            }

            private List<Integer> candidates(Predicate<Integer> predicate) {
                return this.unmatches.stream().filter(predicate).collect(Collectors.toList());
            }

            private List<Distinct> getDistincts() {
                ArrayList<Distinct> res = new ArrayList<Distinct>();
                HashSet<Distinct> existed = new HashSet<Distinct>();
                Iterator iterator = this.unmatches.iterator();
                while (iterator.hasNext()) {
                    int sel = (Integer)iterator.next();
                    Distinct d = new Distinct(sel);
                    if (existed.contains(d)) continue;
                    res.add(d);
                    existed.add(d);
                }
                return res;
            }

            public void pick() {
                this.updateUnmatches();
                if (this.unmatches.isEmpty()) {
                    return;
                }
                if (!this.fullUnmatches.isEmpty()) {
                    List<Integer> cand = this.candidates(x -> ((CalcDiffInstance)CalcDiffInstance.this).currentIfMatchType((int)x.intValue()).count > ((CalcDiffInstance)CalcDiffInstance.this).target((int)x.intValue()).count);
                    Integer sel = (Integer)CodeUtils.selectFirst(cand, (Function<Integer, Integer>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$pick$2(java.lang.Integer ), (Ljava/lang/Integer;)Ljava/lang/Integer;)((ScoreGroup)this), (Comparator)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)I, lambda$pick$3(io.github.jsnimda.inventoryprofiles.sorter.util.CodeUtils$MappedObject io.github.jsnimda.inventoryprofiles.sorter.util.CodeUtils$MappedObject ), (Lio/github/jsnimda/inventoryprofiles/sorter/util/CodeUtils$MappedObject;Lio/github/jsnimda/inventoryprofiles/sorter/util/CodeUtils$MappedObject;)I)()).value;
                    if (((CalcDiffInstance)CalcDiffInstance.this).currentIfMatchType((int)sel.intValue()).count / 2 <= ((CalcDiffInstance)CalcDiffInstance.this).target((int)sel.intValue()).count) {
                        CalcDiffInstance.this.sandbox.rightClick(sel);
                    } else {
                        CalcDiffInstance.this.sandbox.leftClick(sel);
                    }
                    return;
                }
                this.beforePickScore = this.unmatches.stream().map(x -> new GradingResult((int)x).scoreIgnoreCursor()).collect(Collectors.toList());
                this.sortedBeforePickScore = this.beforePickScore.stream().sorted().collect(Collectors.toList());
                List<Distinct> distincts = this.getDistincts();
                List cand = distincts.stream().flatMap(x -> {
                    if (CalcDiffInstance.this.currentIfMatchType(x.index).isEmpty()) {
                        return Stream.empty();
                    }
                    if (((CalcDiffInstance)CalcDiffInstance.this).currentIfMatchType((int)x.index).count > ((CalcDiffInstance)CalcDiffInstance.this).target((int)x.index).count) {
                        if (DiffCalculator.getScoreObject(((CalcDiffInstance)CalcDiffInstance.this).currentIfMatchType((int)x.index).count, ((CalcDiffInstance)CalcDiffInstance.this).target((int)x.index).count).shouldRightClick()) {
                            return Stream.of(new TryPickResult(x.index, 1));
                        }
                        return Stream.of(new TryPickResult(x.index, 1), new TryPickResult(x.index, 0));
                    }
                    return Stream.of(new TryPickResult(x.index, 1));
                }).collect(Collectors.toList());
                TryPickResult res = (TryPickResult)CodeUtils.selectFirst(cand, TryPickResult::compareTo);
                res.clicks.forEach(x -> {
                    if (x.button == 0) {
                        CalcDiffInstance.this.sandbox.leftClick(x.slotId);
                    } else {
                        CalcDiffInstance.this.sandbox.rightClick(x.slotId);
                    }
                });
            }

            private void removeAllMatches(Collection<Integer> indexes) {
                Iterator<Integer> it = indexes.iterator();
                while (it.hasNext()) {
                    if (!CalcDiffInstance.this.matchExact(it.next())) continue;
                    it.remove();
                }
            }

            public void updateUnmatches() {
                this.removeAllMatches(this.unmatches);
                this.removeAllMatches(this.fullUnmatches);
            }

            public List<GradingResult> handleCursorCandidates() {
                return this.unmatches.stream().filter(x -> !CalcDiffInstance.this.currentIfMatchType(x).isFull()).map(x -> new GradingResult((int)x).calc()).collect(Collectors.toList());
            }

            public void handleCursor() {
                this.updateUnmatches();
                if (this.unmatches.isEmpty()) {
                    throw new AssertionError();
                }
                if (!this.fullUnmatches.isEmpty()) {
                    CalcDiffInstance.this.sandbox.leftClick(this.fullUnmatches.first());
                    return;
                }
                List<GradingResult> cand = this.handleCursorCandidates();
                GradingResult sel = CodeUtils.selectFirst(cand, GradingResult::compareTo);
                if (sel == null) {
                    throw new RuntimeException("not found");
                }
                switch (sel.actionType) {
                    case LEFT_CLICK_ME: {
                        CalcDiffInstance.this.sandbox.leftClick(sel.index);
                        return;
                    }
                    case RIGHT_CLICK_ME: {
                        CalcDiffInstance.this.sandbox.rightClick(sel.index);
                        return;
                    }
                    case RIGHT_CLICK_OTHERS_THEN_LEFT_CLICK_ME: {
                        this.rightClickOthers(sel.index);
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            }

            public void rightClickOthers(int index) {
                List<Integer> cand = this.candidates(x -> x != index && ((CalcDiffInstance)CalcDiffInstance.this).currentIfMatchType((int)x.intValue()).count < ((CalcDiffInstance)CalcDiffInstance.this).target((int)x.intValue()).count);
                if (cand.isEmpty()) {
                    throw new RuntimeException("impossible");
                }
                int amount = ((CalcDiffInstance)CalcDiffInstance.this).cursor().count - (((CalcDiffInstance)CalcDiffInstance.this).target((int)index).count - ((CalcDiffInstance)CalcDiffInstance.this).currentIfMatchType((int)index).count);
                cand.sort((a, b) -> {
                    int aClose = ((CalcDiffInstance)CalcDiffInstance.this).target((int)a.intValue()).count - ((CalcDiffInstance)CalcDiffInstance.this).currentIfMatchType((int)a.intValue()).count;
                    int bClose = ((CalcDiffInstance)CalcDiffInstance.this).target((int)b.intValue()).count - ((CalcDiffInstance)CalcDiffInstance.this).currentIfMatchType((int)b.intValue()).count;
                    return aClose - bClose;
                });
                int i = 0;
                while (amount > 0) {
                    int sel = cand.get(i);
                    if (!CalcDiffInstance.this.matchExact(sel)) {
                        CalcDiffInstance.this.sandbox.rightClick(sel);
                        --amount;
                        continue;
                    }
                    ++i;
                }
                CalcDiffInstance.this.sandbox.leftClick(index);
            }

            private static /* synthetic */ int lambda$pick$3(CodeUtils.MappedObject x, CodeUtils.MappedObject y) {
                return (Integer)y.mappedValue - (Integer)x.mappedValue;
            }

            private /* synthetic */ Integer lambda$pick$2(Integer x) {
                return new GradingResult(x).scoreIgnoreCursor();
            }

            private class TryPickResult
            implements Comparable<TryPickResult> {
                public int byIndex;
                public int byButton;
                public List<Click> clicks = new ArrayList<Click>();
                public int cursorCount;
                public List<Integer> afterPickScore;
                public int mostDecreased;
                public boolean shouldSkipThis;
                private List<Integer> sortedScores = null;

                public TryPickResult(int index, int button) {
                    this.byIndex = index;
                    this.byButton = button;
                    this.calc();
                }

                public void calc() {
                    TreeSet<Integer> backupUnmatches = new TreeSet<Integer>(ScoreGroup.this.unmatches);
                    int clicksSize = CalcDiffInstance.this.sandbox.clicks.size();
                    CalcDiffInstance.this.sandbox.save(backupUnmatches);
                    if (this.byButton == 0) {
                        CalcDiffInstance.this.sandbox.leftClick(this.byIndex);
                    } else {
                        CalcDiffInstance.this.sandbox.rightClick(this.byIndex);
                    }
                    while (!CalcDiffInstance.this.cursor().isEmpty()) {
                        ScoreGroup.this.handleCursor();
                    }
                    this.clicks.addAll(CalcDiffInstance.this.sandbox.clicks.subList(clicksSize, CalcDiffInstance.this.sandbox.clicks.size()));
                    this.cursorCount = ((CalcDiffInstance)CalcDiffInstance.this).cursor().count;
                    this.afterPickScore = backupUnmatches.stream().map(x -> new GradingResult((int)x).scoreIgnoreCursor()).collect(Collectors.toList());
                    this.mostDecreased = (Integer)CodeUtils.selectFirst(IntStream.range(0, this.afterPickScore.size()).mapToObj(x -> (Integer)ScoreGroup.this.beforePickScore.get(x) - this.afterPickScore.get(x)).collect(Collectors.toList()), (x, y) -> y - x);
                    this.shouldSkipThis = this.getSortedScores().equals(ScoreGroup.this.sortedBeforePickScore);
                    CalcDiffInstance.this.sandbox.restore();
                    ScoreGroup.this.unmatches = backupUnmatches;
                }

                public int value() {
                    return this.mostDecreased - (this.cursorCount + this.clicks.size());
                }

                public List<Integer> getSortedScores() {
                    if (this.sortedScores == null) {
                        this.sortedScores = this.afterPickScore.stream().sorted().collect(Collectors.toList());
                    }
                    return this.sortedScores;
                }

                public int compare(List<Integer> a, List<Integer> b) {
                    if (a.size() != b.size()) {
                        throw new RuntimeException("unsupported");
                    }
                    for (int i = 0; i < a.size(); ++i) {
                        if (a.get(i) == b.get(i)) continue;
                        return a.get(i) - b.get(i);
                    }
                    return 0;
                }

                @Override
                public int compareTo(TryPickResult o) {
                    if (this.shouldSkipThis || o.shouldSkipThis) {
                        if (this.shouldSkipThis && o.shouldSkipThis) {
                            return 0;
                        }
                        return this.shouldSkipThis ? 1 : -1;
                    }
                    if (o.value() != this.value()) {
                        return o.value() - this.value();
                    }
                    int cmp = this.compare(this.getSortedScores(), o.getSortedScores());
                    if (cmp != 0) {
                        return cmp;
                    }
                    if (this.byIndex == o.byIndex) {
                        return 0;
                    }
                    return Math.random() < 0.5 ? 1 : -1;
                }
            }

            private class Distinct {
                int index;
                int currentCount;
                int targetCount;

                public Distinct(int index) {
                    this.index = index;
                    this.currentCount = ((CalcDiffInstance)CalcDiffInstance.this).currentIfMatchType((int)index).count;
                    this.targetCount = ((CalcDiffInstance)CalcDiffInstance.this).target((int)index).count;
                }

                public int hashCode() {
                    int prime = 31;
                    int result = 1;
                    result = 31 * result + this.getEnclosingInstance().hashCode();
                    result = 31 * result + this.currentCount;
                    result = 31 * result + this.targetCount;
                    return result;
                }

                public boolean equals(Object obj) {
                    if (this == obj) {
                        return true;
                    }
                    if (obj == null) {
                        return false;
                    }
                    if (this.getClass() != obj.getClass()) {
                        return false;
                    }
                    Distinct other = (Distinct)obj;
                    if (!this.getEnclosingInstance().equals(other.getEnclosingInstance())) {
                        return false;
                    }
                    if (this.currentCount != other.currentCount) {
                        return false;
                    }
                    return this.targetCount == other.targetCount;
                }

                private ScoreGroup getEnclosingInstance() {
                    return ScoreGroup.this;
                }
            }
        }
    }
}

