/*
 * Decompiled with CFR 0.152.
 */
package io.github.jsnimda.inventoryprofiles.sorter;

import com.google.common.collect.ImmutableList;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.hotkeys.IKeybind;
import fi.dy.masa.malilib.hotkeys.KeyAction;
import io.github.jsnimda.inventoryprofiles.config.Configs;
import io.github.jsnimda.inventoryprofiles.sorter.VirtualSorterPort;
import io.github.jsnimda.inventoryprofiles.sorter.predefined.SortingMethodProviders;
import io.github.jsnimda.inventoryprofiles.sorter.util.ContainerActions;
import io.github.jsnimda.inventoryprofiles.sorter.util.Current;

public class SorterEventPort {
    public static void handleCloseContainer() {
        ContainerActions.cleanCursor();
        ContainerActions.cleanTempSlotsForClosing();
    }

    public static void doSortAction() {
        VirtualSorterPort.doSort(SortingMethodProviders.current(), VirtualSorterPort.GroupingType.PRESERVED);
    }

    public static void doSortActionByGroupColumns() {
        VirtualSorterPort.doSort(SortingMethodProviders.current(), VirtualSorterPort.GroupingType.COLUMNS);
    }

    public static void doSortActionByGroupRows() {
        VirtualSorterPort.doSort(SortingMethodProviders.current(), VirtualSorterPort.GroupingType.ROWS);
    }

    public static void doSwitchProfile() {
    }

    public static void doMoveAll() {
        ContainerActions.moveAllAlike(GuiBase.isShiftDown());
    }

    public static boolean shouldHandle(IKeybind key) {
        return ImmutableList.of((Object)Configs.Generic.SORT_INVENTORY.getKeybind(), (Object)Configs.Generic.SORT_INVENTORY_BY_GROUP_COLUMNS.getKeybind(), (Object)Configs.Generic.SORT_INVENTORY_BY_GROUP_ROWS.getKeybind(), (Object)Configs.Generic.SWITCH_PROFILE.getKeybind(), (Object)Configs.Generic.MOVE_ALL_CONTAINER_EXISTING_ITEMS.getKeybind()).contains((Object)key);
    }

    public static boolean handleKey(KeyAction action, IKeybind key) {
        if (!Current.inGame()) {
            return false;
        }
        try {
            if (key == Configs.Generic.SORT_INVENTORY.getKeybind()) {
                SorterEventPort.doSortAction();
                return true;
            }
            if (key == Configs.Generic.SORT_INVENTORY_BY_GROUP_COLUMNS.getKeybind()) {
                SorterEventPort.doSortActionByGroupColumns();
                return true;
            }
            if (key == Configs.Generic.SORT_INVENTORY_BY_GROUP_ROWS.getKeybind()) {
                SorterEventPort.doSortActionByGroupRows();
                return true;
            }
            if (key == Configs.Generic.SWITCH_PROFILE.getKeybind()) {
                SorterEventPort.doSwitchProfile();
                return true;
            }
            if (key == Configs.Generic.MOVE_ALL_CONTAINER_EXISTING_ITEMS.getKeybind()) {
                SorterEventPort.doMoveAll();
                return true;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return false;
    }
}

