/*
 * Decompiled with CFR 0.152.
 */
package io.github.jsnimda.inventoryprofiles.sorter;

import io.github.jsnimda.inventoryprofiles.sorter.Click;
import io.github.jsnimda.inventoryprofiles.sorter.VirtualItemStack;
import io.github.jsnimda.inventoryprofiles.sorter.util.Converter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Stack;

class VirtualItemStacksSandbox {
    public static final int INF_LOOP_MAX = 1000;
    public List<Click> clicks = new ArrayList<Click>();
    public List<VirtualItemStack> items;
    public VirtualItemStack cursor = VirtualItemStack.empty();
    private StateSaver stateSaver = new StateSaver();

    public VirtualItemStacksSandbox(List<VirtualItemStack> items) {
        this.items = Converter.copy(items);
    }

    public void save() {
        this.stateSaver.save();
    }

    public void save(Collection<Integer> indexes) {
        this.stateSaver.save(indexes);
    }

    public void restore() {
        this.stateSaver.restore();
    }

    public void unsave() {
        this.stateSaver.unsave();
    }

    public void addClickLimited(Click c) {
        if (this.clicks.size() >= 1000) {
            throw new RuntimeException("Infinite loop detected. Click count > 1000");
        }
        this.clicks.add(c);
    }

    public VirtualItemStack itemAt(int index) {
        return this.items.get(index);
    }

    public void leftClick(int index) {
        this.addClickLimited(Click.leftClick(index));
        if (this.cursor.isEmpty() || !this.cursor.capable(this.itemAt(index))) {
            this.cursor.swap(this.itemAt(index));
        } else {
            this.cursor.transferTo(this.itemAt(index));
        }
    }

    public void rightClick(int index) {
        this.addClickLimited(Click.rightClick(index));
        if (this.cursor.isEmpty()) {
            this.itemAt(index).splitHalfTo(this.cursor);
        } else if (!this.cursor.capable(this.itemAt(index))) {
            this.cursor.swap(this.itemAt(index));
        } else {
            this.cursor.transferOneTo(this.itemAt(index));
        }
    }

    public void rightClick(int index, int times) {
        for (int i = 0; i < times; ++i) {
            this.rightClick(index);
        }
    }

    public void dropOne(int index) {
        this.addClickLimited(Click.dropOne(index));
        if (!this.itemAt(index).isEmpty()) {
            --this.itemAt((int)index).count;
            this.itemAt(index).updateEmpty();
        }
    }

    public void dropAll(int index) {
        this.addClickLimited(Click.dropAll(index));
        this.itemAt(index).setEmpty();
    }

    public void dropOneCursor() {
        this.addClickLimited(Click.dropOneCursor());
        if (!this.cursor.isEmpty()) {
            --this.cursor.count;
            this.cursor.updateEmpty();
        }
    }

    public void dropAllCursor() {
        this.addClickLimited(Click.dropAllCursor());
        this.cursor.setEmpty();
    }

    private class StateSaver {
        private Stack<Integer> clickSizes = new Stack();
        private Stack<Snapshot> itemss = new Stack();
        private Stack<VirtualItemStack> cursors = new Stack();

        private StateSaver() {
        }

        public void save() {
            this.clickSizes.push(VirtualItemStacksSandbox.this.clicks.size());
            this.itemss.push(new Snapshot());
            this.cursors.push(VirtualItemStacksSandbox.this.cursor.copy());
        }

        public void save(Collection<Integer> indexes) {
            this.clickSizes.push(VirtualItemStacksSandbox.this.clicks.size());
            this.itemss.push(new Snapshot(new ArrayList<Integer>(indexes)));
            this.cursors.push(VirtualItemStacksSandbox.this.cursor.copy());
        }

        public void restore() {
            int clickSize = this.clickSizes.pop();
            while (VirtualItemStacksSandbox.this.clicks.size() > clickSize) {
                VirtualItemStacksSandbox.this.clicks.remove(VirtualItemStacksSandbox.this.clicks.size() - 1);
            }
            this.itemss.pop().restore();
            VirtualItemStacksSandbox.this.cursor = this.cursors.pop();
        }

        public void unsave() {
            this.clickSizes.pop();
            this.itemss.pop();
            this.cursors.pop();
        }

        private class Snapshot {
            public boolean isAll;
            public List<VirtualItemStack> snapshotItems;
            public List<Integer> indexes;

            public Snapshot() {
                this.isAll = true;
                this.snapshotItems = Converter.copy(VirtualItemStacksSandbox.this.items);
            }

            public Snapshot(List<Integer> indexes) {
                this.isAll = false;
                this.indexes = indexes;
                this.snapshotItems = new ArrayList<VirtualItemStack>();
                indexes.forEach(x -> this.snapshotItems.add(VirtualItemStacksSandbox.this.items.get((int)x).copy()));
            }

            public void restore() {
                if (this.isAll) {
                    VirtualItemStacksSandbox.this.items = this.snapshotItems;
                } else {
                    for (int i = 0; i < this.indexes.size(); ++i) {
                        int index = this.indexes.get(i);
                        VirtualItemStacksSandbox.this.items.set(index, this.snapshotItems.get(i));
                    }
                }
            }
        }
    }
}

