/*
 * Decompiled with CFR 0.152.
 */
package io.github.jsnimda.inventoryprofiles.sorter;

import io.github.jsnimda.inventoryprofiles.config.Configs;
import io.github.jsnimda.inventoryprofiles.sorter.Click;
import io.github.jsnimda.inventoryprofiles.sorter.IGroupingShapeProvider;
import io.github.jsnimda.inventoryprofiles.sorter.ISortingMethodProvider;
import io.github.jsnimda.inventoryprofiles.sorter.VirtualSorter;
import io.github.jsnimda.inventoryprofiles.sorter.predefined.GroupingShapeProviders;
import io.github.jsnimda.inventoryprofiles.sorter.util.ContainerActions;
import io.github.jsnimda.inventoryprofiles.sorter.util.ContainerInfo;
import io.github.jsnimda.inventoryprofiles.sorter.util.ContainerUtils;
import io.github.jsnimda.inventoryprofiles.sorter.util.Converter;
import io.github.jsnimda.inventoryprofiles.sorter.util.Current;
import io.github.jsnimda.inventoryprofiles.sorter.util.CurrentState;
import io.github.jsnimda.inventoryprofiles.sorter.util.Getter;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_465;

public class VirtualSorterPort {
    public static void doSort(ISortingMethodProvider sortingProvider, GroupingType groupingType) {
        ContainerInfo info = CurrentState.containerInfo();
        boolean sortPlayer = info.sortableSlots.isEmpty() || Configs.AdvancedOptions.SORT_CURSOR_POINTING.getBooleanValue() && ContainerUtils.cursorPointingPlayerInventory();
        VirtualSorterPort.doSort(sortPlayer, sortingProvider, groupingType);
    }

    public static void doSort(boolean sortPlayer, ISortingMethodProvider sortingProvider, GroupingType groupingType) {
        ContainerInfo info = CurrentState.containerInfo();
        if (groupingType == GroupingType.PRESERVED) {
            VirtualSorterPort.doSort(sortPlayer, sortingProvider, GroupingShapeProviders.PRESERVED);
        } else if (groupingType == GroupingType.COLUMNS) {
            VirtualSorterPort.doSort(sortPlayer, sortingProvider, GroupingShapeProviders.columnsProvider(info.sortableWidth));
        } else if (groupingType == GroupingType.ROWS) {
            VirtualSorterPort.doSort(sortPlayer, sortingProvider, GroupingShapeProviders.rowsProvider(info.sortableWidth));
        }
    }

    public static void doSort(boolean sortPlayer, ISortingMethodProvider sortingProvider, IGroupingShapeProvider groupingProvider) {
        List<class_1735> slots;
        if (Current.screen() != null && !(Current.screen() instanceof class_465)) {
            return;
        }
        ContainerInfo info = CurrentState.containerInfo();
        ContainerActions.cleanCursor();
        if (sortPlayer) {
            if (Configs.AdvancedOptions.SORT_RESTOCK_HOTBAR.getBooleanValue()) {
                ContainerActions.restockHotbar();
            }
            slots = info.playerStorageSlots;
        } else {
            slots = info.sortableSlots;
        }
        List<Integer> slotIds = slots.stream().map(x -> Getter.slotId(x)).collect(Collectors.toList());
        VirtualSorterPort.doSort(info.container, slots, slotIds, sortingProvider, groupingProvider);
    }

    public static void doSort(class_1703 container, List<class_1735> slots, List<Integer> slotIds, ISortingMethodProvider sortingProvider, IGroupingShapeProvider groupingProvider) {
        List<Click> clicks = VirtualSorter.doSort(Converter.toVirtualItemStackList(slots), sortingProvider, groupingProvider);
        clicks.forEach(x -> {
            x.slotId = (Integer)slotIds.get(x.slotId);
        });
        int interval = Configs.AdvancedOptions.ADD_INTERVAL_BETWEEN_CLICKS.getBooleanValue() ? Configs.AdvancedOptions.INTERVAL_BETWEEN_CLICKS_MS.getIntegerValue() : 0;
        ContainerActions.genericClicks(container, clicks, interval);
    }

    public static enum GroupingType {
        PRESERVED,
        COLUMNS,
        ROWS;

    }
}

