/*
 * Decompiled with CFR 0.152.
 */
package io.github.jsnimda.inventoryprofiles.sorter.util;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import io.github.jsnimda.inventoryprofiles.Log;
import io.github.jsnimda.inventoryprofiles.sorter.util.ContainerCategory;
import io.github.jsnimda.inventoryprofiles.sorter.util.Current;
import io.github.jsnimda.inventoryprofiles.sorter.util.Getter;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_1263;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1715;
import net.minecraft.class_1725;
import net.minecraft.class_1727;
import net.minecraft.class_1731;
import net.minecraft.class_1735;

public class ContainerInfo {
    public final class_1703 container;
    public final ContainerCategory category;
    public List<class_1735> playerHotbarSlots = new ArrayList<class_1735>();
    public List<class_1735> playerStorageSlots = new ArrayList<class_1735>();
    public class_1735 playerHeadSlot = null;
    public class_1735 playerChestSlot = null;
    public class_1735 playerLegsSlot = null;
    public class_1735 playerFeetSlot = null;
    public class_1735 playerOffhandSlot = null;
    public class_1735 playerMainhandSlot = null;
    public List<class_1735> playerArmorSlots = new ArrayList<class_1735>();
    public List<class_1735> nonPlayerSlots = new ArrayList<class_1735>();
    public ListMultimap<class_1263, class_1735> slotsMap = ArrayListMultimap.create();
    public List<class_1735> craftingSlots = new ArrayList<class_1735>();
    public List<class_1735> craftingResultSlots = new ArrayList<class_1735>();
    public List<class_1735> traderSlots = new ArrayList<class_1735>();
    public List<class_1735> traderInputSlots = new ArrayList<class_1735>();
    public List<class_1735> traderOutputSlots = new ArrayList<class_1735>();
    public List<class_1735> sortableSlots = new ArrayList<class_1735>();
    public List<class_1735> nonSortableStorageSlots = new ArrayList<class_1735>();
    public List<class_1735> storageSlots = new ArrayList<class_1735>();
    public List<class_1735> nonStorageSlots = new ArrayList<class_1735>();
    public int sortableWidth = 9;

    public static ContainerInfo of(class_1703 container) {
        return new ContainerInfo(container);
    }

    private void translatePlayer() {
        this.translatePlayer(this.container);
    }

    private void translatePlayer(class_1703 asContainer) {
        class_1735[] armorSlots = new class_1735[5];
        for (class_1735 s : asContainer.field_7761) {
            if (!(s.field_7871 instanceof class_1661)) continue;
            int invSlot = Getter.invSlot(s);
            if (invSlot >= 0 && invSlot < 9) {
                this.playerHotbarSlots.add(s);
                if (((class_1661)s.field_7871).field_7545 != invSlot) continue;
                this.playerMainhandSlot = s;
                continue;
            }
            if (invSlot <= 35) {
                this.playerStorageSlots.add(s);
                continue;
            }
            if (invSlot > 40) continue;
            armorSlots[invSlot - 36] = s;
        }
        this.playerHeadSlot = armorSlots[3];
        this.playerChestSlot = armorSlots[2];
        this.playerLegsSlot = armorSlots[1];
        this.playerFeetSlot = armorSlots[0];
        this.playerOffhandSlot = armorSlots[4];
        Stream.of(this.playerHeadSlot, this.playerChestSlot, this.playerLegsSlot, this.playerFeetSlot).filter(x -> x != null).forEach(x -> this.playerArmorSlots.add((class_1735)x));
    }

    private void translateNonPlayer() {
        for (class_1735 s : this.container.field_7761) {
            if (s.field_7871 instanceof class_1661) continue;
            this.nonPlayerSlots.add(s);
            this.slotsMap.put((Object)s.field_7871, (Object)s);
        }
        for (class_1735 s : this.container.field_7761) {
            if (s.field_7871 instanceof class_1661) continue;
            if (s instanceof class_1727) {
                this.traderOutputSlots.add(s);
            }
            if (s.field_7871 instanceof class_1715) {
                this.craftingSlots.add(s);
                continue;
            }
            if (s.field_7871 instanceof class_1731) {
                this.craftingResultSlots.add(s);
                continue;
            }
            if (s.field_7871 instanceof class_1725) {
                this.traderSlots.add(s);
                if (s instanceof class_1727) continue;
                this.traderInputSlots.add(s);
                continue;
            }
            if (s instanceof class_1727) continue;
            this.translateGenericSlots(s);
        }
    }

    private void translateGenericSlots(class_1735 s) {
        if (this.category == ContainerCategory.NON_STORAGE) {
            this.nonStorageSlots.add(s);
        } else {
            this.storageSlots.add(s);
            if (this.category == ContainerCategory.NON_SORTABLE_STORAGE) {
                this.nonSortableStorageSlots.add(s);
            } else if (this.category == ContainerCategory.SORTABLE_Nx3) {
                if (Getter.slotId(s) <= 1) {
                    this.nonSortableStorageSlots.add(s);
                } else {
                    this.sortableSlots.add(s);
                }
            } else if (this.category == ContainerCategory.SORTABLE_9xN || this.category == ContainerCategory.SORTABLE_3x3 || this.category == ContainerCategory.UNKNOWN) {
                this.sortableSlots.add(s);
            } else {
                Log.warn("[inventoryprofile] we shouldn't come here");
                Log.warn("[inventoryprofile] unknown slot: " + s + " in category " + (Object)((Object)this.category));
            }
        }
    }

    private void translateCreative() {
        this.translatePlayer((class_1703)Current.playerContainer());
    }

    public ContainerInfo(class_1703 container) {
        this.container = container;
        this.category = ContainerCategory.of(container);
        if (this.category != ContainerCategory.PLAYER_CREATIVE) {
            this.translatePlayer();
            this.translateNonPlayer();
        } else {
            this.translateCreative();
        }
        if (this.category == ContainerCategory.SORTABLE_3x3) {
            this.sortableWidth = 3;
        }
        if (this.category == ContainerCategory.SORTABLE_Nx3) {
            this.sortableWidth = this.sortableSlots.size() / 3;
        }
    }
}

