/*
 * Decompiled with CFR 0.152.
 */
package io.github.jsnimda.inventoryprofiles.sorter.util;

import io.github.jsnimda.inventoryprofiles.sorter.Click;
import io.github.jsnimda.inventoryprofiles.sorter.DiffCalculator;
import io.github.jsnimda.inventoryprofiles.sorter.VirtualItemStack;
import io.github.jsnimda.inventoryprofiles.sorter.VirtualSlot;
import io.github.jsnimda.inventoryprofiles.sorter.util.Current;
import io.github.jsnimda.inventoryprofiles.sorter.util.Getter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1799;

public class ContainerUtils {
    public static boolean cursorPointingPlayerInventory() {
        return Current.focusedSlot() != null && Current.focusedSlot().field_7871 instanceof class_1661;
    }

    public static int getRemainingRoom(@Nullable class_1735 slot, @Nullable class_1799 forItem) {
        if (slot == null || forItem == null || forItem.method_7960()) {
            return 0;
        }
        if (!slot.method_7680(forItem)) {
            return 0;
        }
        if (!slot.method_7681()) {
            return slot.method_7676(forItem);
        }
        class_1799 slotItem = slot.method_7677();
        if (!ContainerUtils.areItemsEqual(slotItem, forItem)) {
            return 0;
        }
        int maxAmount = Math.min(slot.method_7676(slotItem), slotItem.method_7914());
        return Math.max(0, maxAmount - slotItem.method_7947());
    }

    public static boolean areItemsEqual(class_1799 itemStack_1, class_1799 itemStack_2) {
        return itemStack_1.method_7909() == itemStack_2.method_7909() && class_1799.method_7975((class_1799)itemStack_1, (class_1799)itemStack_2);
    }

    public static <T> IdentityHashMap<class_1735, T> getSlotMap(Collection<VirtualSlot> slots, Function<VirtualSlot, T> func) {
        IdentityHashMap<class_1735, T> map = new IdentityHashMap<class_1735, T>();
        for (VirtualSlot s : slots) {
            map.put(s.slotConditionObject, func.apply(s));
        }
        return map;
    }

    public static void checkMismatch(Collection<VirtualSlot> from, Collection<VirtualSlot> to) {
        IdentityHashMap<class_1735, Boolean> toSlotSet;
        IdentityHashMap<class_1735, Boolean> fromSlotSet = ContainerUtils.getSlotMap(from, x -> true);
        if (!fromSlotSet.equals(toSlotSet = ContainerUtils.getSlotMap(to, x -> true))) {
            throw new RuntimeException("slots mismatch");
        }
    }

    public static List<Click> calcDiff(Collection<VirtualSlot> from, Collection<VirtualSlot> to) {
        ContainerUtils.checkMismatch(from, to);
        ArrayList ref = new ArrayList();
        from.forEach(x -> ref.add(x.slotConditionObject));
        IdentityHashMap<class_1735, VirtualSlot> fromMap = ContainerUtils.getSlotMap(from, x -> x);
        IdentityHashMap<class_1735, VirtualSlot> toMap = ContainerUtils.getSlotMap(to, x -> x);
        ArrayList<VirtualItemStack> fromItems = new ArrayList<VirtualItemStack>();
        ArrayList<VirtualItemStack> toItems = new ArrayList<VirtualItemStack>();
        ref.forEach(x -> {
            fromItems.add(((VirtualSlot)fromMap.get((Object)x)).slotItem);
            toItems.add(((VirtualSlot)toMap.get((Object)x)).slotItem);
        });
        List<Click> clicks = DiffCalculator.calcDiff(fromItems, toItems, false);
        clicks.forEach(c -> {
            c.slotId = Getter.slotId((class_1735)ref.get(c.slotId));
        });
        return clicks;
    }
}

